
//
// Warp diffusion tensors, with simulation of fiber destruction
// 
// Assumes that the input and output space are the same
//

#ifndef _DTImageDestructiveWarpFilter_h
#define _DTImageDestructiveWarpFilter_h

#include "DTImage.h"

#include "itkImageToImageFilter.h"
#include "itkVector.h"

class DTImageDestructiveWarpFilter:
  public itk::ImageToImageFilter<DTImageType, DTImageType>
{

public:

  typedef DTImageDestructiveWarpFilter Self;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  itkNewMacro(Self);

  typedef itk::Image<float, 3> FloatImageType;

  typedef itk::Vector<float, 3> VectorType;
  typedef itk::Image<VectorType, 3> DeformationFieldType;
  typedef DeformationFieldType::Pointer DeformationFieldPointer;
  typedef DeformationFieldType::SizeType DeformationFieldSizeType;
  typedef DeformationFieldType::SpacingType DeformationFieldSpacingType;

  // Set the deformation field (target to source deformation)
  void SetDeformationField(DeformationFieldType* def);
  void SetInverseDeformationField(DeformationFieldType* def);

  void NormalizeOutputTraceOn() { m_NormalizeOutputTrace = true; }
  void NormalizeOutputTraceOff() { m_NormalizeOutputTrace = false; }

protected:

  DTImageDestructiveWarpFilter();
  ~DTImageDestructiveWarpFilter();

  void GenerateData();

  DeformationFieldPointer m_DeformationField;
  DeformationFieldPointer m_InverseDeformationField;

  double m_JVariance;

  bool m_NormalizeOutputTrace;

};

#endif
