
#ifndef _DTImageInterpolator_h
#define _DTImageInterpolator_h

#include "DTImage.h"

class DTImageInterpolator
{

public:

  DTImageInterpolator();
  ~DTImageInterpolator();

  void LogEuclideanInterpolationOn() { m_UseLogEuclidean = true; }
  void LogEuclideanInterpolationOff() { m_UseLogEuclidean = false; }

  void SetDefaultTensor(const DiffusionTensor& dt);
  void SetInputImage(const DTImageType* dti);

  DiffusionTensor Evaluate(DTImagePointType& x);

protected:

  bool m_UseLogEuclidean;

  DTImageType* m_InputImage;
  DiffusionTensor m_DefaultTensor;

};

#endif
