
//
// DT image filtering
//
// An implementation of the isospectral filter described in:
// Chefd'hotel, Tschumperle', Deriche, and Faugeras. Regularizing flows for
// constrained matrix-valued images. ECCV 2002
//

#ifndef _DTImageIsospectralFilter_h
#define _DTImageIsospectralFilter_h

#include "itkObject.h"

#include "DiffusionTensor.h"
#include "DTImage.h"

class DTImageIsospectralFilter: public itk::Object
{

public:

  typedef DTImageIsospectralFilter Self;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  itkNewMacro(Self);

  typedef itk::Image<float, 3> InternalImageType;
  typedef InternalImageType::Pointer InternalImagePointer;
  typedef InternalImageType::SizeType InternalImageSizeType;
  typedef InternalImageType::SpacingType InternalImageSpacingType;

  typedef DiffusionTensor::MatrixType MatrixType;

  inline void SetInput(const DTImagePointer& dti) { m_Input = dti; }
  inline DTImagePointer GetOutput() { return m_Output; }

  void Update();

  itkSetMacro(TimeStep, float);
  itkGetMacro(TimeStep, float);

  itkSetMacro(NumberOfIterations, unsigned int);
  itkGetMacro(NumberOfIterations, unsigned int);

protected:

  DTImageIsospectralFilter();
  ~DTImageIsospectralFilter();

  DTImagePointer m_Input;
  DTImagePointer m_Output;

  InternalImagePointer m_Internal;

  float m_TimeStep;
  unsigned int m_NumberOfIterations;

  void Step();

};

#endif
