
//
// Warp diffusion tensors
// 
// Assumes that the input and output space are the same
//

#ifndef _DTImageWarpFilter_h
#define _DTImageWarpFilter_h

#include "DTImage.h"

#include "itkImageToImageFilter.h"
#include "itkVector.h"

class DTImageWarpFilter:
  public itk::ImageToImageFilter<DTImageType, DTImageType>
{

public:

  typedef DTImageWarpFilter Self;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  itkNewMacro(Self);

  typedef itk::Image<float, 3> FloatImageType;

  typedef itk::Vector<float, 3> VectorType;
  typedef itk::Image<VectorType, 3> DeformationFieldType;
  typedef DeformationFieldType::Pointer DeformationFieldPointer;
  typedef DeformationFieldType::SizeType DeformationFieldSizeType;
  typedef DeformationFieldType::SpacingType DeformationFieldSpacingType;

  // Set the deformation field (target to source deformation)
  void SetDeformationField(DeformationFieldType* def);

  void SetInverseDeformationField(DeformationFieldType* def);

protected:

  DTImageWarpFilter();
  ~DTImageWarpFilter();

  void GenerateData();

  DeformationFieldPointer m_DeformationField;
  DeformationFieldPointer m_InverseDeformationField;

};

#endif
