#ifndef __BinaryBlockStructuringElement_h
#define __BinaryBlockStructuringElement_h

#include "itkNeighborhood.h"

template<class TPixel, unsigned int VDimension = 2,
         class TAllocator = itk::NeighborhoodAllocator<TPixel> >
class BinaryBlockStructuringElement
  : public itk::Neighborhood<TPixel, VDimension, TAllocator>
{
public:
  /** Standard class typedefs. */
  typedef BinaryBlockStructuringElement                 Self;
  typedef itk::Neighborhood<TPixel, VDimension, TAllocator> Superclass;

  /** External support for allocator type. */
  typedef TAllocator AllocatorType;

  /** External support for dimensionality. */
  itkStaticConstMacro(NeighborhoodDimension, unsigned int, VDimension);
  
  /** External support for pixel type. */
  typedef TPixel PixelType;
  
  /** Iterator typedef support. Note the naming is intentional, i.e.,
  * ::iterator and ::const_iterator, because the allocator may be a
  * vnl object or other type, which uses this form. */
  typedef typename AllocatorType::iterator       Iterator;
  typedef typename AllocatorType::const_iterator ConstIterator;
  
  /** Size and value typedef support. */
  typedef typename Superclass::SizeType      SizeType;
  typedef typename Superclass::SizeValueType SizeValueType;
  
  /** Radius typedef support. */
  typedef typename Superclass::RadiusType RadiusType;

  /** External slice iterator type typedef support. */
  typedef itk::SliceIterator<TPixel, Self> SliceIteratorType;
  
  /** Default constructor. */
  BinaryBlockStructuringElement() {}

  /** Default destructor. */
  virtual ~BinaryBlockStructuringElement() {}
    
  /** Copy constructor. */
  BinaryBlockStructuringElement(const Self& other)
    : itk::Neighborhood<TPixel, VDimension, TAllocator>(other)
    {
    }

  /** Assignment operator. */
  Self &operator=(const Self& other)
    {
    Superclass::operator=(other);
    return *this;
    }

  /** Build the structuring element */
  void CreateStructuringElement();   
  
protected:
  
private:

};

#ifndef MU_MANUAL_INSTANTIATION
#include "BinaryBlockStructuringElement.txx"
#endif

#endif
