
#ifndef _TumorSimulationParametersXMLFile_h
#define _TumorSimulationParametersXMLFile_h

#include "itkXMLFile.h"

#include "TumorSimulationParameters.h"

class TumorSimulationParametersXMLFileReader: public itk::XMLReader<TumorSimulationParameters>
{

public:

  // Standard typedefs
  typedef TumorSimulationParametersXMLFileReader Self;
  typedef itk::XMLReader<TumorSimulationParameters> Superclass;
  typedef itk::SmartPointer<Self> Pointer;

  // RTTI
  itkTypeMacro(Self, Superclass)

  itkNewMacro(Self);

  virtual int CanReadFile(const char* name);

protected:
  TumorSimulationParametersXMLFileReader();
  ~TumorSimulationParametersXMLFileReader();

  virtual void StartElement(const char * name, const char **atts);
  virtual void EndElement(const char *name);
  virtual void CharacterDataHandler(const char *inData, int inLength);

  TumorSimulationParameters::Pointer m_PObject;
  std::string m_CurrentString;

};

class TumorSimulationParametersXMLFileWriter: public itk::XMLWriterBase<TumorSimulationParameters>
{

public:
  // Standard typedefs
  typedef TumorSimulationParametersXMLFileWriter Self;
  typedef itk::XMLWriterBase<TumorSimulationParameters> Superclass;
  typedef itk::SmartPointer<Self> Pointer;

  // RTTI
  itkTypeMacro(Self, Superclass)

  itkNewMacro(Self);

  virtual int CanWriteFile(const char* name);

  virtual int WriteFile();

protected:
  TumorSimulationParametersXMLFileWriter();
  ~TumorSimulationParametersXMLFileWriter();

};

// Convenience functions
TumorSimulationParameters::Pointer readTumorSimulationParametersXML(const char* fn);
bool writeTumorSimulationParametersXML(const char* fn, TumorSimulationParameters* p);

#endif
