
////////////////////////////////////////////////////////////////////////////////
//
// Generates scalar images from a tensor image
// Currently supports Mean Diffusivity (MD) and Fractional Anisotropy (FA)
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _DTImageScalarSource_h
#define _DTImageScalarSource_h

#include "DTImage.h"

class DTImageScalarSource: public itk::Object
{

public:

  typedef DTImageScalarSource Self;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  itkNewMacro(Self);

  typedef itk::Image<float, 3> FloatImageType;
  typedef FloatImageType::Pointer FloatImagePointer;
  typedef FloatImageType::RegionType FloatImageRegionType;
  typedef FloatImageType::IndexType FloatImageIndexType;
  typedef FloatImageType::SizeType FloatImageSizeType;
  typedef FloatImageType::SpacingType FloatImageSpacingType;

  void SetInput(DTImageType* dti);

  void Update();

  FloatImageType* GetMDImage();
  FloatImageType* GetFAImage();

protected:

  DTImageScalarSource();
  ~DTImageScalarSource();

  DTImagePointer m_DTImage;

  FloatImagePointer m_FAImage;
  FloatImagePointer m_MDImage;

};

#endif
