
////////////////////////////////////////////////////////////////////////////////
//
// Math for tensors represented as matrices, follows Arsegny et al
//
// Assumes input matrices are symmetric, positive-definite, 3x3 matrices (PD(3))
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _FastTensorMatrixMath
#define _FastTensorMatrixMath

#include "DiffusionTensor.h"

namespace FastTensorMatrixMath
{

typedef DiffusionTensor::MatrixType MatrixType;

MatrixType expMap(const MatrixType& X);
MatrixType logMap(const MatrixType& s);

float innerProduct(
  const MatrixType& s1, const MatrixType& s2);
float norm(const MatrixType& s);

MatrixType mean(MatrixType* tarray, float* weights, unsigned int n);

}

#endif
