
////////////////////////////////////////////////////////////////////////////////
//
// Invert a deformation field
//
// Code taken from VTK: vtkGridTransform by David Gobbi
//
////////////////////////////////////////////////////////////////////////////////

// prastawa 10/2004

#ifndef _InverseDeformationFilter_h
#define _InverseDeformationFilter_h

#include "itkImage.h"
#include "itkImageToImageFilter.h"
#include "itkVector.h"

class InverseDeformationFilter:
  public itk::ImageToImageFilter<
    itk::Image<itk::Vector<float, 3>, 3>,
    itk::Image<itk::Vector<float, 3>, 3>
  >
{

public:

  typedef InverseDeformationFilter Self;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  itkNewMacro(Self);

  typedef itk::Vector<float, 3> VectorType;

  typedef itk::Image<VectorType, 3> DeformationType;
  typedef DeformationType::Pointer DeformationPointer;
  typedef DeformationType::IndexType DeformationIndexType;
  typedef DeformationType::PixelType DeformationPixelType;
  typedef DeformationType::PointType DeformationPointType;
  typedef DeformationType::RegionType DeformationRegionType;
  typedef DeformationType::SizeType DeformationSizeType;
  typedef DeformationType::SpacingType DeformationSpacingType;

  typedef itk::Image<unsigned char, 3> ByteImageType;
  typedef ByteImageType::Pointer ByteImagePointer;

  typedef itk::Image<float, 3> FloatImageType;
  typedef FloatImageType::Pointer FloatImagePointer;
  typedef FloatImageType::IndexType FloatImageIndexType;
  typedef FloatImageType::PixelType FloatImagePixelType;
  typedef FloatImageType::PointType FloatImagePointType;
  typedef FloatImageType::RegionType FloatImageRegionType;
  typedef FloatImageType::SizeType FloatImageSizeType;
  typedef FloatImageType::SpacingType FloatImageSpacingType;

  itkGetConstMacro(NumberOfIterations, unsigned int);
  itkSetMacro(NumberOfIterations, unsigned int);

  itkGetConstMacro(Tolerance, double);
  itkSetMacro(Tolerance, double);

  itkGetConstMacro(MaximumDisplacementNorm, double);
  itkSetMacro(MaximumDisplacementNorm, double);

  itkSetMacro(MaskImage, ByteImagePointer);

protected:

  InverseDeformationFilter();
  ~InverseDeformationFilter() { }

  void GenerateData();

  unsigned int m_NumberOfIterations;
  double m_Tolerance;

  ByteImagePointer m_MaskImage;

  double m_MaximumDisplacementNorm;

};

#endif
