
#include "TumorSimulationParameters.h"

TumorSimulationParameters
::TumorSimulationParameters()
{
  m_DatasetName = "SimTumor";

  m_InputDirectory = "";

  m_OutputDirectory = "";

  m_DeformationSeedFileName = "";

  m_ContrastEnhancementType = "ring";

  m_UseQHull = true;

  m_DeformationIterations = 1;
  m_DeformationInitialPressure = 2;
  m_DeformationKappa = 100.0;
  m_DeformationDamping = 0.95;

  m_InfiltrationIterations = 2;
  m_InfiltrationTimeStep = 0.5;
  m_InfiltrationEarlyTime = 0.5;
  m_InfiltrationBodyForceCoefficient = 1;
  m_InfiltrationBodyForceDamping = 0.95;
  m_InfiltrationBodyForceIterations = 1;

  m_BrainYoungModulus = 694.0;
  m_BrainPoissonRatio = 0.4;

  m_FalxYoungModulus = 2000.0;
  m_FalxPoissonRatio = 0.4;

  m_InfiltrationReactionCoefficient = 0.1;
  m_WhiteMatterTensorMultiplier = 100.0;
  m_GrayMatterTensorMultiplier = 1.0;

  m_DeformationSolverIterations = 10;
  m_InfiltrationSolverIterations = 10;

  m_DrawBackground = true;

  m_GadNoiseStddev = 2.25;
  m_T1NoiseStddev = 2.25;
  m_T2NoiseStddev = 3.5;
  m_FLAIRNoiseStddev = 6.0;

  m_GadMaxBiasDegree = 4;
  m_T1MaxBiasDegree = 4;
  m_T2MaxBiasDegree = 4;
  m_FLAIRMaxBiasDegree = 4;

  m_NumberOfThreads = 2;
}

TumorSimulationParameters
::~TumorSimulationParameters()
{

}

bool
TumorSimulationParameters
::CheckValues()
{
  if (m_DatasetName.length() == 0)
    return false;

  if (m_InputDirectory.length() == 0)
    return false;

  if (m_OutputDirectory.length() == 0)
    return false;

  if (m_DeformationSeedFileName.length() == 0)
    return false;

  if (m_DeformationIterations < 0)
    return false;

  if (m_InfiltrationIterations < 0)
    return false;

  if (m_InfiltrationBodyForceIterations < 0)
    return false;

  if (m_DeformationInitialPressure < 0.0)
    return false;

  if (m_InfiltrationTimeStep <= 1e-10)
    return false;

  if (m_InfiltrationBodyForceCoefficient < 0.0)
    return false;

  if (m_DeformationSolverIterations < 0)
    return false;

  if (m_InfiltrationSolverIterations < 0)
    return false;

  return true;
}

void
TumorSimulationParameters
::PrintSelf(std::ostream& os)
{
  os << "Tumor simulation parameters" << std::endl;
  os << "///////////////////////////" << std::endl;
  os << "Dataset name = " << m_DatasetName << std::endl;
  os << "Input directory = " << m_InputDirectory << std::endl;
  os << "Output directory = " << m_OutputDirectory << std::endl;
  os << "Deformation seed file = " << m_DeformationSeedFileName << std::endl;
  os << "Deformation iterations = " << m_DeformationIterations << std::endl;
  os << "Deformation brain Young modulus = " << m_BrainYoungModulus << std::endl;
  os << "Deformation brain Poisson ratio = " << m_BrainPoissonRatio << std::endl;
  os << "Deformation falx Young modulus = " << m_FalxYoungModulus << std::endl;
  os << "Deformation falx Poisson ratio = " << m_FalxPoissonRatio << std::endl;
  os << "Deformation initial pressure (in kPa) = " << m_DeformationInitialPressure << std::endl;
  os << "Deformation kappa = " << m_DeformationKappa << std::endl;
  os << "Deformation damping = " << m_DeformationDamping << std::endl;
  os << "Infiltration iterations = " << m_InfiltrationIterations << std::endl;
  os << "Infiltration time step = " << m_InfiltrationTimeStep << std::endl;
  os << "Infiltration t(early) = " << m_InfiltrationEarlyTime << std::endl;
  os << "Infiltration body force coefficient (lambda) = " << m_InfiltrationBodyForceCoefficient << std::endl;
  os << "Infiltration body force damping  = " << m_InfiltrationBodyForceDamping << std::endl;
  os << "Infiltration body force iterations = " << m_InfiltrationBodyForceIterations << std::endl;
  os << "White matter tensor multiplier = " << m_WhiteMatterTensorMultiplier << std::endl;
  os << "Gray matter tensor multiplier = " << m_GrayMatterTensorMultiplier << std::endl;
  os << "Contrast enhancement type = " << m_ContrastEnhancementType << std::endl;
  if (!m_UseQHull)
    os << "qhull is disabled" << std::endl;

  os << "Gad noise stddev = " << m_GadNoiseStddev << std::endl;
  os << "T1 noise stddev = " << m_T1NoiseStddev << std::endl;
  os << "T2 noise stddev = " << m_T2NoiseStddev << std::endl;
  os << "FLAIR noise stddev = " << m_FLAIRNoiseStddev << std::endl;

  os << "Gad max bias degree = " << m_GadMaxBiasDegree << std::endl;
  os << "T1 max bias degree = " << m_T1MaxBiasDegree << std::endl;
  os << "T2 max bias degree = " << m_T2MaxBiasDegree << std::endl;
  os << "FLAIR max bias degree = " << m_FLAIRMaxBiasDegree << std::endl;

  if (m_DrawBackground)
    os << "Drawing background skull etc" << std::endl;
  else
    os << "Not drawing background skull etc" << std::endl;

  os << std::endl;
  os << "Deformation solver iterations = " << m_DeformationSolverIterations << std::endl;
  os << "Infiltration solver iterations = " << m_InfiltrationSolverIterations << std::endl;
  os << "Number of simulation threads = " << m_NumberOfThreads << std::endl;
}
