/***************************************************************************
 *   Copyright (C) 2007 by Bill Rogers - UTHSCSA - Research Imaging Center *
 *   rogers@uthscsa.edu                                                    *
 *                                                                         *
 ***************************************************************************
**/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstdlib>
#include <string>
#include <time.h>
#include "RicVolumeSet.h"

using namespace std;

int main(int argc, char *argv[])
{

	// read in compressed nifti file
	string filename = "input.nii.gz";
	RicVolume *zvol = new RicVolume(filename);
	cout << "Read file compressed Nifgit file input.nii.gz \n\n";

//	// read in NEMA file with multiple time points
//	RicVolumeSet PeterVol("EK0003Small.des");
//	PeterVol.VolSet[0].CalcMinMaxAvg();
//	cout << "Read file EK0003Small.des with " << PeterVol.nvol << " timepoints \n";
//	cout << "Min="<<PeterVol.VolSet[0].min<<" Max="<<PeterVol.VolSet[0].max<<endl<<endl;
//
//	// write a multi timepoint files in a variety of formats
//	PeterVol.Write_NIFTI("EK0003SmallOut.nii");
//	cout << "Wrote multi-timepoint Nifti file EK0003SmallOut.nii" << endl;
//	PeterVol.Write_NEMA("EK0003SmallOut.des");
//	cout << "Wrote multi-timepoint NEMA file EK0003SmallOut.des" << endl;
//	PeterVol.dtype = RIC_INTEGER;
//	PeterVol.Write_NEMA("EK0003SmallOutI.des");
//	cout << "Wrote multi-timepoint NEMA signed integer file EK0003SmallOut.des" << endl;
//
//	/// read a GIS file into a volume - this one marked with a hole on the left
//	RicVolume rvol("TestHoleLeft.dim");
//	cout << "\nRead GIS file TestHoleLeft.dim \n\n";
//
//	// mark a voxel
//	rvol.vox[1][2][3] = 9999;
//
//	// write  volumes in a multiple of formats
//	rvol.Write_NEMA("RvolumeGISLeftPMM.des","XYZ+--");
//	cout << "Wrote NEMA +-- from GIS" << endl;
//
//	rvol.Write_NEMA("RvolumeGISLeftPMP.des","XYZ+-+");
//	cout << "Wrote NEMA +-+ from GIS" << endl;
//
//	rvol.Write_NEMA("RvolumeGISLeftPPP.des","XYZ+++");
//	cout << "Wrote NEMA +++ from GIS" << endl;
//
//	rvol.Write("RvolumeGIS.dim");
//	cout << "Wrote GIS from GIS" << endl;
//
//	rvol.Write("RvolumeGIS.nii");
//	cout << "Wrote NIFTI from GIS" << endl;

	/// read a Nifti file into a volume
	RicVolume svol("TestHoleLeftmmm.nii");
	cout << "\nRead Nifti file TestHoleLeftmmm.nii \n\n";

	// write  volumes
	svol.Write("SvolumeNII.des");
	cout << "Wrote NEMA from NIFTI" << endl;

	svol.Write("SvolumeNII.dim");
	cout << "Wrote GIS from NIFTI" << endl;

	svol.Write("SvolumeNII.nii");
	cout << "Wrote NIFTI from NIFTI" << endl;

//	/// read a NEMA file into a volume
//	RicVolume tvol("TestHoleLeftmmp.des");
//	cout << "\nRead NEMA file TestHoleLeftmmp.des \n\n";
//
//	// write  volumes
//	tvol.Write("TvolumeNEMA.des");
//	cout << "Wrote NEMA from NEMA" << endl;
//
//	tvol.Write("TvolumeNEMA.dim");
//	cout << "Wrote GIS from NEMA" << endl;
//
//	tvol.Write("TvolumeNEMA.nii");
//	cout << "Wrote NIFTI from NEMA" << endl;


	cout << "Done" << endl;

	return EXIT_SUCCESS;
}
