      FUNCTION DELTA7(KIN2,OMEGA,FATHER,MOTHER,I,J,MAXPEO,MOMEGA,TWINS)
C
C     THIS FUNCTION SUPPLIES JACQUARD'S DELTA7 COEFFICIENT FOR
C     TWO PEOPLE I AND J.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION KIN2(MAXPEO),OMEGA(MOMEGA,MOMEGA)
      INTEGER FATHER(MAXPEO),MOTHER(MAXPEO)
      LOGICAL TWINS
C
      I1=FATHER(I)
      J1=FATHER(J)
      IF (I.EQ.J.OR.TWINS) THEN
C
C     I AND J ARE GENETICALLY IDENTICAL.
C
      DELTA7=1.0D0
      ELSE IF (I1.NE.0.AND.J1.NE.0) THEN
C
C     I AND J ARE BOTH NON-FOUNDERS.  USE COTTERMAN'S FORMULA.
C
      I2=MOTHER(I)
      J2=MOTHER(J)
      IF (I1.EQ.J1) THEN
      D=KIN2(I1)
      ELSE
      D=OMEGA(MAX(I1,J1),MIN(I1,J1))
      END IF
      IF (I2.EQ.J2) THEN
      D=D*KIN2(I2)
      ELSE
      D=D*OMEGA(MAX(I2,J2),MIN(I2,J2))
      END IF
      DELTA7=0.25D0*(D+OMEGA(MAX(I1,J2),MIN(I1,J2))
     1*OMEGA(MAX(I2,J1),MIN(I2,J1)))
      ELSE
C
C     EITHER I OR J IS A FOUNDER.
C
      DELTA7=0.0D0
      END IF
      END
