C Modified 1996-1997 by Charles Peterson, SFBR.
C This is the New Fisher signature.  Do not remove.  fI6%.
C
      SUBROUTINE DIRECT(DERIV,EXTRA,INFORM,KIN2,OMEGA,PAR,PARINC,QDERIV
     1,SCORE,VAR,WORK,DEPVAR,FATHER,GROUP,MOTHER,PERSON,LOGLIK,QDFORM
     2,TOL,ITER,MAXPAR,MAXPEO,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS
     3,NPBAND,NPED,NPEO,NPTOT,NTRAIT,NVAR,PED,UNIT3,DIAG,FORWRD,NORMAL
     4,CONOUT,RAWSD,RAWMU)
C
C     THIS SUBROUTINE DIRECTS THE COMPUTATION OF THE LOG LIKELIHOOD FOR
C     FOR A SINGLE PEDIGREE.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION DERIV(MAXPAR),EXTRA(NEXTRA),INFORM(MAXPAR,MAXPAR)
     1,KIN2(MAXPEO),OMEGA(MOMEGA,MOMEGA),PAR(MAXPAR),PARINC(MAXPAR)
     2,QDERIV(MAXPAR),SCORE(MAXPAR),VAR(MAXVAR),WORK(MWORK),LOGDET
     3,LOGLIK,RAWSD,RAWMU
      INTEGER DEPVAR(NTRAIT),FATHER(MAXPEO),GROUP(MAXPEO),MOTHER(MAXPEO)
     1,PERSON(MAXPEO),BORDER,PED,UNIT3,CONOUT,LID
      LOGICAL ARTTOL,DIAG,FORWRD,INFRM,NORMAL,PASS1,VERBOSE
      CHARACTER FIRST_ID*18
C
C     SET THE INDICATOR FOR THE USE OF ARTIFICIAL TOLERANCES IN
C     INVERTING THE COVARIANCE MATRIX.
C
      ARTTOL=.FALSE.
C
C     COMPUTE TWICE THE KINSHIP MATRIX FOR THE PEDIGREE.  STORE THE
C     NON-DIAGONAL PARTS IN THE LOWER TRIANGLE OF OMEGA.  STORE THE
C     DIAGONAL ELEMENTS IN KIN2.
C
      CALL KIN(OMEGA,FATHER,GROUP,MOTHER,MAXPEO,MOMEGA,NPTOT)
      DO 10 I=1,NPTOT
 10   KIN2(I)=OMEGA(I,I)
C
C     RETRIEVE FROM GROUP THE POSITION ON DATA ENTRY OF EACH PERSON IN
C     THE PEDIGREE.
C
      DO 20 I=1,NPEO
 20   PERSON(I)=MOD(IABS(GROUP(I)),100000)
C
C     INITIALIZE THE LOG DETERMINANT OF THE COVARIANCE MATRIX, THE
C     QUADRATIC FORM, THE DIFFERENTIAL OF THE QUADRATIC FORM, AND THE
C     SCORE VECTOR.
C
      LOGDET=0.0D0
      QDFORM=0.0D0
      DO 30 I=1,NPAR
      QDERIV(I)=0.0D0
 30   SCORE(I)=0.0D0
C
C     COMPUTE THE CONDITIONAL LOG LIKELIHOOD OF THE PEDIGREE BY COMPUTING
C     THE LOG LIKELIHOOD OF THE WHOLE PEDIGREE AND SUBTRACTING FROM IT THE
C     LOG LIKELIHOOD OF THE PROBANDS.  FIRST DO THE PROBAND PART AND THEN
C     THE WHOLE PEDIGREE.
C
      DO 40 I=1,2
      IF (I.EQ.1) THEN
      NP=NPBAND
      ELSE
      NP=NPEO
      END IF
      IF (NP.LE.0) GO TO 40
C
C     EACH OF THE LOG LIKELIHOODS IS COMPUTED ON THE FIRST PASS OF THE
C     NEXT LOOP.  ON THE SECOND PASS THE SCORE VECTOR AND THE INFORMATION
C     MATRIX ARE COMPUTED. 
C
      DO 50 IPASS=1,NPASS
      PASS1=IPASS.EQ.1
      INFRM=DIAG.AND.ITER.EQ.1.AND.I.EQ.2.AND..NOT.PASS1
C
C     DEFINE THE SIZE OF THE COVARIANCE MATRIX AND THE SIZE OF THE 
C     TABLEAU.  INSERT ZERO INTO THE LOWER RIGHT ENTRY OF THE TABLEAU.
C
      IF (PASS1) THEN
      NOMEGA=NP*NTRAIT
      BORDER=NOMEGA+1
      OMEGA(BORDER,BORDER)=0.0D0
      END IF
C
C     INITIALIZE THE INFORMATION MATRIX.
C
      IF (INFRM) THEN
      DO 60 M=1,NPAR
      DO 60 N=1,NPAR
 60   INFORM(M,N)=0.0D0
      DO 70 K=1,NOMEGA*NPAR
 70   WORK(K)=0.0D0
      END IF
C
C     CALL SUBROUTINE CALC TO SET UP THE TABLEAU OR TO COMPUTE THE
C     THE SCORE VECTOR AND INFORMATION MATRIX.
C
      CALL CALC(DERIV,EXTRA,INFORM,KIN2,OMEGA,PAR,PARINC,QDERIV
     1,SCORE,VAR,WORK,DEPVAR,FATHER,GROUP,MOTHER,PERSON,BORDER,MAXPAR
     2,MAXPEO,MAXVAR,MOMEGA,NEXTRA,NOMEGA,NPAR,NPBAND,NP,NTRAIT,NVAR
     3,PED,FORWRD,INFRM,PASS1,RAWSD,RAWMU)
C
C     SWEEP ON THE TABLEAU IF THIS IS PASS ONE.  AT THE SAME TIME
C     COMPUTE THE LOG DETERMINANT OF THE COVARIANCE MATRIX.  THE
C     NEGATIVE OF THE ASSOCIATED QUADRATIC FORM SHOULD APPEAR IN THE
C     LOWER RIGHT ENTRY OF THE TABLEAU AFTER SWEEPING.
C
      IF (PASS1) THEN
      DO 80 K=1,NOMEGA
C         print *,'OMEGA(',K,',',K,') is ',OMEGA(K,K)
      IF (OMEGA(K,K).LE.TOL) THEN
      OMEGA(K,K)=TOL
      ARTTOL=.TRUE.
      END IF
      LOGDET=LOGDET+DLOG(OMEGA(K,K))
 80   CALL SWEEP(OMEGA,WORK,K,MOMEGA,BORDER,.FALSE.)
      QDFORM=QDFORM-OMEGA(BORDER,BORDER)
C      CALL EXIT (0)
C
C     IF THIS IS PASS ONE AND THE PROBAND PART OF THE PEDIGREE, THEN CHANGE
C     THE SIGN OF THE ASSOCIATED LOG DETERMINANT AND QUADRATIC FORM.
C
      IF (I.EQ.1) THEN
      LOGDET=-LOGDET
      QDFORM=-QDFORM
      END IF
C
C     IF THIS IS PASS TWO AND THE PROBAND PART OF THE PEDIGREE, THEN
C     CHANGE THE SIGN OF THE SCORE VECTOR.
C
      ELSE IF (I.EQ.1) THEN
      DO 90 K=1,NPAR
      QDERIV(K)=-QDERIV(K)
 90   SCORE(K)=-SCORE(K)
      END IF
 50   CONTINUE
 40   CONTINUE
C
C     REPORT IF ARTIFICIAL TOLERANCES WERE USED IN INVERTING THE
C     COVARIANCE MATRIX.
C
 100  FORMAT(//
     1,'   *** Warning!  Singular covariance matrix for pedigree with'
     2,' individual'
     3,/,4X,A,' at iteration ',I4,'.  Artificial tolerances were used'
     4,/,'            to invert it.  The parameters at the time were:'
     5,/,(6D12.5))
      IF (ARTTOL .AND. VERBOSE ("ARTTOL")) THEN
         CALL FIRSTID (PED, FIRST_ID)
         LID = LNBLNK (FIRST_ID)
         WRITE(UNIT3,100) FIRST_ID(1:LID),ITER,(PAR(K),K=1,NPAR)
         WRITE(CONOUT,100) FIRST_ID(1:LID),ITER,(PAR(K),K=1,NPAR)
      ENDIF
C
C     COMPUTE THE LOG LIKELIHOOD AND LET THE USER MODIFY IT.
C
      LOGLIK=-0.5D0*(LOGDET+QDFORM)
      NOBS=NPEO-NPBAND
      DO 110 I=1,NPAR
 110  QDERIV(I)=-2.0D0*QDERIV(I)
      CALL NEWLIK(EXTRA,INFORM,PAR,QDERIV,SCORE,LOGLIK,QDFORM,ITER
     1,NEXTRA,NOBS,MAXPAR,NPED,NTRAIT,PED,NORMAL)
      END
