      SUBROUTINE FUN(DERIV,DF,EXTRA,HESS,INFORM,KIN2,OMEGA,PAR,PARINC
     1,PARMAX,QDERIV,SCORE,UNIFRM,VAR,WORK,DEGREE,DEPVAR,FATHER,GROUP
     2,MOTHER,PERSON,DP,F,QDFORM,PEDCUT,PERCUT,TOL,ITER,LAST,MAXPAR
     3,MAXPEO,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS,NPED,NTRAIT,NVAR
     4,UNIT2,UNIT3,DIAG,FORWRD,NORMAL,OUTLIE,PSCORE,PNPEO,CONOUT,RAWSD
     5,RAWMU)
C
C     THIS SUBROUTINE CONTROLS THE COMPUTATION OF F AND ITS
C     PARTIAL DERIVATIVES.  F IS MINUS THE SUM OF THE LOG LIKELIHOODS
C     OVER ALL PEDIGREES.  THE DERIVATIVES ARE COMPUTED NUMERICALLY;
C     FORWARD OR CENTRAL DIFFERENCES ARE USED DEPENDING ON THE LOGICAL
C     VARIABLE FORWRD.  THE NUMERICAL DIFFERENTIATION INTERVAL IS
C     ADJUSTED TO TAKE INTO ACCOUNT THE MAGNITUDE OF A PARAMETER AND
C     WHETHER IT LIES ON ITS UPPER BOUND.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION DERIV(MAXPAR),DF(MAXPAR),EXTRA(NEXTRA)
     1,HESS(MAXPAR,MAXPAR),INFORM(MAXPAR,MAXPAR),KIN2(MAXPEO)
     2,OMEGA(MOMEGA,MOMEGA),PAR(MAXPAR),PARINC(MAXPAR),PARMAX(MAXPAR)
     3,QDERIV(MAXPAR),SCORE(MAXPAR),UNIFRM(NPED),VAR(MAXVAR),WORK(MWORK)
     4,LOGLIK,PSCORE(NPED+1,MAXPAR),RAWSD,RAWMU,PEDLIKE
      INTEGER DEGREE(NPED),DEPVAR(NTRAIT),FATHER(MAXPEO),GROUP(MAXPEO)
     1,MOTHER(MAXPEO),PERSON(MAXPEO),PED,UNIT2,UNIT3,PNPEO(NPED)
      LOGICAL DIAG,FORWRD,NORMAL,OUTLIE,VERBOSE,VSUB
      INTEGER CONOUT,TINDEX,TDISTP
C
      SAVE NPBAND,NPEO,NPTOT
      VSUB = VERBOSE ('SUBITER')
      CALL DOPTION ('PEDLIKE',PEDLIKE)
      IF (PEDLIKE.EQ.1) THEN
         OPEN (34,FILE='pedlike.dat')
         WRITE (34,9)
 9       FORMAT ('LOGLIKELIHOOD')
      END IF

C
C     INITALIZE F, IT'S DERIVATIVES, AND THE TOTAL QUADRATIC FORM.
C
      F=0.0D0
      QDFORM=0.0D0
      IF (NPASS.EQ.2) THEN
      DO 10 I=1,NPAR
 10   DF(I)=0.0D0
C
C     FIND THE PARAMETER INCREMENTS FOR COMPUTING PARTIAL DERIVATIVES.
C
      DO 20 I=1,NPAR   
      D=DP*MAX(ABS(PAR(I)),1.0D0)
      IF (PAR(I)+D.GE.PARMAX(I)) D=-D
 20   PARINC(I)=D
C
C     INITIALIZE THE HESSIAN.
C
      IF (DIAG.AND.ITER.EQ.1) THEN
      DO 30 I=1,NPAR
      DO 30 J=I,NPAR
 30   HESS(I,J)=0.0D0
      END IF
      END IF
C
C     REWIND THE SCRATCH FILE IN PREPARATION FOR READING THE PEDIGREE
C     DATA.
C
      IF (NPED.GT.1.OR.ITER.EQ.1) CALL RESCRATCH(UNIT2)
C
C     DO THE NECESSARY COMPUTATIONS FOR EACH PEDIGREE.
C
      DO 40 PED=1,NPED
C
C     IF THIS IS THE FIRST ITERATION OR THERE ARE MULTIPLE PEDIGREES,
C     THEN READ THE DATA IN FROM THE SCRATCH FILE.
C
      IF (NPED.GT.1.OR.ITER.EQ.1) THEN
         CALL ISCRAT (NPBAND,1,UNIT2,.FALSE.)
         CALL ISCRAT (NPEO,1,UNIT2,.FALSE.)
         CALL ISCRAT (NPTOT,1,UNIT2,.FALSE.)
         CALL ISCRAT(FATHER,NPTOT,UNIT2,.FALSE.)
         CALL ISCRAT(GROUP,NPTOT,UNIT2,.FALSE.)
         CALL ISCRAT(MOTHER,NPTOT,UNIT2,.FALSE.)
         MVAR=NPTOT*NVAR
         CALL RSCRAT(VAR,MVAR,UNIT2,.FALSE.)
      END IF
C
C      PRINT*,'NPBAND,NPEO,NPTOT',NPBAND,NPEO,NPTOT
C      PRINT*,'FATHER',FATHER
C      PRINT*,'GROUP',GROUP
C      PRINT*,'MOTHER',MOTHER
C      PRINT*,'VAR',VAR
C
C     CALL SUBROUTINE DIRECT TO INITIATE THE COMPUTATION OF THE
C     LOG LIKELIHOOD AND SCORE FOR THE CURRENT PEDIGREE.
C
      CALL DIRECT(DERIV,EXTRA,INFORM,KIN2,OMEGA,PAR,PARINC,QDERIV,SCORE
     1,VAR,WORK,DEPVAR,FATHER,GROUP,MOTHER,PERSON,LOGLIK,UNIFRM(PED)
     2,TOL,ITER,MAXPAR,MAXPEO,MAXVAR,MOMEGA,MWORK,NEXTRA,NPAR,NPASS
     3,NPBAND,NPED,NPEO,NPTOT,NTRAIT,NVAR,PED,UNIT3,DIAG,FORWRD,NORMAL
     4,CONOUT,RAWSD,RAWMU)
C
C     ADD THIS PEDIGREE'S INCREMENT TO F, TO THE TOTAL OF THE PEDIGREE
C     QUADRATIC FORMS, TO THE DERIVATIVES OF F, AND TO THE HESSIAN OF F.
C
      F=F-LOGLIK
      QDFORM=QDFORM+UNIFRM(PED)

      IF (VSUB) THEN
         PRINT *,'PED=',PED,'  LOGLIK=',LOGLIK,'  QDFORM=  ',QDFORM
      ENDIF
      IF (PEDLIKE.EQ.1) THEN
         WRITE (34,45) LOGLIK
 45      FORMAT (1X,G26.18)
       END IF


      IF (NPASS.EQ.2) THEN
      DO 50 I=1,NPAR
 50   DF(I)=DF(I)-SCORE(I)
      IF (DIAG.AND.ITER.EQ.1) THEN
      DO 60 I=1,NPAR
      DO 60 J=I,NPAR
 60   HESS(I,J)=HESS(I,J)+INFORM(I,J)
      END IF
      END IF
C
C     IF THIS IS THE LAST ITERATION AND OUTLIERS INDIVIDUALS ARE TO
C     BE NOTED, THEN CALL SUBROUTINE RESID.  ALSO SET THE DEGREES OF
C     OF FREEDOM FOR THE PEDIGREE QUADRATIC FORMS.
C
      IF (OUTLIE.AND.ITER.EQ.LAST) THEN
      TINDEX=TDISTP()
      CALL RESID(OMEGA,WORK,VAR,DEPVAR,PERSON,PERCUT,PAR(TINDEX),MAXPEO
     1,MAXVAR,MOMEGA,MWORK,NPBAND,NPEO,NTRAIT,NVAR,PED,UNIT3,NORMAL)
      DEGREE(PED)=(NPEO-NPBAND)*NTRAIT
      END IF
      PNPEO(PED)=NPEO
      DO 65 I=1,NPAR
      PSCORE(PED,I)=SCORE(I)
 65   CONTINUE
 40   CONTINUE
      IF (PEDLIKE.EQ.1) THEN
         CLOSE (34)
      END IF

C
C     SYMMETRIZE THE HESSIAN AND MAKE SURE THAT IT IS POSITIVE DEFINITE.
C
      IF (DIAG.AND.ITER.EQ.1.AND.NPASS.EQ.2) THEN
      DO 70 I=1,NPAR
      HESS(I,I)=MAX(HESS(I,I),TOL)
      DO 70 J=I,NPAR
 70   HESS(J,I)=HESS(I,J)
      END IF
C
C     IF THIS IS THE LAST ITERATION AND OUTLIER PEDIGREES ARE TO
C     BE NOTED, THEN CALL SUBROUTINE EDFTST.
C
      IF (OUTLIE.AND.ITER.EQ.LAST) CALL PEDTST(UNIFRM,DEGREE,PEDCUT
     1,PAR(TINDEX),NPED,UNIT3,NORMAL)
      END
