      FUNCTION GAUCDF(X)
C
C     GAUCDF COMPUTES THE STANDARD NORMAL DISTRIBUTION FUNCTION AT
C     THE POINT X BY EITHER THE POWER SERIES EXPANSION OF POLYA OR
C     THE ASYMPTOTIC EXPANSION OF MILL'S RATIO.  SEE:
C     M.G. KENDALL AND A. STUART(1963). "THE ADVANCED THEORY OF
C     STATISTICS, VOL. 1, 2ND ED."  HAFNER PUBLISHING. NEW YORK.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      XSQ=X*X
      GAUCDF=0.0D0
      IF (XSQ.LE.16.0D0) THEN
C
C     FOR X BETWEEN -4. AND 4. USE POLYA'S POWER SERIES EXPANSION.
C
      T=0.3989422804014327D0*EXP(-XSQ/2.D0)
      R=1.0D0
 10   GAUCDF=GAUCDF+T
      R=R+2.0D0
      RATIO=XSQ/R
      T=T*RATIO
      IF (T.GT.1.D-10.OR.RATIO.GT.0.9D0) GO TO 10
      GAUCDF=GAUCDF*X+0.5D0
      ELSE
C
C     OTHERWISE, USE THE ASYMPTOTIC EXPANSION.
C
      T=0.3989422804014327D0*EXP(-XSQ/2.D0)/ABS(X)
      R=1.0D0
 20   GAUCDF=GAUCDF+T
      R=R+2.0D0
      RATIO=R/XSQ
      T=-T*RATIO
      IF (RATIO.LT.1.0D0.AND.ABS(T).GT.1.D-10) GO TO 20
      IF (X.GT.0.0D0) GAUCDF=1.0D0-GAUCDF
      END IF
      END
