/*
 * loadsave.cc implements the load and save commands
 * Written by Charles Peterson beginning on January 19, 1998
 * Copyright (c) 1997 Southwest Foundation for Biomedical Research
 */

#include <stdlib.h>
#include <stdio.h>
// tcl.h from solar.h
#include "solar.h"

extern "C" int LoadSaveCmd (ClientData clientData, Tcl_Interp *interp,
		  int argc, char *argv[])
{
    if (argc <= 2)
    {
	if (!(argc == 2 && !StringCmp (argv[1], "help", case_ins)))
	{
	    fprintf (stderr, "Invalid %s command\n\n", argv[0]);
	}
	printf (
"Purpose:  The load command is an alias to make some other commands nicer.\n");
	printf (
"          For example, the command \"load pedigree\" is actually an alias for\n");
	printf (
"          \"pedigree load.\"  For more information about a particular \"load\"\n");
	printf (
"          command, see the help for the underlying command, for example:\n");
	printf (
"          \"help pedigree\".  Here is a summary of some load commands:\n");
	printf ("\n");
	printf (
"              load pedigree <filename>\n");
	printf (
"              load phenotypes <filename>\n");
	printf (
"              load matrix <filename> <name1> [<name2>]\n");
	printf (
"              load model <filename>\n");
	printf (
"              load freq <filename>\n");
	printf (
"              load marker <filename>\n");
	printf (
"              load map <filename>\n");


	if (argc == 2 && !StringCmp (argv[1], "help", case_ins)) return TCL_OK;
	return TCL_ERROR;
    }

    char buf[1024];
    char *arguments = Tcl_Concat (argc-2, argv+2);
    sprintf (buf, "%s %s %s", argv[1], argv[0], arguments);
    Tcl_Free (arguments);
    return Solar_Eval (interp, buf);
}
