      SUBROUTINE SETTAB(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK2,CNORM
     1,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,NTAB)
C
C     THIS SUBROUTINE CREATES AN UPPER TRIANGULAR TABLEAU IN
C     PREPARATION FOR THE QUADRATIC PROGRAMMING PROBLEM.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR),DF(MAXPAR)
     1,HESS(MAXPAR,MAXPAR),PAR(MAXPAR),TABLE(MAXTAB,MAXTAB)
     2,WORK2(MAXTAB)
C
C     FIRST COMPUTE THE NORM OF THE HESSIAN FOR PURPOSES OF SCALING
C     THE CONSTRAINT CONTRIBUTION TO THE UPPER LEFT BLOCK OF THE
C     TABLEAU.
C
      IF (NCNSTR.EQ.0) THEN
      C=1.0D0
      ELSE
      HNORM=0.0D0
      DO 10 I=1,NPAR
      DO 10 J=1,NPAR
 10   HNORM=HNORM+HESS(I,J)**2
      HNORM=SQRT(HNORM)
      C=HNORM/CNORM
C
C     NEXT COMPUTE THE LINEAR EQUALITY CONSTANTS FOR
C     THE INCREMENTS OF THE CURRENT PARAMETER VALUES.
C
      DO 20 I=1,NCNSTR
      S=CVALUE(I)
      DO 30 J=1,NPAR
 30   S=S-CNSTR(I,J)*PAR(J)
 20   WORK2(I)=S
      END IF
C
C     NOW SET UP THE TABLEAU.  IN THE UPPER LEFT BLOCK LOAD THE
C     APPROXIMATE HESSIAN.  IF THERE ARE CONSTRAINTS, AUGMENT
C     THE HESSIAN BY A CONSTANT TIMES CNSTR(TRANSPOSE)*CNSTR.
C     TO THE RIGHT OF THE HESSIAN LOAD CNSTR(TRANSPOSE).  TO THE
C     RIGHT OF THIS LOAD THE NEGATIVE OF THE DIFFERENTIAL. BELOW
C     THE DIFFERENTIAL LOAD THE LINEAR EQUALITY CONSTANTS. THE
C     REST OF THE TABLEAU SHOULD BE ZERO.
C
      NTAB=NPAR+NCNSTR+1
      N1=NPAR+1
      DO 40 K=1,NPAR
      DO 40 J=1,K
      S=0.0D0
      DO 50 I=1,NCNSTR
 50   S=S+CNSTR(I,J)*CNSTR(I,K)
 40   TABLE(J,K)=HESS(J,K)+C*S
      DO 60 I=1,NCNSTR
      K=NPAR+I
      DO 70 J=1,NPAR
 70   TABLE(J,K)=CNSTR(I,J)
      DO 80 J=N1,K
 80   TABLE(J,K)=0.0D0
 60   CONTINUE
      DO 90 J=1,NPAR
 90   TABLE(J,NTAB)=-DF(J)
      DO 100 J=1,NCNSTR
 100  TABLE(J+NPAR,NTAB)=WORK2(J)
      TABLE(NTAB,NTAB)=0.0D0
      END
