      DOUBLE PRECISION FUNCTION ALNORM(X,UPPER)
C
C       ALGORITHM AS 66  APPL. STATIST. (1973) VOL.22, NO.3
C
C       EVALUATES THE TAIL AREA OF THE STANDARDISED NORMAL CURVE
C       FROM X TO INFINITY IF UPPER IS .TRUE. OR
C       FROM MINUS INFINITY TO X IF UPPER IS .FALSE.
C
      DOUBLE PRECISION LTONE, UTZERO, ZERO, HALF, ONE, CON, Z, Y, X
      LOGICAL UPPER,UP
C
C       LTONE AND UTZERO MUST BE SET TO SUIT THE PARTICULAR COMPUTER
C       (SEE INTRODUCTORY TEXT)
C
      DATA LTONE, UTZERO /7.0D0, 18.66D0/
      DATA ZERO, HALF, ONE, CON /0.0D0, 0.5D0, 1.0D0, 1.28D0/
      UP = UPPER
      Z = X
      IF(Z.GE.ZERO) GOTO 10
      UP = .NOT.UP
      Z = -Z
   10 IF(Z.LE.LTONE.OR.UP.AND.Z.LE.UTZERO) GOTO 20
      ALNORM = ZERO
      GOTO 40
   20 Y = HALF * Z * Z
      IF(Z.GT.CON) GOTO 30
C
      ALNORM = HALF - Z * (0.398942280444D0 - 0.399903438504D0 * Y /
     1  (Y + 5.75885480458D0 - 29.8213557808D0 /
     2  (Y + 2.62433121679D0 + 48.6959930692D0 /
     3  (Y + 5.92885724438D0))))
      GOTO 40
C
   30 ALNORM = 0.398942280385D0 * DEXP(-Y) /
     1  (Z - 3.8052D-8 + 1.00000615302D0 /
     2  (Z + 3.98064794D-4 + 1.98615381364D0 /
     3  (Z - 0.151679116635D0 + 5.29330324926D0 /
     4  (Z + 4.8385912808D0 - 15.1508972451D0 /
     5  (Z + 0.742380924027D0 + 30.789933034D0 /
     6  (Z + 3.99019417011D0))))))
C
   40 IF(.NOT.UP) ALNORM = ONE - ALNORM
      RETURN
      END
