C evdout.f
C purpose: write evddata.out file for evdphase 1
C written by: Charles Peterson, June 16, 2011
C called by: pinput.f
C
      subroutine evdout (var,mvar,npeo,nvar,iped,vtraits,sex,mibdid,
     * iffirst,conout)

      double precision var(mvar)
      integer npeo,nvar,iped,vtraits,sex(npeo),iffirst,conout

C allocated here

      double precision phi2(npeo,npeo),evec(npeo,npeo),
     *  tpheno(nvar,npeo),eval(npeo),evali(npeo),tmean(npeo),
     *  sex_evd(npeo)
      double precision phi2temp,pheno
      integer ibdid(npeo),unitno,i,j,idoff,lbase,libdid,ivar,ierr,kvar,
     *  ntraits,id
      logical vsample,verbose

c procedure begins here
c determine ntraits and offset to ibdid

      if (vtraits.eq.0) then
         idoff = 2
         ntraits = 1
      else
         idoff = vtraits + 1
         ntraits = vtraits
      end if

c get ibdid vector

      do 301 i=1,npeo
         kvar = (i-1)*nvar+idoff
         ibdid(i) = var(kvar)
c        print *,"ibdid(",i,") = ",ibdid(i)
         if (ibdid(i).gt.mibdid) then
            mibdid = ibdid(i)
         end if
 301  continue

c get phi2 matrix from loaded matrix file through C++
c note: non-default model type forces loading phi2 matrix during maximization

c     open (unit=29,file='phi2copy.out')

      do 303 i=1,npeo
         do 303 j=i,npeo
            call ibdid2phi (ibdid(i),ibdid(j),phi2temp)
            if (phi2temp.ne.0) then
c               write (29,309) ibdid(i),ibdid(j),phi2temp
 309           format (1x,i5,1x,i5,3x,G12.6)
            end if
c           print *,"phi2temp(",i,",",j,") is ",phi2temp
            phi2(i,j) = phi2temp
            phi2(j,i) = phi2temp
 303  continue
c     close (29)

c do eigenvalue decomposition for this pedigree

      if (iffirst.eq.1) then
         vsample = verbose ("SAMPLE")
         if (vsample) then
            write (conout,311)
 311        format (" Calculating EVD...")
         endif
         iffirst = 0
      end if
      ierr = 0
      call tred2 (npeo,npeo,phi2,eval,evali,evec)
      call tql2 (npeo,npeo,eval,evali,evec,ierr)
      if (ierr.ne.0) then
         print *,"tql2 returned ",ierr
         call exit
      end if 

c compute tmean

      do 321 i=1,npeo
          tmean(i) = 0
          do 320 j=1,npeo
             tmean(i) = tmean(i) + evec(j,i)
 320      continue
 321   continue

C compute transformed trait values
C true matrix multiply with eigenmatrix inverse (flipped indexes)
C canonical form: c(i) = c(i) + A(k,i) * B(k)
       
       do 340 ivar=1,nvar
          if (ivar.eq.ntraits+1.or.ivar.eq.ntraits+2) then 
C ibdid or group indicator
             go to 340
          end if
          do 339 i=1,npeo
             tpheno(ivar,i)=0
             do 338 k=1,npeo
                kvar = (k-1)*nvar+ivar
                pheno = var(kvar)
                tpheno(ivar,i) = tpheno(ivar,i) + evec (k,i) * pheno
 338         continue
 339      continue
 340   continue

c compute transformed sex value
       do 350 i=1,npeo
          sex_evd(i) = 0
          do 349 k=1,npeo
C                sex_evd(i) = sex_evd(i) + evec (k,i) * (sex(k)-1)
                sex_evd(i) = sex_evd(i) + evec (k,i) * (2-sex(k))
 349      continue
 350   continue


c write out results

      do 390 i=1,npeo
         kvar = (i-1)*nvar+idoff
         id = var(kvar)
         write (26,399) id,sex(i),sex_evd(i),tmean(i),eval(i),
     *     (tpheno(j,i),j=1,ntraits),(tpheno(j,i),j=idoff+2,nvar)
 390  continue
 399  format (I5,",0,0,",I1,9000(',',D18.12))
      return
      end



C subroutine unitclof (below) MUST ONLY BE CALLED BY C++ routine unitactive
C this allows for proper closing of fortran unit under all circumstances

      subroutine unitclof(unit)
      integer unit

      close (unit)
      return
      end

      
