      SUBROUTINE QDPROG(DELTA,PAR,PARMAX,PARMIN,TABLE,WORK1,WORK2
     1,NSWEEP,SMALL,TOL,MAXPAR,MAXTAB,NCNSTR,NCYCLE,NPAR,NTAB)
C
C     THIS SUBROUTINE SOLVES THE QUADRATIC PROGRAMMING PROBLEM
C         MIN  DF*DELTA+.5*DELTA(TRANSPOSE)*HESS*DELTA
C           SUBJECT TO CNSTR*DELTA=0
C           PARMIN.LE.PAR+DELTA.LE.PARMAX.
C     SEE: R.I.JENNRICH AND P.F.SAMPSON(1978)  "SOME PROBLEMS
C     FACED IN MAKING A VARIANCE COMPONENT ALGORITHM INTO A
C     GENERAL MIXED MODEL PROGRAM"  PROCEEDINGS OF THE ELEVENTH
C     ANNUAL SYMPOSIUM ON THE INTERFACE. A.R.GALLANT AND T.M.GERIG
C     EDITORS. INSTITUTE OF STATISTICS,NORTH CAROLINA STATE 
C     UNIVERSITY.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION DELTA(MAXPAR),PAR(MAXPAR),PARMAX(MAXPAR)
     1,PARMIN(MAXPAR),TABLE(MAXTAB,MAXTAB),WORK1(MAXPAR)
     2,WORK2(MAXTAB),OLDDELTA,CORDELTA
      INTEGER NSWEEP(MAXPAR)
      LOGICAL INV
C
C     SEE SUBROUTINES SETTAB FOR THE CONSTRUCTION OF THE TABLEAU
C     TABLE AND SEARCH FOR THE DEFINTION OF MOST VARIABLES.
C     NSWEEP =1 OR 0 ACCORDING AS A PARAMETER IS SWEPT OR NOT SWEPT.
C     FOR CHECKING TOLERANCE, SET WORK1 TO THE DIAGONAL ELEMENTS OF
C     TABLE.  BEGIN BY SWEEPING ON THOSE DIAGONAL ELEMENTS OF TABLE
C     CORRESPONDING TO THE PARAMETERS.  ALSO SWEEP ON THE DIAGONAL
C     ELEMENTS CORRESPONDING TO THE CONSTRAINTS.  IF ANY PARAMETER
C     FAILS THE TOLERANCE TEST, THEN RETURN AND RESET THE APPROXIMATE
C     HESSIAN.
C
      CALL DOPTION('CORRECTDELTAS',CORDELTA)
      TOLS=-TOL*1.0D-3
      NCYCLE=0
      INV=.FALSE.
      DO 10 I=1,NPAR
      IF (TABLE(I,I).LE.0.0D0) RETURN
      WORK1(I)=TABLE(I,I)
 10   DELTA(I)=0.0D0
      DO 20 I=1,NPAR
      IF (TABLE(I,I)/WORK1(I).LT.TOL) RETURN
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
 20   NSWEEP(I)=1
      DO 30 I=1,NCNSTR
      K=NPAR+I
      IF (TABLE(K,K).GE.0.0D0) RETURN
 30   CALL SWEEP(TABLE,WORK2,K,MAXTAB,NTAB,INV)
C
C     TAKE A STEP IN THE DIRECTION TABLE(I,NTAB) FOR THE PARAMETERS
C     I THAT ARE CURRENTLY SWEPT.  IF A BOUNDARY IS ENCOUNTERED,
C     DETERMINE THE MAXIMAL FRACTIONAL STEP POSSIBLE.
C
 70   IF (NCYCLE.GE.1000) RETURN
      A=1.0D0
      DO 40 I=1,NPAR
      IF (NSWEEP(I).EQ.1) THEN
      UI=TABLE(I,NTAB)
      IF (UI.GT.0.0D0) THEN
      AI=PARMAX(I)-PAR(I)-DELTA(I)
      ELSE
      AI=PARMIN(I)-PAR(I)-DELTA(I)
      END IF
      IF (ABS(AI).LT.ABS(UI)) A=MIN(A,AI/UI)
      END IF
 40   CONTINUE
C
C     TAKE THE FRACTIONAL STEP FOR THE CURRENTLY SWEPT PARAMETERS,
C     AND RESET THE TRANSFORMED PARTIAL DERIVATIVES FOR THESE
C     PARAMETERS.
C
      DO 50 I=1,NPAR
      IF (NSWEEP(I).EQ.1) THEN
      UI=TABLE(I,NTAB)
      OLDDELTA=DELTA(I)
      DELTA(I)=DELTA(I)+A*UI
      TABLE(I,NTAB)=(1.0D0-A)*UI
C
C Optional numerical correction here (ultimate correction in search.f)
C
      IF (CORDELTA.NE.0D0) THEN
         IF (UI.GT.0D0) THEN
            IF (PARMAX(I)-(PAR(I)+DELTA(I)).LT.0) THEN
               DELTA(I)=PARMAX(I)-PAR(I)
               PRINT *, 'Corrected down DELTA(',I,')'
            END IF
         ELSE
            IF (PAR(I)+DELTA(I)-PARMIN(I).LT.0) THEN
               DELTA(I)=PARMIN(I)-PAR(I)
               PRINT *, 'Corrected up DELTA(',I,')'
            END IF
         END IF
         TABLE(I,NTAB)=UI-(DELTA(I)-OLDDELTA)
      END IF

      END IF
 50   CONTINUE
C
C     FIND THOSE SWEPT PARAMETERS WHICH ARE CRITICAL, AND INVERSE
C     SWEEP THEM IF POSSIBLE.  GO BACK AND TRY TO TAKE ANOTHER
C     STEP OR FRACTIONAL STEP.
C 
      DO 60 I=1,NPAR
C        print *,'sum is ',PAR(3)+DELTA(3)+PAR(4)+DELTA(4)+PAR(6)+
C    1       DELTA(6)
      IF (NSWEEP(I).EQ.1.AND.TABLE(I,I)/WORK1(I).LT.TOLS.AND
     1.(PARMIN(I).GE.PAR(I)+DELTA(I)-SMALL.OR
     2.PARMAX(I).LE.PAR(I)+DELTA(I)+SMALL)) THEN
C     print *,'Paramter critical ',I
      INV=.TRUE.
      NCYCLE=NCYCLE+1
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
      NSWEEP(I)=0
      GO TO 70
      END IF
 60   CONTINUE
C
C     FIND AN UNSWEPT PARAMETER THAT VIOLATES THE KUHN-TUCKER
C     CONDIION AND SWEEP ON IT.  GO BACK AND TRY TO TAKE A
C     STEP OR FRACTIONAL STEP.  IF NO SUCH PARAMETER EXISTS,
C     THE PROBLEM IS SOLVED.
C
      DO 80 I=1,NPAR
      UI=TABLE(I,NTAB)
      IF (NSWEEP(I).EQ.0.AND
     1.((UI.GT.0.0D0.AND.PARMIN(I).GE.PAR(I)+DELTA(I)-SMALL).OR
     2.(UI.LT.0.0D0.AND.PARMAX(I).LE.PAR(I)+DELTA(I)+SMALL))) THEN
      INV=.FALSE.
      NCYCLE=NCYCLE+1
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,INV)
      NSWEEP(I)=1
      GO TO 70
      END IF
 80   CONTINUE
      NCYCLE=-1
      END
