      FUNCTION CHISQ(X,N)
C
C     CHISQ COMPUTES THE RIGHT TAIL PROBABILITY (PVALUE) FOR A
C     CHI-SQUARE DISTRIBUTION WITH N DEGREES OF FREEDOM.  IF THE POINT
C     X IS TOO LARGE,  CHISQ IS SET TO ZERO.  NOTE THE APPLICATION
C     OF THE CENTRAL LIMIT THEOREM HERE.  FOR N BIGGER THAN 100,
C     THE WILSON-HILFERTY APPROXIMATION IS USED.  SEE:  SECTION 16.7
C     OF M.G. KENDALL AND A. STUART(1963). "THE ADVANCED THEORY OF
C     STATISTICS, VOL. 1, 2ND ED."  HAFNER PUBLISHING. NEW YORK.
C     FOR ALL OTHER N, EXACT FORMULAS ARE POSSIBLE BASED ON SUCCESSIVE
C     INTEGRATIONS BY PARTS.  ONE FORMULA IS APPROPRIATE WHEN
C     N IS EVEN AND ANOTHER WHEN N IS ODD.  SEE: PROBLEM 16.7 OF
C     KENDALL AND STUART.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      Y=DBLE(N)
C
C     IF X IS HUGE, CHISQ IS ZERO.
C
      IF (X/SQRT(Y).GT.30.D0) THEN
      CHISQ=0.0D0
C
C     IF THE NUMBER OF DEGREES OF FREEDOM IS BIG, USE THE WILSON-HILFERTY
C     APPROXIMATION.
C
      ELSE IF (N.GT.100) THEN
      T=((X/Y)**(1.0D0/3.0D0)+2.0D0/(9.D0*Y)-1.0D0)*SQRT(9.D0*Y/2.D0)
      CHISQ=GAUCDF(-T)
C
C     OTHERWISE, USE ONE OF THE SERIES' GIVEN IN PROBLEM 16.7.
C
      ELSE
      IF (MOD(N,2).EQ.1) THEN
C
C     N IS ODD.
C
      Y=SQRT(X)
      CHISQ=2.0D0*GAUCDF(-Y)
      M=(N-1)/2
      IF (M.EQ.0) RETURN
      T=0.7978845608028654D0*EXP(-X/2.0D0)*Y
      DEN=1.0D0
      ELSE
C
C     N IS EVEN.
C
      CHISQ=EXP(-X/2.0D0)
      M=(N-2)/2
      IF (M.EQ.0) RETURN
      T=CHISQ*X/2.0D0
      DEN=2.0D0
      END IF
C
C     SUM A FINITE SERIES CORRESPONDING TO THE REPEATED INTEGRATION
C     BY PARTS.  IF THE TERMS GET SMALL ENOUGH, QUIT.
C
      DO 10 I=1,M
      CHISQ=CHISQ+T
      DEN=DEN+2.0D0
      RATIO=X/DEN
      IF (T.LT.1.D-10.AND.RATIO.LT.0.9D0) RETURN
 10   T=T*RATIO
      END IF
      END
