      FUNCTION FDIST(X,P,Q)
C
C     THIS FUNCTION SUBROUTINE COMPUTES THE F CUMULATIVE DISTRIBUTION
C     AT THE POINT X FOR DEGREES OF FREEDOM P AND Q.  P AND Q NEED
C     NOT BE INTEGERS.  SEE EQUATIONS 3A.2.7A, 3A.2.9, AND 3A.2.12
C     IN CR RAO(1973), "LINEAR STATISTICAL INFERENCE AND ITS APPLICATIONS
C     2ND ED."  WHEN Q IS LARGE, A CHI-SQUARE APPROXIMATION IS USED. THIS
C     IS DESCRIBED IN EXAMPLE 1.5.2 OF BICKEL AND DOKSUM(1977),
C     "MATHEMATICAL STATTISTICS."
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      IF (Q.GE.1000.0D0) THEN
      FDIST=1.0D0-CHISQ(X*P,INT(P))
      ELSE
      PP=.5D0*P
      QQ=.5D0*Q
      T=P*X/(Q+P*X)
      FDIST=BETA(T,PP,QQ)
      END IF
      END
