      SUBROUTINE NEWLIK(EXTRA,INFORM,PAR,QDERIV,SCORE,LOGLIK,QDFORM,ITER
     1,NEXTRA,NOBS,NPAR,NPED,NTRAIT,PED,NORMAL)
C
C     THIS SUBROUTINE CAN BE USED TO ADJUST THE LOGLIKELIHOOD, QUADRATIC
C     FORM, AND SCORE FOR PEDIGREE NUMBER PED AT ITERATION NUMBER ITER.  
C     AT THE FIRST ITERATION IT CAN ALSO BE USED TO ADJUST THE INFORMATION
C     MATRIX.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION EXTRA(NEXTRA),INFORM(NPAR,NPAR),PAR(NPAR)
     1,QDERIV(NPAR),SCORE(NPAR),LOGLIK
      INTEGER PED,TINDEX,TDISTP
      LOGICAL NORMAL
C
      DOUBLE PRECISION LOGDET
C
C     RECOMPUTE THE LOGLIKELIHOOD.  THE PARAMETER PAR(TDISTP())
C     THE MULTIVARIATE T PARAMETER.
C
      IF (.NOT.NORMAL) THEN
	TINDEX=TDISTP()
        T=PAR(TINDEX)
        A=DBLE(NOBS*NTRAIT)
        B=T+A
        C=T+QDFORM
        D=1.D0+QDFORM/T
        LOGDET=-2.D0*LOGLIK-QDFORM
        LOGLIK=-.5D0*(LOGDET+A*LOG(T)+B*LOG(D))
     :  +GAMLOG(.5D0*B)-GAMLOG(.5D0*T)
C
C     RECOMPUTE THE SCORE VECTOR.  DL WILL BE THE DERIVATIVE OF THE
C     LOG DETERMINANT.
C
        DO 10 I=1,NPAR
          IF (I.NE.TINDEX) THEN
             DL=-2.D0*SCORE(I)-QDERIV(I)
             SCORE(I)=-.5D0*(DL+B*QDERIV(I)/C)
          ENDIF
 10    CONTINUE
C
C     COMPUTE THE SCORE COMPONENT CORRESPONDING TO THE T DISTRIBUTION
C     PARAMETER.
C
        SCORE(TINDEX)=.5D0*(1.D0-B/C-LOG(D)+DIGAM(.5D0*B)-DIGAM(.5D0*T))
C
C     APPROXIMATE THE INFORMATION MATRIX ENTRY FOR THE T PARAMETER
C     BY MINUS THE DERIVATIVE OF THE SCORE.  NOTE THE SCALING OF
C     THIS ENTRY BASED ON NEWTON'S METHOD.
C
        IF (ITER.EQ.1) THEN
          DS=.5D0*(1.D0/T-2.D0/C+B/(C*C))
     :    +.25D0*(TRIGAM(.5D0*B)-TRIGAM(.5D0*T))
          INFORM(TINDEX,TINDEX)=MAX(ABS(.1D0*SCORE(TINDEX)),-DS)
        END IF
      END IF
      END
