      SUBROUTINE RESID(OMEGA,WORK,VAR,DEPVAR,PERSON,PERCUT,TPAR,MAXPEO
     1,MAXVAR,MOMEGA,MWORK,NPBAND,NPEO,NTRAIT,NVAR,PED,UNIT3,NORMAL)
C
C     THIS SUBROUTINE LOOKS AT THE RESIDUALS OF EACH NON-PROBAND
C     CONDITIONAL ON THE REMAINING TRAIT VALUES RECORDED FOR THE
C     PEDIGREE.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION OMEGA(MOMEGA,MOMEGA),WORK(MWORK),VAR(MAXVAR)
      INTEGER DEPVAR(NTRAIT),PERSON(MAXPEO),BORDER,PED,UNIT3,LID
     1,GETVIRT,JOFF
      LOGICAL NORMAL
      CHARACTER*18 FIRST_ID
C
C     TMULT IS USED TO ADJUST PREDICTED STANDARD DEVIATIONS IN A
C     MULTIVARIATE T MODEL.
C
      IF (.NOT.NORMAL.AND.TPAR.GT.2.D0) TMULT=SQRT(TPAR/(TPAR-2.D0))
C
C     OUTPUT A HEADER.
C
      IF (PED.EQ.1) WRITE(UNIT3,10)
 10   FORMAT(//,'                POSSIBLE OUTLIER INDIVIDUALS'
     1//' FOR EACH NON-PROBAND WITH ALL VARIABLES MEASURED, IT IS'
     2/' POSSIBLE TO PREDICT HIS/HER TRAIT VALUES GIVEN THE TRAIT'
     3/' VALUES OF OTHER PEDIGREE MEMBERS.  THESE PREDICTED VALUES'
     4/' CAN BE COMPARED TO THE OBSERVED VALUES BY COMPUTING AN'
     5/' APPROPRIATE QUADRATIC FORM.  THOSE INDIVIDUALS WITH PVALUES'
     6/' FOR THE QUADRATIC FORM LESS THAN THE CUTOFF MAY BE OUTLIERS'
     7/' AND ARE LISTED BELOW.  PEDIGREES IDENTIFIED BY FIRST IND. ID')
C
C     COPY THE UPPER TRIANGLE OF THE TABLEAU INTO THE LOWER TRIANGLE
C     OF THE TABLEAU.
C
      BORDER=NPEO*NTRAIT+1
      DO 20 I=1,BORDER
      DO 20 J=I,BORDER
 20   OMEGA(J,I)=OMEGA(I,J)
C
C     FOR EACH NON-PROBAND IN THE PEDIGREE COPY HIS PART OF
C     -OMEGA(INVERSE) AND OMEGA(INVERSE)*RESIDUAL INTO THE UPPER
C     LEFT HAND TRIANGLE OF THE TABLEAU.  THIS CREATES A PARTIAL
C     TABLEAU.
C
      NBORD=NTRAIT+1
      SAVE=OMEGA(NBORD,NBORD)
      DO 30 IPER=NPBAND+1,NPEO
      ITRAIT=(IPER-1)*NTRAIT
      DO 40 J=1,NTRAIT
      OMEGA(J,NBORD)=OMEGA(BORDER,ITRAIT+J)
      DO 40 K=J,NTRAIT
 40   OMEGA(J,K)=OMEGA(ITRAIT+K,ITRAIT+J)
C
C     SET THE LOWER RIGHT ENTRY OF THIS PARTIAL TABLEAU TO ZERO.
C     HERE, AFTER INVERSE SWEEPING, THE CONDITIONAL QUADRATIC FORM
C     FOR THE CURRENT PERSON WILL APPEAR.
C
      OMEGA(NBORD,NBORD)=0.0D0
C
C     INVERSE SWEEP THE PARTIAL TABLEAU.  THIS PRODUCES THE CONDITIONAL
C     COVARIANCE MATRIX BORDERED ON THE RIGHT BY THE CONDITIONAL
C     RESIDUAL.
C
      DO 50 J=1,NTRAIT
 50   CALL SWEEP(OMEGA,WORK,J,MOMEGA,NBORD,.TRUE.)
C
C     RECORD THE QUADRATIC FORM AND COMPUTE ITS ASSOCIATED PVALUE.
C
      QDFORM=OMEGA(NBORD,NBORD)
C
C     FOR THE NORMAL MODEL USE A CHI-SQUARE DISTRIBUTION AND FOR THE
C     T MODEL USE AN F DISTRIBUTION.  THE T PARAMETER IS PASSED VIA
C     TPAR.
C
      IF (NORMAL) THEN
      PVALUE=CHISQ(QDFORM,NTRAIT)
      ELSE
      DFN=DBLE(NTRAIT)
      POINT=QDFORM/DFN
      PVALUE=1.D0-FDIST(POINT,DFN,TPAR)
      END IF
C
C     IF THE PVALUE OF THE CURRENT PERSON IS BELOW THE CUTOFF
C     LEVEL, THEN OUTPUT THE STATISTICS FOR HIM.
C
      IF (PVALUE.LE.PERCUT) THEN
      CALL FIRSTID (PED, FIRST_ID)
      LID = LNBLNK (FIRST_ID)
      IF (QDFORM.LT.100.) THEN
      WRITE(UNIT3,60) FIRST_ID(1:LID),PERSON(IPER),QDFORM,PVALUE
 60   FORMAT(/' PEDIGREE    PERSON    QUADRATIC FORM      PVALUE'
     1,/,A,6X,I6,9X,F8.4,8X,F7.5)
      ELSE
      WRITE(UNIT3,70) FIRST_ID(1:LID),PERSON(IPER),QDFORM,PVALUE
 70   FORMAT(/' PEDIGREE    PERSON    QUADRATIC FORM      PVALUE'
     1,/,A,6X,I6,7X,G10.4,8X,F7.5)
      END IF
      WRITE(UNIT3,80)
 80   FORMAT(' TRAIT      OBSERVED     PREDICTED    STANDARD DEVIATION')
      IVAR=(IPER-1)*NVAR
      DO 90 J=1,NTRAIT
         JOFF = NTRAIT
         IF (GETVIRT().NE.0) THEN
            IF (VAR(IVAR).NE.J) GOTO 90
            JOFF = 2
         ENDIF
      OBSERV=VAR(IVAR+JOFF)
      PREDIC=OBSERV-OMEGA(J,NBORD)
      IF (NORMAL.OR.TPAR.GT.2.0D0) THEN
      STDEV=SQRT(OMEGA(J,J))
      IF (.NOT.NORMAL) STDEV=TMULT*STDEV
      WRITE(UNIT3,100) J,OBSERV,PREDIC,STDEV
 100  FORMAT(I5,7X,G10.4,4X,G10.4,5X,G10.4)
      ELSE
      WRITE(UNIT3,110) J,OBSERV,PREDIC
 110  FORMAT(I5,7X,G10.4,3X,G10.4,9X,'*******')
      END IF
 90   CONTINUE
      END IF
C
C     REMEMBER TO REPLACE THE DIAGONAL ENTRY OF OMEGA WHERE THE
C     QUADRATIC FORM APPEARED.
C
 30   IF (IPER.EQ.1) OMEGA(NBORD,NBORD)=SAVE
      END
