      FUNCTION TRIGAM(X)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE COMPUTES THE SECOND DERIVATIVE OF LOG(GAMMA(X)) VIA
C     A RECURRENCE RELATION AND THE ASYMPTOTIC EXPANSION 6.4.12
C     GIVEN IN: M ABRAMOWITZ, IA STEGUN(1964). HANDBOOK OF MATHEMATICAL
C     FUNCTIONS WITH FORMULAS, GRAPHS, AND MATHEMATICAL TABLES.
C     NATIONAL BUREAU OF STANDARDS.
C
      Y=X
      F=0.D0
 10   IF (Y.LT.10.D0) THEN
      F=F+1.D0/(Y*Y)
      Y=Y+1.D0
      GO TO 10
      END IF
      TRIGAM=F+1.D0/Y+1.D0/(2.D0*Y**2)+1.D0/(6.D0*Y**3)
      TRIGAM=TRIGAM-1.D0/(30.D0*Y**5)+1.D0/(42.D0*Y**7)
      END
