/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.libraries;

import edu.jhmi.rad.medic.structures.BinaryTree;
import edu.jhmi.rad.medic.structures.CriticalPointLUT;
import edu.jhmi.rad.medic.structures.Graph;
import edu.jhmi.rad.medic.structures.GraphNode;
import edu.jhmi.rad.medic.utilities.ImageCropper;
import edu.jhmi.rad.medic.utilities.Numerics;
import edu.jhu.ece.iacl.utility.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class ObjectProcessing {
    private static final int MaxObject = 1000000;
    public static final int SUPERIOR = 10;
    public static final int SUPEQUAL = 11;
    public static final int INFERIOR = 12;
    public static final int INFEQUAL = 13;
    public static final int EQUAL = 14;
    public static final int UNEQUAL = 15;
    public static final int NONE = 25;
    public static final int AND = 26;
    public static final int OR = 27;
    public static final int XOR = 28;
    public static final float SQR2 = (float)Math.sqrt(2.0);
    public static final float SQR3 = (float)Math.sqrt(3.0);

    public static final boolean[][][] objectFromImage(float[][][] img, int nx, int ny, int nz, float level1, float level2, int type1, int type2) {
        boolean[][][] obj = new boolean[nx][ny][nz];
        if (level1 > level2) {
            float tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = true;
                    if (type1 == 12 && img[x][y][z] >= level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 13 && img[x][y][z] > level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 10 && img[x][y][z] <= level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 11 && img[x][y][z] < level1) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 10 && img[x][y][z] <= level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 11 && img[x][y][z] < level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 12 && img[x][y][z] >= level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 13 && img[x][y][z] > level2) {
                        obj[x][y][z] = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[][][] objectFromImage(float[][][] img, int nx, int ny, int nz, float level, int type) {
        boolean[][][] obj = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = true;
                    if (type == 12 && img[x][y][z] >= level) {
                        obj[x][y][z] = false;
                    }
                    if (type == 13 && img[x][y][z] > level) {
                        obj[x][y][z] = false;
                    }
                    if (type == 10 && img[x][y][z] <= level) {
                        obj[x][y][z] = false;
                    }
                    if (type == 11 && img[x][y][z] < level) {
                        obj[x][y][z] = false;
                    }
                    if (type == 14 && img[x][y][z] != level) {
                        obj[x][y][z] = false;
                    }
                    if (type == 15 && img[x][y][z] == level) {
                        obj[x][y][z] = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[] objectFromImage(float[] img, int nx, int ny, int nz, float level, int type) {
        boolean[] obj = new boolean[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    int xyz = x + nx * y + nx * ny * z;
                    obj[xyz] = true;
                    if (type == 12 && img[xyz] >= level) {
                        obj[xyz] = false;
                    }
                    if (type == 13 && img[xyz] > level) {
                        obj[xyz] = false;
                    }
                    if (type == 10 && img[xyz] <= level) {
                        obj[xyz] = false;
                    }
                    if (type == 11 && img[xyz] < level) {
                        obj[xyz] = false;
                    }
                    if (type == 14 && img[xyz] != level) {
                        obj[xyz] = false;
                    }
                    if (type == 15 && img[xyz] == level) {
                        obj[xyz] = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final float[] floatObjectFromImage(float[] img, int nx, int ny, int nz, float level, int type) {
        float[] obj = new float[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    int xyz = x + nx * y + nx * ny * z;
                    obj[xyz] = 1.0f;
                    if (type == 12 && img[xyz] >= level) {
                        obj[xyz] = 0.0f;
                    }
                    if (type == 13 && img[xyz] > level) {
                        obj[xyz] = 0.0f;
                    }
                    if (type == 10 && img[xyz] <= level) {
                        obj[xyz] = 0.0f;
                    }
                    if (type == 11 && img[xyz] < level) {
                        obj[xyz] = 0.0f;
                    }
                    if (type == 14 && img[xyz] != level) {
                        obj[xyz] = 0.0f;
                    }
                    if (type == 15 && img[xyz] == level) {
                        obj[xyz] = 0.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[][][] objectFromImage(float[][][] img, float thresh, Comparator comp) {
        int nx = img.length;
        int ny = img[0].length;
        int nz = img[0][0].length;
        boolean[][][] obj = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    switch (comp) {
                        case SUP: {
                            obj[x][y][z] = img[x][y][z] > thresh;
                            break;
                        }
                        case SUP_EQ: {
                            obj[x][y][z] = img[x][y][z] >= thresh;
                            break;
                        }
                        case INF: {
                            obj[x][y][z] = img[x][y][z] < thresh;
                            break;
                        }
                        case INF_EQ: {
                            obj[x][y][z] = img[x][y][z] <= thresh;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[][][] objectFromLabelImage(int[][][] img, int nx, int ny, int nz, int level1, int level2, int type1, int type2) {
        boolean[][][] obj = new boolean[nx][ny][nz];
        if (level1 > level2) {
            int tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = true;
                    if (type1 == 12 && img[x][y][z] >= level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 13 && img[x][y][z] > level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 10 && img[x][y][z] <= level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 11 && img[x][y][z] < level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 14 && img[x][y][z] != level1) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 10 && img[x][y][z] <= level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 11 && img[x][y][z] < level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 12 && img[x][y][z] >= level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 13 && img[x][y][z] > level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 14 && img[x][y][z] != level2) {
                        obj[x][y][z] = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[][][] objectFromLabelImage(byte[][][] img, int nx, int ny, int nz, int level1, int level2, int type1, int type2) {
        boolean[][][] obj = new boolean[nx][ny][nz];
        if (level1 > level2) {
            int tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = true;
                    if (type1 == 12 && img[x][y][z] >= level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 13 && img[x][y][z] > level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 10 && img[x][y][z] <= level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 11 && img[x][y][z] < level1) {
                        obj[x][y][z] = false;
                    }
                    if (type1 == 14 && img[x][y][z] != level1) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 10 && img[x][y][z] <= level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 11 && img[x][y][z] < level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 12 && img[x][y][z] >= level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 13 && img[x][y][z] > level2) {
                        obj[x][y][z] = false;
                    }
                    if (type2 == 14 && img[x][y][z] != level2) {
                        obj[x][y][z] = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[][][] objectFromLabelImage(byte[][][] img, int nx, int ny, int nz, int level, int type) {
        return ObjectProcessing.objectFromLabelImage(img, nx, ny, nz, level, level, type, type);
    }

    public static final boolean[][][] objectFromLabelImage(int[][][] img, int nx, int ny, int nz, int level, int type) {
        return ObjectProcessing.objectFromLabelImage(img, nx, ny, nz, level, level, type, type);
    }

    public static final boolean[][] objectFromLabelImage(int[][] img, int nx, int ny, int level1, int level2, int type1, int type2) {
        boolean[][] obj = new boolean[nx][ny];
        if (level1 > level2) {
            int tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                obj[x][y] = true;
                if (type1 == 12 && img[x][y] >= level1) {
                    obj[x][y] = false;
                }
                if (type1 == 13 && img[x][y] > level1) {
                    obj[x][y] = false;
                }
                if (type1 == 10 && img[x][y] <= level1) {
                    obj[x][y] = false;
                }
                if (type1 == 11 && img[x][y] < level1) {
                    obj[x][y] = false;
                }
                if (type1 == 14 && img[x][y] != level1) {
                    obj[x][y] = false;
                }
                if (type2 == 10 && img[x][y] <= level2) {
                    obj[x][y] = false;
                }
                if (type2 == 11 && img[x][y] < level2) {
                    obj[x][y] = false;
                }
                if (type2 == 12 && img[x][y] >= level2) {
                    obj[x][y] = false;
                }
                if (type2 == 13 && img[x][y] > level2) {
                    obj[x][y] = false;
                }
                if (type2 == 14 && img[x][y] != level2) {
                    obj[x][y] = false;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final byte[][][] objectFromLabelImageToByte(byte[][][] img, int nx, int ny, int nz, int level1, int level2, int type1, int type2) {
        byte[][][] obj = new byte[nx][ny][nz];
        if (level1 > level2) {
            int tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = 1;
                    if (type1 == 12 && img[x][y][z] >= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 13 && img[x][y][z] > level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 10 && img[x][y][z] <= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 11 && img[x][y][z] < level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 14 && img[x][y][z] != level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 10 && img[x][y][z] <= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 11 && img[x][y][z] < level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 12 && img[x][y][z] >= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 13 && img[x][y][z] > level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 14 && img[x][y][z] != level2) {
                        obj[x][y][z] = 0;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final byte[][][] objectFromLabelImageToByte(byte[][][] img, int nx, int ny, int nz, int[] maskinds) {
        byte[][][] obj = new byte[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = 1;
                    if (maskinds[img[x][y][z]] < 0) {
                        obj[x][y][z] = 0;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final byte[][][] objectFromLabelImageToByteZwise(byte[][][] img, int nx, int ny, int nz, int level1, int level2, int type1, int type2) {
        byte[][][] obj = new byte[nx][ny][nz];
        if (level1 > level2) {
            int tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int z = 0;
        while (z < nz) {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    obj[x][y][z] = 1;
                    if (type1 == 12 && img[x][y][z] >= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 13 && img[x][y][z] > level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 10 && img[x][y][z] <= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 11 && img[x][y][z] < level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 14 && img[x][y][z] != level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 10 && img[x][y][z] <= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 11 && img[x][y][z] < level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 12 && img[x][y][z] >= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 13 && img[x][y][z] > level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 14 && img[x][y][z] != level2) {
                        obj[x][y][z] = 0;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return obj;
    }

    public static final byte[][][] objectFromLabelImageToByte(byte[] img, int nx, int ny, int nz, int level1, int level2, int type1, int type2) {
        byte[][][] obj = new byte[nx][ny][nz];
        if (level1 > level2) {
            int tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int xyz = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = 1;
                    if (type1 == 12 && img[xyz] >= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 13 && img[xyz] > level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 10 && img[xyz] <= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 11 && img[xyz] < level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 14 && img[xyz] != level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 10 && img[xyz] <= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 11 && img[xyz] < level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 12 && img[xyz] >= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 13 && img[xyz] > level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 14 && img[xyz] != level2) {
                        obj[x][y][z] = 0;
                    }
                    ++xyz;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final byte[][][] objectFromLabelImageToByte(byte[] img, int nx, int ny, int nz, int[] maskinds) {
        byte[][][] obj = new byte[nx][ny][nz];
        int xyz = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[xyz] >= 0 && maskinds[img[xyz]] >= 0) {
                        obj[x][y][z] = 1;
                    }
                    ++xyz;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final byte[][][] objectFromLabelImageToByteZwise(byte[] img, int nx, int ny, int nz, int level1, int level2, int type1, int type2) {
        byte[][][] obj = new byte[nx][ny][nz];
        if (level1 > level2) {
            int tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int xyz = 0;
        int z = 0;
        while (z < nz) {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    obj[x][y][z] = 1;
                    if (type1 == 12 && img[xyz] >= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 13 && img[xyz] > level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 10 && img[xyz] <= level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 11 && img[xyz] < level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type1 == 14 && img[xyz] != level1) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 10 && img[xyz] <= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 11 && img[xyz] < level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 12 && img[xyz] >= level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 13 && img[xyz] > level2) {
                        obj[x][y][z] = 0;
                    }
                    if (type2 == 14 && img[xyz] != level2) {
                        obj[x][y][z] = 0;
                    }
                    ++xyz;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return obj;
    }

    public static final byte[][][] objectFromLabelImageToByte(byte[] img, int nx, int ny, int nz, int level, int type) {
        return ObjectProcessing.objectFromLabelImageToByte(img, nx, ny, nz, level, level, type, type);
    }

    public static final byte[][][] objectFromLabelImageToByteZwise(byte[] img, int nx, int ny, int nz, int level, int type) {
        return ObjectProcessing.objectFromLabelImageToByteZwise(img, nx, ny, nz, level, level, type, type);
    }

    public static final byte[][][] objectFromLabelImageToByte(byte[][][] img, int nx, int ny, int nz, int level, int type) {
        return ObjectProcessing.objectFromLabelImageToByte(img, nx, ny, nz, level, level, type, type);
    }

    public static final byte[][][] objectFromLabelImageToByteZwise(byte[][][] img, int nx, int ny, int nz, int level, int type) {
        return ObjectProcessing.objectFromLabelImageToByteZwise(img, nx, ny, nz, level, level, type, type);
    }

    public static final boolean[][][] objectFromLabelImage(int[][][] img, int nx, int ny, int nz, int[] groups) {
        boolean[][][] obj = new boolean[nx][ny][nz];
        Arrays.sort(groups);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (Arrays.binarySearch(groups, img[x][y][z]) >= 0) {
                        obj[x][y][z] = true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final float[][][] labelFromImage(float[][][] img, int nx, int ny, int nz, float level1, float level2, int type1, int type2) {
        float[][][] label = new float[nx][ny][nz];
        boolean[][][] obj = ObjectProcessing.objectFromImage(img, nx, ny, nz, level1, level2, type1, type2);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    label[x][y][z] = obj[x][y][z] ? 1.0f : 0.0f;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        obj = null;
        return label;
    }

    public static final boolean[][] objectFromImageXSlice(float[][][] img, int nx, int ny, int nz, int x, float level1, float level2, int type1, int type2) {
        boolean[][] obj = new boolean[ny][nz];
        if (level1 > level2) {
            float tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int y = 0;
        while (y < ny) {
            int z = 0;
            while (z < nz) {
                obj[y][z] = true;
                if (type1 == 12 && img[x][y][z] >= level1) {
                    obj[y][z] = false;
                }
                if (type1 == 13 && img[x][y][z] > level1) {
                    obj[y][z] = false;
                }
                if (type1 == 10 && img[x][y][z] <= level1) {
                    obj[y][z] = false;
                }
                if (type1 == 11 && img[x][y][z] < level1) {
                    obj[y][z] = false;
                }
                if (type2 == 10 && img[x][y][z] <= level2) {
                    obj[y][z] = false;
                }
                if (type2 == 11 && img[x][y][z] < level2) {
                    obj[y][z] = false;
                }
                if (type2 == 12 && img[x][y][z] >= level2) {
                    obj[y][z] = false;
                }
                if (type2 == 13 && img[x][y][z] > level2) {
                    obj[y][z] = false;
                }
                ++z;
            }
            ++y;
        }
        return obj;
    }

    public static final boolean[][] objectFromImageYSlice(float[][][] img, int nx, int ny, int nz, int y, float level1, float level2, int type1, int type2) {
        boolean[][] obj = new boolean[nx][nz];
        if (level1 > level2) {
            float tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int x = 0;
        while (x < nx) {
            int z = 0;
            while (z < nz) {
                obj[x][z] = true;
                if (type1 == 12 && img[x][y][z] >= level1) {
                    obj[x][z] = false;
                }
                if (type1 == 13 && img[x][y][z] > level1) {
                    obj[x][z] = false;
                }
                if (type1 == 10 && img[x][y][z] <= level1) {
                    obj[x][z] = false;
                }
                if (type1 == 11 && img[x][y][z] < level1) {
                    obj[x][z] = false;
                }
                if (type2 == 10 && img[x][y][z] <= level2) {
                    obj[x][z] = false;
                }
                if (type2 == 11 && img[x][y][z] < level2) {
                    obj[x][z] = false;
                }
                if (type2 == 12 && img[x][y][z] >= level2) {
                    obj[x][z] = false;
                }
                if (type2 == 13 && img[x][y][z] > level2) {
                    obj[x][z] = false;
                }
                ++z;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[][] objectFromImageZSlice(float[][][] img, int nx, int ny, int nz, int z, float level1, float level2, int type1, int andor, int type2) {
        boolean[][] obj = new boolean[nx][ny];
        if (level1 > level2) {
            float tmp = level1;
            level1 = level2;
            level2 = tmp;
            int typ = type1;
            type1 = type2;
            type2 = typ;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                if (andor == 26) {
                    obj[x][y] = true;
                    if (type1 == 12 && img[x][y][z] >= level1) {
                        obj[x][y] = false;
                    }
                    if (type1 == 13 && img[x][y][z] > level1) {
                        obj[x][y] = false;
                    }
                    if (type1 == 10 && img[x][y][z] <= level1) {
                        obj[x][y] = false;
                    }
                    if (type1 == 11 && img[x][y][z] < level1) {
                        obj[x][y] = false;
                    }
                    if (type2 == 10 && img[x][y][z] <= level2) {
                        obj[x][y] = false;
                    }
                    if (type2 == 11 && img[x][y][z] < level2) {
                        obj[x][y] = false;
                    }
                    if (type2 == 12 && img[x][y][z] >= level2) {
                        obj[x][y] = false;
                    }
                    if (type2 == 13 && img[x][y][z] > level2) {
                        obj[x][y] = false;
                    }
                } else {
                    obj[x][y] = false;
                    if (type1 == 12 && img[x][y][z] < level1) {
                        obj[x][y] = true;
                    }
                    if (type1 == 13 && img[x][y][z] <= level1) {
                        obj[x][y] = true;
                    }
                    if (type1 == 10 && img[x][y][z] > level1) {
                        obj[x][y] = true;
                    }
                    if (type1 == 11 && img[x][y][z] >= level1) {
                        obj[x][y] = true;
                    }
                    if (type2 == 10 && img[x][y][z] > level2) {
                        obj[x][y] = true;
                    }
                    if (type2 == 11 && img[x][y][z] >= level2) {
                        obj[x][y] = true;
                    }
                    if (type2 == 12 && img[x][y][z] < level2) {
                        obj[x][y] = true;
                    }
                    if (type2 == 13 && img[x][y][z] <= level2) {
                        obj[x][y] = true;
                    }
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[] objectFromLabelImage(byte[] img, int nx, int ny, int nz, byte level, int type) {
        boolean[] obj = new boolean[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    int xyz = x + nx * y + nx * ny * z;
                    obj[xyz] = true;
                    if (type == 12 && img[xyz] >= level) {
                        obj[xyz] = false;
                    }
                    if (type == 13 && img[xyz] > level) {
                        obj[xyz] = false;
                    }
                    if (type == 10 && img[xyz] <= level) {
                        obj[xyz] = false;
                    }
                    if (type == 11 && img[xyz] < level) {
                        obj[xyz] = false;
                    }
                    if (type == 14 && img[xyz] != level) {
                        obj[xyz] = false;
                    }
                    if (type == 15 && img[xyz] == level) {
                        obj[xyz] = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final int countLabels(int[][][] label, int nx, int ny, int nz) {
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    int n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == (Integer)lb.get(n)) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, label[x][y][z]);
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return Nlb;
    }

    public static final int countLabels(int[] label, int nx, int ny) {
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int xyz = 0;
        while (xyz < nx * ny) {
            boolean newLabel = true;
            int n = 0;
            while (n < Nlb) {
                if (label[xyz] == (Integer)lb.get(n)) {
                    newLabel = false;
                    break;
                }
                ++n;
            }
            if (newLabel) {
                lb.add(Nlb, label[xyz]);
                ++Nlb;
            }
            ++xyz;
        }
        return Nlb;
    }

    public static final int countLabels(int[] label, int nx, int ny, int nz) {
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int xyz = 0;
        while (xyz < nx * ny * nz) {
            boolean newLabel = true;
            int n = 0;
            while (n < Nlb) {
                if (label[xyz] == (Integer)lb.get(n)) {
                    newLabel = false;
                    break;
                }
                ++n;
            }
            if (newLabel) {
                lb.add(Nlb, label[xyz]);
                ++Nlb;
            }
            ++xyz;
        }
        return Nlb;
    }

    public static final int countLabels(float[][][] label, int nx, int ny, int nz) {
        ArrayList<Float> lb = new ArrayList<Float>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    int n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == ((Float)lb.get(n)).floatValue()) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, Float.valueOf(label[x][y][z]));
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return Nlb;
    }

    public static final int countLabels(float[] label, int nx, int ny, int nz) {
        ArrayList<Float> lb = new ArrayList<Float>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    int xyz = x + nx * y + nx * ny * z;
                    int n = 0;
                    while (n < Nlb) {
                        if (label[xyz] == ((Float)lb.get(n)).floatValue()) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, Float.valueOf(label[xyz]));
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return Nlb;
    }

    public static final int countLabels(int[][] label, int nx, int ny) {
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                boolean newLabel = true;
                int n = 0;
                while (n < Nlb) {
                    if (label[x][y] == (Integer)lb.get(n)) {
                        newLabel = false;
                        break;
                    }
                    ++n;
                }
                if (newLabel) {
                    lb.add(Nlb, label[x][y]);
                    ++Nlb;
                }
                ++y;
            }
            ++x;
        }
        return Nlb;
    }

    public static final int[] listLabels(int[][][] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == (Integer)lb.get(n)) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, label[x][y][z]);
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            ++n;
        }
        return list;
    }

    public static final int[] listLabels(int[][] label, int nx, int ny) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                boolean newLabel = true;
                n = 0;
                while (n < Nlb) {
                    if (label[x][y] == (Integer)lb.get(n)) {
                        newLabel = false;
                        break;
                    }
                    ++n;
                }
                if (newLabel) {
                    lb.add(Nlb, label[x][y]);
                    ++Nlb;
                }
                ++y;
            }
            ++x;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            ++n;
        }
        return list;
    }

    public static final float[] listLabels(float[][][] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Float> lb = new ArrayList<Float>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == ((Float)lb.get(n)).floatValue()) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, Float.valueOf(label[x][y][z]));
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        float[] list = new float[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = ((Float)lb.get(n)).floatValue();
            ++n;
        }
        return list;
    }

    public static final float[] listLabels(float[] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Float> lb = new ArrayList<Float>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    int xyz = x + nx * y + nx * ny * z;
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[xyz] == ((Float)lb.get(n)).floatValue()) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, Float.valueOf(label[xyz]));
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        float[] list = new float[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = ((Float)lb.get(n)).floatValue();
            ++n;
        }
        return list;
    }

    public static final int[] listLabels(int[] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int ind = -1;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    ind = x + y * nx + z * nx * ny;
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[ind] == (Integer)lb.get(n)) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, label[ind]);
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            ++n;
        }
        return list;
    }

    public static final int[] listLabels(byte[] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int ind = -1;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    ind = x + y * nx + z * nx * ny;
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[ind] == (Integer)lb.get(n)) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, Integer.valueOf(label[ind]));
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            ++n;
        }
        return list;
    }

    public static final float[] listOrderedLabels(float[][][] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Float> lb = new ArrayList<Float>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == ((Float)lb.get(n)).floatValue()) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, Float.valueOf(label[x][y][z]));
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        float[] list = new float[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = ((Float)lb.get(n)).floatValue();
            int m = n + 1;
            while (m < Nlb) {
                if (((Float)lb.get(m)).floatValue() < list[n]) {
                    list[n] = ((Float)lb.get(m)).floatValue();
                    lb.set(m, (Float)lb.get(n));
                    lb.set(n, Float.valueOf(list[n]));
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final int[] listOrderedLabels(int[][][] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == (Integer)lb.get(n)) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add(Nlb, label[x][y][z]);
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            int m = n + 1;
            while (m < Nlb) {
                if ((Integer)lb.get(m) < list[n]) {
                    list[n] = (Integer)lb.get(m);
                    lb.set(m, (Integer)lb.get(n));
                    lb.set(n, list[n]);
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final int[] listOrderedLabels(int[][] label, int nx, int ny) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                boolean newLabel = true;
                n = 0;
                while (n < Nlb) {
                    if (label[x][y] == (Integer)lb.get(n)) {
                        newLabel = false;
                        break;
                    }
                    ++n;
                }
                if (newLabel) {
                    lb.add(Nlb, label[x][y]);
                    ++Nlb;
                }
                ++y;
            }
            ++x;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            int m = n + 1;
            while (m < Nlb) {
                if ((Integer)lb.get(m) < list[n]) {
                    list[n] = (Integer)lb.get(m);
                    lb.set(m, (Integer)lb.get(n));
                    lb.set(n, list[n]);
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final int[] listOrderedLabels(int[] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int xyz = 0;
        while (xyz < nx * ny * nz) {
            boolean newLabel = true;
            n = 0;
            while (n < Nlb) {
                if (label[xyz] == (Integer)lb.get(n)) {
                    newLabel = false;
                    break;
                }
                ++n;
            }
            if (newLabel) {
                lb.add(Nlb, label[xyz]);
                ++Nlb;
            }
            ++xyz;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            int m = n + 1;
            while (m < Nlb) {
                if ((Integer)lb.get(m) < list[n]) {
                    list[n] = (Integer)lb.get(m);
                    lb.set(m, (Integer)lb.get(n));
                    lb.set(n, list[n]);
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final int[] listOrderedLabels(int[] label, int nx, int ny) {
        int n;
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int Nlb = 0;
        int xyz = 0;
        while (xyz < nx * ny) {
            boolean newLabel = true;
            n = 0;
            while (n < Nlb) {
                if (label[xyz] == (Integer)lb.get(n)) {
                    newLabel = false;
                    break;
                }
                ++n;
            }
            if (newLabel) {
                lb.add(Nlb, label[xyz]);
                ++Nlb;
            }
            ++xyz;
        }
        int[] list = new int[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Integer)lb.get(n);
            int m = n + 1;
            while (m < Nlb) {
                if ((Integer)lb.get(m) < list[n]) {
                    list[n] = (Integer)lb.get(m);
                    lb.set(m, (Integer)lb.get(n));
                    lb.set(n, list[n]);
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final short[] listOrderedLabels(short[][][] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Short> lb = new ArrayList<Short>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == (Short)lb.get(n)) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add((short)Nlb, label[x][y][z]);
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        short[] list = new short[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Short)lb.get(n);
            int m = n + 1;
            while (m < Nlb) {
                if ((Short)lb.get(m) < list[n]) {
                    list[n] = (Short)lb.get(m);
                    lb.set(m, (Short)lb.get(n));
                    lb.set(n, list[n]);
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final short[] listOrderedLabels(short[] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Short> lb = new ArrayList<Short>();
        int Nlb = 0;
        int xyz = 0;
        while (xyz < nx * ny * nz) {
            boolean newLabel = true;
            n = 0;
            while (n < Nlb) {
                if (label[xyz] == (Short)lb.get(n)) {
                    newLabel = false;
                    break;
                }
                ++n;
            }
            if (newLabel) {
                lb.add((short)Nlb, label[xyz]);
                ++Nlb;
            }
            ++xyz;
        }
        short[] list = new short[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Short)lb.get(n);
            int m = n + 1;
            while (m < Nlb) {
                if ((Short)lb.get(m) < list[n]) {
                    list[n] = (Short)lb.get(m);
                    lb.set(m, (Short)lb.get(n));
                    lb.set(n, list[n]);
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final byte[] listOrderedLabels(byte[][][] label, int nx, int ny, int nz) {
        int n;
        ArrayList<Byte> lb = new ArrayList<Byte>();
        int Nlb = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boolean newLabel = true;
                    n = 0;
                    while (n < Nlb) {
                        if (label[x][y][z] == (Byte)lb.get(n)) {
                            newLabel = false;
                            break;
                        }
                        ++n;
                    }
                    if (newLabel) {
                        lb.add((byte)Nlb, label[x][y][z]);
                        ++Nlb;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        byte[] list = new byte[Nlb];
        n = 0;
        while (n < Nlb) {
            list[n] = (Byte)lb.get(n);
            int m = n + 1;
            while (m < Nlb) {
                if ((Byte)lb.get(m) < list[n]) {
                    list[n] = (Byte)lb.get(m);
                    lb.set(m, (Byte)lb.get(n));
                    lb.set(n, list[n]);
                }
                ++m;
            }
            ++n;
        }
        return list;
    }

    public static final boolean[][][] largestObjectFromLabel(int[][][] label, int nlb, int nx, int ny, int nz) {
        int z;
        int y;
        boolean[][][] obj = new boolean[nx][ny][nz];
        int[] Nobj = new int[nlb];
        int n = 0;
        while (n < nlb) {
            Nobj[n] = 0;
            ++n;
        }
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    int n2 = label[x][y][z];
                    Nobj[n2] = Nobj[n2] + 1;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int size = 0;
        int best = 0;
        n = 1;
        while (n < nlb) {
            if (Nobj[n] > size) {
                size = Nobj[n];
                best = n;
            }
            ++n;
        }
        if (best > 0) {
            x = 0;
            while (x < nx) {
                y = 0;
                while (y < ny) {
                    z = 0;
                    while (z < nz) {
                        obj[x][y][z] = label[x][y][z] == best;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x < nx) {
                y = 0;
                while (y < ny) {
                    z = 0;
                    while (z < nz) {
                        obj[x][y][z] = false;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return obj;
    }

    public static final boolean[] largestObjectFromLabel(int[] label, int nlb, int nx, int ny, int nz) {
        boolean[] obj = new boolean[nx * ny * nz];
        int[] Nobj = new int[nlb];
        int n = 0;
        while (n < nlb) {
            Nobj[n] = 0;
            ++n;
        }
        int xyz = 0;
        while (xyz < nx * ny * nz) {
            int n2 = label[xyz];
            Nobj[n2] = Nobj[n2] + 1;
            ++xyz;
        }
        int size = 0;
        int best = 0;
        n = 1;
        while (n < nlb) {
            if (Nobj[n] > size) {
                size = Nobj[n];
                best = n;
            }
            ++n;
        }
        if (best > 0) {
            xyz = 0;
            while (xyz < nx * ny * nz) {
                obj[xyz] = label[xyz] == best;
                ++xyz;
            }
        } else {
            xyz = 0;
            while (xyz < nx * ny * nz) {
                obj[xyz] = false;
                ++xyz;
            }
        }
        return obj;
    }

    public static final boolean[][][] largestObjectFromLabel(int[][][] label, int nx, int ny, int nz) {
        int nlabels = ObjectProcessing.countLabels(label, nx, ny, nz);
        int[] lablist = ObjectProcessing.listLabels(label, nx, ny, nz);
        System.out.println("nlabels: " + nlabels);
        System.out.println("lablist: " + ArrayUtil.printArray(lablist));
        if (nlabels > 1) {
            return ObjectProcessing.largestObjectFromLabel(label, ObjectProcessing.countLabels(label, nx, ny, nz), nx, ny, nz);
        }
        return null;
    }

    public static final boolean[][] largestObjectFromLabel(int[][] label, int nlb, int nx, int ny) {
        int y;
        boolean[][] obj = new boolean[nx][ny];
        int[] Nobj = new int[nlb];
        int n = 0;
        while (n < nlb) {
            Nobj[n] = 0;
            ++n;
        }
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                int n2 = label[x][y];
                Nobj[n2] = Nobj[n2] + 1;
                ++y;
            }
            ++x;
        }
        int size = 0;
        int best = 0;
        n = 1;
        while (n < nlb) {
            if (Nobj[n] > size) {
                size = Nobj[n];
                best = n;
            }
            ++n;
        }
        if (best > 0) {
            x = 0;
            while (x < nx) {
                y = 0;
                while (y < ny) {
                    obj[x][y] = label[x][y] == best;
                    ++y;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x < nx) {
                y = 0;
                while (y < ny) {
                    obj[x][y] = false;
                    ++y;
                }
                ++x;
            }
        }
        return obj;
    }

    public static final boolean[][] largestObjectFromLabel(int[][] label, int nx, int ny) {
        return ObjectProcessing.largestObjectFromLabel(label, ObjectProcessing.countLabels(label, nx, ny), nx, ny);
    }

    public static final boolean[][][] connectedObjectAt(boolean[][][] object, int x0, int y0, int z0, int nx, int ny, int nz) {
        boolean[][][] obj = new boolean[nx][ny][nz];
        int[][][] label = ObjectProcessing.connected6Object3D(object, nx, ny, nz);
        int lb = label[x0][y0][z0];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = label[x][y][z] == lb;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean[][][] removeHoles(boolean[][][] object, int nx, int ny, int nz, int conn) {
        int[][][] lb;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    object[x][y][z] = !object[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (conn == 6) {
            lb = ObjectProcessing.connected6Object3D(object, nx, ny, nz);
        } else if (conn == 18) {
            lb = ObjectProcessing.connected18Object3D(object, nx, ny, nz);
        } else if (conn == 26) {
            lb = ObjectProcessing.connected26Object3D(object, nx, ny, nz);
        } else {
            System.out.println("Unsupported connectivity: " + conn + " \n");
            return null;
        }
        object = ObjectProcessing.largestObjectFromLabel(lb, nx, ny, nz);
        int x2 = 0;
        while (x2 < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    object[x2][y][z] = !object[x2][y][z];
                    ++z;
                }
                ++y;
            }
            ++x2;
        }
        return object;
    }

    public static final boolean[][][] removeHoles6(boolean[][][] object, int nx, int ny, int nz) {
        return ObjectProcessing.removeHoles(object, nx, ny, nz, 6);
    }

    public static final boolean[][][] removeHoles18(boolean[][][] object, int nx, int ny, int nz) {
        return ObjectProcessing.removeHoles(object, nx, ny, nz, 18);
    }

    public static final boolean[][][] largestObject(boolean[][][] object, int nx, int ny, int nz, int conn) {
        int[][][] lb;
        if (conn == 6) {
            lb = ObjectProcessing.connected6Object3D(object, nx, ny, nz);
        } else if (conn == 18) {
            lb = ObjectProcessing.connected18Object3D(object, nx, ny, nz);
        } else {
            System.out.println("Unsupported connectivity: " + conn + " \n");
            return null;
        }
        object = ObjectProcessing.largestObjectFromLabel(lb, nx, ny, nz);
        return object;
    }

    public static final boolean[][][] largest6Object(boolean[][][] object, int nx, int ny, int nz) {
        return ObjectProcessing.largestObject(object, nx, ny, nz, 6);
    }

    public static final boolean[][][] largest18Object(boolean[][][] object, int nx, int ny, int nz) {
        return ObjectProcessing.largestObject(object, nx, ny, nz, 18);
    }

    public static final Graph objectGraphFrom6Label(int[][][] label, int nx, int ny, int nz) {
        int z;
        int y;
        Graph objectGraph = new Graph();
        boolean[][][] isProcessed = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    isProcessed[x][y][z] = false;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    if (label[x][y][z] > 0) {
                        int index = objectGraph.getNodeIndex(label[x][y][z]);
                        if (index == -1) {
                            GraphNode node = new GraphNode(label[x][y][z]);
                            objectGraph.addNode(node);
                            index = objectGraph.getSize() - 1;
                        }
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + k >= 0 && z + k < nz && i * i + j * j + k * k < 2 && isProcessed[x + i][y + j][z + k] && label[x + i][y + j][z + k] != label[x][y][z] && label[x + i][y + j][z + k] > 0 && !objectGraph.getNodeAt(index).isLinkedTo(label[x + i][y + j][z + k])) {
                                        int neighbor = objectGraph.getNodeIndex(label[x + i][y + j][z + k]);
                                        objectGraph.addNodeLink(index, neighbor);
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        isProcessed[x][y][z] = true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        isProcessed = null;
        return objectGraph;
    }

    public static final Graph objectGraphFrom18Label(int[][][] label, int nx, int ny, int nz) {
        int z;
        int y;
        Graph objectGraph = new Graph();
        boolean[][][] isProcessed = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    if (label[x][y][z] > 0) {
                        isProcessed[x][y][z] = false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    if (label[x][y][z] > 0) {
                        int index = objectGraph.getNodeIndex(label[x][y][z]);
                        if (index == -1) {
                            GraphNode node = new GraphNode(label[x][y][z]);
                            objectGraph.addNode(node);
                            index = objectGraph.getSize() - 1;
                        }
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + k >= 0 && z + k < nz && i * i + j * j + k * k < 3 && isProcessed[x + i][y + j][z + k] && label[x + i][y + j][z + k] != label[x][y][z] && label[x + i][y + j][z + k] > 0 && !objectGraph.getNodeAt(index).isLinkedTo(label[x + i][y + j][z + k])) {
                                        int neighbor = objectGraph.getNodeIndex(label[x + i][y + j][z + k]);
                                        objectGraph.addNodeLink(index, neighbor);
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        isProcessed[x][y][z] = true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        isProcessed = null;
        return objectGraph;
    }

    public static final Graph objectGraphFrom26Label(int[][][] label, int nx, int ny, int nz) {
        int z;
        int y;
        Graph objectGraph = new Graph();
        boolean[][][] isProcessed = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    isProcessed[x][y][z] = false;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    if (label[x][y][z] > 0) {
                        int index = objectGraph.getNodeIndex(label[x][y][z]);
                        if (index == -1) {
                            GraphNode node = new GraphNode(label[x][y][z]);
                            objectGraph.addNode(node);
                            index = objectGraph.getSize() - 1;
                        }
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + k >= 0 && z + k < nz && i * i + j * j + k * k < 4 && isProcessed[x + i][y + j][z + k] && label[x + i][y + j][z + k] != label[x][y][z] && label[x + i][y + j][z + k] > 0 && !objectGraph.getNodeAt(index).isLinkedTo(label[x + i][y + j][z + k])) {
                                        int neighbor = objectGraph.getNodeIndex(label[x + i][y + j][z + k]);
                                        objectGraph.addNodeLink(index, neighbor);
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        isProcessed[x][y][z] = true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        isProcessed = null;
        return objectGraph;
    }

    public static final int[][] connected4Object2D(boolean[][] img, int nx, int ny) {
        int k;
        int y;
        int[][] label = new int[nx][ny];
        ArrayList<Integer> lb = new ArrayList<Integer>();
        int[] connect = new int[4];
        boolean AddLabel = false;
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                label[x][y] = 0;
                ++y;
            }
            ++x;
        }
        lb.add(0, 0);
        int Nlabel = 1;
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                if (img[x][y]) {
                    int Nconnect = 0;
                    int i = -1;
                    while (i <= 1) {
                        int j = -1;
                        while (j <= 1) {
                            if (x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && i * i + j * j < 2 && label[x + i][y + j] > 0) {
                                connect[Nconnect] = (Integer)lb.get(label[x + i][y + j]);
                                ++Nconnect;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (Nconnect > 0) {
                        int lbMin = (Integer)lb.get(connect[0]);
                        k = 1;
                        while (k < Nconnect) {
                            lbMin = Math.min(lbMin, (Integer)lb.get(connect[k]));
                            ++k;
                        }
                        k = 0;
                        while (k < Nconnect) {
                            lb.set(connect[k], lbMin);
                            ++k;
                        }
                        label[x][y] = lbMin;
                    } else {
                        label[x][y] = Nlabel;
                        lb.add(Nlabel, Nlabel);
                        ++Nlabel;
                    }
                }
                ++y;
            }
            ++x;
        }
        k = 1;
        while (k < Nlabel) {
            int c = k;
            while ((Integer)lb.get(c) != c) {
                c = (Integer)lb.get(c);
            }
            lb.set(k, c);
            ++k;
        }
        int Nlb = 0;
        int[] lb2 = new int[Nlabel];
        lb2[0] = 0;
        k = 1;
        while (k < Nlabel) {
            if ((Integer)lb.get(k) == k) {
                lb2[k] = ++Nlb;
            }
            ++k;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                label[x][y] = lb2[(Integer)lb.get(label[x][y])];
                ++y;
            }
            ++x;
        }
        lb = null;
        lb2 = null;
        connect = null;
        return label;
    }

    public static final int[][] connected8Object2D(boolean[][] img, int nx, int ny) {
        int k;
        int y;
        int[][] label = new int[nx][ny];
        int[] lb = new int[1000000];
        int[] connect = new int[4];
        boolean AddLabel = false;
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                label[x][y] = 0;
                ++y;
            }
            ++x;
        }
        lb[0] = 0;
        int Nlabel = 1;
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                if (img[x][y]) {
                    int Nconnect = 0;
                    int i = -1;
                    while (i <= 1) {
                        int j = -1;
                        while (j <= 1) {
                            if (x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && i * i + j * j < 3 && label[x + i][y + j] > 0) {
                                connect[Nconnect] = lb[label[x + i][y + j]];
                                ++Nconnect;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (Nconnect > 0) {
                        int lbMin = lb[connect[0]];
                        k = 1;
                        while (k < Nconnect) {
                            lbMin = Math.min(lbMin, lb[connect[k]]);
                            ++k;
                        }
                        k = 0;
                        while (k < Nconnect) {
                            lb[connect[k]] = lbMin;
                            ++k;
                        }
                        label[x][y] = lbMin;
                    } else {
                        label[x][y] = Nlabel;
                        lb[Nlabel] = Nlabel;
                        if (++Nlabel >= lb.length - 1) {
                            int[] tmp = new int[2 * lb.length];
                            int n = 0;
                            while (n < Nlabel) {
                                tmp[n] = lb[n];
                                ++n;
                            }
                            lb = tmp;
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
        k = 1;
        while (k < Nlabel) {
            int c = k;
            while (lb[c] != c) {
                c = lb[c];
            }
            lb[k] = c;
            ++k;
        }
        int Nlb = 0;
        int[] lb2 = new int[Nlabel];
        lb2[0] = 0;
        k = 1;
        while (k < Nlabel) {
            if (lb[k] == k) {
                lb2[k] = ++Nlb;
            }
            ++k;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                label[x][y] = lb2[lb[label[x][y]]];
                ++y;
            }
            ++x;
        }
        lb = null;
        lb2 = null;
        connect = null;
        return label;
    }

    public static final int[][][] connected6Object3Dwrong(boolean[][][] img, int nx, int ny, int nz) {
        int k;
        int z;
        int y;
        int Nlabel = 0;
        int[][][] label = new int[nx][ny][nz];
        int[] lb = new int[1000000];
        int[] connect = new int[7];
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    label[x][y][z] = 0;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        lb[0] = 0;
        Nlabel = 1;
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        int Nconnect = 0;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + k >= 0 && z + k < nz && i * i + j * j + k * k < 2 && label[x + i][y + j][z + k] > 0) {
                                        connect[Nconnect] = lb[label[x + i][y + j][z + k]];
                                        ++Nconnect;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (Nconnect > 0) {
                            int lbMin = lb[connect[0]];
                            int l = 1;
                            while (l < Nconnect) {
                                lbMin = Math.min(lbMin, lb[connect[l]]);
                                ++l;
                            }
                            l = 0;
                            while (l < Nconnect) {
                                lb[connect[l]] = lbMin;
                                ++l;
                            }
                            label[x][y][z] = lbMin;
                        } else {
                            label[x][y][z] = Nlabel;
                            lb[Nlabel] = Nlabel;
                            if (++Nlabel >= lb.length - 1) {
                                int[] tmp = new int[2 * lb.length];
                                int n = 0;
                                while (n < Nlabel) {
                                    tmp[n] = lb[n];
                                    ++n;
                                }
                                lb = tmp;
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        k = 1;
        while (k < Nlabel) {
            int c = k;
            while (lb[c] != c) {
                c = lb[c];
            }
            lb[k] = c;
            ++k;
        }
        int Nlb = 0;
        int[] lb2 = new int[Nlabel];
        lb2[0] = 0;
        k = 1;
        while (k < Nlabel) {
            if (lb[k] == k) {
                lb2[k] = ++Nlb;
            }
            ++k;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    label[x][y][z] = lb2[lb[label[x][y][z]]];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        lb = null;
        lb2 = null;
        connect = null;
        return label;
    }

    public static final int[][][] connected6Object3D(boolean[][][] img, int nx, int ny, int nz) {
        int y;
        int z;
        int y2;
        int Nlabel = 0;
        int[][][] label = new int[nx][ny][nz];
        int[] lb = new int[1000000];
        int[] connect = new int[6];
        int x = 0;
        while (x < nx) {
            y2 = 0;
            while (y2 < ny) {
                z = 0;
                while (z < nz) {
                    label[x][y2][z] = 0;
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
        lb[0] = 0;
        Nlabel = 1;
        x = 0;
        while (x < nx) {
            y2 = 0;
            while (y2 < ny) {
                z = 0;
                while (z < nz) {
                    if (img[x][y2][z]) {
                        int Nconnect = 0;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y2 + j >= 0 && y2 + j < ny && z + k >= 0 && z + k < nz && i * i + j * j + k * k < 2 && label[x + i][y2 + j][z + k] > 0) {
                                        connect[Nconnect] = lb[label[x + i][y2 + j][z + k]];
                                        ++Nconnect;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (Nconnect > 0) {
                            int lbMin = lb[connect[0]];
                            int l = 1;
                            while (l < Nconnect) {
                                lbMin = Math.min(lbMin, lb[connect[l]]);
                                ++l;
                            }
                            l = 0;
                            while (l < Nconnect) {
                                lb[connect[l]] = lbMin;
                                ++l;
                            }
                            label[x][y2][z] = lbMin;
                        } else {
                            label[x][y2][z] = Nlabel;
                            lb[Nlabel] = Nlabel;
                            if (++Nlabel >= lb.length - 1) {
                                int[] tmp = new int[2 * lb.length];
                                int n = 0;
                                while (n < Nlabel) {
                                    tmp[n] = lb[n];
                                    ++n;
                                }
                                lb = tmp;
                            }
                        }
                    }
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
        int k = 1;
        while (k < Nlabel) {
            int c = k;
            while (lb[c] != c) {
                c = lb[c];
            }
            lb[k] = c;
            ++k;
        }
        int Nlb = 0;
        int[] lb2 = new int[Nlabel];
        lb2[0] = 0;
        int k2 = 1;
        while (k2 < Nlabel) {
            if (lb[k2] == k2) {
                lb2[k2] = ++Nlb;
            }
            ++k2;
        }
        int x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                int z2 = 0;
                while (z2 < nz) {
                    if (lb2[lb[label[x2][y][z2]]] > 0) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k3 = -1;
                                while (k3 <= 1) {
                                    if (x2 + i >= 0 && x2 + i < nx && y + j >= 0 && y + j < ny && z2 + k3 >= 0 && z2 + k3 < nz && i * i + j * j + k3 * k3 < 2 && lb2[lb[label[x2 + i][y + j][z2 + k3]]] > 0 && lb2[lb[label[x2 + i][y + j][z2 + k3]]] > lb2[lb[label[x2][y][z2]]]) {
                                        int badLb = lb2[lb[label[x2 + i][y + j][z2 + k3]]];
                                        lb2[lb[label[x2 + i][y + j][z2 + k3]]] = lb2[lb[label[x2][y][z2]]];
                                        int n = 1;
                                        while (n < Nlabel) {
                                            if (lb2[n] > badLb) {
                                                int n2 = n;
                                                lb2[n2] = lb2[n2] - 1;
                                            }
                                            ++n;
                                        }
                                    }
                                    ++k3;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z2;
                }
                ++y;
            }
            ++x2;
        }
        x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                int z3 = 0;
                while (z3 < nz) {
                    label[x2][y][z3] = lb2[lb[label[x2][y][z3]]];
                    ++z3;
                }
                ++y;
            }
            ++x2;
        }
        lb = null;
        lb2 = null;
        connect = null;
        return label;
    }

    public static final int[] connected6Object3D(boolean[] img, int nx, int ny, int nz) {
        int Nlabel = 0;
        int[] label = new int[nx * ny * nz];
        int[] lb = new int[1000000];
        int[] connect = new int[6];
        int xyz = 0;
        while (xyz < nx * ny * nz) {
            label[xyz] = 0;
            ++xyz;
        }
        lb[0] = 0;
        Nlabel = 1;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    int xyz2 = x + nx * y + nx * ny * z;
                    if (img[xyz2]) {
                        int Nconnect = 0;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + k >= 0 && z + k < nz && i * i + j * j + k * k < 2 && label[xyz2 + i + nx * j + nx * ny * k] > 0) {
                                        connect[Nconnect] = lb[label[xyz2 + i + nx * j + nx * ny * k]];
                                        ++Nconnect;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (Nconnect > 0) {
                            int lbMin = lb[connect[0]];
                            int l = 1;
                            while (l < Nconnect) {
                                lbMin = Math.min(lbMin, lb[connect[l]]);
                                ++l;
                            }
                            l = 0;
                            while (l < Nconnect) {
                                lb[connect[l]] = lbMin;
                                ++l;
                            }
                            label[xyz2] = lbMin;
                        } else {
                            label[xyz2] = Nlabel;
                            lb[Nlabel] = Nlabel;
                            if (++Nlabel >= lb.length - 1) {
                                int[] tmp = new int[2 * lb.length];
                                int n = 0;
                                while (n < Nlabel) {
                                    tmp[n] = lb[n];
                                    ++n;
                                }
                                lb = tmp;
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int k = 1;
        while (k < Nlabel) {
            int c = k;
            while (lb[c] != c) {
                c = lb[c];
            }
            lb[k] = c;
            ++k;
        }
        int Nlb = 0;
        int[] lb2 = new int[Nlabel];
        lb2[0] = 0;
        int k2 = 1;
        while (k2 < Nlabel) {
            if (lb[k2] == k2) {
                lb2[k2] = ++Nlb;
            }
            ++k2;
        }
        int x2 = 0;
        while (x2 < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    int xyz3 = x2 + nx * y + nx * ny * z;
                    if (lb2[lb[label[xyz3]]] > 0) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k3 = -1;
                                while (k3 <= 1) {
                                    if (x2 + i >= 0 && x2 + i < nx && y + j >= 0 && y + j < ny && z + k3 >= 0 && z + k3 < nz && i * i + j * j + k3 * k3 < 2 && lb2[lb[label[xyz3 + i + nx * j + nx * ny * k3]]] > 0 && lb2[lb[label[xyz3 + i + nx * j + nx * ny * k3]]] > lb2[lb[label[xyz3]]]) {
                                        int badLb = lb2[lb[label[xyz3 + i + nx * j + nx * ny * k3]]];
                                        lb2[lb[label[xyz3 + i + nx * j + nx * ny * k3]]] = lb2[lb[label[xyz3]]];
                                        int n = 1;
                                        while (n < Nlabel) {
                                            if (lb2[n] > badLb) {
                                                int n2 = n;
                                                lb2[n2] = lb2[n2] - 1;
                                            }
                                            ++n;
                                        }
                                    }
                                    ++k3;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x2;
        }
        int xyz4 = 0;
        while (xyz4 < nx * ny * nz) {
            label[xyz4] = lb2[lb[label[xyz4]]];
            ++xyz4;
        }
        lb = null;
        lb2 = null;
        connect = null;
        return label;
    }

    public static final int[][][] connected6Object3D(boolean[][][] img) {
        return ObjectProcessing.connected6Object3D(img, img.length, img[0].length, img[0][0].length);
    }

    public static final int[][][] connected26Object3D(boolean[][][] img) {
        return ObjectProcessing.connected26Object3D(img, img.length, img[0].length, img[0][0].length);
    }

    public static final int[][][] connected18Object3D(boolean[][][] img) {
        return ObjectProcessing.connected18Object3D(img, img.length, img[0].length, img[0][0].length);
    }

    public static final int[][][] connected18Object3D(boolean[][][] img, int nx, int ny, int nz) {
        int y;
        int z;
        int y2;
        int Nlabel = 0;
        int[][][] label = new int[nx][ny][nz];
        int[] lb = new int[1000000];
        int[] connect = new int[18];
        int x = 0;
        while (x < nx) {
            y2 = 0;
            while (y2 < ny) {
                z = 0;
                while (z < nz) {
                    label[x][y2][z] = 0;
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
        lb[0] = 0;
        Nlabel = 1;
        x = 0;
        while (x < nx) {
            y2 = 0;
            while (y2 < ny) {
                z = 0;
                while (z < nz) {
                    if (img[x][y2][z]) {
                        int Nconnect = 0;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y2 + j >= 0 && y2 + j < ny && z + k >= 0 && z + k < nz && i * i + j * j + k * k < 3 && label[x + i][y2 + j][z + k] > 0) {
                                        connect[Nconnect] = lb[label[x + i][y2 + j][z + k]];
                                        ++Nconnect;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (Nconnect > 0) {
                            int lbMin = lb[connect[0]];
                            int l = 1;
                            while (l < Nconnect) {
                                lbMin = Math.min(lbMin, lb[connect[l]]);
                                ++l;
                            }
                            l = 0;
                            while (l < Nconnect) {
                                lb[connect[l]] = lbMin;
                                ++l;
                            }
                            label[x][y2][z] = lbMin;
                        } else {
                            label[x][y2][z] = Nlabel;
                            lb[Nlabel] = Nlabel;
                            if (++Nlabel >= lb.length - 1) {
                                int[] tmp = new int[2 * lb.length];
                                int n = 0;
                                while (n < Nlabel) {
                                    tmp[n] = lb[n];
                                    ++n;
                                }
                                lb = tmp;
                            }
                        }
                    }
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
        int k = 1;
        while (k < Nlabel) {
            int c = k;
            while (lb[c] != c) {
                c = lb[c];
            }
            lb[k] = c;
            ++k;
        }
        int Nlb = 0;
        int[] lb2 = new int[Nlabel];
        lb2[0] = 0;
        int k2 = 1;
        while (k2 < Nlabel) {
            if (lb[k2] == k2) {
                lb2[k2] = ++Nlb;
            }
            ++k2;
        }
        int x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                int z2 = 0;
                while (z2 < nz) {
                    if (lb2[lb[label[x2][y][z2]]] > 0) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k3 = -1;
                                while (k3 <= 1) {
                                    if (x2 + i >= 0 && x2 + i < nx && y + j >= 0 && y + j < ny && z2 + k3 >= 0 && z2 + k3 < nz && i * i + j * j + k3 * k3 < 3 && lb2[lb[label[x2 + i][y + j][z2 + k3]]] > 0 && lb2[lb[label[x2 + i][y + j][z2 + k3]]] > lb2[lb[label[x2][y][z2]]]) {
                                        int badLb = lb2[lb[label[x2 + i][y + j][z2 + k3]]];
                                        lb2[lb[label[x2 + i][y + j][z2 + k3]]] = lb2[lb[label[x2][y][z2]]];
                                        int n = 1;
                                        while (n < Nlabel) {
                                            if (lb2[n] > badLb) {
                                                int n2 = n;
                                                lb2[n2] = lb2[n2] - 1;
                                            }
                                            ++n;
                                        }
                                    }
                                    ++k3;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z2;
                }
                ++y;
            }
            ++x2;
        }
        x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                int z3 = 0;
                while (z3 < nz) {
                    label[x2][y][z3] = lb2[lb[label[x2][y][z3]]];
                    ++z3;
                }
                ++y;
            }
            ++x2;
        }
        lb = null;
        lb2 = null;
        connect = null;
        return label;
    }

    public static final int[][][] connected26Object3D(boolean[][][] img, int nx, int ny, int nz) {
        int y;
        int z;
        int y2;
        int Nlabel = 0;
        int[][][] label = new int[nx][ny][nz];
        int[] lb = new int[1000000];
        int[] connect = new int[26];
        int x = 0;
        while (x < nx) {
            y2 = 0;
            while (y2 < ny) {
                z = 0;
                while (z < nz) {
                    label[x][y2][z] = 0;
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
        lb[0] = 0;
        Nlabel = 1;
        x = 0;
        while (x < nx) {
            y2 = 0;
            while (y2 < ny) {
                z = 0;
                while (z < nz) {
                    if (img[x][y2][z]) {
                        int Nconnect = 0;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k = -1;
                                while (k <= 1) {
                                    if (x + i >= 0 && x + i < nx && y2 + j >= 0 && y2 + j < ny && z + k >= 0 && z + k < nz && label[x + i][y2 + j][z + k] > 0) {
                                        connect[Nconnect] = lb[label[x + i][y2 + j][z + k]];
                                        ++Nconnect;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (Nconnect > 0) {
                            int lbMin = lb[connect[0]];
                            int l = 1;
                            while (l < Nconnect) {
                                lbMin = Math.min(lbMin, lb[connect[l]]);
                                ++l;
                            }
                            l = 0;
                            while (l < Nconnect) {
                                lb[connect[l]] = lbMin;
                                ++l;
                            }
                            label[x][y2][z] = lbMin;
                        } else {
                            label[x][y2][z] = Nlabel;
                            lb[Nlabel] = Nlabel;
                            if (++Nlabel >= lb.length - 1) {
                                int[] tmp = new int[2 * lb.length];
                                int n = 0;
                                while (n < Nlabel) {
                                    tmp[n] = lb[n];
                                    ++n;
                                }
                                lb = tmp;
                            }
                        }
                    }
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
        int k = 1;
        while (k < Nlabel) {
            int c = k;
            while (lb[c] != c) {
                c = lb[c];
            }
            lb[k] = c;
            ++k;
        }
        int Nlb = 0;
        int[] lb2 = new int[Nlabel];
        lb2[0] = 0;
        int k2 = 1;
        while (k2 < Nlabel) {
            if (lb[k2] == k2) {
                lb2[k2] = ++Nlb;
            }
            ++k2;
        }
        int x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                int z2 = 0;
                while (z2 < nz) {
                    if (lb2[lb[label[x2][y][z2]]] > 0) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int k3 = -1;
                                while (k3 <= 1) {
                                    if (x2 + i >= 0 && x2 + i < nx && y + j >= 0 && y + j < ny && z2 + k3 >= 0 && z2 + k3 < nz && lb2[lb[label[x2 + i][y + j][z2 + k3]]] > 0 && lb2[lb[label[x2 + i][y + j][z2 + k3]]] > lb2[lb[label[x2][y][z2]]]) {
                                        int badLb = lb2[lb[label[x2 + i][y + j][z2 + k3]]];
                                        lb2[lb[label[x2 + i][y + j][z2 + k3]]] = lb2[lb[label[x2][y][z2]]];
                                        int n = 1;
                                        while (n < Nlabel) {
                                            if (lb2[n] > badLb) {
                                                int n2 = n;
                                                lb2[n2] = lb2[n2] - 1;
                                            }
                                            ++n;
                                        }
                                    }
                                    ++k3;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z2;
                }
                ++y;
            }
            ++x2;
        }
        x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                int z3 = 0;
                while (z3 < nz) {
                    label[x2][y][z3] = lb2[lb[label[x2][y][z3]]];
                    ++z3;
                }
                ++y;
            }
            ++x2;
        }
        lb = null;
        lb2 = null;
        connect = null;
        return label;
    }

    public static final int cubicSurfaceFromObject(boolean[][][] img, int nx, int ny, int nz) {
        int n;
        int n2;
        int Nv = 0;
        int Ne = 0;
        int Nf = 0;
        boolean cleanUp = true;
        int Mv = nx * ny * nz;
        int Me = nx * ny * nz;
        int Mf = nx * ny * nz;
        float[][] vertex = new float[Mv][3];
        int[][] edge = new int[Me][2];
        int[][] face = new int[Mf][4];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        int Nv0 = Nv;
                        int Ne0 = Ne;
                        int Nf0 = Nf;
                        boolean newFace = false;
                        if (!img[x + 1][y][z]) {
                            newFace = true;
                            vertex[Nv + 0][0] = (float)x + 0.5f;
                            vertex[Nv + 0][1] = (float)y - 0.5f;
                            vertex[Nv + 0][2] = (float)z - 0.5f;
                            vertex[Nv + 1][0] = (float)x + 0.5f;
                            vertex[Nv + 1][1] = (float)y + 0.5f;
                            vertex[Nv + 1][2] = (float)z - 0.5f;
                            vertex[Nv + 2][0] = (float)x + 0.5f;
                            vertex[Nv + 2][1] = (float)y + 0.5f;
                            vertex[Nv + 2][2] = (float)z + 0.5f;
                            vertex[Nv + 3][0] = (float)x + 0.5f;
                            vertex[Nv + 3][1] = (float)y - 0.5f;
                            vertex[Nv + 3][2] = (float)z + 0.5f;
                            edge[Ne + 0][0] = Nv + 0;
                            edge[Ne + 0][1] = Nv + 1;
                            edge[Ne + 1][0] = Nv + 1;
                            edge[Ne + 1][1] = Nv + 2;
                            edge[Ne + 2][0] = Nv + 2;
                            edge[Ne + 2][1] = Nv + 3;
                            edge[Ne + 3][0] = Nv + 3;
                            edge[Ne + 3][1] = Nv + 0;
                            face[Nf + 0][0] = Ne + 0;
                            face[Nf + 0][1] = Ne + 1;
                            face[Nf + 0][2] = Ne + 2;
                            face[Nf + 0][3] = Ne + 3;
                            Nv += 4;
                            Ne += 4;
                            ++Nf;
                        }
                        if (!img[x - 1][y][z]) {
                            newFace = true;
                            vertex[Nv + 0][0] = (float)x - 0.5f;
                            vertex[Nv + 0][1] = (float)y - 0.5f;
                            vertex[Nv + 0][2] = (float)z - 0.5f;
                            vertex[Nv + 1][0] = (float)x - 0.5f;
                            vertex[Nv + 1][1] = (float)y + 0.5f;
                            vertex[Nv + 1][2] = (float)z - 0.5f;
                            vertex[Nv + 2][0] = (float)x - 0.5f;
                            vertex[Nv + 2][1] = (float)y + 0.5f;
                            vertex[Nv + 2][2] = (float)z + 0.5f;
                            vertex[Nv + 3][0] = (float)x - 0.5f;
                            vertex[Nv + 3][1] = (float)y - 0.5f;
                            vertex[Nv + 3][2] = (float)z + 0.5f;
                            edge[Ne + 0][0] = Nv + 0;
                            edge[Ne + 0][1] = Nv + 1;
                            edge[Ne + 1][0] = Nv + 1;
                            edge[Ne + 1][1] = Nv + 2;
                            edge[Ne + 2][0] = Nv + 2;
                            edge[Ne + 2][1] = Nv + 3;
                            edge[Ne + 3][0] = Nv + 3;
                            edge[Ne + 3][1] = Nv + 0;
                            face[Nf + 0][0] = Ne + 0;
                            face[Nf + 0][1] = Ne + 1;
                            face[Nf + 0][2] = Ne + 2;
                            face[Nf + 0][3] = Ne + 3;
                            Nv += 4;
                            Ne += 4;
                            ++Nf;
                        }
                        if (!img[x][y + 1][z]) {
                            newFace = true;
                            vertex[Nv + 0][0] = (float)x - 0.5f;
                            vertex[Nv + 0][1] = (float)y + 0.5f;
                            vertex[Nv + 0][2] = (float)z - 0.5f;
                            vertex[Nv + 1][0] = (float)x + 0.5f;
                            vertex[Nv + 1][1] = (float)y + 0.5f;
                            vertex[Nv + 1][2] = (float)z - 0.5f;
                            vertex[Nv + 2][0] = (float)x + 0.5f;
                            vertex[Nv + 2][1] = (float)y + 0.5f;
                            vertex[Nv + 2][2] = (float)z + 0.5f;
                            vertex[Nv + 3][0] = (float)x - 0.5f;
                            vertex[Nv + 3][1] = (float)y + 0.5f;
                            vertex[Nv + 3][2] = (float)z + 0.5f;
                            edge[Ne + 0][0] = Nv + 0;
                            edge[Ne + 0][1] = Nv + 1;
                            edge[Ne + 1][0] = Nv + 1;
                            edge[Ne + 1][1] = Nv + 2;
                            edge[Ne + 2][0] = Nv + 2;
                            edge[Ne + 2][1] = Nv + 3;
                            edge[Ne + 3][0] = Nv + 3;
                            edge[Ne + 3][1] = Nv + 0;
                            face[Nf + 0][0] = Ne + 0;
                            face[Nf + 0][1] = Ne + 1;
                            face[Nf + 0][2] = Ne + 2;
                            face[Nf + 0][3] = Ne + 3;
                            Nv += 4;
                            Ne += 4;
                            ++Nf;
                        }
                        if (!img[x][y - 1][z]) {
                            newFace = true;
                            vertex[Nv + 0][0] = (float)x - 0.5f;
                            vertex[Nv + 0][1] = (float)y - 0.5f;
                            vertex[Nv + 0][2] = (float)z - 0.5f;
                            vertex[Nv + 1][0] = (float)x + 0.5f;
                            vertex[Nv + 1][1] = (float)y - 0.5f;
                            vertex[Nv + 1][2] = (float)z - 0.5f;
                            vertex[Nv + 2][0] = (float)x + 0.5f;
                            vertex[Nv + 2][1] = (float)y - 0.5f;
                            vertex[Nv + 2][2] = (float)z + 0.5f;
                            vertex[Nv + 3][0] = (float)x - 0.5f;
                            vertex[Nv + 3][1] = (float)y - 0.5f;
                            vertex[Nv + 3][2] = (float)z + 0.5f;
                            edge[Ne + 0][0] = Nv + 0;
                            edge[Ne + 0][1] = Nv + 1;
                            edge[Ne + 1][0] = Nv + 1;
                            edge[Ne + 1][1] = Nv + 2;
                            edge[Ne + 2][0] = Nv + 2;
                            edge[Ne + 2][1] = Nv + 3;
                            edge[Ne + 3][0] = Nv + 3;
                            edge[Ne + 3][1] = Nv + 0;
                            face[Nf + 0][0] = Ne + 0;
                            face[Nf + 0][1] = Ne + 1;
                            face[Nf + 0][2] = Ne + 2;
                            face[Nf + 0][3] = Ne + 3;
                            Nv += 4;
                            Ne += 4;
                            ++Nf;
                        }
                        if (!img[x][y][z + 1]) {
                            newFace = true;
                            vertex[Nv + 0][0] = (float)x - 0.5f;
                            vertex[Nv + 0][1] = (float)y - 0.5f;
                            vertex[Nv + 0][2] = (float)z + 0.5f;
                            vertex[Nv + 1][0] = (float)x + 0.5f;
                            vertex[Nv + 1][1] = (float)y - 0.5f;
                            vertex[Nv + 1][2] = (float)z + 0.5f;
                            vertex[Nv + 2][0] = (float)x + 0.5f;
                            vertex[Nv + 2][1] = (float)y + 0.5f;
                            vertex[Nv + 2][2] = (float)z + 0.5f;
                            vertex[Nv + 3][0] = (float)x - 0.5f;
                            vertex[Nv + 3][1] = (float)y + 0.5f;
                            vertex[Nv + 3][2] = (float)z + 0.5f;
                            edge[Ne + 0][0] = Nv + 0;
                            edge[Ne + 0][1] = Nv + 1;
                            edge[Ne + 1][0] = Nv + 1;
                            edge[Ne + 1][1] = Nv + 2;
                            edge[Ne + 2][0] = Nv + 2;
                            edge[Ne + 2][1] = Nv + 3;
                            edge[Ne + 3][0] = Nv + 3;
                            edge[Ne + 3][1] = Nv + 0;
                            face[Nf + 0][0] = Ne + 0;
                            face[Nf + 0][1] = Ne + 1;
                            face[Nf + 0][2] = Ne + 2;
                            face[Nf + 0][3] = Ne + 3;
                            Nv += 4;
                            Ne += 4;
                            ++Nf;
                        }
                        if (!img[x][y][z - 1]) {
                            newFace = true;
                            vertex[Nv + 0][0] = (float)x - 0.5f;
                            vertex[Nv + 0][1] = (float)y - 0.5f;
                            vertex[Nv + 0][2] = (float)z - 0.5f;
                            vertex[Nv + 1][0] = (float)x + 0.5f;
                            vertex[Nv + 1][1] = (float)y - 0.5f;
                            vertex[Nv + 1][2] = (float)z - 0.5f;
                            vertex[Nv + 2][0] = (float)x + 0.5f;
                            vertex[Nv + 2][1] = (float)y + 0.5f;
                            vertex[Nv + 2][2] = (float)z - 0.5f;
                            vertex[Nv + 3][0] = (float)x - 0.5f;
                            vertex[Nv + 3][1] = (float)y + 0.5f;
                            vertex[Nv + 3][2] = (float)z - 0.5f;
                            edge[Ne + 0][0] = Nv + 0;
                            edge[Ne + 0][1] = Nv + 1;
                            edge[Ne + 1][0] = Nv + 1;
                            edge[Ne + 1][1] = Nv + 2;
                            edge[Ne + 2][0] = Nv + 2;
                            edge[Ne + 2][1] = Nv + 3;
                            edge[Ne + 3][0] = Nv + 3;
                            edge[Ne + 3][1] = Nv + 0;
                            face[Nf + 0][0] = Ne + 0;
                            face[Nf + 0][1] = Ne + 1;
                            face[Nf + 0][2] = Ne + 2;
                            face[Nf + 0][3] = Ne + 3;
                            Nv += 4;
                            Ne += 4;
                            ++Nf;
                        }
                        if (newFace && !cleanUp) {
                            int[] idv = new int[Nv];
                            n2 = 0;
                            while (n2 < Nv) {
                                idv[n2] = -1;
                                ++n2;
                            }
                            int lb = 0;
                            n = 0;
                            while (n < Nv) {
                                if (idv[n] == -1) {
                                    idv[n] = lb;
                                    int m = n + 1;
                                    while (m < Nv) {
                                        if (vertex[m][0] == vertex[n][0] && vertex[m][1] == vertex[n][1] && vertex[m][2] == vertex[n][2]) {
                                            idv[m] = lb;
                                        }
                                        ++m;
                                    }
                                    ++lb;
                                }
                                ++n;
                            }
                            int nV = lb;
                            float[][] Vertex = new float[nV][3];
                            int n3 = 0;
                            while (n3 < Nv) {
                                Vertex[idv[n3]][0] = vertex[n3][0];
                                Vertex[idv[n3]][1] = vertex[n3][1];
                                Vertex[idv[n3]][2] = vertex[n3][2];
                                ++n3;
                            }
                            n3 = 0;
                            while (n3 < Ne) {
                                edge[n3][0] = idv[edge[n3][0]];
                                edge[n3][1] = idv[edge[n3][1]];
                                ++n3;
                            }
                            int[] ide = new int[Ne];
                            int n4 = 0;
                            while (n4 < Ne) {
                                ide[n4] = -1;
                                ++n4;
                            }
                            lb = 0;
                            n4 = 0;
                            while (n4 < Ne) {
                                if (ide[n4] == -1) {
                                    ide[n4] = lb;
                                    int m = n4 + 1;
                                    while (m < Ne) {
                                        if (edge[m][0] == edge[n4][0] && edge[m][1] == edge[n4][1] || edge[m][0] == edge[n4][1] && edge[m][1] == edge[n4][0]) {
                                            ide[m] = lb;
                                        }
                                        ++m;
                                    }
                                    ++lb;
                                }
                                ++n4;
                            }
                            int nE = lb;
                            int[][] Edge = new int[nE][2];
                            int n5 = 0;
                            while (n5 < Ne) {
                                Edge[ide[n5]][0] = edge[n5][0];
                                Edge[ide[n5]][1] = edge[n5][1];
                                ++n5;
                            }
                            n5 = 0;
                            while (n5 < Nf) {
                                face[n5][0] = ide[face[n5][0]];
                                face[n5][1] = ide[face[n5][1]];
                                face[n5][2] = ide[face[n5][2]];
                                face[n5][3] = ide[face[n5][3]];
                                ++n5;
                            }
                            idv = null;
                            ide = null;
                            Nv = nV;
                            Ne = nE;
                            n5 = 0;
                            while (n5 < Nv) {
                                vertex[n5][0] = Vertex[n5][0];
                                vertex[n5][1] = Vertex[n5][1];
                                vertex[n5][2] = Vertex[n5][2];
                                ++n5;
                            }
                            Vertex = null;
                            n5 = 0;
                            while (n5 < Ne) {
                                edge[n5][0] = Edge[n5][0];
                                edge[n5][1] = Edge[n5][1];
                                ++n5;
                            }
                            Edge = null;
                            System.gc();
                        }
                    }
                    if (Nv + 24 >= Mv) {
                        float[][] tmv = new float[Mv += nx * ny * nz][3];
                        n2 = 0;
                        while (n2 < Nv) {
                            tmv[n2][0] = vertex[n2][0];
                            tmv[n2][1] = vertex[n2][1];
                            tmv[n2][2] = vertex[n2][2];
                            ++n2;
                        }
                        vertex = new float[Mv][3];
                        n2 = 0;
                        while (n2 < Nv) {
                            vertex[n2][0] = tmv[n2][0];
                            vertex[n2][1] = tmv[n2][1];
                            vertex[n2][2] = tmv[n2][2];
                            ++n2;
                        }
                        tmv = null;
                        System.gc();
                    }
                    if (Ne + 24 >= Me) {
                        int[][] tme = new int[Me += nx * ny * nz][2];
                        n2 = 0;
                        while (n2 < Ne) {
                            tme[n2][0] = edge[n2][0];
                            tme[n2][1] = edge[n2][1];
                            ++n2;
                        }
                        edge = new int[Me][2];
                        n2 = 0;
                        while (n2 < Ne) {
                            edge[n2][0] = tme[n2][0];
                            edge[n2][1] = tme[n2][1];
                            ++n2;
                        }
                        tme = null;
                        System.gc();
                    }
                    if (Nf + 12 >= Mf) {
                        int[][] tmf = new int[Mf += nx * ny * nz][4];
                        n2 = 0;
                        while (n2 < Nf) {
                            tmf[n2][0] = face[n2][0];
                            tmf[n2][1] = face[n2][1];
                            tmf[n2][2] = face[n2][2];
                            tmf[n2][3] = face[n2][3];
                            ++n2;
                        }
                        face = new int[Mf][4];
                        n2 = 0;
                        while (n2 < Nf) {
                            face[n2][0] = tmf[n2][0];
                            face[n2][1] = tmf[n2][1];
                            face[n2][2] = tmf[n2][2];
                            face[n2][3] = tmf[n2][3];
                            ++n2;
                        }
                        tmf = null;
                        System.gc();
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (cleanUp) {
            int[] idv = new int[Nv];
            int n6 = 0;
            while (n6 < Nv) {
                idv[n6] = -1;
                ++n6;
            }
            int lb = 0;
            int n7 = 0;
            while (n7 < Nv) {
                if (idv[n7] == -1) {
                    idv[n7] = lb;
                    int m = n7 + 1;
                    while (m < Nv) {
                        if (vertex[m][0] == vertex[n7][0] && vertex[m][1] == vertex[n7][1] && vertex[m][2] == vertex[n7][2]) {
                            idv[m] = lb;
                        }
                        ++m;
                    }
                    ++lb;
                }
                ++n7;
            }
            int nV = lb;
            float[][] Vertex = new float[nV][3];
            n2 = 0;
            while (n2 < Nv) {
                Vertex[idv[n2]][0] = vertex[n2][0];
                Vertex[idv[n2]][1] = vertex[n2][1];
                Vertex[idv[n2]][2] = vertex[n2][2];
                ++n2;
            }
            n2 = 0;
            while (n2 < Ne) {
                edge[n2][0] = idv[edge[n2][0]];
                edge[n2][1] = idv[edge[n2][1]];
                ++n2;
            }
            int[] ide = new int[Ne];
            n = 0;
            while (n < Ne) {
                ide[n] = -1;
                ++n;
            }
            lb = 0;
            n = 0;
            while (n < Ne) {
                if (ide[n] == -1) {
                    ide[n] = lb;
                    int m = n + 1;
                    while (m < Ne) {
                        if (edge[m][0] == edge[n][0] && edge[m][1] == edge[n][1] || edge[m][0] == edge[n][1] && edge[m][1] == edge[n][0]) {
                            ide[m] = lb;
                        }
                        ++m;
                    }
                    ++lb;
                }
                ++n;
            }
            int nE = lb;
            int[][] Edge = new int[nE][2];
            int n8 = 0;
            while (n8 < Ne) {
                Edge[ide[n8]][0] = edge[n8][0];
                Edge[ide[n8]][1] = edge[n8][1];
                ++n8;
            }
            n8 = 0;
            while (n8 < Nf) {
                face[n8][0] = ide[face[n8][0]];
                face[n8][1] = ide[face[n8][1]];
                face[n8][2] = ide[face[n8][2]];
                face[n8][3] = ide[face[n8][3]];
                ++n8;
            }
            Nv = nV;
            Ne = nE;
        }
        return Nv - Ne + Nf;
    }

    public static final int eulerCharacteristic(boolean[][][] img, int nx, int ny, int nz, int cObj, int cBg) {
        int z;
        int y;
        int Nv = 0;
        int Ne = 0;
        int Nf = 0;
        int x = 1;
        while (x < nx - 1) {
            y = 1;
            while (y < ny - 1) {
                z = 1;
                while (z < nz - 1) {
                    if (img[x][y][z] != img[x - 1][y][z]) {
                        ++Nf;
                    }
                    if (img[x][y][z] != img[x][y - 1][z]) {
                        ++Nf;
                    }
                    if (img[x][y][z] != img[x][y][z - 1]) {
                        ++Nf;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 1;
        while (x < nx - 1) {
            y = 1;
            while (y < ny - 1) {
                z = 1;
                while (z < nz - 1) {
                    if (img[x][y][z] != img[x - 1][y - 1][z]) {
                        ++Ne;
                    } else if (img[x - 1][y][z] != img[x][y - 1][z]) {
                        ++Ne;
                    } else if (img[x][y][z] == img[x - 1][y - 1][z] && img[x][y][z] != img[x][y - 1][z] && img[x][y][z] != img[x - 1][y][z]) {
                        Ne += 2;
                    } else if (img[x - 1][y][z] == img[x][y - 1][z] && img[x - 1][y][z] != img[x][y][z] && img[x - 1][y][z] != img[x - 1][y - 1][z]) {
                        Ne += 2;
                    }
                    if (img[x][y][z] != img[x][y - 1][z - 1]) {
                        ++Ne;
                    } else if (img[x][y - 1][z] != img[x][y][z - 1]) {
                        ++Ne;
                    } else if (img[x][y][z] == img[x][y - 1][z - 1] && img[x][y][z] != img[x][y - 1][z] && img[x][y][z] != img[x][y][z - 1]) {
                        Ne += 2;
                    } else if (img[x][y - 1][z] == img[x][y][z - 1] && img[x][y - 1][z] != img[x][y][z] && img[x][y - 1][z] != img[x][y - 1][z - 1]) {
                        Ne += 2;
                    }
                    if (img[x][y][z] != img[x - 1][y][z - 1]) {
                        ++Ne;
                    } else if (img[x][y][z - 1] != img[x - 1][y][z]) {
                        ++Ne;
                    } else if (img[x][y][z] == img[x - 1][y][z - 1] && img[x][y][z] != img[x][y][z - 1] && img[x][y][z] != img[x - 1][y][z]) {
                        Ne += 2;
                    } else if (img[x][y][z - 1] == img[x - 1][y][z] && img[x][y][z - 1] != img[x][y][z] && img[x][y][z - 1] != img[x - 1][y][z - 1]) {
                        Ne += 2;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int x2 = 1;
        while (x2 < nx - 1) {
            int y2 = 1;
            while (y2 < ny - 1) {
                int z2 = 1;
                while (z2 < nz - 1) {
                    int Nobj = 0;
                    int Nbg = 0;
                    int N6 = 0;
                    int N18 = 0;
                    boolean N26 = false;
                    if (img[x2][y2][z2]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (img[x2 - 1][y2][z2]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (img[x2][y2 - 1][z2]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (img[x2][y2][z2 - 1]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (img[x2][y2 - 1][z2 - 1]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (img[x2 - 1][y2][z2 - 1]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (img[x2 - 1][y2 - 1][z2]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (img[x2 - 1][y2 - 1][z2 - 1]) {
                        ++Nobj;
                    } else {
                        ++Nbg;
                    }
                    if (Nobj <= Nbg) {
                        if (Nobj != 0) {
                            if (Nobj == 1) {
                                ++Nv;
                            } else {
                                if (img[x2][y2][z2] && img[x2 - 1][y2][z2]) {
                                    ++N6;
                                }
                                if (img[x2][y2][z2] && img[x2][y2 - 1][z2]) {
                                    ++N6;
                                }
                                if (img[x2][y2][z2] && img[x2][y2][z2 - 1]) {
                                    ++N6;
                                }
                                if (img[x2 - 1][y2][z2] && img[x2 - 1][y2 - 1][z2]) {
                                    ++N6;
                                }
                                if (img[x2 - 1][y2][z2] && img[x2 - 1][y2][z2 - 1]) {
                                    ++N6;
                                }
                                if (img[x2][y2 - 1][z2] && img[x2 - 1][y2 - 1][z2]) {
                                    ++N6;
                                }
                                if (img[x2][y2 - 1][z2] && img[x2][y2 - 1][z2 - 1]) {
                                    ++N6;
                                }
                                if (img[x2][y2][z2 - 1] && img[x2 - 1][y2][z2 - 1]) {
                                    ++N6;
                                }
                                if (img[x2][y2][z2 - 1] && img[x2][y2 - 1][z2 - 1]) {
                                    ++N6;
                                }
                                if (img[x2 - 1][y2 - 1][z2 - 1] && img[x2][y2 - 1][z2 - 1]) {
                                    ++N6;
                                }
                                if (img[x2 - 1][y2 - 1][z2 - 1] && img[x2 - 1][y2][z2 - 1]) {
                                    ++N6;
                                }
                                if (img[x2 - 1][y2 - 1][z2 - 1] && img[x2 - 1][y2 - 1][z2]) {
                                    ++N6;
                                }
                                if (Nobj == 2 && N6 == 1) {
                                    ++Nv;
                                } else if (Nobj == 3 && N6 == 2) {
                                    ++Nv;
                                } else if (Nobj == 4 && N6 == 4) {
                                    ++Nv;
                                } else if (Nobj == 4 && N6 == 3) {
                                    ++Nv;
                                } else {
                                    if (img[x2][y2][z2] && img[x2][y2 - 1][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2][y2][z2] && img[x2 - 1][y2][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2][y2][z2] && img[x2 - 1][y2 - 1][z2]) {
                                        ++N18;
                                    }
                                    if (img[x2 - 1][y2][z2] && img[x2 - 1][y2 - 1][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2 - 1][y2][z2] && img[x2][y2 - 1][z2]) {
                                        ++N18;
                                    }
                                    if (img[x2 - 1][y2][z2] && img[x2][y2][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2][y2 - 1][z2] && img[x2 - 1][y2 - 1][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2][y2 - 1][z2] && img[x2][y2][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2][y2][z2 - 1] && img[x2 - 1][y2 - 1][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2][y2 - 1][z2 - 1] && img[x2 - 1][y2][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (img[x2 - 1][y2][z2 - 1] && img[x2 - 1][y2 - 1][z2]) {
                                        ++N18;
                                    }
                                    if (img[x2 - 1][y2 - 1][z2] && img[x2][y2 - 1][z2 - 1]) {
                                        ++N18;
                                    }
                                    if (Nobj == 2 && N18 == 1) {
                                        Nv = cObj == 6 ? (Nv += 2) : ++Nv;
                                    } else if (Nobj == 3 && N18 == 1) {
                                        Nv = cObj == 6 ? (Nv += 2) : ++Nv;
                                    } else if (Nobj == 3 && N18 == 3) {
                                        Nv = cObj == 6 ? (Nv += 3) : (Nv += 2);
                                    } else if (Nobj == 4 && N18 == 2) {
                                        Nv += 2;
                                    } else if (Nobj == 4 && N18 == 3) {
                                        Nv += 2;
                                    } else if (Nobj == 4 && N18 == 6) {
                                        Nv += 4;
                                    } else if (Nobj == 2) {
                                        Nv = cObj == 26 ? (Nv += 0) : (Nv += 2);
                                    } else {
                                        System.out.println("!:" + Nobj + ", " + N6 + ", " + N18);
                                    }
                                }
                            }
                        }
                    } else if (Nbg != 0) {
                        if (Nbg == 1) {
                            ++Nv;
                        } else {
                            if (!img[x2][y2][z2] && !img[x2 - 1][y2][z2]) {
                                ++N6;
                            }
                            if (!img[x2][y2][z2] && !img[x2][y2 - 1][z2]) {
                                ++N6;
                            }
                            if (!img[x2][y2][z2] && !img[x2][y2][z2 - 1]) {
                                ++N6;
                            }
                            if (!img[x2 - 1][y2][z2] && !img[x2 - 1][y2 - 1][z2]) {
                                ++N6;
                            }
                            if (!img[x2 - 1][y2][z2] && !img[x2 - 1][y2][z2 - 1]) {
                                ++N6;
                            }
                            if (!img[x2][y2 - 1][z2] && !img[x2 - 1][y2 - 1][z2]) {
                                ++N6;
                            }
                            if (!img[x2][y2 - 1][z2] && !img[x2][y2 - 1][z2 - 1]) {
                                ++N6;
                            }
                            if (!img[x2][y2][z2 - 1] && !img[x2 - 1][y2][z2 - 1]) {
                                ++N6;
                            }
                            if (!img[x2][y2][z2 - 1] && !img[x2][y2 - 1][z2 - 1]) {
                                ++N6;
                            }
                            if (!img[x2 - 1][y2 - 1][z2 - 1] && !img[x2][y2 - 1][z2 - 1]) {
                                ++N6;
                            }
                            if (!img[x2 - 1][y2 - 1][z2 - 1] && !img[x2 - 1][y2][z2 - 1]) {
                                ++N6;
                            }
                            if (!img[x2 - 1][y2 - 1][z2 - 1] && !img[x2 - 1][y2 - 1][z2]) {
                                ++N6;
                            }
                            if (Nbg == 2 && N6 == 1) {
                                ++Nv;
                            } else if (Nbg == 3 && N6 == 2) {
                                ++Nv;
                            } else if (Nbg == 4 && N6 == 4) {
                                ++Nv;
                            } else if (Nbg == 4 && N6 == 3) {
                                ++Nv;
                            } else {
                                if (!img[x2][y2][z2] && !img[x2][y2 - 1][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2][y2][z2] && !img[x2 - 1][y2][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2][y2][z2] && !img[x2 - 1][y2 - 1][z2]) {
                                    ++N18;
                                }
                                if (!img[x2 - 1][y2][z2] && !img[x2 - 1][y2 - 1][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2 - 1][y2][z2] && !img[x2][y2 - 1][z2]) {
                                    ++N18;
                                }
                                if (!img[x2 - 1][y2][z2] && !img[x2][y2][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2][y2 - 1][z2] && !img[x2 - 1][y2 - 1][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2][y2 - 1][z2] && !img[x2][y2][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2][y2][z2 - 1] && !img[x2 - 1][y2 - 1][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2][y2 - 1][z2 - 1] && !img[x2 - 1][y2][z2 - 1]) {
                                    ++N18;
                                }
                                if (!img[x2 - 1][y2][z2 - 1] && !img[x2 - 1][y2 - 1][z2]) {
                                    ++N18;
                                }
                                if (!img[x2 - 1][y2 - 1][z2] && !img[x2][y2 - 1][z2 - 1]) {
                                    ++N18;
                                }
                                if (Nbg == 2 && N18 == 1) {
                                    Nv = cBg == 6 ? (Nv += 2) : ++Nv;
                                } else if (Nbg == 3 && N18 == 1) {
                                    Nv = cBg == 6 ? (Nv += 2) : ++Nv;
                                } else if (Nbg == 3 && N18 == 3) {
                                    Nv = cBg == 6 ? (Nv += 3) : (Nv += 2);
                                } else if (Nbg == 4 && N18 == 2) {
                                    Nv += 2;
                                } else if (Nbg == 4 && N18 == 3) {
                                    Nv += 2;
                                } else if (Nbg == 4 && N18 == 6) {
                                    Nv += 4;
                                } else if (Nbg == 2) {
                                    Nv = cBg == 26 ? (Nv += 0) : (Nv += 2);
                                } else {
                                    System.out.println("!:" + Nbg + ", " + N6 + ", " + N18);
                                }
                            }
                        }
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
        return Nv - Ne + Nf;
    }

    public static final float[][][] thicknessMap(boolean[][][] img, int nx, int ny, int nz) {
        float[][][] map = new float[nx][ny][nz];
        float min = nx + ny + nz;
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    if (img[x][y][z]) {
                        float thickness = 0.0f;
                        map[x][y][z] = nx + ny + nz;
                        int n = 1;
                        int m = 1;
                        while (x + n < nx && img[x][y][z] == img[x + n][y][z]) {
                            ++n;
                        }
                        while (x - m >= 0 && img[x][y][z] == img[x - m][y][z]) {
                            ++m;
                        }
                        thickness = n + m - 1;
                        if (thickness < map[x][y][z]) {
                            map[x][y][z] = thickness;
                        }
                        n = 1;
                        m = 1;
                        while (y + n < ny && img[x][y][z] == img[x][y + n][z]) {
                            ++n;
                        }
                        while (y - m >= 0 && img[x][y][z] == img[x][y - m][z]) {
                            ++m;
                        }
                        thickness = n + m - 1;
                        if (thickness < map[x][y][z]) {
                            map[x][y][z] = thickness;
                        }
                        n = 1;
                        m = 1;
                        while (z + n < nz && img[x][y][z] == img[x][y][z + n]) {
                            ++n;
                        }
                        while (z - m >= 0 && img[x][y][z] == img[x][y][z - m]) {
                            ++m;
                        }
                        thickness = n + m - 1;
                        if (thickness < map[x][y][z]) {
                            map[x][y][z] = thickness;
                        }
                        if (map[x][y][z] < min) {
                            min = map[x][y][z];
                        }
                    } else {
                        map[x][y][z] = 0.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        System.out.println("minimum thickness: " + min);
        return map;
    }

    public static final float[][][] fullConnection(boolean[][][] img, int nx, int ny, int nz) {
        float[][][] res = new float[nx][ny][nz];
        int[] count = new int[8];
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    res[x][y][z] = 0.0f;
                    if (img[x][y][z]) {
                        float[] fArray = res[x][y];
                        int n = z;
                        fArray[n] = fArray[n] + 1.0f;
                        int n2 = 0;
                        while (n2 < 8) {
                            count[n2] = 0;
                            ++n2;
                        }
                        int i = 0;
                        while (i <= 1) {
                            int j = 0;
                            while (j <= 1) {
                                int l = 0;
                                while (l <= 1) {
                                    if (img[x + i][y + j][z + l]) {
                                        count[0] = count[0] + 1;
                                    }
                                    if (img[x - i][y + j][z + l]) {
                                        count[1] = count[1] + 1;
                                    }
                                    if (img[x + i][y - j][z + l]) {
                                        count[2] = count[2] + 1;
                                    }
                                    if (img[x + i][y + j][z - l]) {
                                        count[3] = count[3] + 1;
                                    }
                                    if (img[x + i][y - j][z - l]) {
                                        count[4] = count[4] + 1;
                                    }
                                    if (img[x - i][y + j][z - l]) {
                                        count[5] = count[5] + 1;
                                    }
                                    if (img[x - i][y - j][z + l]) {
                                        count[6] = count[6] + 1;
                                    }
                                    if (img[x - i][y - j][z - l]) {
                                        count[7] = count[7] + 1;
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        n2 = 0;
                        while (n2 < 8) {
                            if (count[n2] == 8) {
                                float[] fArray2 = res[x][y];
                                int n3 = z;
                                fArray2[n3] = fArray2[n3] + 1.0f;
                            }
                            ++n2;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return res;
    }

    public static final float[][][] connectivity(boolean[][][] img, int nx, int ny, int nz) {
        float[][][] obj = new float[nx][ny][nz];
        int[] Nb = new int[8];
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    if (img[x][y][z]) {
                        obj[x][y][z] = 6.0f;
                        if (img[x + 1][y + 1][z] && !img[x + 1][y][z] && !img[x][y + 1][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x][y + 1][z + 1] && !img[x][y + 1][z] && !img[x][y][z + 1]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x + 1][y][z + 1] && !img[x][y][z + 1] && !img[x + 1][y][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x - 1][y + 1][z] && !img[x - 1][y][z] && !img[x][y + 1][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x][y - 1][z + 1] && !img[x][y - 1][z] && !img[x][y][z + 1]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x + 1][y][z - 1] && !img[x][y][z - 1] && !img[x + 1][y][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x + 1][y - 1][z] && !img[x + 1][y][z] && !img[x][y - 1][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x][y + 1][z - 1] && !img[x][y + 1][z] && !img[x][y][z - 1]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x - 1][y][z + 1] && !img[x][y][z + 1] && !img[x - 1][y][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x - 1][y - 1][z] && !img[x - 1][y][z] && !img[x][y - 1][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x][y - 1][z - 1] && !img[x][y - 1][z] && !img[x][y][z - 1]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x - 1][y][z - 1] && !img[x][y][z - 1] && !img[x - 1][y][z]) {
                            obj[x][y][z] = 18.0f;
                        }
                        if (img[x + 1][y + 1][z + 1] && !img[x + 1][y][z] && !img[x][y + 1][z] && !img[x][y][z + 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                        if (img[x - 1][y + 1][z + 1] && !img[x - 1][y][z] && !img[x][y + 1][z] && !img[x][y][z + 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                        if (img[x + 1][y - 1][z + 1] && !img[x + 1][y][z] && !img[x][y - 1][z] && !img[x][y][z + 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                        if (img[x + 1][y + 1][z - 1] && !img[x + 1][y][z] && !img[x][y + 1][z] && !img[x][y][z - 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                        if (img[x + 1][y - 1][z - 1] && !img[x + 1][y][z] && !img[x][y - 1][z] && !img[x][y][z - 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                        if (img[x - 1][y + 1][z - 1] && !img[x - 1][y][z] && !img[x][y + 1][z] && !img[x][y][z - 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                        if (img[x - 1][y - 1][z + 1] && !img[x - 1][y][z] && !img[x][y - 1][z] && !img[x][y][z + 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                        if (img[x - 1][y - 1][z - 1] && !img[x - 1][y][z] && !img[x][y - 1][z] && !img[x][y][z - 1]) {
                            obj[x][y][z] = 26.0f;
                        }
                    } else {
                        obj[x][y][z] = 0.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final float[][][] wellComposed(boolean[][][] img, int nx, int ny, int nz) {
        float[][][] obj = new float[nx][ny][nz];
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    obj[x][y][z] = !img[x][y][z] ? 0.0f : (ObjectProcessing.isWellComposed(img, x, y, z) ? 1.0f : 2.0f);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return obj;
    }

    public static final boolean isWellComposed(boolean[][] obj2d, int xi, int yi) {
        boolean[][][] obj = new boolean[3][3][3];
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                int z = 0;
                while (z < 3) {
                    obj[x][y][z] = obj2d[x][y];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return ObjectProcessing.isWellComposed(obj, xi, yi, 1);
    }

    public static final boolean isWellComposed(boolean[][][] img, int x, int y, int z) {
        if (img[x][y][z]) {
            if (img[x - 1][y - 1][z] && !img[x - 1][y][z] && !img[x][y - 1][z]) {
                return false;
            }
            if (img[x][y - 1][z - 1] && !img[x][y - 1][z] && !img[x][y][z - 1]) {
                return false;
            }
            if (img[x - 1][y][z - 1] && !img[x][y][z - 1] && !img[x - 1][y][z]) {
                return false;
            }
            if (img[x - 1][y + 1][z] && !img[x - 1][y][z] && !img[x][y + 1][z]) {
                return false;
            }
            if (img[x][y - 1][z + 1] && !img[x][y - 1][z] && !img[x][y][z + 1]) {
                return false;
            }
            if (img[x + 1][y][z - 1] && !img[x][y][z - 1] && !img[x + 1][y][z]) {
                return false;
            }
            if (img[x + 1][y - 1][z] && !img[x + 1][y][z] && !img[x][y - 1][z]) {
                return false;
            }
            if (img[x][y + 1][z - 1] && !img[x][y + 1][z] && !img[x][y][z - 1]) {
                return false;
            }
            if (img[x - 1][y][z + 1] && !img[x][y][z + 1] && !img[x - 1][y][z]) {
                return false;
            }
            if (img[x + 1][y + 1][z] && !img[x + 1][y][z] && !img[x][y + 1][z]) {
                return false;
            }
            if (img[x][y + 1][z + 1] && !img[x][y + 1][z] && !img[x][y][z + 1]) {
                return false;
            }
            if (img[x + 1][y][z + 1] && !img[x][y][z + 1] && !img[x + 1][y][z]) {
                return false;
            }
            if (!(!img[x - 1][y - 1][z - 1] || img[x - 1][y][z] && img[x - 1][y - 1][z] || img[x - 1][y][z] && img[x - 1][y][z - 1] || img[x][y - 1][z] && img[x][y - 1][z - 1] || img[x][y - 1][z] && img[x - 1][y - 1][z] || img[x][y][z - 1] && img[x - 1][y][z - 1] || img[x][y][z - 1] && img[x][y - 1][z - 1])) {
                return false;
            }
            if (!(!img[x - 1][y - 1][z + 1] || img[x - 1][y][z] && img[x - 1][y - 1][z] || img[x - 1][y][z] && img[x - 1][y][z + 1] || img[x][y - 1][z] && img[x][y - 1][z + 1] || img[x][y - 1][z] && img[x - 1][y - 1][z] || img[x][y][z + 1] && img[x - 1][y][z + 1] || img[x][y][z + 1] && img[x][y - 1][z + 1])) {
                return false;
            }
            if (!(!img[x - 1][y + 1][z - 1] || img[x - 1][y][z] && img[x - 1][y + 1][z] || img[x - 1][y][z] && img[x - 1][y][z - 1] || img[x][y + 1][z] && img[x][y + 1][z - 1] || img[x][y + 1][z] && img[x - 1][y + 1][z] || img[x][y][z - 1] && img[x - 1][y][z - 1] || img[x][y][z - 1] && img[x][y + 1][z - 1])) {
                return false;
            }
            if (!(!img[x + 1][y - 1][z - 1] || img[x + 1][y][z] && img[x + 1][y - 1][z] || img[x + 1][y][z] && img[x + 1][y][z - 1] || img[x][y - 1][z] && img[x][y - 1][z - 1] || img[x][y - 1][z] && img[x + 1][y - 1][z] || img[x][y][z - 1] && img[x + 1][y][z - 1] || img[x][y][z - 1] && img[x][y - 1][z - 1])) {
                return false;
            }
            if (!(!img[x - 1][y + 1][z + 1] || img[x - 1][y][z] && img[x - 1][y + 1][z] || img[x - 1][y][z] && img[x - 1][y][z + 1] || img[x][y + 1][z] && img[x][y + 1][z + 1] || img[x][y + 1][z] && img[x - 1][y + 1][z] || img[x][y][z + 1] && img[x - 1][y][z + 1] || img[x][y][z + 1] && img[x][y + 1][z + 1])) {
                return false;
            }
            if (!(!img[x + 1][y - 1][z + 1] || img[x + 1][y][z] && img[x + 1][y - 1][z] || img[x + 1][y][z] && img[x + 1][y][z + 1] || img[x][y - 1][z] && img[x][y - 1][z + 1] || img[x][y - 1][z] && img[x + 1][y - 1][z] || img[x][y][z + 1] && img[x + 1][y][z + 1] || img[x][y][z + 1] && img[x][y - 1][z + 1])) {
                return false;
            }
            if (!(!img[x + 1][y + 1][z - 1] || img[x + 1][y][z] && img[x + 1][y + 1][z] || img[x + 1][y][z] && img[x + 1][y][z - 1] || img[x][y + 1][z] && img[x][y + 1][z - 1] || img[x][y + 1][z] && img[x + 1][y + 1][z] || img[x][y][z - 1] && img[x + 1][y][z - 1] || img[x][y][z - 1] && img[x][y + 1][z - 1])) {
                return false;
            }
            if (!(!img[x + 1][y + 1][z + 1] || img[x + 1][y][z] && img[x + 1][y + 1][z] || img[x + 1][y][z] && img[x + 1][y][z + 1] || img[x][y + 1][z] && img[x][y + 1][z + 1] || img[x][y + 1][z] && img[x + 1][y + 1][z] || img[x][y][z + 1] && img[x + 1][y][z + 1] || img[x][y][z + 1] && img[x][y + 1][z + 1])) {
                return false;
            }
        }
        return true;
    }

    public static final boolean[][][] objectBoundary(boolean[][][] obj, int nx, int ny, int nz) {
        return ObjectProcessing.objectInsideBoundary(obj, nx, ny, nz, 6);
    }

    public static final boolean[][][] objectInsideBoundary(boolean[][][] obj, int nx, int ny, int nz, int connectivity) {
        boolean[][][] boundary = new boolean[nx][ny][nz];
        int dist = connectivity == 6 ? 1 : (connectivity == 18 ? 2 : 3);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boundary[x][y][z] = false;
                    if (obj[x][y][z]) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (i * i + j * j + l * l <= dist && x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + l >= 0 && z + l < nz && !obj[x + i][y + j][z + l]) {
                                        boundary[x][y][z] = true;
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return boundary;
    }

    public static final boolean[][][] objectOutsideBoundary(boolean[][][] obj, int nx, int ny, int nz, int connectivity) {
        boolean[][][] boundary = new boolean[nx][ny][nz];
        int dist = connectivity == 6 ? 1 : (connectivity == 18 ? 2 : 3);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    boundary[x][y][z] = false;
                    if (!obj[x][y][z]) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (i * i + j * j + l * l <= dist && x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + l >= 0 && z + l < nz && obj[x + i][y + j][z + l]) {
                                        boundary[x][y][z] = true;
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return boundary;
    }

    public static boolean[][][] createObjectMask(float[][][] image, float val, int nx, int ny, int nz) {
        int z;
        int y;
        boolean[][][] objMask = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    if (image[x][y][z] < val) {
                        objMask[x][y][z] = false;
                    } else {
                        System.out.println("x: " + x);
                        System.out.println("y: " + y);
                        System.out.println("z: " + z);
                        objMask[x][y][z] = true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                objMask[x][y][0] = false;
                objMask[x][y][nz - 1] = false;
                ++y;
            }
            ++x;
        }
        y = 0;
        while (y < ny) {
            z = 0;
            while (z < nz) {
                objMask[0][y][z] = false;
                objMask[nx - 1][y][z] = false;
                ++z;
            }
            ++y;
        }
        z = 0;
        while (z < nz) {
            x = 0;
            while (x < nx) {
                objMask[x][0][z] = false;
                objMask[x][ny - 1][z] = false;
                ++x;
            }
            ++z;
        }
        return objMask;
    }

    public static final float[][][] objectCurvature(boolean[][][] obj, int nx, int ny, int nz) {
        int z;
        int y;
        float[][][] curv = new float[nx][ny][nz];
        float[][][] level = new float[nx][ny][nz];
        int x = 1;
        while (x < nx - 1) {
            y = 1;
            while (y < ny - 1) {
                z = 1;
                while (z < nz - 1) {
                    if (obj[x][y][z]) {
                        int boundary = 0;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (!(i * i + j * j + l * l != 1 || obj[x + i][y + j][z + l] || boundary != 0 && boundary <= 6)) {
                                        boundary = 6;
                                    } else if (!(i * i + j * j + l * l != 2 || obj[x + i][y + j][z + l] || boundary != 0 && boundary <= 18)) {
                                        boundary = 18;
                                    } else if (i * i + j * j + l * l == 3 && !obj[x + i][y + j][z + l] && boundary == 0) {
                                        boundary = 26;
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        level[x][y][z] = boundary == 0 ? -1.0f : 0.0f;
                    } else {
                        level[x][y][z] = 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 1;
        while (x < nx - 1) {
            y = 1;
            while (y < ny - 1) {
                z = 1;
                while (z < nz - 1) {
                    if (level[x][y][z] == 0.0f) {
                        float u = level[x][y][z];
                        float xp = level[x + 1][y][z];
                        float xm = level[x - 1][y][z];
                        float yp = level[x][y + 1][z];
                        float ym = level[x][y + 1][z];
                        float zp = level[x][y][z + 1];
                        float zm = level[x][y][z - 1];
                        float xpyp = level[x + 1][y + 1][z];
                        float xmyp = level[x - 1][y + 1][z];
                        float xpym = level[x + 1][y - 1][z];
                        float xmym = level[x - 1][y - 1][z];
                        float xpzp = level[x + 1][y][z + 1];
                        float xmzp = level[x - 1][y][z + 1];
                        float xpzm = level[x + 1][y][z - 1];
                        float xmzm = level[x - 1][y][z - 1];
                        float ypzp = level[x][y + 1][z + 1];
                        float ymzp = level[x][y - 1][z + 1];
                        float ypzm = level[x][y + 1][z - 1];
                        float ymzm = level[x][y - 1][z - 1];
                        float xpypzm = level[x + 1][y + 1][z - 1];
                        float xpymzm = level[x + 1][y - 1][z - 1];
                        float xmypzm = level[x - 1][y + 1][z - 1];
                        float xmymzm = level[x - 1][y - 1][z - 1];
                        float xpypzp = level[x + 1][y + 1][z + 1];
                        float xpymzp = level[x + 1][y - 1][z + 1];
                        float xmypzp = level[x - 1][y + 1][z + 1];
                        float xmymzp = level[x - 1][y - 1][z + 1];
                        float ux = 0.25f * (xp + xpyp + xpzp + xpypzp - xm - xmyp - xmzp - xmypzp);
                        float uy = 0.25f * (yp + xpyp + ypzp + xpypzp - ym - xpym - ymzp - xpymzp);
                        float uz = 0.25f * (zp + xpzp + ypzp + xpypzp - zm - xpzm - ypzm - xpypzm);
                        float uxx = 0.0625f * (4.0f * xp + 2.0f * xpyp + 2.0f * xpzp + 2.0f * xpym + 2.0f * xpzm + xpypzp + xpymzp + xpypzm + xpymzm + 4.0f * xm + 2.0f * xmyp + 2.0f * xmzp + 2.0f * xmym + 2.0f * xmzm + xmypzp + xmymzp + xmypzm + xmymzm) - 0.125f * (4.0f * u + 2.0f * yp + 2.0f * zp + 2.0f * ym + 2.0f * zm + ypzp + ymzp + ypzm + ymzm);
                        float uyy = 0.0625f * (4.0f * yp + 2.0f * xpyp + 2.0f * ypzp + 2.0f * xmyp + 2.0f * ypzm + xpypzp + xpymzp + xpypzm + xpymzm + 4.0f * ym + 2.0f * xpym + 2.0f * ymzp + 2.0f * xmym + 2.0f * ymzm + xmypzp + xmymzp + xmypzm + xmymzm) - 0.125f * (4.0f * u + 2.0f * xp + 2.0f * zp + 2.0f * xm + 2.0f * zm + xpzp + xmzp + xpzm + xmzm);
                        float uzz = 0.0625f * (4.0f * zp + 2.0f * xpzp + 2.0f * ypzp + 2.0f * xmzp + 2.0f * ymzp + xpypzp + xpymzp + xpypzm + xpymzm + 4.0f * zm + 2.0f * xpzm + 2.0f * ypzm + 2.0f * xmzm + 2.0f * ymzm + xmypzp + xmymzp + xmypzm + xmymzm) - 0.125f * (4.0f * u + 2.0f * xp + 2.0f * yp + 2.0f * xm + 2.0f * ym + xpyp + xmyp + xpym + xmym);
                        float uxy = 0.0625f * (2.0f * xpyp + 2.0f * xmym + xpypzp + xpypzm + xmymzp + xmymzm - 2.0f * xpym - 2.0f * xmyp - xpymzp - xpymzm - xmypzp - xmypzm);
                        float uyz = 0.0625f * (2.0f * ypzp + 2.0f * ymzm + xpypzp + xmypzp + xpymzm + xmymzm - 2.0f * ymzp - 2.0f * ypzm - xpymzp - xmymzp - xpypzm - xmypzm);
                        float uzx = 0.0625f * (2.0f * xpzp + 2.0f * xmzm + xpypzp + xpymzp + xmypzm + xmymzm - 2.0f * xmzp - 2.0f * xpzm - xpypzm - xpymzm - xmypzp - xmymzp);
                        float num = ux * ux * (uyy + uzz) + uy * uy * (uzz + uxx) + uz * uz * (uxx + uyy) - 2.0f * ux * uy * uxy - 2.0f * uy * uz * uyz - 2.0f * uz * ux * uzx;
                        float den = (float)Math.sqrt(ux * ux + uy * uy + uz * uz);
                        curv[x][y][z] = (den = 2.0f * den * den * den) > 0.0f ? num / den : 0.0f;
                    } else {
                        curv[x][y][z] = 0.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return curv;
    }

    public static final int volume(boolean[][][] img, int nx, int ny, int nz) {
        int count = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        ++count;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return count;
    }

    public static final int volume(int[][][] img, int lb, int nx, int ny, int nz) {
        int count = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z] == lb) {
                        ++count;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return count;
    }

    public static final int countParts(boolean[][][] img, int nx, int ny, int nz, int cObj, int cBg) {
        int[][][] lb = null;
        if (cObj == 6) {
            lb = ObjectProcessing.connected6Object3D(img, nx, ny, nz);
        } else if (cObj == 18) {
            lb = ObjectProcessing.connected18Object3D(img, nx, ny, nz);
        } else if (cObj == 26) {
            lb = ObjectProcessing.connected26Object3D(img, nx, ny, nz);
        }
        return ObjectProcessing.countLabels(lb, nx, ny, nz) - 1;
    }

    public static final int countHoles(boolean[][][] img, int nx, int ny, int nz, int cObj, int cBg) {
        int[][][] lb = null;
        boolean[][][] obj = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    obj[x][y][z] = !img[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (cBg == 6) {
            lb = ObjectProcessing.connected6Object3D(obj, nx, ny, nz);
        } else if (cBg == 18) {
            lb = ObjectProcessing.connected18Object3D(obj, nx, ny, nz);
        } else if (cBg == 26) {
            lb = ObjectProcessing.connected26Object3D(obj, nx, ny, nz);
        }
        return ObjectProcessing.countLabels(lb, nx, ny, nz) - 2;
    }

    public static final boolean[][][] binaryOperation(boolean[][][] img1, boolean[][][] img2, int operator, int nx, int ny, int nz) {
        boolean[][][] res = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    res[x][y][z] = false;
                    if (operator == 26 && img1[x][y][z] && img2[x][y][z]) {
                        res[x][y][z] = true;
                    } else if (operator == 27 && (img1[x][y][z] || img2[x][y][z])) {
                        res[x][y][z] = true;
                    } else if (operator == 28 && (img1[x][y][z] && !img2[x][y][z] || !img1[x][y][z] && img2[x][y][z])) {
                        res[x][y][z] = true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return res;
    }

    public static final boolean[][][] inverse(boolean[][][] img, int nx, int ny, int nz) {
        boolean[][][] res = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    res[x][y][z] = !img[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return res;
    }

    public static final float objectCentile(boolean[][][] obj, float[][][] intensity, float centile, int Nbins, int nx, int ny, int nz) {
        float Imin = intensity[0][0][0];
        float Imax = intensity[0][0][0];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (intensity[x][y][z] > Imax) {
                        Imax = intensity[x][y][z];
                    }
                    if (intensity[x][y][z] < Imin) {
                        Imin = intensity[x][y][z];
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        float[] hist = new float[Nbins + 1];
        int x2 = 0;
        while (x2 < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (obj[x2][y][z]) {
                        int bin = Numerics.floor((intensity[x2][y][z] - Imin) / (Imax - Imin) * (float)Nbins);
                        if (bin < 0) {
                            bin = 0;
                        }
                        if (bin >= Nbins) {
                            bin = Nbins - 1;
                        }
                        int n = bin;
                        hist[n] = hist[n] + 1.0f;
                        int n2 = Nbins;
                        hist[n2] = hist[n2] + 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x2;
        }
        float count = 0.0f;
        int bin = 0;
        while (count < centile * hist[Nbins]) {
            count += hist[bin];
            ++bin;
        }
        float val = Imin + (float)(bin - 1) / (float)Nbins * (Imax - Imin);
        return val;
    }

    public static final int[][] confusionMatrix(int[][][] seg, int[][][] ref, int nx, int ny, int nz) {
        int[] seglabels = ObjectProcessing.listOrderedLabels(seg, nx, ny, nz);
        int[] reflabels = ObjectProcessing.listOrderedLabels(seg, nx, ny, nz);
        ArrayList<Integer> alllabels = new ArrayList<Integer>();
        int i = 0;
        while (i < seglabels.length) {
            alllabels.add(seglabels[i]);
            ++i;
        }
        i = 0;
        while (i < seglabels.length) {
            if (!alllabels.contains(reflabels[i])) {
                alllabels.add(reflabels[i]);
            }
            ++i;
        }
        Collections.sort(alllabels);
        int nlabels = alllabels.size();
        int[][] confmtx = new int[nlabels][nlabels];
        int i2 = -1;
        int j = -1;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    i2 = Collections.binarySearch(alllabels, ref[x][y][z]);
                    j = Collections.binarySearch(alllabels, seg[x][y][z]);
                    int[] nArray = confmtx[i2];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return confmtx;
    }

    public static final boolean[][][] simpleSkeleton(boolean[][][] obj, int nx, int ny, int nz, int connectivity) {
        int l;
        int j;
        int i;
        int z;
        int y;
        float val = 0.0f;
        float ngb = 0.0f;
        int[] vec = new int[3];
        float epsilon = 0.001f;
        float mindist = 2.0f;
        BinaryTree tree = new BinaryTree(nx * ny * nz, 3, -1, 1);
        CriticalPointLUT lut = connectivity == 6 ? new CriticalPointLUT("critical626LUT.raw.gz", 200) : (connectivity == 18 ? new CriticalPointLUT("critical186LUT.raw.gz", 200) : new CriticalPointLUT("critical266LUT.raw.gz", 200));
        if (!lut.loadCompressedPattern()) {
            System.out.println("Problem loading the algorithm's LUT from: " + lut.getFilename());
            return null;
        }
        int max = 2;
        boolean[][][] skeleton = new boolean[nx][ny][nz];
        boolean[][][] critical = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    skeleton[x][y][z] = obj[x][y][z];
                    critical[x][y][z] = false;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 1;
        while (x < nx - 1) {
            y = 1;
            while (y < ny - 1) {
                z = 1;
                while (z < nz - 1) {
                    if (obj[x][y][z]) {
                        int boundary = 0;
                        i = -1;
                        while (i <= 1) {
                            j = -1;
                            while (j <= 1) {
                                l = -1;
                                while (l <= 1) {
                                    if (i * i + j * j + l * l < max) {
                                        if (!(i * i + j * j + l * l != 1 || obj[x + i][y + j][z + l] || boundary != 0 && boundary <= 6)) {
                                            boundary = 6;
                                        } else if (!(i * i + j * j + l * l != 2 || obj[x + i][y + j][z + l] || boundary != 0 && boundary <= 18)) {
                                            boundary = 18;
                                        } else if (i * i + j * j + l * l == 3 && !obj[x + i][y + j][z + l] && boundary == 0) {
                                            boundary = 26;
                                        }
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (boundary == 6) {
                            val = 0.5f;
                        } else if (boundary == 18) {
                            val = 0.5f * SQR2;
                        } else if (boundary == 26) {
                            val = 0.5f * SQR3;
                        }
                        if (boundary > 0) {
                            vec[0] = x;
                            vec[1] = y;
                            vec[2] = z;
                            tree.addValue(val, vec);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        while (tree.isNotEmpty()) {
            x = tree.getFirstIndex(0);
            y = tree.getFirstIndex(1);
            z = tree.getFirstIndex(2);
            val = tree.getFirst();
            tree.removeFirst();
            if (!skeleton[x][y][z]) continue;
            if (lut.get(lut.keyFromPattern(skeleton, x, y, z))) {
                int nb = -1;
                i = -1;
                while (i <= 1) {
                    j = -1;
                    while (j <= 1) {
                        l = -1;
                        while (l <= 1) {
                            if (skeleton[x + i][y + j][z + l]) {
                                ++nb;
                            }
                            ++l;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (nb <= 1 && !(val < mindist)) continue;
                skeleton[x][y][z] = false;
                critical[x][y][z] = false;
                i = -1;
                while (i <= 1) {
                    j = -1;
                    while (j <= 1) {
                        l = -1;
                        while (l <= 1) {
                            if (i * i + j * j + l * l < max) {
                                if (critical[x + i][y + j][z + l]) {
                                    ngb = val + epsilon;
                                    vec[0] = x + i;
                                    vec[1] = y + j;
                                    vec[2] = z + l;
                                    tree.addValue(ngb, vec);
                                } else if (skeleton[x + i][y + j][z + l]) {
                                    if (i * i + j * j + l * l == 1) {
                                        ngb = val + 1.0f;
                                    } else if (i * i + j * j + l * l == 2) {
                                        ngb = val + SQR2;
                                    } else if (i * i + j * j + l * l == 3) {
                                        ngb = val + SQR3;
                                    }
                                    vec[0] = x + i;
                                    vec[1] = y + j;
                                    vec[2] = z + l;
                                    tree.addValue(ngb, vec);
                                }
                            }
                            ++l;
                        }
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            critical[x][y][z] = true;
        }
        tree.finalize();
        tree = null;
        return skeleton;
    }

    public static final short[][][][] voronoiFeatureTransform(boolean[][][] obj, int nx, int ny, int nz) {
        short y;
        short[][][][] ft = new short[nx][ny][nz][3];
        short[][] gx = new short[nx][3];
        short[][] gy = new short[ny][3];
        short[][] gz = new short[nz][3];
        short z = 0;
        while (z < nz) {
            y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    if (obj[x][y][z]) {
                        ft[x][y][z][0] = x;
                        ft[x][y][z][1] = y;
                        ft[x][y][z][2] = z;
                    } else {
                        ft[x][y][z][0] = -1;
                        ft[x][y][z][1] = -1;
                        ft[x][y][z][2] = -1;
                    }
                    x = (short)(x + 1);
                }
                ObjectProcessing.computePartialVoronoiDiagramX(ft, gx, y, z, nx, ny, nz);
                y = (short)(y + 1);
            }
            short x = 0;
            while (x < nx) {
                ObjectProcessing.computePartialVoronoiDiagramY(ft, gy, x, z, nx, ny, nz);
                x = (short)(x + 1);
            }
            z = (short)(z + 1);
        }
        short x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                ObjectProcessing.computePartialVoronoiDiagramZ(ft, gz, x, y, nx, ny, nz);
                y = (short)(y + 1);
            }
            x = (short)(x + 1);
        }
        gx = null;
        gy = null;
        gz = null;
        return ft;
    }

    /*
     * Unable to fully structure code
     */
    private static final void computePartialVoronoiDiagramX(short[][][][] ft, short[][] g, short y, short z, int nx, int ny, int nz) {
        xi = new short[3];
        l = -1;
        i = 0;
        while (i < nx) {
            block5: {
                xi[0] = i;
                xi[1] = y;
                xi[2] = z;
                if (ft[i][y][z][0] <= -1) break block5;
                if (l >= 1) ** GOTO lbl15
                g[++l][0] = ft[i][y][z][0];
                g[l][1] = ft[i][y][z][1];
                g[l][2] = ft[i][y][z][2];
                break block5;
lbl-1000:
                // 1 sources

                {
                    --l;
lbl15:
                    // 2 sources

                    ** while (l >= 1 && ObjectProcessing.removeVoronoiFeature((short[])g[l - 1], (short[])g[l], (short[])ft[i][y][z], (short[])xi, (int)0))
                }
lbl16:
                // 1 sources

                g[++l][0] = ft[i][y][z][0];
                g[l][1] = ft[i][y][z][1];
                g[l][2] = ft[i][y][z][2];
            }
            i = (short)(i + 1);
        }
        ns = l;
        if (ns == -1) {
            return;
        }
        l = 0;
        i = 0;
        while (i < nx) {
            xi[0] = i;
            xi[1] = y;
            xi[2] = z;
            while (l < ns && ObjectProcessing.ftDistance(xi, g[l]) > ObjectProcessing.ftDistance(xi, g[l + 1])) {
                ++l;
            }
            ft[i][y][z][0] = g[l][0];
            ft[i][y][z][1] = g[l][1];
            ft[i][y][z][2] = g[l][2];
            i = (short)(i + 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void computePartialVoronoiDiagramY(short[][][][] ft, short[][] g, short x, short z, int nx, int ny, int nz) {
        xi = new short[3];
        l = -1;
        i = 0;
        while (i < ny) {
            block5: {
                xi[0] = x;
                xi[1] = i;
                xi[2] = z;
                if (ft[x][i][z][0] <= -1) break block5;
                if (l >= 1) ** GOTO lbl15
                g[++l][0] = ft[x][i][z][0];
                g[l][1] = ft[x][i][z][1];
                g[l][2] = ft[x][i][z][2];
                break block5;
lbl-1000:
                // 1 sources

                {
                    --l;
lbl15:
                    // 2 sources

                    ** while (l >= 1 && ObjectProcessing.removeVoronoiFeature((short[])g[l - 1], (short[])g[l], (short[])ft[x][i][z], (short[])xi, (int)1))
                }
lbl16:
                // 1 sources

                g[++l][0] = ft[x][i][z][0];
                g[l][1] = ft[x][i][z][1];
                g[l][2] = ft[x][i][z][2];
            }
            i = (short)(i + 1);
        }
        ns = l;
        if (ns == -1) {
            return;
        }
        l = 0;
        i = 0;
        while (i < ny) {
            xi[0] = x;
            xi[1] = i;
            xi[2] = z;
            while (l < ns && ObjectProcessing.ftDistance(xi, g[l]) > ObjectProcessing.ftDistance(xi, g[l + 1])) {
                ++l;
            }
            ft[x][i][z][0] = g[l][0];
            ft[x][i][z][1] = g[l][1];
            ft[x][i][z][2] = g[l][2];
            i = (short)(i + 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void computePartialVoronoiDiagramZ(short[][][][] ft, short[][] g, short x, short y, int nx, int ny, int nz) {
        xi = new short[3];
        l = -1;
        i = 0;
        while (i < nz) {
            block5: {
                xi[0] = x;
                xi[1] = y;
                xi[2] = i;
                if (ft[x][y][i][0] <= -1) break block5;
                if (l >= 1) ** GOTO lbl15
                g[++l][0] = ft[x][y][i][0];
                g[l][1] = ft[x][y][i][1];
                g[l][2] = ft[x][y][i][2];
                break block5;
lbl-1000:
                // 1 sources

                {
                    --l;
lbl15:
                    // 2 sources

                    ** while (l >= 1 && ObjectProcessing.removeVoronoiFeature((short[])g[l - 1], (short[])g[l], (short[])ft[x][y][i], (short[])xi, (int)2))
                }
lbl16:
                // 1 sources

                g[++l][0] = ft[x][y][i][0];
                g[l][1] = ft[x][y][i][1];
                g[l][2] = ft[x][y][i][2];
            }
            i = (short)(i + 1);
        }
        ns = l;
        if (ns == -1) {
            return;
        }
        l = 0;
        i = 0;
        while (i < nz) {
            xi[0] = x;
            xi[1] = y;
            xi[2] = i;
            while (l < ns && ObjectProcessing.ftDistance(xi, g[l]) > ObjectProcessing.ftDistance(xi, g[l + 1])) {
                ++l;
            }
            ft[x][y][i][0] = g[l][0];
            ft[x][y][i][1] = g[l][1];
            ft[x][y][i][2] = g[l][2];
            i = (short)(i + 1);
        }
    }

    public static final short[][] voronoiFeatureTransform(boolean[] obj, int nx, int ny, int nz) {
        short y;
        short[][] ft = new short[nx * ny * nz][3];
        short[][] gx = new short[nx][3];
        short[][] gy = new short[ny][3];
        short[][] gz = new short[nz][3];
        short z = 0;
        while (z < nz) {
            y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    int xyz = x + nx * y + nx * ny * z;
                    if (obj[xyz]) {
                        ft[xyz][0] = x;
                        ft[xyz][1] = y;
                        ft[xyz][2] = z;
                    } else {
                        ft[xyz][0] = -1;
                        ft[xyz][1] = -1;
                        ft[xyz][2] = -1;
                    }
                    x = (short)(x + 1);
                }
                ObjectProcessing.computePartialVoronoiDiagramX(ft, gx, y, z, nx, ny, nz);
                y = (short)(y + 1);
            }
            short x = 0;
            while (x < nx) {
                ObjectProcessing.computePartialVoronoiDiagramY(ft, gy, x, z, nx, ny, nz);
                x = (short)(x + 1);
            }
            z = (short)(z + 1);
        }
        short x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                ObjectProcessing.computePartialVoronoiDiagramZ(ft, gz, x, y, nx, ny, nz);
                y = (short)(y + 1);
            }
            x = (short)(x + 1);
        }
        gx = null;
        gy = null;
        gz = null;
        return ft;
    }

    /*
     * Unable to fully structure code
     */
    private static final void computePartialVoronoiDiagramX(short[][] ft, short[][] g, short y, short z, int nx, int ny, int nz) {
        xi = new short[3];
        l = -1;
        i = 0;
        while (i < nx) {
            block5: {
                xi[0] = i;
                xi[1] = y;
                xi[2] = z;
                iyz = i + nx * y + nx * ny * z;
                if (ft[iyz][0] <= -1) break block5;
                if (l >= 1) ** GOTO lbl16
                g[++l][0] = ft[iyz][0];
                g[l][1] = ft[iyz][1];
                g[l][2] = ft[iyz][2];
                break block5;
lbl-1000:
                // 1 sources

                {
                    --l;
lbl16:
                    // 2 sources

                    ** while (l >= 1 && ObjectProcessing.removeVoronoiFeature((short[])g[l - 1], (short[])g[l], (short[])ft[iyz], (short[])xi, (int)0))
                }
lbl17:
                // 1 sources

                g[++l][0] = ft[iyz][0];
                g[l][1] = ft[iyz][1];
                g[l][2] = ft[iyz][2];
            }
            i = (short)(i + 1);
        }
        ns = l;
        if (ns == -1) {
            return;
        }
        l = 0;
        i = 0;
        while (i < nx) {
            xi[0] = i;
            xi[1] = y;
            xi[2] = z;
            iyz = i + nx * y + nx * ny * z;
            while (l < ns && ObjectProcessing.ftDistance(xi, g[l]) > ObjectProcessing.ftDistance(xi, g[l + 1])) {
                ++l;
            }
            ft[iyz][0] = g[l][0];
            ft[iyz][1] = g[l][1];
            ft[iyz][2] = g[l][2];
            i = (short)(i + 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void computePartialVoronoiDiagramY(short[][] ft, short[][] g, short x, short z, int nx, int ny, int nz) {
        xi = new short[3];
        l = -1;
        i = 0;
        while (i < ny) {
            block5: {
                xi[0] = x;
                xi[1] = i;
                xi[2] = z;
                xiz = x + nx * i + nx * ny * z;
                if (ft[xiz][0] <= -1) break block5;
                if (l >= 1) ** GOTO lbl16
                g[++l][0] = ft[xiz][0];
                g[l][1] = ft[xiz][1];
                g[l][2] = ft[xiz][2];
                break block5;
lbl-1000:
                // 1 sources

                {
                    --l;
lbl16:
                    // 2 sources

                    ** while (l >= 1 && ObjectProcessing.removeVoronoiFeature((short[])g[l - 1], (short[])g[l], (short[])ft[xiz], (short[])xi, (int)1))
                }
lbl17:
                // 1 sources

                g[++l][0] = ft[xiz][0];
                g[l][1] = ft[xiz][1];
                g[l][2] = ft[xiz][2];
            }
            i = (short)(i + 1);
        }
        ns = l;
        if (ns == -1) {
            return;
        }
        l = 0;
        i = 0;
        while (i < ny) {
            xi[0] = x;
            xi[1] = i;
            xi[2] = z;
            xiz = x + nx * i + nx * ny * z;
            while (l < ns && ObjectProcessing.ftDistance(xi, g[l]) > ObjectProcessing.ftDistance(xi, g[l + 1])) {
                ++l;
            }
            ft[xiz][0] = g[l][0];
            ft[xiz][1] = g[l][1];
            ft[xiz][2] = g[l][2];
            i = (short)(i + 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void computePartialVoronoiDiagramZ(short[][] ft, short[][] g, short x, short y, int nx, int ny, int nz) {
        xi = new short[3];
        l = -1;
        i = 0;
        while (i < nz) {
            block5: {
                xi[0] = x;
                xi[1] = y;
                xi[2] = i;
                xyi = x + nx * y + nx * ny * i;
                if (ft[xyi][0] <= -1) break block5;
                if (l >= 1) ** GOTO lbl16
                g[++l][0] = ft[xyi][0];
                g[l][1] = ft[xyi][1];
                g[l][2] = ft[xyi][2];
                break block5;
lbl-1000:
                // 1 sources

                {
                    --l;
lbl16:
                    // 2 sources

                    ** while (l >= 1 && ObjectProcessing.removeVoronoiFeature((short[])g[l - 1], (short[])g[l], (short[])ft[xyi], (short[])xi, (int)2))
                }
lbl17:
                // 1 sources

                g[++l][0] = ft[xyi][0];
                g[l][1] = ft[xyi][1];
                g[l][2] = ft[xyi][2];
            }
            i = (short)(i + 1);
        }
        ns = l;
        if (ns == -1) {
            return;
        }
        l = 0;
        i = 0;
        while (i < nz) {
            xi[0] = x;
            xi[1] = y;
            xi[2] = i;
            xyi = x + nx * y + nx * ny * i;
            while (l < ns && ObjectProcessing.ftDistance(xi, g[l]) > ObjectProcessing.ftDistance(xi, g[l + 1])) {
                ++l;
            }
            ft[xyi][0] = g[l][0];
            ft[xyi][1] = g[l][1];
            ft[xyi][2] = g[l][2];
            i = (short)(i + 1);
        }
    }

    public static final float[][][] voronoiFeatureSquaredDistance(boolean[][][] obj, int nx, int ny, int nz) {
        short[][][][] ft = ObjectProcessing.voronoiFeatureTransform(obj, nx, ny, nz);
        float[][][] dist = new float[nx][ny][nz];
        short x = 0;
        while (x < nx) {
            short y = 0;
            while (y < ny) {
                short z = 0;
                while (z < nz) {
                    if (ft[x][y][z][0] > -1) {
                        short[] pt = new short[]{x, y, z};
                        dist[x][y][z] = ObjectProcessing.ftDistance(pt, ft[x][y][z]);
                    } else {
                        dist[x][y][z] = -1.0f;
                    }
                    z = (short)(z + 1);
                }
                y = (short)(y + 1);
            }
            x = (short)(x + 1);
        }
        ft = null;
        return dist;
    }

    public static final float[][][] voronoiFeatureDistance(boolean[][][] obj, int nx, int ny, int nz) {
        short[][][][] ft = ObjectProcessing.voronoiFeatureTransform(obj, nx, ny, nz);
        float[][][] dist = new float[nx][ny][nz];
        short x = 0;
        while (x < nx) {
            short y = 0;
            while (y < ny) {
                short z = 0;
                while (z < nz) {
                    if (ft[x][y][z][0] > -1) {
                        short[] pt = new short[]{x, y, z};
                        dist[x][y][z] = (float)Math.sqrt(ObjectProcessing.ftDistance(pt, ft[x][y][z]));
                    } else {
                        dist[x][y][z] = -1.0f;
                    }
                    z = (short)(z + 1);
                }
                y = (short)(y + 1);
            }
            x = (short)(x + 1);
        }
        ft = null;
        return dist;
    }

    private static final boolean removeVoronoiFeature(short[] u, short[] v, short[] w, short[] Rd, int d) {
        float duR = 0.0f;
        float dvR = 0.0f;
        float dwR = 0.0f;
        int i = 0;
        while (i < 3) {
            if (i != d) {
                duR += (float)((u[i] - Rd[i]) * (u[i] - Rd[i]));
                dvR += (float)((v[i] - Rd[i]) * (v[i] - Rd[i]));
                dwR += (float)((w[i] - Rd[i]) * (w[i] - Rd[i]));
            }
            ++i;
        }
        return (float)(w[d] - u[d]) * dvR - (float)(w[d] - v[d]) * duR - (float)(v[d] - u[d]) * dwR - (float)((w[d] - u[d]) * (w[d] - v[d]) * (v[d] - u[d])) > 0.0f;
    }

    private static final float ftDistance(short[] u, short[] v) {
        return (u[0] - v[0]) * (u[0] - v[0]) + (u[1] - v[1]) * (u[1] - v[1]) + (u[2] - v[2]) * (u[2] - v[2]);
    }

    public static final float[][][] signedDistanceFunction(boolean[][][] obj, int nx, int ny, int nz) {
        short y;
        short[][][][] ft = ObjectProcessing.voronoiFeatureTransform(obj, nx, ny, nz);
        float[][][] dist = new float[nx][ny][nz];
        short x = 0;
        while (x < nx) {
            short y2 = 0;
            while (y2 < ny) {
                short z = 0;
                while (z < nz) {
                    if (!obj[x][y2][z] && ft[x][y2][z][0] > -1) {
                        short[] pt = new short[]{x, y2, z};
                        dist[x][y2][z] = (float)Math.sqrt(ObjectProcessing.ftDistance(pt, ft[x][y2][z])) - 0.5f;
                    } else {
                        dist[x][y2][z] = 0.0f;
                    }
                    z = (short)(z + 1);
                }
                y2 = (short)(y2 + 1);
            }
            x = (short)(x + 1);
        }
        boolean[][][] bg = new boolean[nx][ny][nz];
        short x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    bg[x2][y][z] = !obj[x2][y][z];
                    z = (short)(z + 1);
                }
                y = (short)(y + 1);
            }
            x2 = (short)(x2 + 1);
        }
        ft = ObjectProcessing.voronoiFeatureTransform(bg, nx, ny, nz);
        x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                short z = 0;
                while (z < nz) {
                    if (!bg[x2][y][z] && ft[x2][y][z][0] > -1) {
                        short[] pt = new short[]{x2, y, z};
                        dist[x2][y][z] = -((float)Math.sqrt(ObjectProcessing.ftDistance(pt, ft[x2][y][z]))) + 0.5f;
                    } else if (!bg[x2][y][z]) {
                        dist[x2][y][z] = 0.0f;
                    }
                    z = (short)(z + 1);
                }
                y = (short)(y + 1);
            }
            x2 = (short)(x2 + 1);
        }
        ft = null;
        return dist;
    }

    public static final float[] signedDistanceFunction(boolean[] obj, int nx, int ny, int nz) {
        short z;
        short y;
        short[][] ft = ObjectProcessing.voronoiFeatureTransform(obj, nx, ny, nz);
        float[] dist = new float[nx * ny * nz];
        short x = 0;
        while (x < nx) {
            short y2 = 0;
            while (y2 < ny) {
                short z2 = 0;
                while (z2 < nz) {
                    int xyz = x + nx * y2 + nx * ny * z2;
                    if (obj[xyz] && ft[xyz][0] > -1) {
                        short[] pt = new short[]{x, y2, z2};
                        dist[xyz] = (float)Math.sqrt(ObjectProcessing.ftDistance(pt, ft[xyz]));
                    } else {
                        dist[xyz] = 0.0f;
                    }
                    z2 = (short)(z2 + 1);
                }
                y2 = (short)(y2 + 1);
            }
            x = (short)(x + 1);
        }
        boolean[] bg = new boolean[nx * ny * nz];
        short x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    int xyz = x2 + nx * y + nx * ny * z;
                    bg[xyz] = !obj[xyz];
                    z = (short)(z + 1);
                }
                y = (short)(y + 1);
            }
            x2 = (short)(x2 + 1);
        }
        ft = ObjectProcessing.voronoiFeatureTransform(bg, nx, ny, nz);
        x2 = 0;
        while (x2 < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    int xyz = x2 + nx * y + nx * ny * z;
                    if (bg[xyz] && ft[xyz][0] > -1) {
                        short[] pt = new short[]{x2, y, z};
                        dist[xyz] = -((float)Math.sqrt(ObjectProcessing.ftDistance(pt, ft[xyz])));
                    } else {
                        dist[xyz] = 0.0f;
                    }
                    z = (short)(z + 1);
                }
                y = (short)(y + 1);
            }
            x2 = (short)(x2 + 1);
        }
        ft = null;
        return dist;
    }

    public static final float hausdorffDistance(boolean[][][] obj1, boolean[][][] obj2, float rx, float ry, float rz, int nx, int ny, int nz) {
        float maxdist = 0.0f;
        ImageCropper crop = new ImageCropper(nx, ny, nz);
        crop.setBorderSize(1);
        crop.findCroppingBoundaries(obj1, obj2);
        obj1 = crop.cropImage(obj1);
        obj2 = crop.cropImage(obj2);
        nx = crop.mx();
        ny = crop.my();
        nz = crop.mz();
        if (ObjectProcessing.volume(obj1, nx, ny, nz) == 0 || ObjectProcessing.volume(obj2, nx, ny, nz) == 0) {
            return -1.0f;
        }
        boolean[][][] bound1 = ObjectProcessing.objectBoundary(obj1, nx, ny, nz);
        boolean[][][] bound2 = ObjectProcessing.objectBoundary(obj2, nx, ny, nz);
        float[][][] dist1 = ObjectProcessing.voronoiFeatureSquaredDistance(bound1, nx, ny, nz);
        float[][][] dist2 = ObjectProcessing.voronoiFeatureSquaredDistance(bound2, nx, ny, nz);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (bound1[x][y][z] && dist2[x][y][z] > maxdist) {
                        maxdist = dist2[x][y][z];
                    }
                    if (bound2[x][y][z] && dist1[x][y][z] > maxdist) {
                        maxdist = dist1[x][y][z];
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return (float)Math.sqrt(maxdist);
    }

    public static final float averageSurfaceDistance(boolean[][][] obj1, boolean[][][] obj2, float rx, float ry, float rz, int nx, int ny, int nz) {
        float avgdist = 0.0f;
        float avgnb = 0.0f;
        float minres = Numerics.min(Numerics.min(rx, ry), rz);
        ImageCropper crop = new ImageCropper(nx, ny, nz);
        crop.setBorderSize(1);
        crop.findCroppingBoundaries(obj1, obj2);
        obj1 = crop.cropImage(obj1);
        obj2 = crop.cropImage(obj2);
        nx = crop.mx();
        ny = crop.my();
        nz = crop.mz();
        if (ObjectProcessing.volume(obj1, nx, ny, nz) == 0 || ObjectProcessing.volume(obj2, nx, ny, nz) == 0) {
            return -1.0f;
        }
        boolean[][][] bound1 = ObjectProcessing.objectBoundary(obj1, nx, ny, nz);
        boolean[][][] bound2 = ObjectProcessing.objectBoundary(obj2, nx, ny, nz);
        float[][][] dist1 = ObjectProcessing.voronoiFeatureSquaredDistance(bound1, nx, ny, nz);
        float[][][] dist2 = ObjectProcessing.voronoiFeatureSquaredDistance(bound2, nx, ny, nz);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (bound1[x][y][z]) {
                        avgdist += (float)Math.sqrt(dist2[x][y][z]);
                        avgnb += 1.0f;
                    }
                    if (bound2[x][y][z]) {
                        avgdist += (float)Math.sqrt(dist1[x][y][z]);
                        avgnb += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return avgdist / avgnb;
    }

    public static final float averageSurfaceDifference(boolean[][][] obj1, boolean[][][] obj2, float rx, float ry, float rz, int nx, int ny, int nz) {
        float avgdist = 0.0f;
        float avgnb = 0.0f;
        float minres = Numerics.min(Numerics.min(rx, ry), rz);
        ImageCropper crop = new ImageCropper(nx, ny, nz);
        crop.setBorderSize(1);
        crop.findCroppingBoundaries(obj1, obj2);
        obj1 = crop.cropImage(obj1);
        obj2 = crop.cropImage(obj2);
        nx = crop.mx();
        ny = crop.my();
        nz = crop.mz();
        if (ObjectProcessing.volume(obj1, nx, ny, nz) == 0 || ObjectProcessing.volume(obj2, nx, ny, nz) == 0) {
            return -1.0f;
        }
        boolean[][][] bound1 = ObjectProcessing.objectBoundary(obj1, nx, ny, nz);
        boolean[][][] bound2 = ObjectProcessing.objectBoundary(obj2, nx, ny, nz);
        float[][][] dist1 = ObjectProcessing.voronoiFeatureSquaredDistance(bound1, nx, ny, nz);
        float[][][] dist2 = ObjectProcessing.voronoiFeatureSquaredDistance(bound2, nx, ny, nz);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (bound1[x][y][z]) {
                        if (obj2[x][y][z]) {
                            avgdist += (float)Math.sqrt(dist2[x][y][z]);
                            avgnb += 1.0f;
                        } else {
                            avgdist += -((float)Math.sqrt(dist2[x][y][z]));
                            avgnb += 1.0f;
                        }
                    }
                    if (bound2[x][y][z]) {
                        if (obj1[x][y][z]) {
                            avgdist += -((float)Math.sqrt(dist1[x][y][z]));
                            avgnb += 1.0f;
                        } else {
                            avgdist += (float)Math.sqrt(dist1[x][y][z]);
                            avgnb += 1.0f;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return avgdist / avgnb;
    }

    public static final float averageSquaredSurfaceDistance(boolean[][][] obj1, boolean[][][] obj2, float rx, float ry, float rz, int nx, int ny, int nz) {
        float avgdist = 0.0f;
        float avgnb = 0.0f;
        float minres = Numerics.min(Numerics.min(rx, ry), rz);
        ImageCropper crop = new ImageCropper(nx, ny, nz);
        crop.setBorderSize(1);
        crop.findCroppingBoundaries(obj1, obj2);
        obj1 = crop.cropImage(obj1);
        obj2 = crop.cropImage(obj2);
        nx = crop.mx();
        ny = crop.my();
        nz = crop.mz();
        if (ObjectProcessing.volume(obj1, nx, ny, nz) == 0 || ObjectProcessing.volume(obj2, nx, ny, nz) == 0) {
            return -1.0f;
        }
        boolean[][][] bound1 = ObjectProcessing.objectBoundary(obj1, nx, ny, nz);
        boolean[][][] bound2 = ObjectProcessing.objectBoundary(obj2, nx, ny, nz);
        float[][][] dist1 = ObjectProcessing.voronoiFeatureSquaredDistance(bound1, nx, ny, nz);
        float[][][] dist2 = ObjectProcessing.voronoiFeatureSquaredDistance(bound2, nx, ny, nz);
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (bound1[x][y][z]) {
                        avgdist += dist2[x][y][z];
                        avgnb += 1.0f;
                    }
                    if (bound2[x][y][z]) {
                        avgdist += dist1[x][y][z];
                        avgnb += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return (float)Math.sqrt(avgdist / avgnb);
    }

    private static final float convexityScore(boolean[][][] obj, int x, int y, int z) {
        float boundaries = 0.0f;
        if (obj[x - 1][y][z]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y][z]) {
            boundaries += 1.0f;
        }
        if (obj[x][y - 1][z]) {
            boundaries += 1.0f;
        }
        if (obj[x][y + 1][z]) {
            boundaries += 1.0f;
        }
        if (obj[x][y][z - 1]) {
            boundaries += 1.0f;
        }
        if (obj[x][y][z + 1]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y - 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z] && obj[x][y - 1][z]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y + 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z] && obj[x][y + 1][z]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y - 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z] && obj[x][y - 1][z]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y + 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z] && obj[x][y + 1][z]) {
            boundaries += 1.0f;
        }
        if (obj[x][y - 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y - 1][z] && obj[x][y][z - 1]) {
            boundaries += 1.0f;
        }
        if (obj[x][y - 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y - 1][z] && obj[x][y][z + 1]) {
            boundaries += 1.0f;
        }
        if (obj[x][y + 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y + 1][z] && obj[x][y][z - 1]) {
            boundaries += 1.0f;
        }
        if (obj[x][y + 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y + 1][z] && obj[x][y][z + 1]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y][z - 1] && obj[x - 1][y][z]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y][z - 1] && obj[x + 1][y][z]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y][z + 1] && obj[x - 1][y][z]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y][z + 1] && obj[x + 1][y][z]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y - 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y - 1][z] && obj[x][y - 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y - 1][z - 1] && obj[x - 1][y][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z - 1] && obj[x - 1][y - 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z] && obj[x][y - 1][z] && obj[x][y][z - 1]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y - 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y - 1][z] && obj[x][y - 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y - 1][z - 1] && obj[x + 1][y][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z - 1] && obj[x + 1][y - 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z] && obj[x][y - 1][z] && obj[x][y][z - 1]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y + 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y + 1][z] && obj[x][y + 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y + 1][z - 1] && obj[x - 1][y][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z - 1] && obj[x - 1][y + 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z] && obj[x][y + 1][z] && obj[x][y][z - 1]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y - 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y - 1][z] && obj[x][y - 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y - 1][z + 1] && obj[x - 1][y][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z + 1] && obj[x - 1][y - 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z] && obj[x][y - 1][z] && obj[x][y][z + 1]) {
            boundaries += 1.0f;
        }
        if (obj[x - 1][y + 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y + 1][z] && obj[x][y + 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y + 1][z + 1] && obj[x - 1][y][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z + 1] && obj[x - 1][y + 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x - 1][y][z] && obj[x][y + 1][z] && obj[x][y][z + 1]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y - 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y - 1][z] && obj[x][y - 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y - 1][z + 1] && obj[x + 1][y][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z + 1] && obj[x + 1][y - 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z] && obj[x][y - 1][z] && obj[x][y][z + 1]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y + 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y + 1][z] && obj[x][y + 1][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y + 1][z - 1] && obj[x + 1][y][z - 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z - 1] && obj[x + 1][y + 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z] && obj[x][y + 1][z] && obj[x][y][z - 1]) {
            boundaries += 1.0f;
        }
        if (obj[x + 1][y + 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y + 1][z] && obj[x][y + 1][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x][y + 1][z + 1] && obj[x + 1][y][z + 1]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z + 1] && obj[x + 1][y + 1][z]) {
            boundaries += 1.0f;
        } else if (obj[x + 1][y][z] && obj[x][y + 1][z] && obj[x][y][z + 1]) {
            boundaries += 1.0f;
        }
        return boundaries / 26.0f;
    }

    public static final float[][][] convexityMap(boolean[][][] img, int nx, int ny, int nz) {
        float[][][] score = new float[nx][ny][nz];
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    score[x][y][z] = ObjectProcessing.convexityScore(img, x, y, z);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return score;
    }

    public static final float meanConvexity(boolean[][][] img, int nx, int ny, int nz) {
        float score = 0.0f;
        int count = 0;
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    if (!img[x][y][z]) {
                        boolean boundary = false;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (img[x + i][y + j][z + l]) {
                                        boundary = true;
                                        break;
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (boundary) {
                            score += ObjectProcessing.convexityScore(img, x, y, z);
                            ++count;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return score / (float)count;
    }

    public static final float absConvexity(boolean[][][] img, int nx, int ny, int nz) {
        float score = 0.0f;
        int count = 0;
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    if (!img[x][y][z]) {
                        boolean boundary = false;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (img[x + i][y + j][z + l]) {
                                        boundary = true;
                                        break;
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (boundary) {
                            score += Numerics.abs(ObjectProcessing.convexityScore(img, x, y, z) - 0.5f);
                            ++count;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return score / (float)count;
    }

    public static final float stdConvexity(boolean[][][] img, float mean, int nx, int ny, int nz) {
        float score = 0.0f;
        int count = 0;
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    if (!img[x][y][z]) {
                        boolean boundary = false;
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (img[x + i][y + j][z + l]) {
                                        boundary = true;
                                        break;
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (boundary) {
                            score += (ObjectProcessing.convexityScore(img, x, y, z) - mean) * (ObjectProcessing.convexityScore(img, x, y, z) - mean);
                            ++count;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return (float)Math.sqrt(score / (float)(count - 1));
    }

    public static final float[] center(boolean[][][] img, int nx, int ny, int nz) {
        float[] center = new float[3];
        float count = 0.0f;
        int n = 0;
        while (n < 3) {
            center[n] = 0.0f;
            ++n;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        center[0] = center[0] + (float)x;
                        center[1] = center[1] + (float)y;
                        center[2] = center[2] + (float)z;
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 0.0f) {
            center[0] = center[0] / count;
            center[1] = center[1] / count;
            center[2] = center[2] / count;
        }
        return center;
    }

    public static final float[] center(int[][][] img, int lb, int nx, int ny, int nz) {
        float[] center = new float[3];
        float count = 0.0f;
        int n = 0;
        while (n < 3) {
            center[n] = 0.0f;
            ++n;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z] == lb) {
                        center[0] = center[0] + (float)x;
                        center[1] = center[1] + (float)y;
                        center[2] = center[2] + (float)z;
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 0.0f) {
            center[0] = center[0] / count;
            center[1] = center[1] / count;
            center[2] = center[2] / count;
        }
        return center;
    }

    public static final float[] center(float[][][] img, int nx, int ny, int nz) {
        float[] center = new float[3];
        float count = 0.0f;
        int n = 0;
        while (n < 3) {
            center[n] = 0.0f;
            ++n;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z] <= 0.0f) {
                        center[0] = center[0] + (float)x;
                        center[1] = center[1] + (float)y;
                        center[2] = center[2] + (float)z;
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 0.0f) {
            center[0] = center[0] / count;
            center[1] = center[1] / count;
            center[2] = center[2] / count;
        }
        return center;
    }

    public static final float[] center(int[] img, int lb, int nx, int ny, int nz) {
        float[] center = new float[3];
        float count = 0.0f;
        int ind = -1;
        int n = 0;
        while (n < 3) {
            center[n] = 0.0f;
            ++n;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    ind = x + y * nx + z * nx * ny;
                    if (img[ind] == lb) {
                        center[0] = center[0] + (float)x;
                        center[1] = center[1] + (float)y;
                        center[2] = center[2] + (float)z;
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 0.0f) {
            center[0] = center[0] / count;
            center[1] = center[1] / count;
            center[2] = center[2] / count;
        }
        return center;
    }

    public static final float[] center(byte[] img, int lb, int nx, int ny, int nz) {
        float[] center = new float[3];
        float count = 0.0f;
        int ind = -1;
        int n = 0;
        while (n < 3) {
            center[n] = 0.0f;
            ++n;
        }
        ind = 0;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[ind] == lb) {
                        center[0] = center[0] + (float)x;
                        center[1] = center[1] + (float)y;
                        center[2] = center[2] + (float)z;
                        count += 1.0f;
                    }
                    ++ind;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 0.0f) {
            center[0] = center[0] / count;
            center[1] = center[1] / count;
            center[2] = center[2] / count;
        }
        return center;
    }

    public static final float[] deviation(boolean[][][] img, float[] center, int nx, int ny, int nz) {
        float[] std = new float[3];
        float count = 0.0f;
        int n = 0;
        while (n < 3) {
            std[n] = 0.0f;
            ++n;
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        std[0] = std[0] + ((float)x - center[0]) * ((float)x - center[0]);
                        std[1] = std[1] + ((float)y - center[1]) * ((float)y - center[1]);
                        std[2] = std[2] + ((float)z - center[2]) * ((float)z - center[2]);
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 1.0f) {
            std[0] = (float)Math.sqrt(std[0] / (count - 1.0f));
            std[1] = (float)Math.sqrt(std[1] / (count - 1.0f));
            std[2] = (float)Math.sqrt(std[2] / (count - 1.0f));
        }
        return std;
    }

    public static final float meanDistance(boolean[][][] img, float x0, float y0, float z0, int nx, int ny, int nz, float rx, float ry, float rz) {
        float dist = 0.0f;
        float count = 0.0f;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        dist = (float)((double)dist + Math.sqrt(((float)x - x0) * rx * ((float)x - x0) * rx + ((float)y - y0) * ry * ((float)y - y0) * ry + ((float)z - z0) * rz * ((float)z - z0) * rz));
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 0.0f) {
            dist /= count;
        }
        return dist;
    }

    public static final float stdDistance(boolean[][][] img, float x0, float y0, float z0, float mean, int nx, int ny, int nz, float rx, float ry, float rz) {
        float var = 0.0f;
        float count = 0.0f;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        float dist = (float)Math.sqrt(((float)x - x0) * rx * ((float)x - x0) * rx + ((float)y - y0) * ry * ((float)y - y0) * ry + ((float)z - z0) * rz * ((float)z - z0) * rz);
                        var += (dist - mean) * (dist - mean);
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 1.0f) {
            var /= count - 1.0f;
        }
        return (float)Math.sqrt(var);
    }

    public static final float[] meanDirection(boolean[][][] img, float x0, float y0, float z0, int nx, int ny, int nz, float rx, float ry, float rz) {
        float[] dir = new float[3];
        int i = 0;
        while (i < 3) {
            dir[i] = 0.0f;
            ++i;
        }
        float count = 0.0f;
        float dist = 0.0f;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        dist = (float)Math.sqrt(((float)x - x0) * rx * ((float)x - x0) * rx + ((float)y - y0) * ry * ((float)y - y0) * ry + ((float)z - z0) * rz * ((float)z - z0) * rz);
                        dir[0] = dir[0] + ((float)x - x0) * rx / dist;
                        dir[1] = dir[1] + ((float)y - y0) * ry / dist;
                        dir[2] = dir[2] + ((float)z - z0) * rz / dist;
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 0.0f) {
            dist = (float)Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1] + dir[2] * dir[2]);
            int i2 = 0;
            while (i2 < 3) {
                dir[i2] = dir[i2] / dist;
                ++i2;
            }
        }
        return dir;
    }

    public static final float[] stdDirection(boolean[][][] img, float x0, float y0, float z0, float[] mean, int nx, int ny, int nz, float rx, float ry, float rz) {
        float[] var = new float[3];
        int i = 0;
        while (i < 3) {
            var[i] = 0.0f;
            ++i;
        }
        float count = 0.0f;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        float dist = (float)Math.sqrt(((float)x - x0) * rx * ((float)x - x0) * rx + ((float)y - y0) * ry * ((float)y - y0) * ry + ((float)z - z0) * rz * ((float)z - z0) * rz);
                        var[0] = var[0] + (((float)x - x0) * rx / dist - mean[0]) * (((float)x - x0) * rx / dist - mean[0]);
                        var[1] = var[1] + (((float)y - y0) * ry / dist - mean[1]) * (((float)y - y0) * ry / dist - mean[1]);
                        var[2] = var[2] + (((float)z - z0) * rz / dist - mean[2]) * (((float)z - z0) * rz / dist - mean[2]);
                        count += 1.0f;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (count > 1.0f) {
            int i2 = 0;
            while (i2 < 3) {
                var[i2] = (float)Math.sqrt(var[i2] / (count - 1.0f));
                ++i2;
            }
        }
        return var;
    }

    public static final float sharedBoundaryArea(float[][][] img, float id1, float id2, int nx, int ny, int nz, float rx, float ry, float rz) {
        float area = 0.0f;
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    if (img[x][y][z] == id1) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (i * i + j * j + l * l == 1 && img[x + i][y + j][z + l] == id2) {
                                        if (i * i == 1) {
                                            area += ry * rz;
                                        } else if (j * j == 1) {
                                            area += rz * rx;
                                        } else if (l * l == 1) {
                                            area += rx * ry;
                                        }
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return area;
    }

    public static final float sharedBoundaryArea(byte[][][] img, byte id1, byte id2, int nx, int ny, int nz, float rx, float ry, float rz) {
        float area = 0.0f;
        int x = 1;
        while (x < nx - 1) {
            int y = 1;
            while (y < ny - 1) {
                int z = 1;
                while (z < nz - 1) {
                    if (img[x][y][z] == id1) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (i * i + j * j + l * l == 1 && img[x + i][y + j][z + l] == id2) {
                                        if (i * i == 1) {
                                            area += ry * rz;
                                        } else if (j * j == 1) {
                                            area += rz * rx;
                                        } else if (l * l == 1) {
                                            area += rx * ry;
                                        }
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return area;
    }

    public static final float boundaryArea(boolean[][][] img, int nx, int ny, int nz, float rx, float ry, float rz) {
        float area = 0.0f;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    if (img[x][y][z]) {
                        int i = -1;
                        while (i <= 1) {
                            int j = -1;
                            while (j <= 1) {
                                int l = -1;
                                while (l <= 1) {
                                    if (i * i + j * j + l * l == 1 && x + i >= 0 && x + i < nx && y + j >= 0 && y + j < ny && z + l >= 0 && z + l < nz && !img[x + i][y + j][z + l]) {
                                        if (i * i == 1) {
                                            area += ry * rz;
                                        } else if (j * j == 1) {
                                            area += rz * rx;
                                        } else if (l * l == 1) {
                                            area += rx * ry;
                                        }
                                    }
                                    ++l;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return area;
    }

    public static enum Comparator {
        SUP,
        SUP_EQ,
        INF,
        INF_EQ;

    }
}

