/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.structures;

public class BinaryTree {
    private float[] tree;
    private int[][] index;
    private int N;
    private int Nc;
    private int Nmax;
    private int Nup;
    private int minormax;
    private static int memory;
    public static final int MAXTREE = 1;
    public static final int MINTREE = -1;
    public static final int FIXEDSIZE = 0;
    public static final int ADAPTATIVE = 1;

    public BinaryTree(int Nsize, int Ncoord, int type) {
        this.minormax = type;
        this.Nc = Ncoord;
        this.N = 0;
        this.Nmax = Nsize;
        this.Nup = Nsize;
        memory = 0;
        this.tree = new float[this.Nmax];
        this.index = new int[this.Nmax][Ncoord];
    }

    public BinaryTree(int Nsize, int Ncoord, int type, int mem) {
        this.minormax = type;
        this.Nc = Ncoord;
        this.N = 0;
        this.Nmax = Nsize;
        this.Nup = Nsize;
        memory = mem;
        this.tree = new float[this.Nmax];
        this.index = new int[this.Nmax][Ncoord];
    }

    public void finalize() {
        this.tree = null;
        this.index = null;
    }

    public final void reset() {
        this.N = 0;
    }

    public final void setMaxTree() {
        this.minormax = 1;
    }

    public final void setMinTree() {
        this.minormax = -1;
    }

    public final void addValue(float val, int[] x) {
        boolean stop = false;
        if (memory == 1 && this.N >= this.Nmax - 2) {
            int j;
            float[] tmp = new float[this.Nmax];
            int[][] ind = new int[this.Nmax][this.Nc];
            int i = 1;
            while (i <= this.N) {
                tmp[i] = this.tree[i];
                j = 0;
                while (j < this.Nc) {
                    ind[i][j] = this.index[i][j];
                    ++j;
                }
                ++i;
            }
            this.Nmax += this.Nup;
            this.tree = new float[this.Nmax];
            this.index = new int[this.Nmax][this.Nc];
            i = 1;
            while (i <= this.N) {
                this.tree[i] = tmp[i];
                j = 0;
                while (j < this.Nc) {
                    this.index[i][j] = ind[i][j];
                    ++j;
                }
                ++i;
            }
            tmp = null;
            ind = null;
        }
        int n = this.N + 1;
        int n2 = n / 2;
        if (this.minormax == -1) {
            while (!stop) {
                if (n2 > 0) {
                    if (val < this.tree[n2]) {
                        this.tree[n] = this.tree[n2];
                        int m = 0;
                        while (m < this.Nc) {
                            this.index[n][m] = this.index[n2][m];
                            ++m;
                        }
                        n = n2;
                        n2 = n / 2;
                        continue;
                    }
                    stop = true;
                    continue;
                }
                stop = true;
            }
        } else if (this.minormax == 1) {
            while (!stop) {
                if (n2 > 0) {
                    if (val > this.tree[n2]) {
                        this.tree[n] = this.tree[n2];
                        int m = 0;
                        while (m < this.Nc) {
                            this.index[n][m] = this.index[n2][m];
                            ++m;
                        }
                        n = n2;
                        n2 = n / 2;
                        continue;
                    }
                    stop = true;
                    continue;
                }
                stop = true;
            }
        }
        this.tree[n] = val;
        int m = 0;
        while (m < this.Nc) {
            this.index[n][m] = x[m];
            ++m;
        }
        ++this.N;
    }

    public final void removeFirst() {
        int[] x = new int[this.Nc];
        boolean stop = false;
        float val = this.tree[this.N];
        int m = 0;
        while (m < this.Nc) {
            x[m] = this.index[this.N][m];
            ++m;
        }
        int n = 1;
        int n2 = 2 * n;
        if (this.minormax == -1) {
            while (!stop) {
                if (n2 < this.N) {
                    if (n2 + 1 < this.N) {
                        if (val > this.tree[n2] || val > this.tree[n2 + 1]) {
                            if (this.tree[n2] > this.tree[n2 + 1]) {
                                this.tree[n] = this.tree[n2 + 1];
                                m = 0;
                                while (m < this.Nc) {
                                    this.index[n][m] = this.index[n2 + 1][m];
                                    ++m;
                                }
                                n = n2 + 1;
                                n2 = 2 * n;
                                continue;
                            }
                            this.tree[n] = this.tree[n2];
                            m = 0;
                            while (m < this.Nc) {
                                this.index[n][m] = this.index[n2][m];
                                ++m;
                            }
                            n = n2;
                            n2 = 2 * n;
                            continue;
                        }
                        stop = true;
                        continue;
                    }
                    if (val > this.tree[n2]) {
                        this.tree[n] = this.tree[n2];
                        m = 0;
                        while (m < this.Nc) {
                            this.index[n][m] = this.index[n2][m];
                            ++m;
                        }
                        n = n2;
                        stop = true;
                        continue;
                    }
                    stop = true;
                    continue;
                }
                stop = true;
            }
        } else if (this.minormax == 1) {
            while (!stop) {
                if (n2 < this.N) {
                    if (n2 + 1 < this.N) {
                        if (val < this.tree[n2] || val < this.tree[n2 + 1]) {
                            if (this.tree[n2] < this.tree[n2 + 1]) {
                                this.tree[n] = this.tree[n2 + 1];
                                m = 0;
                                while (m < this.Nc) {
                                    this.index[n][m] = this.index[n2 + 1][m];
                                    ++m;
                                }
                                n = n2 + 1;
                                n2 = 2 * n;
                                continue;
                            }
                            this.tree[n] = this.tree[n2];
                            m = 0;
                            while (m < this.Nc) {
                                this.index[n][m] = this.index[n2][m];
                                ++m;
                            }
                            n = n2;
                            n2 = 2 * n;
                            continue;
                        }
                        stop = true;
                        continue;
                    }
                    if (val < this.tree[n2]) {
                        this.tree[n] = this.tree[n2];
                        m = 0;
                        while (m < this.Nc) {
                            this.index[n][m] = this.index[n2][m];
                            ++m;
                        }
                        n = n2;
                        stop = true;
                        continue;
                    }
                    stop = true;
                    continue;
                }
                stop = true;
            }
        }
        this.tree[n] = val;
        m = 0;
        while (m < this.Nc) {
            this.index[n][m] = x[m];
            ++m;
        }
        --this.N;
    }

    public final float getFirst() {
        return this.tree[1];
    }

    public final int[] getFirstIndices() {
        return this.index[1];
    }

    public final int getFirstIndex(int m) {
        return this.index[1][m];
    }

    public final void print() {
        int n = 2;
        int i = 1;
        while (i <= this.N) {
            System.out.print("  " + (int)(100.0f * this.tree[i]));
            if (i % n == n - 1) {
                System.out.print("\n");
                n *= 2;
            }
            ++i;
        }
    }

    public final boolean isNotEmpty() {
        return this.N > 0;
    }

    public final boolean isBinaryTree() {
        boolean isBinary;
        block4: {
            block5: {
                isBinary = true;
                if (this.minormax != -1) break block5;
                int i = 2;
                while (i <= this.N) {
                    int n = i / 2;
                    if (this.tree[n] > this.tree[i]) {
                        isBinary = false;
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (this.minormax != 1) break block4;
            int i = 2;
            while (i <= this.N) {
                int n = i / 2;
                if (this.tree[n] < this.tree[i]) {
                    isBinary = false;
                    break;
                }
                ++i;
            }
        }
        return isBinary;
    }
}

