/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.structures;

import edu.jhmi.rad.medic.structures.GraphNode;
import java.util.Vector;

public class Graph {
    private Vector nodes = new Vector();
    private int Nn;
    private int Nloops;
    private int Nparts;
    public static final int NOTFOUND = -1;

    public Graph() {
        this.Nn = 0;
    }

    public Graph(GraphNode[] nod, int N) {
        int n = 0;
        while (n < N) {
            this.nodes.add(nod[n]);
            ++n;
        }
        this.Nn = N;
    }

    public void finalize() {
        this.nodes.clear();
        this.nodes = null;
        this.Nn = 0;
    }

    public final void addNode(GraphNode nod) {
        this.nodes.add(nod);
        ++this.Nn;
    }

    public final void setNodeAt(int indx, GraphNode nod) {
        this.nodes.set(indx, nod);
    }

    public final void addNode(int label) {
        GraphNode nod = new GraphNode(label);
        this.nodes.add(nod);
        ++this.Nn;
    }

    public final void removeNodeAt(int indx) {
        this.nodes.remove(indx);
        --this.Nn;
    }

    public final void removeNode(int label) {
        int n = 0;
        while (n < this.Nn) {
            if (((GraphNode)this.nodes.get(n)).equals(label)) {
                this.nodes.remove(n);
                break;
            }
            ++n;
        }
        --this.Nn;
    }

    public final GraphNode getNodeAt(int indx) {
        return (GraphNode)this.nodes.get(indx);
    }

    public final GraphNode getNode(int label) {
        int n = 0;
        while (n < this.Nn) {
            if (((GraphNode)this.nodes.get(n)).equals(label)) {
                return (GraphNode)this.nodes.get(n);
            }
            ++n;
        }
        return null;
    }

    public final int getNodeIndex(int label) {
        int n = 0;
        while (n < this.Nn) {
            if (((GraphNode)this.nodes.get(n)).equals(label)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final boolean containsNode(int label) {
        int n = 0;
        while (n < this.Nn) {
            if (((GraphNode)this.nodes.get(n)).equals(label)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final void addNodeLink(int indx1, int indx2) {
        GraphNode nod1 = this.getNodeAt(indx1);
        GraphNode nod2 = this.getNodeAt(indx2);
        nod1.addLinkTo(nod2.getLabel());
        nod2.addLinkTo(nod1.getLabel());
        this.setNodeAt(indx1, nod1);
        this.setNodeAt(indx2, nod2);
    }

    public final int getSize() {
        return this.Nn;
    }

    public final int getLoops() {
        return this.Nloops;
    }

    public final int getParts() {
        return this.Nparts;
    }

    public final String printGraph() {
        String message = new String("graph(" + this.Nn + ":\n");
        int n = 0;
        while (n < this.Nn) {
            message = message.concat("node " + n + ": ");
            message = message.concat(String.valueOf(this.getNodeAt(n).printNode()) + "\n");
            ++n;
        }
        return message;
    }

    public final int countSubGraphs() {
        boolean[] visited = new boolean[this.Nn];
        int n = 0;
        while (n < this.Nn) {
            visited[n] = false;
            ++n;
        }
        this.Nparts = 0;
        n = 0;
        while (n < this.Nn) {
            if (!visited[n]) {
                ++this.Nparts;
                this.visitGraph(n, visited);
            }
            ++n;
        }
        return this.Nparts;
    }

    private final void visitGraph(int indx, boolean[] visited) {
        visited[indx] = true;
        int n = 0;
        while (n < this.getNodeAt(indx).getLinkSize()) {
            int next = this.getNodeIndex(this.getNodeAt(indx).getLinkAt(n));
            if (!visited[next]) {
                this.visitGraph(next, visited);
            }
            ++n;
        }
    }

    public final int countLoopsAndSubGraphs() {
        boolean[] visited = new boolean[this.Nn];
        int n = 0;
        while (n < this.Nn) {
            visited[n] = false;
            ++n;
        }
        this.Nloops = 0;
        this.Nparts = 0;
        n = 0;
        while (n < this.Nn) {
            if (!visited[n]) {
                ++this.Nparts;
                this.loopedPath(n, -1, visited);
            }
            ++n;
        }
        return this.Nloops;
    }

    void loopedPath(int curr, int prec, boolean[] visited) {
        GraphNode nod = this.getNodeAt(curr);
        visited[curr] = true;
        int n = 0;
        while (n < nod.getLinkSize()) {
            int next = this.getNodeIndex(nod.getLinkAt(n));
            if (next != prec) {
                if (!visited[next]) {
                    this.loopedPath(next, curr, visited);
                } else {
                    ++this.Nloops;
                    GraphNode linked = this.getNodeAt(next);
                    linked.removeLinkTo(curr);
                    this.setNodeAt(next, linked);
                    nod.removeLinkAt(n);
                    this.setNodeAt(curr, nod);
                }
            }
            ++n;
        }
    }
}

