/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.utilities;

import edu.jhmi.rad.medic.utilities.Numerics;
import gov.nih.mipav.model.structures.ModelImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;

public class ImageCropper {
    private int nx;
    private int ny;
    private int nz;
    private int Nx;
    private int Ny;
    private int Nz;
    private int x0;
    private int xN;
    private int y0;
    private int yN;
    private int z0;
    private int zN;
    private int mx;
    private int my;
    private int mz;
    private int borderSize;
    private float maskingValue;
    private float maskingThreshold;
    private String maskingMode;
    private boolean verbose = true;
    private boolean debug = true;

    public ImageCropper(int nx_, int ny_, int nz_) {
        this.nx = nx_;
        this.ny = ny_;
        this.nz = nz_;
        this.x0 = 0;
        this.y0 = 0;
        this.z0 = 0;
        this.xN = this.nx - 1;
        this.yN = this.ny - 1;
        this.zN = this.nz - 1;
        this.borderSize = 0;
        this.Nx = this.nx;
        this.Ny = this.ny;
        this.Nz = this.nz;
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        this.maskingValue = 0.0f;
        this.maskingThreshold = 0.0f;
    }

    public int nx() {
        return this.nx;
    }

    public int ny() {
        return this.ny;
    }

    public int nz() {
        return this.nz;
    }

    public int Nx() {
        return this.Nx;
    }

    public int Ny() {
        return this.Ny;
    }

    public int Nz() {
        return this.Nz;
    }

    public int mx() {
        return this.mx;
    }

    public int my() {
        return this.my;
    }

    public int mz() {
        return this.mz;
    }

    public int border() {
        return this.borderSize;
    }

    public int[] getOriginalExtents() {
        int[] extent = new int[]{this.nx, this.ny, this.nz};
        return extent;
    }

    public int[] getOriginalExtents(int nt) {
        int[] extent = new int[]{this.nx, this.ny, this.nz, nt};
        return extent;
    }

    public int[] boundingBox() {
        int[] box = new int[]{this.x0, this.xN, this.y0, this.yN, this.z0, this.zN};
        return box;
    }

    public void setBoundingBox(int[] box) {
        this.x0 = box[0];
        this.xN = box[1];
        this.y0 = box[2];
        this.yN = box[3];
        this.z0 = box[4];
        this.zN = box[5];
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
    }

    public void setMaskingValue(float v) {
        this.maskingValue = v;
    }

    public void setBorderSize(int b) {
        this.borderSize = b;
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
    }

    public float[][][] convertArray(float[] image) {
        float[][][] tmp = new float[this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x][y][z] = image[x + this.nx * y + this.nx * this.ny * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static float[][][] convertArray(float[] image, int nx, int ny, int nz) {
        float[][][] tmp = new float[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    tmp[x][y][z] = image[x + nx * y + nx * ny * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static float[][][] convertArray(float[] image, int[] n) {
        float[][][] tmp = new float[n[0]][n[1]][n[2]];
        int x = 0;
        while (x < n[0]) {
            int y = 0;
            while (y < n[1]) {
                int z = 0;
                while (z < n[2]) {
                    tmp[x][y][z] = image[x + n[0] * y + n[0] * n[1] * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][][][] convertArray(float[] image, int nv) {
        float[][][][] tmp = new float[nv][this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    int v = 0;
                    while (v < nv) {
                        tmp[v][x][y][z] = image[x + this.nx * y + this.nx * this.ny * z + this.nx * this.ny * this.nz * v];
                        ++v;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][][] convertFloatImage(ModelImage image) {
        try {
            float[] buffer = new float[this.nx * this.ny * this.nz];
            image.exportData(0, this.nx * this.ny * this.nz, buffer);
            float[][][] tmp = new float[this.nx][this.ny][this.nz];
            int x = 0;
            while (x < this.nx) {
                int y = 0;
                while (y < this.ny) {
                    int z = 0;
                    while (z < this.nz) {
                        tmp[x][y][z] = buffer[x + this.nx * y + this.nx * this.ny * z];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return tmp;
        }
        catch (IOException error) {
            float[] buffer = null;
            return null;
        }
        catch (OutOfMemoryError e) {
            float[] buffer = null;
            return null;
        }
    }

    public float[][][][] convertFloatImage(ModelImage image, int nt) {
        try {
            float[] buffer = new float[this.nx * this.ny * this.nz * nt];
            image.exportData(0, this.nx * this.ny * this.nz * nt, buffer);
            float[][][][] tmp = new float[nt][this.nx][this.ny][this.nz];
            int t = 0;
            while (t < nt) {
                int x = 0;
                while (x < this.nx) {
                    int y = 0;
                    while (y < this.ny) {
                        int z = 0;
                        while (z < this.nz) {
                            tmp[t][x][y][z] = buffer[x + this.nx * y + this.nx * this.ny * z + this.nx * this.ny * this.nz * t];
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++t;
            }
            return tmp;
        }
        catch (IOException error) {
            float[] buffer = null;
            return null;
        }
        catch (OutOfMemoryError e) {
            float[] buffer = null;
            return null;
        }
    }

    public boolean[][][][] convertBooleanImage(ModelImage image, int nt) {
        try {
            BitSet buffer = new BitSet(this.nx * this.ny * this.nz * nt);
            image.exportData(0, this.nx * this.ny * this.nz * nt, buffer);
            boolean[][][][] tmp = new boolean[nt][this.nx][this.ny][this.nz];
            int t = 0;
            while (t < nt) {
                int x = 0;
                while (x < this.nx) {
                    int y = 0;
                    while (y < this.ny) {
                        int z = 0;
                        while (z < this.nz) {
                            tmp[t][x][y][z] = buffer.get(x + this.nx * y + this.nx * this.ny * z + this.nx * this.ny * this.nz * t);
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++t;
            }
            return tmp;
        }
        catch (IOException error) {
            Object buffer = null;
            return null;
        }
        catch (OutOfMemoryError e) {
            Object buffer = null;
            return null;
        }
    }

    public byte[][][] convertByteImage(ModelImage image) {
        try {
            byte[] buffer = new byte[this.nx * this.ny * this.nz];
            image.exportData(0, this.nx * this.ny * this.nz, buffer);
            byte[][][] tmp = new byte[this.nx][this.ny][this.nz];
            int x = 0;
            while (x < this.nx) {
                int y = 0;
                while (y < this.ny) {
                    int z = 0;
                    while (z < this.nz) {
                        tmp[x][y][z] = buffer[x + this.nx * y + this.nx * this.ny * z];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return tmp;
        }
        catch (IOException error) {
            byte[] buffer = null;
            return null;
        }
        catch (OutOfMemoryError e) {
            byte[] buffer = null;
            return null;
        }
    }

    public int[][][] convertIntImage(ModelImage image) {
        try {
            int[] buffer = new int[this.nx * this.ny * this.nz];
            image.exportData(0, this.nx * this.ny * this.nz, buffer);
            int[][][] tmp = new int[this.nx][this.ny][this.nz];
            int x = 0;
            while (x < this.nx) {
                int y = 0;
                while (y < this.ny) {
                    int z = 0;
                    while (z < this.nz) {
                        tmp[x][y][z] = buffer[x + this.nx * y + this.nx * this.ny * z];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return tmp;
        }
        catch (IOException error) {
            int[] buffer = null;
            return null;
        }
        catch (OutOfMemoryError e) {
            int[] buffer = null;
            return null;
        }
    }

    public float[] convertArray(float[][][] image) {
        float[] tmp = new float[this.nx * this.ny * this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x + this.nx * y + this.nx * this.ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static float[] convertArray(float[][][] image, int nx, int ny, int nz) {
        float[] tmp = new float[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    tmp[x + nx * y + nx * ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static float[] convertArray(float[][][] image, int[] n) {
        float[] tmp = new float[n[0] * n[1] * n[2]];
        int x = 0;
        while (x < n[0]) {
            int y = 0;
            while (y < n[1]) {
                int z = 0;
                while (z < n[2]) {
                    tmp[x + n[0] * y + n[0] * n[1] * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[] convertArray(float[][][][] image, int nv) {
        float[] tmp = new float[this.nx * this.ny * this.nz * nv];
        int v = 0;
        while (v < nv) {
            int x = 0;
            while (x < this.nx) {
                int y = 0;
                while (y < this.ny) {
                    int z = 0;
                    while (z < this.nz) {
                        tmp[x + this.nx * y + this.nx * this.ny * z + this.nx * this.ny * this.nz * v] = image[v][x][y][z];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return tmp;
    }

    public static float[] convertArrayVector(float[][][][] image, int[] n) {
        float[] tmp = new float[n[0] * n[1] * n[2] * n[3]];
        int x = 0;
        while (x < n[0]) {
            int y = 0;
            while (y < n[1]) {
                int z = 0;
                while (z < n[2]) {
                    int v = 0;
                    while (v < n[3]) {
                        tmp[x + n[0] * y + n[0] * n[1] * z + n[0] * n[1] * n[2] * v] = image[x][y][z][v];
                        ++v;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][] convertVectorArray(float[][][][] image, int nv) {
        float[][] tmp = new float[nv][this.nx * this.ny * this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    int v = 0;
                    while (v < nv) {
                        tmp[v][x + this.nx * y + this.nx * this.ny * z] = image[x][y][z][v];
                        ++v;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][] convertArrayVector(float[][][][] image, int nv) {
        float[][] tmp = new float[this.nx * this.ny * this.nz][nv];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    int v = 0;
                    while (v < nv) {
                        tmp[x + this.nx * y + this.nx * this.ny * z][v] = image[x][y][z][v];
                        ++v;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][] convertArrayVector(float[][][][][] image, int nv, int nw) {
        float[][] tmp = new float[this.nx * this.ny * this.nz][nv * nw];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    int v = 0;
                    while (v < nv) {
                        int w = 0;
                        while (w < nw) {
                            tmp[x + this.nx * y + this.nx * this.ny * z][v + nv * w] = image[x][y][z][v][w];
                            ++w;
                        }
                        ++v;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public byte[][][] convertArray(byte[] image) {
        byte[][][] tmp = new byte[this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x][y][z] = image[x + this.nx * y + this.nx * this.ny * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static byte[][][] convertArray(byte[] image, int[] n) {
        byte[][][] tmp = new byte[n[0]][n[1]][n[2]];
        int x = 0;
        while (x < n[0]) {
            int y = 0;
            while (y < n[1]) {
                int z = 0;
                while (z < n[2]) {
                    tmp[x][y][z] = image[x + n[0] * y + n[0] * n[1] * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public short[] convertArray(short[][][] image) {
        short[] tmp = new short[this.nx * this.ny * this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x + this.nx * y + this.nx * this.ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public byte[] convertArray(byte[][][] image) {
        byte[] tmp = new byte[this.nx * this.ny * this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x + this.nx * y + this.nx * this.ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public boolean[] convertArray(boolean[][][] image) {
        boolean[] tmp = new boolean[this.nx * this.ny * this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x + this.nx * y + this.nx * this.ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public boolean[] convertArray(boolean[][][][] image, int nv) {
        boolean[] tmp = new boolean[this.nx * this.ny * this.nz * nv];
        int v = 0;
        while (v < nv) {
            int x = 0;
            while (x < this.nx) {
                int y = 0;
                while (y < this.ny) {
                    int z = 0;
                    while (z < this.nz) {
                        tmp[x + this.nx * y + this.nx * this.ny * z + this.nx * this.ny * this.nz * v] = image[v][x][y][z];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return tmp;
    }

    public static boolean[] convertArray(boolean[][][] image, int nx, int ny, int nz) {
        boolean[] tmp = new boolean[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    tmp[x + nx * y + nx * ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static boolean[][][] convertArray(boolean[] image, int nx, int ny, int nz) {
        boolean[][][] tmp = new boolean[nx][ny][nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    tmp[x][y][z] = image[x + nx * y + nx * ny * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static byte[] convertArray(byte[][][] image, int nx, int ny, int nz) {
        byte[] tmp = new byte[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    tmp[x + nx * y + nx * ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static byte[] convertArray(byte[][][][] image, int nx, int ny, int nz, int nt) {
        byte[] tmp = new byte[nx * ny * nz * nt];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    int t = 0;
                    while (t < nt) {
                        tmp[x + nx * y + nx * ny * z + nx * ny * nz * t] = image[x][y][z][t];
                        ++t;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static short[] convertArray(short[][][] image, int nx, int ny, int nz) {
        short[] tmp = new short[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    tmp[x + nx * y + nx * ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static byte[] convertArray(byte[][][] image, int[] n) {
        byte[] tmp = new byte[n[0] * n[1] * n[2]];
        int x = 0;
        while (x < n[0]) {
            int y = 0;
            while (y < n[1]) {
                int z = 0;
                while (z < n[2]) {
                    tmp[x + n[0] * y + n[0] * n[1] * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public int[][][] convertArray(int[] image) {
        int[][][] tmp = new int[this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x][y][z] = image[x + this.nx * y + this.nx * this.ny * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public int[][][][] convertArray(int[] image, int nv) {
        int[][][][] tmp = new int[nv][this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    int v = 0;
                    while (v < nv) {
                        tmp[v][x][y][z] = image[x + this.nx * y + this.nx * this.ny * z + this.nx * this.ny * this.nz * v];
                        ++v;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public int[] convertArray(int[][][] image) {
        int[] tmp = new int[this.nx * this.ny * this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x + this.nx * y + this.nx * this.ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public static int[] convertArray(int[][][] image, int nx, int ny, int nz) {
        int[] tmp = new int[nx * ny * nz];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    tmp[x + nx * y + nx * ny * z] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][][] addBorder(float[][][] image, int border) {
        this.borderSize = border;
        this.Nx = this.nx + 2 * this.borderSize;
        this.Ny = this.ny + 2 * this.borderSize;
        this.Nz = this.nz + 2 * this.borderSize;
        float[][][] tmp = new float[this.Nx][this.Ny][this.Nz];
        int x = 0;
        while (x < this.Nx) {
            int y = 0;
            while (y < this.Ny) {
                int z = 0;
                while (z < this.Nz) {
                    tmp[x][y][z] = x < this.borderSize || x >= this.nx + this.borderSize || y < this.borderSize || y >= this.ny + this.borderSize || z < this.borderSize || z >= this.nz + this.borderSize ? this.maskingValue : image[x - this.borderSize][y - this.borderSize][z - this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][][][] addBorder(float[][][][] image, int nv, int border) {
        this.borderSize = border;
        this.Nx = this.nx + 2 * this.borderSize;
        this.Ny = this.ny + 2 * this.borderSize;
        this.Nz = this.nz + 2 * this.borderSize;
        float[][][][] tmp = new float[nv][this.Nx][this.Ny][this.Nz];
        int v = 0;
        while (v < nv) {
            int x = 0;
            while (x < this.Nx) {
                int y = 0;
                while (y < this.Ny) {
                    int z = 0;
                    while (z < this.Nz) {
                        tmp[v][x][y][z] = x < this.borderSize || x >= this.nx + this.borderSize || y < this.borderSize || y >= this.ny + this.borderSize || z < this.borderSize || z >= this.nz + this.borderSize ? this.maskingValue : image[v][x - this.borderSize][y - this.borderSize][z - this.borderSize];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return tmp;
    }

    public byte[][][] addBorder(byte[][][] image, int bgLabel, int border) {
        this.borderSize = border;
        this.Nx = this.nx + 2 * this.borderSize;
        this.Ny = this.ny + 2 * this.borderSize;
        this.Nz = this.nz + 2 * this.borderSize;
        byte[][][] tmp = new byte[this.Nx][this.Ny][this.Nz];
        int x = 0;
        while (x < this.Nx) {
            int y = 0;
            while (y < this.Ny) {
                int z = 0;
                while (z < this.Nz) {
                    tmp[x][y][z] = x < this.borderSize || x >= this.nx + this.borderSize || y < this.borderSize || y >= this.ny + this.borderSize || z < this.borderSize || z >= this.nz + this.borderSize ? (byte)bgLabel : image[x - this.borderSize][y - this.borderSize][z - this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public int[][][] addBorder(int[][][] image, int bgLabel, int border) {
        this.borderSize = border;
        this.Nx = this.nx + 2 * this.borderSize;
        this.Ny = this.ny + 2 * this.borderSize;
        this.Nz = this.nz + 2 * this.borderSize;
        int[][][] tmp = new int[this.Nx][this.Ny][this.Nz];
        int x = 0;
        while (x < this.Nx) {
            int y = 0;
            while (y < this.Ny) {
                int z = 0;
                while (z < this.Nz) {
                    tmp[x][y][z] = x < this.borderSize || x >= this.nx + this.borderSize || y < this.borderSize || y >= this.ny + this.borderSize || z < this.borderSize || z >= this.nz + this.borderSize ? bgLabel : image[x - this.borderSize][y - this.borderSize][z - this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][][] removeBorder(float[][][] image) {
        float[][][] tmp = new float[this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x][y][z] = image[x + this.borderSize][y + this.borderSize][z + this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][][][] removeBorder(float[][][][] image, int nv) {
        float[][][][] tmp = new float[nv][this.nx][this.ny][this.nz];
        int v = 0;
        while (v < nv) {
            int x = 0;
            while (x < this.nx) {
                int y = 0;
                while (y < this.ny) {
                    int z = 0;
                    while (z < this.nz) {
                        tmp[v][x][y][z] = image[v][x + this.borderSize][y + this.borderSize][z + this.borderSize];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return tmp;
    }

    public int[][][] removeBorder(int[][][] image) {
        int[][][] tmp = new int[this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x][y][z] = image[x + this.borderSize][y + this.borderSize][z + this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public byte[][][] removeBorder(byte[][][] image) {
        byte[][][] tmp = new byte[this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    tmp[x][y][z] = image[x + this.borderSize][y + this.borderSize][z + this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public float[][][] updateBorder(float[][][] image, int border, int prevBorder) {
        int borderDiff = border - prevBorder;
        this.borderSize = border;
        this.Nx = this.nx + 2 * this.borderSize;
        this.Ny = this.ny + 2 * this.borderSize;
        this.Nz = this.nz + 2 * this.borderSize;
        this.x0 += borderDiff;
        this.y0 += borderDiff;
        this.z0 += borderDiff;
        this.xN += borderDiff;
        this.yN += borderDiff;
        this.zN += borderDiff;
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        float[][][] tmp = new float[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            int y = 0;
            while (y < this.my) {
                int z = 0;
                while (z < this.mz) {
                    tmp[x][y][z] = borderDiff > 0 && (x < borderDiff || x >= this.mx - borderDiff || y < borderDiff || y >= this.my - borderDiff || z < borderDiff || z >= this.mz - borderDiff) ? this.maskingValue : image[x - borderDiff][y - borderDiff][z - borderDiff];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return tmp;
    }

    public void findCroppingBoundaries(boolean[][][] mask) {
        this.x0 = this.Nx;
        this.xN = 0;
        this.y0 = this.Ny;
        this.yN = 0;
        this.z0 = this.Nz;
        this.zN = 0;
        int x = this.borderSize;
        while (x < this.Nx - this.borderSize) {
            int y = this.borderSize;
            while (y < this.Ny - this.borderSize) {
                int z = this.borderSize;
                while (z < this.Nz - this.borderSize) {
                    if (mask[x][y][z]) {
                        if (x < this.x0) {
                            this.x0 = x;
                        }
                        if (x > this.xN) {
                            this.xN = x;
                        }
                        if (y < this.y0) {
                            this.y0 = y;
                        }
                        if (y > this.yN) {
                            this.yN = y;
                        }
                        if (z < this.z0) {
                            this.z0 = z;
                        }
                        if (z > this.zN) {
                            this.zN = z;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        if (this.debug) {
            System.out.print("boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n");
        }
    }

    public void findCroppingBoundaries(boolean[][][] mask1, boolean[][][] mask2) {
        this.x0 = this.Nx;
        this.xN = 0;
        this.y0 = this.Ny;
        this.yN = 0;
        this.z0 = this.Nz;
        this.zN = 0;
        int x = this.borderSize;
        while (x < this.Nx - this.borderSize) {
            int y = this.borderSize;
            while (y < this.Ny - this.borderSize) {
                int z = this.borderSize;
                while (z < this.Nz - this.borderSize) {
                    if (mask1[x][y][z] || mask2[x][y][z]) {
                        if (x < this.x0) {
                            this.x0 = x;
                        }
                        if (x > this.xN) {
                            this.xN = x;
                        }
                        if (y < this.y0) {
                            this.y0 = y;
                        }
                        if (y > this.yN) {
                            this.yN = y;
                        }
                        if (z < this.z0) {
                            this.z0 = z;
                        }
                        if (z > this.zN) {
                            this.zN = z;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        if (this.debug) {
            System.out.print("boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n");
        }
    }

    public void findCroppingBoundaries(float[][][] image, float val) {
        this.x0 = this.Nx;
        this.xN = 0;
        this.y0 = this.Ny;
        this.yN = 0;
        this.z0 = this.Nz;
        this.zN = 0;
        this.maskingThreshold = val;
        int x = this.borderSize;
        while (x < this.Nx - this.borderSize) {
            int y = this.borderSize;
            while (y < this.Ny - this.borderSize) {
                int z = this.borderSize;
                while (z < this.Nz - this.borderSize) {
                    if (image[x][y][z] > this.maskingThreshold) {
                        if (x < this.x0) {
                            this.x0 = x;
                        }
                        if (x > this.xN) {
                            this.xN = x;
                        }
                        if (y < this.y0) {
                            this.y0 = y;
                        }
                        if (y > this.yN) {
                            this.yN = y;
                        }
                        if (z < this.z0) {
                            this.z0 = z;
                        }
                        if (z > this.zN) {
                            this.zN = z;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        if (this.debug) {
            System.out.print("boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n");
        }
    }

    public void findCroppingBoundaries(float[] image, float val) {
        this.x0 = this.Nx;
        this.xN = 0;
        this.y0 = this.Ny;
        this.yN = 0;
        this.z0 = this.Nz;
        this.zN = 0;
        this.maskingThreshold = val;
        int x = this.borderSize;
        while (x < this.Nx - this.borderSize) {
            int y = this.borderSize;
            while (y < this.Ny - this.borderSize) {
                int z = this.borderSize;
                while (z < this.Nz - this.borderSize) {
                    int xyz = x + this.nx * y + this.nx * this.ny * z;
                    if (image[xyz] > this.maskingThreshold) {
                        if (x < this.x0) {
                            this.x0 = x;
                        }
                        if (x > this.xN) {
                            this.xN = x;
                        }
                        if (y < this.y0) {
                            this.y0 = y;
                        }
                        if (y > this.yN) {
                            this.yN = y;
                        }
                        if (z < this.z0) {
                            this.z0 = z;
                        }
                        if (z > this.zN) {
                            this.zN = z;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        if (this.debug) {
            System.out.print("boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n");
        }
    }

    public void findCroppingBoundaries(float[][][][] image, float val, int nt) {
        this.x0 = this.Nx;
        this.xN = 0;
        this.y0 = this.Ny;
        this.yN = 0;
        this.z0 = this.Nz;
        this.zN = 0;
        this.maskingThreshold = val;
        int t = 0;
        while (t < nt) {
            int x = this.borderSize;
            while (x < this.Nx - this.borderSize) {
                int y = this.borderSize;
                while (y < this.Ny - this.borderSize) {
                    int z = this.borderSize;
                    while (z < this.Nz - this.borderSize) {
                        if (image[t][x][y][z] > this.maskingThreshold) {
                            if (x < this.x0) {
                                this.x0 = x;
                            }
                            if (x > this.xN) {
                                this.xN = x;
                            }
                            if (y < this.y0) {
                                this.y0 = y;
                            }
                            if (y > this.yN) {
                                this.yN = y;
                            }
                            if (z < this.z0) {
                                this.z0 = z;
                            }
                            if (z > this.zN) {
                                this.zN = z;
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++t;
        }
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        if (this.debug) {
            System.out.print("boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n");
        }
    }

    public void findCroppingBoundaries(byte[][][] label, int bgLabel) {
        this.x0 = this.Nx;
        this.xN = 0;
        this.y0 = this.Ny;
        this.yN = 0;
        this.z0 = this.Nz;
        this.zN = 0;
        int x = this.borderSize;
        while (x < this.Nx - this.borderSize) {
            int y = this.borderSize;
            while (y < this.Ny - this.borderSize) {
                int z = this.borderSize;
                while (z < this.Nz - this.borderSize) {
                    if (label[x][y][z] > bgLabel) {
                        if (x < this.x0) {
                            this.x0 = x;
                        }
                        if (x > this.xN) {
                            this.xN = x;
                        }
                        if (y < this.y0) {
                            this.y0 = y;
                        }
                        if (y > this.yN) {
                            this.yN = y;
                        }
                        if (z < this.z0) {
                            this.z0 = z;
                        }
                        if (z > this.zN) {
                            this.zN = z;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        if (this.debug) {
            System.out.print("boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n");
        }
    }

    public int[] updateOriginalBoundaries() {
        int offset;
        if (this.debug) {
            System.out.print("boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n");
        }
        if (this.x0 < this.borderSize) {
            offset = this.borderSize - this.x0;
            if (this.debug) {
                System.out.println("x0 +" + offset + "\n");
            }
            this.nx += offset;
            this.Nx += offset;
            this.x0 += offset;
            this.xN += offset;
        }
        if (this.xN >= this.Nx - this.borderSize) {
            offset = this.xN - this.Nx + this.borderSize;
            if (this.debug) {
                System.out.println("xN +" + offset + "\n");
            }
            this.nx += offset;
            this.Nx += offset;
        }
        if (this.y0 < this.borderSize) {
            offset = this.borderSize - this.y0;
            if (this.debug) {
                System.out.println("y0 +" + offset + "\n");
            }
            this.ny += offset;
            this.Ny += offset;
            this.y0 += offset;
            this.yN += offset;
        }
        if (this.yN >= this.Ny - this.borderSize) {
            offset = this.yN - this.Ny + this.borderSize;
            if (this.debug) {
                System.out.println("yN +" + offset + "\n");
            }
            this.ny += offset;
            this.Ny += offset;
        }
        if (this.z0 < this.borderSize) {
            offset = this.borderSize - this.z0;
            if (this.debug) {
                System.out.println("z0 +" + offset + "\n");
            }
            this.nz += offset;
            this.Nz += offset;
            this.z0 += offset;
            this.zN += offset;
        }
        if (this.zN >= this.Nz - this.borderSize) {
            offset = this.zN - this.Nz + this.borderSize;
            if (this.debug) {
                System.out.println("zN +" + offset + "\n");
            }
            this.nz += offset;
            this.Nz += offset;
        }
        if (this.debug) {
            System.out.print("new dimensions: [" + this.nx + "," + this.ny + "," + this.nz + "]\n");
        }
        int[] dim = new int[]{this.nx, this.ny, this.nz};
        return dim;
    }

    public String displayOriginalBoundaryUpdate() {
        int offset;
        String info = "boundary update: \n";
        if (this.x0 < this.borderSize) {
            offset = this.borderSize - this.x0;
            info = String.valueOf(info) + "x0 +" + offset + "\n";
        }
        if (this.xN >= this.Nx - this.borderSize) {
            offset = this.xN - this.Nx + this.borderSize;
            info = String.valueOf(info) + "xN +" + offset + "\n";
        }
        if (this.y0 < this.borderSize) {
            offset = this.borderSize - this.y0;
            info = String.valueOf(info) + "y0 +" + offset + "\n";
        }
        if (this.yN >= this.Ny - this.borderSize) {
            offset = this.yN - this.Ny + this.borderSize;
            info = String.valueOf(info) + "yN +" + offset + "\n";
        }
        if (this.z0 < this.borderSize) {
            offset = this.borderSize - this.z0;
            info = String.valueOf(info) + "z0 +" + offset + "\n";
        }
        if (this.zN >= this.Nz - this.borderSize) {
            offset = this.zN - this.Nz + this.borderSize;
            info = String.valueOf(info) + "zN +" + offset + "\n";
        }
        return info;
    }

    public boolean[][][] createMask(float[][][] image, float val) {
        int z;
        int y;
        this.maskingThreshold = val;
        boolean[][][] mask = new boolean[this.nx][this.ny][this.nz];
        int x = this.borderSize;
        while (x < this.Nx - this.borderSize) {
            y = this.borderSize;
            while (y < this.Ny - this.borderSize) {
                z = this.borderSize;
                while (z < this.Nz - this.borderSize) {
                    mask[x][y][z] = !(image[x][y][z] <= this.maskingThreshold);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.Nx) {
            y = 0;
            while (y < this.Ny) {
                int i = 0;
                while (i < this.borderSize) {
                    mask[x][y][i] = false;
                    mask[x][y][this.Nz - i] = false;
                    ++i;
                }
                ++y;
            }
            ++x;
        }
        int i = 0;
        while (i < this.borderSize) {
            y = 0;
            while (y < this.Ny) {
                z = 0;
                while (z < this.Nz) {
                    mask[i][y][z] = false;
                    mask[this.Nx - i][y][z] = false;
                    ++z;
                }
                ++y;
            }
            ++i;
        }
        x = 0;
        while (x < this.Nx) {
            int i2 = 0;
            while (i2 < this.borderSize) {
                z = 0;
                while (z < this.Nz) {
                    mask[x][i2][z] = false;
                    mask[x][this.Ny - i2][z] = false;
                    ++z;
                }
                ++i2;
            }
            ++x;
        }
        return mask;
    }

    public float[][][] cropImage(float[][][] image) {
        int z;
        int y;
        float[][][] smaller = new float[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    smaller[x][y][z] = this.maskingValue;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public float[] cropImage(float[] image) {
        float[] smaller = new float[this.mx * this.my * this.mz];
        int xyz = 0;
        while (xyz < this.mx * this.my * this.mz) {
            smaller[xyz] = this.maskingValue;
            ++xyz;
        }
        int x = this.x0;
        while (x <= this.xN) {
            int y = this.y0;
            while (y <= this.yN) {
                int z = this.z0;
                while (z <= this.zN) {
                    smaller[x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize)] = image[x + this.nx * y + this.nx * this.ny * z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public float[] cropImage(float[] image, int nv) {
        int n;
        int z;
        int y;
        float[] smaller = new float[this.mx * this.my * this.mz * nv];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    n = 0;
                    while (n < nv) {
                        smaller[x + this.mx * y + this.mx * this.my * z + this.mx * this.my * this.mz * n] = this.maskingValue;
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    n = 0;
                    while (n < nv) {
                        smaller[x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize) + this.mx * this.my * this.mz * n] = image[x + this.nx * y + this.nx * this.ny * z + this.nx * this.ny * this.nz * n];
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public float[][] cropImage(float[][] image, int nv) {
        int n;
        int z;
        int y;
        float[][] smaller = new float[nv][this.mx * this.my * this.mz];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    n = 0;
                    while (n < nv) {
                        smaller[n][x + this.mx * y + this.mx * this.my * z] = this.maskingValue;
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    n = 0;
                    while (n < nv) {
                        smaller[n][x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize)] = image[n][x + this.nx * y + this.nx * this.ny * z];
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public int[][][] cropImage(int[][][] image, int bgLabel) {
        int z;
        int y;
        int[][][] smaller = new int[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    smaller[x][y][z] = bgLabel;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public short[][][] cropImage(short[][][] image) {
        int z;
        int y;
        short[][][] smaller = new short[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    smaller[x][y][z] = (short)this.maskingValue;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public byte[][][] cropImage(byte[][][] image) {
        int z;
        int y;
        byte[][][] smaller = new byte[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    smaller[x][y][z] = (byte)this.maskingValue;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public byte[][][] cropImage(byte[][][] image, int bgLabel) {
        int z;
        int y;
        byte[][][] smaller = new byte[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    smaller[x][y][z] = (byte)bgLabel;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public boolean[][][] cropImage(boolean[][][] image) {
        int z;
        int y;
        boolean[][][] smaller = new boolean[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    smaller[x][y][z] = false;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize] = image[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public float[][][][] cropImage(float[][][][] image, int nv) {
        int n;
        int z;
        int y;
        float[][][][] smaller = new float[this.mx][this.my][this.mz][nv];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    n = 0;
                    while (n < nv) {
                        smaller[x][y][z][n] = this.maskingValue;
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    n = 0;
                    while (n < nv) {
                        smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize][n] = image[x][y][z][n];
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public float[][][][][] cropImage(float[][][][][] image, int nv, int nw) {
        int w;
        int n;
        int z;
        int y;
        float[][][][][] smaller = new float[this.mx][this.my][this.mz][nv][nw];
        int x = 0;
        while (x < this.mx) {
            y = 0;
            while (y < this.my) {
                z = 0;
                while (z < this.mz) {
                    n = 0;
                    while (n < nv) {
                        w = 0;
                        while (w < nw) {
                            smaller[x][y][z][n][w] = this.maskingValue;
                            ++w;
                        }
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = this.x0;
        while (x <= this.xN) {
            y = this.y0;
            while (y <= this.yN) {
                z = this.z0;
                while (z <= this.zN) {
                    n = 0;
                    while (n < nv) {
                        w = 0;
                        while (w < nw) {
                            smaller[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize][n][w] = image[x][y][z][n][w];
                            ++w;
                        }
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return smaller;
    }

    public float[][][] updateCroppedImage(float[][][] image, int[] box, int[] diff) {
        this.x0 = box[0] - diff[0];
        this.xN = box[1] + diff[1];
        this.y0 = box[2] - diff[2];
        this.yN = box[3] + diff[3];
        this.z0 = box[4] - diff[4];
        this.zN = box[5] + diff[5];
        this.mx = this.xN - this.x0 + 1 + 2 * this.borderSize;
        this.my = this.yN - this.y0 + 1 + 2 * this.borderSize;
        this.mz = this.zN - this.z0 + 1 + 2 * this.borderSize;
        float[][][] recropped = new float[this.mx][this.my][this.mz];
        int x = 0;
        while (x < this.mx) {
            int y = 0;
            while (y < this.my) {
                int z = 0;
                while (z < this.mz) {
                    recropped[x][y][z] = x < diff[0] + this.borderSize || x >= this.mx - diff[1] - this.borderSize || y < diff[2] + this.borderSize || y >= this.my - diff[3] - this.borderSize || z < diff[4] + this.borderSize || z >= this.mz - diff[5] - this.borderSize ? this.maskingValue : image[x - diff[0]][y - diff[2]][z - diff[4]];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return recropped;
    }

    public float[][][] uncropImage(float[][][] image) {
        int z;
        int y;
        float[][][] larger = new float[this.Nx][this.Ny][this.Nz];
        int x = 0;
        while (x < this.Nx) {
            y = 0;
            while (y < this.Ny) {
                z = 0;
                while (z < this.Nz) {
                    larger[x][y][z] = this.maskingValue;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = Numerics.max(this.x0 - this.borderSize, 0);
        while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
            y = Numerics.max(this.y0 - this.borderSize, 0);
            while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                z = Numerics.max(this.z0 - this.borderSize, 0);
                while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                    larger[x][y][z] = image[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return larger;
    }

    public float[] uncropImage(float[] image) {
        float[] larger = new float[this.Nx * this.Ny * this.Nz];
        int xyz = 0;
        while (xyz < this.Nx * this.Ny * this.Nz) {
            larger[xyz] = this.maskingValue;
            ++xyz;
        }
        int x = Numerics.max(this.x0 - this.borderSize, 0);
        while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
            int y = Numerics.max(this.y0 - this.borderSize, 0);
            while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                int z = Numerics.max(this.z0 - this.borderSize, 0);
                while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                    larger[x + this.Nx * y + this.Nx * this.Ny * z] = image[x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize)];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return larger;
    }

    public byte[] uncropImage(byte[] image) {
        byte[] larger = new byte[this.Nx * this.Ny * this.Nz];
        int xyz = 0;
        while (xyz < this.Nx * this.Ny * this.Nz) {
            larger[xyz] = (byte)this.maskingValue;
            ++xyz;
        }
        int x = Numerics.max(this.x0 - this.borderSize, 0);
        while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
            int y = Numerics.max(this.y0 - this.borderSize, 0);
            while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                int z = Numerics.max(this.z0 - this.borderSize, 0);
                while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                    larger[x + this.Nx * y + this.Nx * this.Ny * z] = image[x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize)];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return larger;
    }

    public float[][][][] uncropImage(float[][][][] image, int nv) {
        int z;
        int y;
        int x;
        float[][][][] larger = new float[nv][this.Nx][this.Ny][this.Nz];
        int v = 0;
        while (v < nv) {
            x = 0;
            while (x < this.Nx) {
                y = 0;
                while (y < this.Ny) {
                    z = 0;
                    while (z < this.Nz) {
                        larger[v][x][y][z] = this.maskingValue;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        v = 0;
        while (v < nv) {
            x = Numerics.max(this.x0 - this.borderSize, 0);
            while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
                y = Numerics.max(this.y0 - this.borderSize, 0);
                while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                    z = Numerics.max(this.z0 - this.borderSize, 0);
                    while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                        larger[v][x][y][z] = image[v][x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return larger;
    }

    public float[][] uncropImage(float[][] image, int nv) {
        float[][] larger = new float[nv][this.Nx * this.Ny * this.Nz];
        int v = 0;
        while (v < nv) {
            int xyz = 0;
            while (xyz < this.Nx * this.Ny * this.Nz) {
                larger[v][xyz] = this.maskingValue;
                ++xyz;
            }
            ++v;
        }
        v = 0;
        while (v < nv) {
            int x = Numerics.max(this.x0 - this.borderSize, 0);
            while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
                int y = Numerics.max(this.y0 - this.borderSize, 0);
                while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                    int z = Numerics.max(this.z0 - this.borderSize, 0);
                    while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                        larger[v][x + this.Nx * y + this.Nx * this.Ny * z] = image[v][x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize)];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return larger;
    }

    public float[] uncropImage(float[] image, int nv) {
        float[] larger = new float[nv * this.Nx * this.Ny * this.Nz];
        int v = 0;
        while (v < nv) {
            int xyz = 0;
            while (xyz < this.Nx * this.Ny * this.Nz) {
                larger[xyz + this.Nx * this.Ny * this.Nz * v] = this.maskingValue;
                ++xyz;
            }
            ++v;
        }
        v = 0;
        while (v < nv) {
            int x = Numerics.max(this.x0 - this.borderSize, 0);
            while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
                int y = Numerics.max(this.y0 - this.borderSize, 0);
                while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                    int z = Numerics.max(this.z0 - this.borderSize, 0);
                    while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                        larger[x + this.Nx * y + this.Nx * this.Ny * z + this.Nx * this.Ny * this.Nz * v] = image[x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize) + this.mx * this.my * this.mz * v];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return larger;
    }

    public byte[][][] uncropImage(byte[][][] image) {
        int z;
        int y;
        byte[][][] larger = new byte[this.Nx][this.Ny][this.Nz];
        int x = 0;
        while (x < this.Nx) {
            y = 0;
            while (y < this.Ny) {
                z = 0;
                while (z < this.Nz) {
                    larger[x][y][z] = (byte)this.maskingValue;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = Numerics.max(this.x0 - this.borderSize, 0);
        while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
            y = Numerics.max(this.y0 - this.borderSize, 0);
            while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                z = Numerics.max(this.z0 - this.borderSize, 0);
                while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                    larger[x][y][z] = image[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return larger;
    }

    public int[][][] uncropImage(int[][][] image, int bgValue) {
        int z;
        int y;
        int[][][] larger = new int[this.Nx][this.Ny][this.Nz];
        int x = 0;
        while (x < this.Nx) {
            y = 0;
            while (y < this.Ny) {
                z = 0;
                while (z < this.Nz) {
                    larger[x][y][z] = bgValue;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = Numerics.max(this.x0 - this.borderSize, 0);
        while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
            y = Numerics.max(this.y0 - this.borderSize, 0);
            while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                z = Numerics.max(this.z0 - this.borderSize, 0);
                while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                    larger[x][y][z] = image[x - this.x0 + this.borderSize][y - this.y0 + this.borderSize][z - this.z0 + this.borderSize];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return larger;
    }

    public int[][][] uncropImage(int[][][] image) {
        return this.uncropImage(image, 0);
    }

    public float[] uncropAndBuffer(float[][] image, int nv) {
        float[] larger = new float[nv * this.Nx * this.Ny * this.Nz];
        int xyz = 0;
        while (xyz < nv * this.Nx * this.Ny * this.Nz) {
            larger[xyz] = this.maskingValue;
            ++xyz;
        }
        int v = 0;
        while (v < nv) {
            int x = Numerics.max(this.x0 - this.borderSize, 0);
            while (x <= Numerics.min(this.xN + this.borderSize, this.Nx - 1)) {
                int y = Numerics.max(this.y0 - this.borderSize, 0);
                while (y <= Numerics.min(this.yN + this.borderSize, this.Ny - 1)) {
                    int z = Numerics.max(this.z0 - this.borderSize, 0);
                    while (z <= Numerics.min(this.zN + this.borderSize, this.Nz - 1)) {
                        larger[x + this.Nx * y + this.Nx * this.Ny * z + this.Nx * this.Ny * this.Nz * v] = image[v][x - this.x0 + this.borderSize + this.mx * (y - this.y0 + this.borderSize) + this.mx * this.my * (z - this.z0 + this.borderSize)];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++v;
        }
        return larger;
    }

    public double[][] uncropTransformMatrix(double[][] mat) {
        double[][] larger = new double[4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                larger[i][j] = mat[i][j];
                ++j;
            }
            ++i;
        }
        double[] dArray = larger[0];
        dArray[3] = dArray[3] + ((double)(this.x0 - this.borderSize) - mat[0][0] * (double)(this.x0 - this.borderSize) - mat[0][1] * (double)(this.y0 - this.borderSize) - mat[0][2] * (double)(this.z0 - this.borderSize));
        double[] dArray2 = larger[1];
        dArray2[3] = dArray2[3] + ((double)(this.y0 - this.borderSize) - mat[1][0] * (double)(this.x0 - this.borderSize) - mat[1][1] * (double)(this.y0 - this.borderSize) - mat[1][2] * (double)(this.z0 - this.borderSize));
        double[] dArray3 = larger[2];
        dArray3[3] = dArray3[3] + ((double)(this.z0 - this.borderSize) - mat[2][0] * (double)(this.x0 - this.borderSize) - mat[2][1] * (double)(this.y0 - this.borderSize) - mat[2][2] * (double)(this.z0 - this.borderSize));
        return larger;
    }

    public double[][] uncropTransformMatrix(float[][] mat) {
        double[][] larger = new double[4][4];
        if (mat.length == 3) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 4) {
                    larger[i][j] = mat[i][j];
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < 3) {
                larger[3][j] = 0.0;
                ++j;
            }
            larger[3][3] = 1.0;
        } else {
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 4) {
                    larger[i][j] = mat[i][j];
                    ++j;
                }
                ++i;
            }
        }
        double[] dArray = larger[0];
        dArray[3] = dArray[3] + (double)((float)(this.x0 - this.borderSize) - mat[0][0] * (float)(this.x0 - this.borderSize) - mat[0][1] * (float)(this.y0 - this.borderSize) - mat[0][2] * (float)(this.z0 - this.borderSize));
        double[] dArray2 = larger[1];
        dArray2[3] = dArray2[3] + (double)((float)(this.y0 - this.borderSize) - mat[1][0] * (float)(this.x0 - this.borderSize) - mat[1][1] * (float)(this.y0 - this.borderSize) - mat[1][2] * (float)(this.z0 - this.borderSize));
        double[] dArray3 = larger[2];
        dArray3[3] = dArray3[3] + (double)((float)(this.z0 - this.borderSize) - mat[2][0] * (float)(this.x0 - this.borderSize) - mat[2][1] * (float)(this.y0 - this.borderSize) - mat[2][2] * (float)(this.z0 - this.borderSize));
        return larger;
    }

    public double[][] uncropTransformMatrix(double[][] mat, float rx, float ry, float rz) {
        double[][] larger = new double[4][4];
        if (mat.length == 3) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 4) {
                    larger[i][j] = mat[i][j];
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < 3) {
                larger[3][j] = 0.0;
                ++j;
            }
            larger[3][3] = 1.0;
        } else {
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 4) {
                    larger[i][j] = mat[i][j];
                    ++j;
                }
                ++i;
            }
        }
        double[] dArray = larger[0];
        dArray[3] = dArray[3] + ((double)((float)(this.x0 - this.borderSize) * rx) - mat[0][0] * (double)(this.x0 - this.borderSize) * (double)rx - mat[0][1] * (double)(this.y0 - this.borderSize) * (double)ry - mat[0][2] * (double)(this.z0 - this.borderSize) * (double)rz);
        double[] dArray2 = larger[1];
        dArray2[3] = dArray2[3] + ((double)((float)(this.y0 - this.borderSize) * ry) - mat[1][0] * (double)(this.x0 - this.borderSize) * (double)rx - mat[1][1] * (double)(this.y0 - this.borderSize) * (double)ry - mat[1][2] * (double)(this.z0 - this.borderSize) * (double)rz);
        double[] dArray3 = larger[2];
        dArray3[3] = dArray3[3] + ((double)((float)(this.z0 - this.borderSize) * rz) - mat[2][0] * (double)(this.x0 - this.borderSize) * (double)rx - mat[2][1] * (double)(this.y0 - this.borderSize) * (double)ry - mat[2][2] * (double)(this.z0 - this.borderSize) * (double)rz);
        return larger;
    }

    public String displayParameters() {
        String line = "cropping parameters: \n";
        line = String.valueOf(line) + "original size: [" + this.nx + "," + this.ny + "," + this.nz + "]\n";
        line = String.valueOf(line) + "border: " + this.borderSize + "\n";
        line = String.valueOf(line) + "extended size: [" + this.Nx + "," + this.Ny + "," + this.Nz + "]\n";
        line = String.valueOf(line) + "boundaries: [" + this.x0 + "," + this.xN + "] [" + this.y0 + "," + this.yN + "] [" + this.z0 + "," + this.zN + "]\n";
        line = String.valueOf(line) + "cropped size: [" + this.mx + "," + this.my + "," + this.mz + "]\n";
        return line;
    }

    public final int[][] mapColorsToLabels(int[] buffer) {
        ArrayList<int[]> map = new ArrayList<int[]>();
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    int[] color = new int[]{buffer[0 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z], buffer[1 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z], buffer[2 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z], buffer[3 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z]};
                    boolean isFound = false;
                    int n = 0;
                    while (n < map.size()) {
                        if (color[0] == ((int[])map.get(n))[0] && color[1] == ((int[])map.get(n))[1] && color[2] == ((int[])map.get(n))[2] && color[3] == ((int[])map.get(n))[3]) {
                            isFound = true;
                        }
                        ++n;
                    }
                    if (!isFound) {
                        map.add(color);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int[][] finalmap = new int[map.size()][4];
        int n = 0;
        while (n < map.size()) {
            int i = 0;
            while (i < 4) {
                finalmap[n][i] = ((int[])map.get(n))[i];
                ++i;
            }
            ++n;
        }
        return finalmap;
    }

    public final int[][][] convertColorToLabelImage(int[] buffer, int[][] map) {
        int[][][] img = new int[this.nx][this.ny][this.nz];
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                int z = 0;
                while (z < this.nz) {
                    img[x][y][z] = 0;
                    int[] color = new int[]{buffer[0 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z], buffer[1 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z], buffer[2 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z], buffer[3 + 4 * x + 4 * this.nx * y + 4 * this.nx * this.ny * z]};
                    int n = 0;
                    while (n < map.length) {
                        if (color[0] == map[n][0] && color[1] == map[n][1] && color[2] == map[n][2] && color[3] == map[n][3]) {
                            img[x][y][z] = n + 1;
                        }
                        ++n;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return img;
    }
}

