/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.utilities;

public class Numerics {
    public static final float ZERO = 1.0E-30f;
    public static final float INF = 1.0E30f;
    public static final float PI = 3.1416f;

    public static final double randomGaussian() {
        double v2;
        double v1;
        double rsq;
        while ((rsq = (v1 = 2.0 * Math.random() - 1.0) * v1 + (v2 = 2.0 * Math.random() - 1.0) * v2) <= 0.0 || rsq >= 1.0) {
        }
        return v1 * Math.sqrt(-2.0 * Math.log(rsq) / rsq);
    }

    public static final double randomT3(double sigma) {
        double v2;
        double v1;
        double rsq;
        while ((rsq = (v1 = 2.0 * Math.random() - 1.0) * v1 + (v2 = 2.0 * Math.random() - 1.0) * v2) <= 0.0 || rsq >= 1.0) {
        }
        if (v1 > 0.0) {
            return Math.sqrt(sigma * sigma + Math.sqrt(2.0 * sigma * sigma * sigma / Math.PI / rsq));
        }
        return -Math.sqrt(sigma * sigma + Math.sqrt(2.0 * sigma * sigma * sigma / Math.PI / rsq));
    }

    public static final float determinant3D(float[][] m) {
        float det = m[0][0] * m[1][1] * m[2][2] + m[1][0] * m[2][1] * m[0][2] + m[2][0] * m[0][1] * m[1][2] - m[2][0] * m[1][1] * m[0][2] - m[2][1] * m[1][2] * m[0][0] - m[2][2] * m[1][0] * m[0][1];
        return det;
    }

    public static final void invert3Dmatrix(float[][] m) {
        float[] d = new float[9];
        float det = m[0][0] * m[1][1] * m[2][2] + m[1][0] * m[2][1] * m[0][2] + m[2][0] * m[0][1] * m[1][2] - m[2][0] * m[1][1] * m[0][2] - m[2][1] * m[1][2] * m[0][0] - m[2][2] * m[1][0] * m[0][1];
        det = 1.0f / det;
        d[0] = (m[1][1] * m[2][2] - m[1][2] * m[2][1]) * det;
        d[1] = (m[2][1] * m[0][2] - m[2][2] * m[0][1]) * det;
        d[2] = (m[0][1] * m[1][2] - m[0][2] * m[1][1]) * det;
        d[3] = (m[1][2] * m[2][0] - m[1][0] * m[2][2]) * det;
        d[4] = (m[0][0] * m[2][2] - m[0][2] * m[2][0]) * det;
        d[5] = (m[1][0] * m[0][2] - m[1][2] * m[0][0]) * det;
        d[6] = (m[1][0] * m[2][1] - m[1][1] * m[2][0]) * det;
        d[7] = (m[0][1] * m[2][0] - m[0][0] * m[2][1]) * det;
        d[8] = (m[0][0] * m[1][1] - m[0][1] * m[1][0]) * det;
        m[0][0] = d[0];
        m[1][0] = d[1];
        m[2][0] = d[2];
        m[0][1] = d[3];
        m[1][1] = d[4];
        m[2][1] = d[5];
        m[0][2] = d[6];
        m[1][2] = d[7];
        m[2][2] = d[8];
    }

    public static final float invertMatrix(float[][] m, float[][] inverse, int nColumn) {
        float swap;
        int l;
        int k;
        int j;
        float det = 0.0f;
        if (nColumn == 1) {
            det = m[0][0];
            if (det != 0.0f) {
                inverse[0][0] = 1.0f / m[0][0];
            } else {
                System.out.println("Matrix is singular");
            }
            return det;
        }
        if (nColumn == 2) {
            det = m[0][0] * m[1][1] - m[0][1] * m[1][0];
            if (det != 0.0f) {
                inverse[0][0] = m[1][1] / det;
                inverse[0][1] = -m[1][0] / det;
                inverse[1][0] = -m[0][1] / det;
                inverse[1][1] = m[1][1] / det;
            } else {
                System.out.println("Matrix is singular");
            }
            return det;
        }
        if (nColumn == 3) {
            det = m[0][0] * m[1][1] * m[2][2] + m[1][0] * m[2][1] * m[0][2] + m[2][0] * m[0][1] * m[1][2] - m[2][0] * m[1][1] * m[0][2] - m[2][1] * m[1][2] * m[0][0] - m[2][2] * m[1][0] * m[0][1];
            if (det != 0.0f) {
                inverse[0][0] = (m[1][1] * m[2][2] - m[1][2] * m[2][1]) / det;
                inverse[0][1] = (m[2][1] * m[0][2] - m[2][2] * m[0][1]) / det;
                inverse[0][2] = (m[0][1] * m[1][2] - m[0][2] * m[1][1]) / det;
                inverse[1][0] = (m[1][2] * m[2][0] - m[1][0] * m[2][2]) / det;
                inverse[1][1] = (m[0][0] * m[2][2] - m[0][2] * m[2][0]) / det;
                inverse[1][2] = (m[1][0] * m[0][2] - m[1][2] * m[0][0]) / det;
                inverse[2][0] = (m[1][0] * m[2][1] - m[1][1] * m[2][0]) / det;
                inverse[2][1] = (m[0][1] * m[2][0] - m[0][0] * m[2][1]) / det;
                inverse[2][2] = (m[0][0] * m[1][1] - m[0][1] * m[1][0]) / det;
            } else {
                System.out.println("Matrix is singular");
            }
            return det;
        }
        int[] pivlst = new int[2 * nColumn + 1];
        boolean[] pivchk = new boolean[nColumn];
        int leCol = 0;
        int leRow = 0;
        int zeroMat = -1;
        det = 1.0f;
        int i = 0;
        while (i < nColumn) {
            pivchk[i] = false;
            j = 0;
            while (j < nColumn) {
                inverse[i][j] = m[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nColumn) {
            float leval = 0.0f;
            j = 0;
            while (j < nColumn) {
                if (!pivchk[j]) {
                    k = 0;
                    while (k < nColumn) {
                        float temp;
                        if (!pivchk[k] && (temp = Math.abs(inverse[j][k])) > leval) {
                            leRow = j;
                            leCol = k;
                            leval = temp;
                            zeroMat = 0;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            System.out.println("leCol= " + leCol + "leRow= " + leRow);
            if (zeroMat != 0) {
                System.out.println("Cannot invert the zero matrix\n");
                det = 0.0f;
                inverse = null;
            }
            pivchk[leCol] = true;
            pivlst[i * 2] = leRow;
            pivlst[i * 2 + 1] = leCol;
            if (leRow != leCol) {
                det = -det;
                l = 0;
                while (l < nColumn) {
                    swap = inverse[leRow][l];
                    inverse[leRow][l] = inverse[leCol][l];
                    inverse[leCol][l] = swap;
                    ++l;
                }
            }
            float piv = inverse[leCol][leCol];
            System.out.println(det *= piv);
            if ((double)det > 1.0E30) {
                det = 1.0f;
            }
            inverse[leCol][leCol] = 1.0f;
            l = 0;
            while (l < nColumn) {
                inverse[leCol][l] = inverse[leCol][l] / piv;
                System.out.println("inverse[" + leCol + "][" + l + "]= " + inverse[leCol][l]);
                ++l;
            }
            int l1 = 0;
            while (l1 < nColumn) {
                if (l1 != leCol) {
                    float t = inverse[l1][leCol];
                    inverse[l1][leCol] = 0.0f;
                    int l2 = 0;
                    while (l2 < nColumn) {
                        inverse[l1][l2] = inverse[l1][l2] - inverse[leCol][l2] * t;
                        ++l2;
                    }
                }
                ++l1;
            }
            ++i;
        }
        i = 0;
        while (i < nColumn) {
            l = nColumn - i - 1;
            if (pivlst[l * 2] != pivlst[l * 2 + 1]) {
                leRow = pivlst[l * 2];
                leCol = pivlst[l * 2 + 1];
                k = 0;
                while (k < nColumn) {
                    swap = inverse[k][leRow];
                    inverse[k][leRow] = inverse[k][leCol];
                    inverse[k][leCol] = swap;
                    ++k;
                }
            }
            ++i;
        }
        return det;
    }

    public static final float[][] invert3Dtransform(float[][] m) {
        float det = 0.0f;
        float[][] inverse = new float[3][4];
        det = m[0][0] * m[1][1] * m[2][2] + m[1][0] * m[2][1] * m[0][2] + m[2][0] * m[0][1] * m[1][2] - m[2][0] * m[1][1] * m[0][2] - m[2][1] * m[1][2] * m[0][0] - m[2][2] * m[1][0] * m[0][1];
        if (det != 0.0f) {
            inverse[0][0] = (m[1][1] * m[2][2] - m[1][2] * m[2][1]) / det;
            inverse[0][1] = (m[2][1] * m[0][2] - m[2][2] * m[0][1]) / det;
            inverse[0][2] = (m[0][1] * m[1][2] - m[0][2] * m[1][1]) / det;
            inverse[1][0] = (m[1][2] * m[2][0] - m[1][0] * m[2][2]) / det;
            inverse[1][1] = (m[0][0] * m[2][2] - m[0][2] * m[2][0]) / det;
            inverse[1][2] = (m[1][0] * m[0][2] - m[1][2] * m[0][0]) / det;
            inverse[2][0] = (m[1][0] * m[2][1] - m[1][1] * m[2][0]) / det;
            inverse[2][1] = (m[0][1] * m[2][0] - m[0][0] * m[2][1]) / det;
            inverse[2][2] = (m[0][0] * m[1][1] - m[0][1] * m[1][0]) / det;
            inverse[0][3] = -inverse[0][0] * m[0][3] - inverse[0][1] * m[1][3] - inverse[0][2] * m[2][3];
            inverse[1][3] = -inverse[1][0] * m[0][3] - inverse[1][1] * m[1][3] - inverse[1][2] * m[2][3];
            inverse[2][3] = -inverse[2][0] * m[0][3] - inverse[2][1] * m[1][3] - inverse[2][2] * m[2][3];
        } else {
            System.out.println("Matrix is singular");
        }
        return inverse;
    }

    public static final float[] eigenvalues3D(float[][] m) {
        float[] values = new float[3];
        double a1 = m[0][0] * m[1][1] - m[0][1] * m[1][0] + (m[1][1] * m[2][2] - m[1][2] * m[2][1]) + (m[2][2] * m[0][0] - m[2][0] * m[0][2]);
        double a2 = -(m[0][0] + m[1][1] + m[2][2]);
        double Q = (3.0 * a1 - a2 * a2) / 9.0;
        double a0 = -(m[0][0] * m[1][1] * m[2][2] + m[0][1] * m[1][2] * m[2][0] + m[1][0] * m[0][2] * m[2][1] - m[0][1] * m[1][0] * m[2][2] - m[1][2] * m[2][1] * m[0][0] - m[2][0] * m[0][2] * m[1][1]);
        double R = (9.0 * a2 * a1 - 27.0 * a0 - 2.0 * a2 * a2 * a2) / 54.0;
        double D = Q * Q * Q + R * R;
        if (D > 0.0) {
            values[0] = 0.0f;
            values[1] = 0.0f;
            values[2] = 0.0f;
        } else if (D < 0.0) {
            float tmp;
            double theta = Math.acos(R / Math.sqrt(-Q * Q * Q));
            double sQ = 2.0 * Math.sqrt(-Q);
            values[0] = (float)(sQ * Math.cos(theta / 3.0) - a2 / 3.0);
            values[1] = (float)(sQ * Math.cos((theta + Math.PI * 2) / 3.0) - a2 / 3.0);
            values[2] = (float)(sQ * Math.cos((theta + Math.PI * 4) / 3.0) - a2 / 3.0);
            if (Numerics.abs(values[0]) < Numerics.abs(values[1])) {
                tmp = values[0];
                values[0] = values[1];
                values[1] = tmp;
            }
            if (Numerics.abs(values[0]) < Numerics.abs(values[2])) {
                tmp = values[0];
                values[0] = values[2];
                values[2] = tmp;
            }
            if (Numerics.abs(values[1]) < Numerics.abs(values[2])) {
                tmp = values[1];
                values[1] = values[2];
                values[2] = tmp;
            }
        } else {
            double S = Math.cbrt(R);
            values[0] = (float)(-a2 / 3.0 + 2.0 * S);
            values[1] = (float)(-a2 / 3.0 - S);
            values[2] = values[1];
            if (Numerics.abs(values[0]) < Numerics.abs(values[1])) {
                float tmp = values[0];
                values[0] = values[2];
                values[2] = tmp;
            }
        }
        return values;
    }

    public static final float[][] eigenvectors3D(float[][] m, float[] values) {
        float[][] vector = new float[3][3];
        double[] ArIx = new double[3];
        double[] ArIy = new double[3];
        double[] ArIz = new double[3];
        if (values[0] == 0.0f) {
            vector[0][0] = 1.0f;
            vector[1][0] = 0.0f;
            vector[2][0] = 0.0f;
            vector[0][1] = 0.0f;
            vector[1][1] = 1.0f;
            vector[2][1] = 0.0f;
            vector[0][2] = 0.0f;
            vector[1][2] = 0.0f;
            vector[2][2] = 1.0f;
            return vector;
        }
        int i = 0;
        while (i < 3) {
            ArIx[0] = m[0][0] - values[i];
            ArIx[1] = m[1][0];
            ArIx[2] = m[2][0];
            double normx2 = ArIx[0] * ArIx[0] + ArIx[1] * ArIx[1] + ArIx[2] * ArIx[2];
            ArIy[0] = m[0][1];
            ArIy[1] = m[1][1] - values[i];
            ArIy[2] = m[2][1];
            double normy2 = ArIy[0] * ArIy[0] + ArIy[1] * ArIy[1] + ArIy[2] * ArIy[2];
            ArIz[0] = m[0][2];
            ArIz[1] = m[1][2];
            ArIz[2] = m[2][2] - values[i];
            double normz2 = ArIz[0] * ArIz[0] + ArIz[1] * ArIz[1] + ArIz[2] * ArIz[2];
            if (normx2 < normy2 && normx2 < normz2) {
                vector[0][i] = (float)(ArIy[1] * ArIz[2] - ArIy[2] * ArIz[1]);
                vector[1][i] = (float)(ArIy[2] * ArIz[0] - ArIy[0] * ArIz[2]);
                vector[2][i] = (float)(ArIy[0] * ArIz[1] - ArIy[1] * ArIz[0]);
            } else if (normy2 < normz2 && normy2 < normx2) {
                vector[0][i] = (float)(ArIz[1] * ArIx[2] - ArIz[2] * ArIx[1]);
                vector[1][i] = (float)(ArIz[2] * ArIx[0] - ArIz[0] * ArIx[2]);
                vector[2][i] = (float)(ArIz[0] * ArIx[1] - ArIz[1] * ArIx[0]);
            } else {
                vector[0][i] = (float)(ArIx[1] * ArIy[2] - ArIx[2] * ArIy[1]);
                vector[1][i] = (float)(ArIx[2] * ArIy[0] - ArIx[0] * ArIy[2]);
                vector[2][i] = (float)(ArIx[0] * ArIy[1] - ArIx[1] * ArIy[0]);
            }
            double norm = Math.sqrt(vector[0][i] * vector[0][i] + vector[1][i] * vector[1][i] + vector[2][i] * vector[2][i]);
            vector[0][i] = (float)((double)vector[0][i] / norm);
            vector[1][i] = (float)((double)vector[1][i] / norm);
            vector[2][i] = (float)((double)vector[2][i] / norm);
            ++i;
        }
        return vector;
    }

    public static final double[] eigenvalues3D(double[][] m) {
        double[] values = new double[3];
        double a1 = m[0][0] * m[1][1] - m[0][1] * m[1][0] + (m[1][1] * m[2][2] - m[1][2] * m[2][1]) + (m[2][2] * m[0][0] - m[2][0] * m[0][2]);
        double a2 = -(m[0][0] + m[1][1] + m[2][2]);
        double Q = (3.0 * a1 - a2 * a2) / 9.0;
        double a0 = -(m[0][0] * m[1][1] * m[2][2] + m[0][1] * m[1][2] * m[2][0] + m[1][0] * m[0][2] * m[2][1] - m[0][1] * m[1][0] * m[2][2] - m[1][2] * m[2][1] * m[0][0] - m[2][0] * m[0][2] * m[1][1]);
        double R = (9.0 * a2 * a1 - 27.0 * a0 - 2.0 * a2 * a2 * a2) / 54.0;
        double D = Q * Q * Q + R * R;
        if (D > 0.0) {
            values[0] = 0.0;
            values[1] = 0.0;
            values[2] = 0.0;
        } else if (D < 0.0) {
            double tmp;
            double theta = Math.acos(R / Math.sqrt(-Q * Q * Q));
            double sQ = 2.0 * Math.sqrt(-Q);
            values[0] = sQ * Math.cos(theta / 3.0) - a2 / 3.0;
            values[1] = sQ * Math.cos((theta + Math.PI * 2) / 3.0) - a2 / 3.0;
            values[2] = sQ * Math.cos((theta + Math.PI * 4) / 3.0) - a2 / 3.0;
            if (Numerics.abs(values[0]) < Numerics.abs(values[1])) {
                tmp = values[0];
                values[0] = values[1];
                values[1] = tmp;
            }
            if (Numerics.abs(values[0]) < Numerics.abs(values[2])) {
                tmp = values[0];
                values[0] = values[2];
                values[2] = tmp;
            }
            if (Numerics.abs(values[1]) < Numerics.abs(values[2])) {
                tmp = values[1];
                values[1] = values[2];
                values[2] = tmp;
            }
        } else {
            double S = Math.cbrt(R);
            values[0] = -a2 / 3.0 + 2.0 * S;
            values[1] = -a2 / 3.0 - S;
            values[2] = values[1];
            if (Numerics.abs(values[0]) < Numerics.abs(values[1])) {
                double tmp = values[0];
                values[0] = values[2];
                values[2] = tmp;
            }
        }
        return values;
    }

    public static final double[][] eigenvectors3D(double[][] m, double[] values) {
        double[][] vector = new double[3][3];
        double[] ArIx = new double[3];
        double[] ArIy = new double[3];
        double[] ArIz = new double[3];
        if (values[0] == 0.0) {
            vector[0][0] = 1.0;
            vector[1][0] = 0.0;
            vector[2][0] = 0.0;
            vector[0][1] = 0.0;
            vector[1][1] = 1.0;
            vector[2][1] = 0.0;
            vector[0][2] = 0.0;
            vector[1][2] = 0.0;
            vector[2][2] = 1.0;
            return vector;
        }
        int i = 0;
        while (i < 3) {
            ArIx[0] = m[0][0] - values[i];
            ArIx[1] = m[1][0];
            ArIx[2] = m[2][0];
            double normx2 = ArIx[0] * ArIx[0] + ArIx[1] * ArIx[1] + ArIx[2] * ArIx[2];
            ArIy[0] = m[0][1];
            ArIy[1] = m[1][1] - values[i];
            ArIy[2] = m[2][1];
            double normy2 = ArIy[0] * ArIy[0] + ArIy[1] * ArIy[1] + ArIy[2] * ArIy[2];
            ArIz[0] = m[0][2];
            ArIz[1] = m[1][2];
            ArIz[2] = m[2][2] - values[i];
            double normz2 = ArIz[0] * ArIz[0] + ArIz[1] * ArIz[1] + ArIz[2] * ArIz[2];
            if (normx2 < normy2 && normx2 < normz2) {
                vector[0][i] = ArIy[1] * ArIz[2] - ArIy[2] * ArIz[1];
                vector[1][i] = ArIy[2] * ArIz[0] - ArIy[0] * ArIz[2];
                vector[2][i] = ArIy[0] * ArIz[1] - ArIy[1] * ArIz[0];
            } else if (normy2 < normz2 && normy2 < normx2) {
                vector[0][i] = ArIz[1] * ArIx[2] - ArIz[2] * ArIx[1];
                vector[1][i] = ArIz[2] * ArIx[0] - ArIz[0] * ArIx[2];
                vector[2][i] = ArIz[0] * ArIx[1] - ArIz[1] * ArIx[0];
            } else {
                vector[0][i] = ArIx[1] * ArIy[2] - ArIx[2] * ArIy[1];
                vector[1][i] = ArIx[2] * ArIy[0] - ArIx[0] * ArIy[2];
                vector[2][i] = ArIx[0] * ArIy[1] - ArIx[1] * ArIy[0];
            }
            double norm = Math.sqrt(vector[0][i] * vector[0][i] + vector[1][i] * vector[1][i] + vector[2][i] * vector[2][i]);
            vector[0][i] = vector[0][i] / norm;
            vector[1][i] = vector[1][i] / norm;
            vector[2][i] = vector[2][i] / norm;
            ++i;
        }
        return vector;
    }

    public static final int round(float num) {
        if (num == (float)((int)num)) {
            return (int)num;
        }
        if (num > 0.0f) {
            return (int)(num + 0.5f);
        }
        return (int)(num - 0.5f);
    }

    public static final int floor(float num) {
        if (num == (float)((int)num)) {
            return (int)num;
        }
        if (num > 0.0f) {
            return (int)num;
        }
        return (int)num - 1;
    }

    public static final int ceil(float num) {
        if (num == (float)((int)num)) {
            return (int)num;
        }
        if (num > 0.0f) {
            return (int)num + 1;
        }
        return (int)num;
    }

    public static final int round(double num) {
        if (num == (double)((int)num)) {
            return (int)num;
        }
        if (num > 0.0) {
            return (int)(num + 0.5);
        }
        return (int)(num - 0.5);
    }

    public static final int floor(double num) {
        if (num == (double)((int)num)) {
            return (int)num;
        }
        if (num > 0.0) {
            return (int)num;
        }
        return (int)num - 1;
    }

    public static final int ceil(double num) {
        if (num == (double)((int)num)) {
            return (int)num;
        }
        if (num > 0.0) {
            return (int)num + 1;
        }
        return (int)num;
    }

    public static final float min(float a, float b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static final double min(double a, double b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static final int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static final long min(long a, long b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static final float min(float a, float b, float c) {
        return Numerics.min(a, Numerics.min(b, c));
    }

    public static final float min(float[] a) {
        float m = a[0];
        int n = 1;
        while (n < a.length) {
            if (a[n] < m) {
                m = a[n];
            }
            ++n;
        }
        return m;
    }

    public static final float min(float x1, float x2, float x3, float x4, float x5, float x6, float x7, float x8, float x9, float x10, float x11, float x12, float x13, float x14, float x15, float x16, float x17, float x18, float x19, float x20, float x21, float x22, float x23, float x24) {
        return Numerics.min(x1, Numerics.min(x2, Numerics.min(x3, Numerics.min(x4, Numerics.min(x5, Numerics.min(x6, Numerics.min(x7, Numerics.min(x8, Numerics.min(x9, Numerics.min(x10, Numerics.min(x11, Numerics.min(x12, Numerics.min(x13, Numerics.min(x14, Numerics.min(x15, Numerics.min(x16, Numerics.min(x17, Numerics.min(x18, Numerics.min(x19, Numerics.min(x20, Numerics.min(x21, Numerics.min(x22, Numerics.min(x23, x24)))))))))))))))))))))));
    }

    public static final float min(float x1, float x2, float x3, float x4, float x5, float x6, float x7, float x8, float x9, float x10, float x11, float x12, float x13, float x14, float x15, float x16, float x17, float x18) {
        return Numerics.min(x1, Numerics.min(x2, Numerics.min(x3, Numerics.min(x4, Numerics.min(x5, Numerics.min(x6, Numerics.min(x7, Numerics.min(x8, Numerics.min(x9, Numerics.min(x10, Numerics.min(x11, Numerics.min(x12, Numerics.min(x13, Numerics.min(x14, Numerics.min(x15, Numerics.min(x16, Numerics.min(x17, x18)))))))))))))))));
    }

    public static final float max(float x1, float x2, float x3, float x4, float x5, float x6, float x7, float x8, float x9, float x10, float x11, float x12, float x13, float x14, float x15, float x16, float x17, float x18, float x19, float x20, float x21, float x22, float x23, float x24) {
        return Numerics.max(x1, Numerics.max(x2, Numerics.max(x3, Numerics.max(x4, Numerics.max(x5, Numerics.max(x6, Numerics.max(x7, Numerics.max(x8, Numerics.max(x9, Numerics.max(x10, Numerics.max(x11, Numerics.max(x12, Numerics.max(x13, Numerics.max(x14, Numerics.max(x15, Numerics.max(x16, Numerics.max(x17, Numerics.max(x18, Numerics.max(x19, Numerics.max(x20, Numerics.max(x21, Numerics.max(x22, Numerics.max(x23, x24)))))))))))))))))))))));
    }

    public static final float max(float x1, float x2, float x3, float x4, float x5, float x6, float x7, float x8, float x9, float x10, float x11, float x12, float x13, float x14, float x15, float x16, float x17, float x18) {
        return Numerics.max(x1, Numerics.max(x2, Numerics.max(x3, Numerics.max(x4, Numerics.max(x5, Numerics.max(x6, Numerics.max(x7, Numerics.max(x8, Numerics.max(x9, Numerics.max(x10, Numerics.max(x11, Numerics.max(x12, Numerics.max(x13, Numerics.max(x14, Numerics.max(x15, Numerics.max(x16, Numerics.max(x17, x18)))))))))))))))));
    }

    public static final float max(float[][][] img, int x, int y, int z, int d) {
        float max = -1.0E30f;
        int i = -d;
        while (i <= d) {
            int j = -d;
            while (j <= d) {
                int k = -d;
                while (k <= d) {
                    if (img[x + i][y + j][z + k] > max) {
                        max = img[x + i][y + j][z + k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public static final float min(float[][][] img, int x, int y, int z, int d) {
        float min = 1.0E30f;
        int i = -d;
        while (i <= d) {
            int j = -d;
            while (j <= d) {
                int k = -d;
                while (k <= d) {
                    if (img[x + i][y + j][z + k] < min) {
                        min = img[x + i][y + j][z + k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public static final float max(float a, float b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static final double max(double a, double b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static final int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static final int max(int a, int b, int c) {
        return Numerics.max(a, Numerics.max(b, c));
    }

    public static final float max(float a, float b, float c) {
        return Numerics.max(a, Numerics.max(b, c));
    }

    public static final float max(float[] val) {
        float max = val[0];
        int n = 1;
        while (n < val.length) {
            if (val[n] > max) {
                max = val[n];
            }
            ++n;
        }
        return max;
    }

    public static final int max(int[] val) {
        int max = val[0];
        int n = 1;
        while (n < val.length) {
            if (val[n] > max) {
                max = val[n];
            }
            ++n;
        }
        return max;
    }

    public static final byte max(byte[] val) {
        byte max = val[0];
        int n = 1;
        while (n < val.length) {
            if (val[n] > max) {
                max = val[n];
            }
            ++n;
        }
        return max;
    }

    public static final float max(float[] val, int first, int last) {
        float max = val[first];
        int n = first + 1;
        while (n < last) {
            if (val[n] > max) {
                max = val[n];
            }
            ++n;
        }
        return max;
    }

    public static final int bounded(int x, int a, int b) {
        return Numerics.max(a, Numerics.min(x, b));
    }

    public static final float bounded(float x, float a, float b) {
        return Numerics.max(a, Numerics.min(x, b));
    }

    public static final double bounded(double x, double a, double b) {
        return Numerics.max(a, Numerics.min(x, b));
    }

    public static final float minmag(float a, float b) {
        if (a * a < b * b) {
            return a;
        }
        return b;
    }

    public static final float maxmag(float a, float b) {
        if (a * a > b * b) {
            return a;
        }
        return b;
    }

    public static final float mapped(float x, float a, float b) {
        return (Numerics.max(a, Numerics.min(x, b)) - a) / (b - a);
    }

    public static final float abs(float a) {
        if (a > 0.0f) {
            return a;
        }
        return -a;
    }

    public static final double abs(double a) {
        if (a > 0.0) {
            return a;
        }
        return -a;
    }

    public static final int abs(int a) {
        if (a > 0) {
            return a;
        }
        return -a;
    }

    public static final int sign(float a) {
        if (a > 0.0f) {
            return 1;
        }
        if (a < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static final int sign(double a) {
        if (a > 0.0) {
            return 1;
        }
        if (a < 0.0) {
            return -1;
        }
        return 0;
    }

    public static final float pow(float a, float b) {
        if (b == 0.0f) {
            return 1.0f;
        }
        if (b == 1.0f) {
            return a;
        }
        if (b == 2.0f) {
            return a * a;
        }
        if (b == 3.0f) {
            return a * a * a;
        }
        if (b == 0.5f) {
            return (float)Math.sqrt(a);
        }
        if (b == 0.33333334f) {
            return (float)Math.cbrt(a);
        }
        if (b == 0.6666667f) {
            return (float)Math.cbrt(a * a);
        }
        return (float)Math.pow(a, b);
    }

    public static final float inverse(float a) {
        if (a > 1.0E-30f || a < -1.0E-30f) {
            return 1.0f / a;
        }
        return 1.0E30f;
    }

    public static final byte bestIndex(float[] val) {
        int nmax = 0;
        int m = 1;
        while (m < val.length) {
            if (val[m] > val[nmax]) {
                nmax = m;
            }
            m = (byte)(m + 1);
        }
        return (byte)nmax;
    }

    public static final byte[] bestIndex(float[] val, int num) {
        byte[] id = new byte[num];
        int n = 0;
        while (n < num) {
            int nmax = 0;
            int m = 1;
            while (m < val.length) {
                if (val[m] > val[nmax]) {
                    nmax = m;
                }
                m = (byte)(m + 1);
            }
            id[n] = nmax;
            int n2 = nmax;
            val[n2] = val[n2] * -1.0f;
            ++n;
        }
        n = 0;
        while (n < num) {
            byte by = id[n];
            val[by] = val[by] * -1.0f;
            ++n;
        }
        return id;
    }

    public static final void bestIndex(byte[] id, float[] val, int num) {
        int n = 0;
        while (n < num) {
            int nmax = 0;
            int m = 1;
            while (m < val.length) {
                if (val[m] > val[nmax]) {
                    nmax = m;
                }
                m = (byte)(m + 1);
            }
            id[n] = nmax;
            int n2 = nmax;
            val[n2] = val[n2] * -1.0f;
            ++n;
        }
        n = 0;
        while (n < num) {
            byte by = id[n];
            val[by] = val[by] * -1.0f;
            ++n;
        }
    }

    public static final void bestIndex(byte[] id, float[] bestval, float[] val, int num) {
        int n = 0;
        while (n < num) {
            int nmax = 0;
            int m = 1;
            while (m < val.length) {
                if (val[m] > val[nmax]) {
                    nmax = m;
                }
                m = (byte)(m + 1);
            }
            id[n] = nmax;
            bestval[n] = val[nmax];
            val[nmax] = -1.0E30f;
            ++n;
        }
    }

    public static final void bestIndex(short[] id, float[] bestval, float[] val, int num) {
        int n = 0;
        while (n < num) {
            int nmax = 0;
            int m = 1;
            while (m < val.length) {
                if (val[m] > val[nmax]) {
                    nmax = m;
                }
                m = (short)(m + 1);
            }
            id[n] = nmax;
            bestval[n] = val[nmax];
            val[nmax] = -1.0E30f;
            ++n;
        }
    }

    public static final void bestIndex(byte[] id, float[] bestval, float[] val, int num, byte first) {
        int n = 0;
        while (n < num) {
            int nmax = first;
            int m = 0;
            while (m < val.length) {
                if (val[m] > val[nmax]) {
                    nmax = m;
                }
                m = (byte)(m + 1);
            }
            id[n] = nmax;
            bestval[n] = val[nmax];
            val[nmax] = -1.0E30f;
            ++n;
        }
    }

    public static final void sortDown(float[] val) {
        float[] sorted = new float[val.length];
        int n = 0;
        while (n < val.length) {
            int nmax = 0;
            int m = 1;
            while (m < val.length) {
                if (val[m] > val[nmax]) {
                    nmax = m;
                }
                m = (byte)(m + 1);
            }
            sorted[n] = val[nmax];
            val[nmax] = -1.0E30f;
            ++n;
        }
        n = 0;
        while (n < val.length) {
            val[n] = sorted[n];
            ++n;
        }
    }

    public static final int argmax(float a, float b, float c) {
        if (a > b) {
            if (a > c) {
                return 0;
            }
            return 2;
        }
        if (b > c) {
            return 1;
        }
        return 2;
    }

    public static final int argmax(double a, double b, double c) {
        if (a > b) {
            if (a > c) {
                return 0;
            }
            return 2;
        }
        if (b > c) {
            return 1;
        }
        return 2;
    }

    public static final byte bin(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    public static final float square(float val) {
        return val * val;
    }

    public static final double square(double val) {
        return val * val;
    }

    public static final float kronecker(boolean val) {
        if (val) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static void main(String[] args) {
        float[] numbers = new float[]{-1.2f, -1.0f, -0.5f, -0.2f, 0.0f, 0.3f, 0.5f, 1.0f, 1.2f, 1.6f};
        int n = 0;
        while (n < numbers.length) {
            System.out.println("number: " + numbers[n] + ", floor: " + Numerics.floor(numbers[n]) + ", ceil: " + Numerics.ceil(numbers[n]) + ", round: " + Numerics.round(numbers[n]));
            ++n;
        }
    }
}

