/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.ece.iacl.utility;

import Jama.Matrix;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.TransMatrix;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ArrayUtil {
    private static int testx = -1;
    private static int testy = -1;
    private static int testz = -1;
    private double[] minbounds;
    private double[] maxbounds;
    private double[] step;
    private double[] currentVector;
    private int movingComp;
    private int numComps;

    public void initVectorSweep(double[] minbounds, double[] maxbounds, double[] step) {
        this.minbounds = minbounds;
        this.maxbounds = maxbounds;
        this.step = step;
        if (minbounds.length != maxbounds.length) {
            System.out.println("Warning - vectors must be of the same length");
        }
        if (minbounds.length != step.length) {
            System.out.println("Warning - vectors must be of the same length");
        }
        this.numComps = minbounds.length;
        System.out.println("numcomps: " + this.numComps);
    }

    public static void testDouble(double a) {
        System.out.println(a);
    }

    public static void testInt(int a) {
        System.out.println(a);
    }

    public static void test2dFloatArray(float[][] a) {
        System.out.println(a[0][0]);
        System.out.println(a[0][0]);
    }

    public double[] getNextVector() {
        if (this.currentVector == null) {
            this.currentVector = (double[])this.minbounds.clone();
            this.movingComp = this.numComps - 1;
            return this.currentVector;
        }
        this.currentVector[this.movingComp] = this.currentVector[this.movingComp] + this.step[this.movingComp];
        while (this.currentVector[this.movingComp] > this.maxbounds[this.movingComp]) {
            this.currentVector[this.movingComp] = this.minbounds[this.movingComp];
            --this.movingComp;
            if (this.movingComp < 0) {
                return null;
            }
            this.currentVector[this.movingComp] = this.currentVector[this.movingComp] + this.step[this.movingComp];
        }
        this.movingComp = this.numComps - 1;
        return this.currentVector;
    }

    public static final int indexOf(int x, int[] list) {
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(float x, float[] list) {
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(double x, double[] list) {
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(String x, String[] list) {
        int i = 0;
        while (i < list.length) {
            if (x.equals(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int[] find(int x, int[] list) {
        int n = ArrayUtil.numberOf(x, list);
        if (n == 0) {
            return null;
        }
        int[] idxs = new int[n];
        int k = 0;
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                idxs[k] = i;
                if (++k == n) {
                    return idxs;
                }
            }
            ++i;
        }
        return idxs;
    }

    public static final int[] find(boolean x, boolean[] list) {
        int n = ArrayUtil.numberOf(x, list);
        if (n == 0) {
            return null;
        }
        int[] idxs = new int[n];
        int k = 0;
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                idxs[k] = i;
                if (++k == n) {
                    return idxs;
                }
            }
            ++i;
        }
        return idxs;
    }

    public static final int[] find(double x, double[] list) {
        int n = ArrayUtil.numberOf(x, list);
        if (n == 0) {
            return null;
        }
        int[] idxs = new int[n];
        int k = 0;
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                idxs[k] = i;
                if (++k == n) {
                    return idxs;
                }
            }
            ++i;
        }
        return idxs;
    }

    public static final int[] find(String x, String[] list) {
        int n = ArrayUtil.numberOf(x, list);
        if (n == 0) {
            return null;
        }
        int[] idxs = new int[n];
        int k = 0;
        int i = 0;
        while (i < list.length) {
            if (x.equals(list[i])) {
                idxs[k] = i;
                if (++k == n) {
                    return idxs;
                }
            }
            ++i;
        }
        return idxs;
    }

    public static final int numberOf(boolean x, boolean[] list) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static final int numberOf(int x, int[] list) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static final int numberOf(float x, float[] list) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static final int numberOf(double x, double[] list) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            if (x == list[i]) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static final int numberOf(String x, String[] list) {
        int n = 0;
        int i = 0;
        while (i < list.length) {
            if (x.equals(list[i])) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static final void replace(byte find, byte replace, byte[] list) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == find) {
                list[i] = replace;
            }
            ++i;
        }
    }

    public static final int[] sortWithInds(int[] x, int[] idx) {
        int[] out = (int[])x.clone();
        Arrays.sort(out);
        int i = 0;
        while (i < out.length) {
            idx[i] = ArrayUtil.indexOf(out[i], x);
            ++i;
        }
        return out;
    }

    public static final float[] sortWithInds(float[] x, int[] idx) {
        float[] out = (float[])x.clone();
        Arrays.sort(out);
        int i = 0;
        while (i < out.length) {
            idx[i] = ArrayUtil.indexOf(out[i], x);
            ++i;
        }
        return out;
    }

    public static final double[] sortWithInds(double[] x, int[] idx, int[] rev) {
        double[] out = (double[])x.clone();
        Arrays.sort(out);
        int i = 0;
        while (i < out.length) {
            idx[i] = ArrayUtil.indexOf(out[i], x);
            ++i;
        }
        return out;
    }

    public static final int[] sortWithInds(int[] x, int[] idx, int[] rev) {
        int[] out = (int[])x.clone();
        Arrays.sort(out);
        int i = 0;
        while (i < out.length) {
            idx[i] = ArrayUtil.indexOf(out[i], x);
            ++i;
        }
        return out;
    }

    public static final float[] sortWithInds(float[] x, int[] idx, int[] rev) {
        float[] out = (float[])x.clone();
        Arrays.sort(out);
        int i = 0;
        while (i < out.length) {
            idx[i] = ArrayUtil.indexOf(out[i], x);
            ++i;
        }
        return out;
    }

    public static final double[] sortWithInds(double[] x, int[] idx) {
        double[] out = (double[])x.clone();
        Arrays.sort(out);
        int i = 0;
        while (i < out.length) {
            idx[i] = ArrayUtil.indexOf(out[i], x);
            ++i;
        }
        return out;
    }

    public static float[] reorder(float[] orig, int[] inds) {
        float[] out = new float[orig.length];
        int i = 0;
        while (i < orig.length) {
            out[i] = orig[inds[i]];
            ++i;
        }
        return out;
    }

    public static int[] reverseInds(int[] inds) {
        int N = inds.length;
        int[] revinds = new int[N];
        int i = 0;
        while (i < N) {
            revinds[i] = inds[N - inds[i] - 1];
            ++i;
        }
        return revinds;
    }

    public static final int[] permute(int[] in, int[] idx) {
        int[] out = new int[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[idx[i]];
            ++i;
        }
        return out;
    }

    public static final float[] permute(float[] in, int[] idx) {
        float[] out = new float[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[idx[i]];
            ++i;
        }
        return out;
    }

    public static final double[] permute(double[] in, int[] idx) {
        double[] out = new double[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[idx[i]];
            ++i;
        }
        return out;
    }

    public static final float min(float[] in, int[] idx) {
        float min = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] < min) {
                min = in[i];
            }
            ++i;
        }
        return min;
    }

    public static final float max(float[] in, int[] idx) {
        float max = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] > max) {
                max = in[i];
            }
            ++i;
        }
        return max;
    }

    public static final boolean contains(int[] list, int x) {
        return ArrayUtil.indexOf(x, list) > -1;
    }

    public static final boolean contains(float[] list, float x) {
        return ArrayUtil.indexOf(x, list) > -1;
    }

    public static final boolean contains(String[] list, String x) {
        return ArrayUtil.indexOf(x, list) > -1;
    }

    public static final int[] removeElement(int[] list, int x) {
        if (ArrayUtil.contains(list, x)) {
            int[] out = new int[list.length - 1];
            int j = 0;
            int i = 0;
            while (i < list.length) {
                if (list[i] != x) {
                    out[j] = list[i];
                    ++j;
                }
                ++i;
            }
            return out;
        }
        return list;
    }

    public static final float[] removeIndex(float[] in, int ind) {
        float[] out = new float[in.length - 1];
        int j = 0;
        int i = 0;
        while (i < in.length) {
            if (i != ind) {
                out[j] = in[i];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final int[] removeIndex(int[] in, int ind) {
        int[] out = new int[in.length - 1];
        int j = 0;
        int i = 0;
        while (i < in.length) {
            if (i != ind) {
                out[j] = in[i];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final void fill(byte[] in, byte val) {
        int i = 0;
        while (i < in.length) {
            in[i] = val;
            ++i;
        }
    }

    public static final void fill(int[] in, int val) {
        int i = 0;
        while (i < in.length) {
            in[i] = val;
            ++i;
        }
    }

    public static final void fill(float[] in, float val) {
        int i = 0;
        while (i < in.length) {
            in[i] = val;
            ++i;
        }
    }

    public static final void fill(float[][] in, float val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                in[i][j] = val;
                ++j;
            }
            ++i;
        }
    }

    public static final void fill(boolean[] in, boolean val) {
        int i = 0;
        while (i < in.length) {
            in[i] = val;
            ++i;
        }
    }

    public static final void fill(double[] in, double val) {
        int i = 0;
        while (i < in.length) {
            in[i] = val;
            ++i;
        }
    }

    public static final void fill(boolean[][] in, boolean val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                in[i][j] = val;
                ++j;
            }
            ++i;
        }
    }

    public static final void fill(double[][] in, double val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                in[i][j] = val;
                ++j;
            }
            ++i;
        }
    }

    public static final void fill(int[][] in, int val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                in[i][j] = val;
                ++j;
            }
            ++i;
        }
    }

    public static final void fill(float[][][] in, float val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                int k = 0;
                while (k < in[0][0].length) {
                    in[i][j][k] = val;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void fill(double[][][] in, double val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                int k = 0;
                while (k < in[0][0].length) {
                    in[i][j][k] = val;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void fill(int[][][] in, int val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                int k = 0;
                while (k < in[0][0].length) {
                    in[i][j][k] = val;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void fill(float[][][][] in, float val) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                int k = 0;
                while (k < in[0][0].length) {
                    int l = 0;
                    while (l < in[0][0][0].length) {
                        in[i][j][k][0] = val;
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static float[] concatenate(List<float[]> list) {
        int totlen = 0;
        int i = 0;
        while (i < list.size()) {
            totlen += list.get(i).length;
            ++i;
        }
        float[] out = new float[totlen];
        int k = 0;
        int i2 = 0;
        while (i2 < list.size()) {
            float[] a = list.get(i2);
            int j = 0;
            while (j < a.length) {
                out[k] = a[j];
                ++k;
                ++j;
            }
            ++i2;
        }
        return out;
    }

    public static float[][] concatenate(float[][] a, float[][] b, int dim) {
        float[][] out = null;
        if (dim == 0) {
            int j;
            if (a[0].length != b[0].length) {
                System.out.println("number of columns of inputs are not the identical");
                return null;
            }
            out = new float[a.length + b.length][a[0].length];
            int k = 0;
            int i = 0;
            while (i < a.length) {
                j = 0;
                while (j < a[0].length) {
                    out[i][j] = a[i][j];
                    ++j;
                }
                ++k;
                ++i;
            }
            i = 0;
            while (i < b.length) {
                j = 0;
                while (j < a[0].length) {
                    out[k][j] = b[i][j];
                    ++j;
                }
                ++k;
                ++i;
            }
        } else {
            int i;
            if (a.length != b.length) {
                System.out.println("number of rows of inputs are not the identical");
                return null;
            }
            out = new float[a.length][a[0].length + b[0].length];
            int k = 0;
            int j = 0;
            while (j < a[0].length) {
                i = 0;
                while (i < a.length) {
                    out[i][j] = a[i][j];
                    ++i;
                }
                ++k;
                ++j;
            }
            j = 0;
            while (j < b[0].length) {
                i = 0;
                while (i < b.length) {
                    out[i][k] = b[i][j];
                    ++i;
                }
                ++k;
                ++j;
            }
        }
        return out;
    }

    public static double[][] concatenate(List<double[][]> alist, int dim) {
        double[][] out = null;
        if (dim == 0) {
            int N = 0;
            int M = 0;
            for (double[][] l : alist) {
                N += l.length;
                if (l[0].length <= M) continue;
                M = l[0].length;
            }
            out = new double[N][M];
            int k = 0;
            for (double[][] dArray : alist) {
                int i = 0;
                while (i < dArray.length) {
                    int j = 0;
                    while (j < dArray[i].length) {
                        out[k][j] = dArray[i][j];
                        ++k;
                        ++j;
                    }
                    ++i;
                }
            }
        } else {
            int N = 0;
            int M = 0;
            for (double[][] l : alist) {
                N += l[0].length;
                if (l.length <= M) continue;
                M = l.length;
            }
            out = new double[M][N];
            int k = 0;
            for (double[][] dArray : alist) {
                int i = 0;
                while (i < dArray.length) {
                    int j = 0;
                    while (j < dArray[i].length) {
                        out[i][k] = dArray[i][j];
                        ++k;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return out;
    }

    public static final int[] clone(int[] in) {
        int nx = in.length;
        int[] out = new int[nx];
        int i = 0;
        while (i < nx) {
            out[i] = in[i];
            ++i;
        }
        return out;
    }

    public static final float[] clone(float[] in) {
        int nx = in.length;
        float[] out = new float[nx];
        int i = 0;
        while (i < nx) {
            out[i] = in[i];
            ++i;
        }
        return out;
    }

    public static final byte[] clone(byte[] in) {
        int nx = in.length;
        byte[] out = new byte[nx];
        int i = 0;
        while (i < nx) {
            out[i] = in[i];
            ++i;
        }
        return out;
    }

    public static final double[] clone(double[] in) {
        int nx = in.length;
        double[] out = new double[nx];
        int i = 0;
        while (i < nx) {
            out[i] = in[i];
            ++i;
        }
        return out;
    }

    public static final int[][] clone(int[][] in) {
        int nx = in.length;
        int ny = in[0].length;
        int[][] out = new int[nx][ny];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                out[i][j] = in[i][j];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final float[][] clone(float[][] in) {
        int nx = in.length;
        int ny = in[0].length;
        float[][] out = new float[nx][ny];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                out[i][j] = in[i][j];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final double[][] clone(double[][] in) {
        int nx = in.length;
        int ny = in[0].length;
        double[][] out = new double[nx][ny];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                out[i][j] = in[i][j];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final int[][][] clone(int[][][] in) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int[][][] out = new int[nx][ny][nz];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    out[i][j][k] = in[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final double[][][] clone(double[][][] in) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        double[][][] out = new double[nx][ny][nz];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    out[i][j][k] = in[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final float[][][] clone(float[][][] in) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        float[][][] out = new float[nx][ny][nz];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    out[i][j][k] = in[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final double[][][][] clone(double[][][][] in) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        double[][][][] out = new double[nx][ny][nz][nc];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    int l = 0;
                    while (l < nc) {
                        out[i][j][k][l] = in[i][j][k][l];
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final float[][][][] clone(float[][][][] in) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        float[][][][] out = new float[nx][ny][nz][nc];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                int k = 0;
                while (k < nz) {
                    int l = 0;
                    while (l < nc) {
                        out[i][j][k][l] = in[i][j][k][l];
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final double[][] toDouble(float[][] a) {
        double[][] b = new double[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                b[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final double[][] toDouble(int[][] a) {
        double[][] b = new double[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                b[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final float[][] toFloat(byte[][] a) {
        float[][] b = new float[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                b[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final float[][][] toFloat(byte[][][] a) {
        float[][][] b = new float[a.length][a[0].length][a[0][0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                int k = 0;
                while (k < a[0][0].length) {
                    b[i][j][k] = a[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final float[][] toFloat(double[][] a) {
        float[][] b = new float[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                b[i][j] = (float)a[i][j];
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final float[][] toFloat(int[][] a) {
        float[][] b = new float[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                b[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final double[] toDouble(float[] a) {
        double[] b = new double[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = a[i];
            ++i;
        }
        return b;
    }

    public static final double[] toDouble(int[] a) {
        double[] b = new double[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = a[i];
            ++i;
        }
        return b;
    }

    public static final String[] toString(double[] a) {
        String[] b = new String[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = Double.toString(a[i]);
            ++i;
        }
        return b;
    }

    public static final String[] toString(float[] a) {
        String[] b = new String[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = Float.toString(a[i]);
            ++i;
        }
        return b;
    }

    public static final float[] toFloat(double[] a) {
        float[] b = new float[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = (float)a[i];
            ++i;
        }
        return b;
    }

    public static final float[] toFloat(int[] a) {
        float[] b = new float[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = a[i];
            ++i;
        }
        return b;
    }

    public static final int[] toInt(double[] a) {
        int[] b = new int[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = (int)a[i];
            ++i;
        }
        return b;
    }

    public static final int[] toInt(float[] a) {
        int[] b = new int[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = (int)a[i];
            ++i;
        }
        return b;
    }

    public static final int[][] toInt(double[][] a) {
        int[][] b = new int[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                b[i][j] = (int)a[i][j];
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final int[][] toInt(float[][] a) {
        int[][] b = new int[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                b[i][j] = (int)a[i][j];
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final int[][][] toInt(boolean[][][] a) {
        int[][][] b = new int[a.length][a[0].length][a[0][0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                int k = 0;
                while (k < a[0][0].length) {
                    if (a[i][j][k]) {
                        b[i][j][k] = 1;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return b;
    }

    public static final float[] normalizeSum(float[] in) {
        float sum = 0.0f;
        float[] out = new float[in.length];
        int i = 0;
        while (i < in.length) {
            sum += in[i];
            ++i;
        }
        i = 0;
        while (i < in.length) {
            out[i] = in[i] / sum;
            ++i;
        }
        return out;
    }

    public static final double[] normalizeSum(double[] in) {
        double sum = 0.0;
        double[] out = new double[in.length];
        int i = 0;
        while (i < in.length) {
            sum += in[i];
            ++i;
        }
        i = 0;
        while (i < in.length) {
            out[i] = in[i] / sum;
            ++i;
        }
        return out;
    }

    public static final float[] normalizeLength(float[] in) {
        float[] out = new float[in.length];
        float sum = ArrayUtil.sumOfSquares(in);
        int i = 0;
        while (i < in.length) {
            out[i] = in[i] / sum;
            ++i;
        }
        return out;
    }

    public static final void normalizeComponentsOverwrite(float[][][][] in) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        float lensqr = -1.0f;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    lensqr = ArrayUtil.sumOfSquares(in[x][y][z]);
                    if (lensqr > 0.0f) {
                        int c = 0;
                        while (c < nc) {
                            in[x][y][z][c] = (float)((double)in[x][y][z][c] / Math.sqrt(lensqr));
                            ++c;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static float[][][] vectorMagnitude4D(float[][][][] vec4D) {
        int rows = vec4D.length;
        int cols = vec4D[0].length;
        int slices = vec4D[0][0].length;
        int components = vec4D[0][0][0].length;
        float[][][] M = new float[rows][cols][slices];
        double sum = 0.0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    sum = 0.0;
                    int l = 0;
                    while (l < components) {
                        sum += Math.pow(vec4D[i][j][k][l], 2.0);
                        ++l;
                    }
                    M[i][j][k] = (float)Math.sqrt(sum);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return M;
    }

    public static final double[] normalizeLength(double[] in) {
        double[] out = new double[in.length];
        double sum = ArrayUtil.sumOfSquares(in);
        int i = 0;
        while (i < in.length) {
            out[i] = in[i] / sum;
            ++i;
        }
        return out;
    }

    public static final float[] normalizeTo(float[] in, float normsum) {
        float sum = 0.0f;
        float[] out = new float[in.length];
        int i = 0;
        while (i < in.length) {
            sum += in[i];
            ++i;
        }
        i = 0;
        while (i < in.length) {
            out[i] = normsum * in[i] / sum;
            ++i;
        }
        return out;
    }

    public static final double[] normalizeTo(double[] in, double normsum) {
        double sum = 0.0;
        double[] out = new double[in.length];
        int i = 0;
        while (i < in.length) {
            sum += in[i];
            ++i;
        }
        i = 0;
        while (i < in.length) {
            out[i] = normsum * in[i] / sum;
            ++i;
        }
        return out;
    }

    public static final int max(int[] in) {
        int out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] > out) {
                out = in[i];
            }
            ++i;
        }
        return out;
    }

    public static final double max(double[] in) {
        double out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] > out) {
                out = in[i];
            }
            ++i;
        }
        return out;
    }

    public static final float max(float[] in) {
        float out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] > out) {
                out = in[i];
            }
            ++i;
        }
        return out;
    }

    public static final int min(int[] in) {
        int out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] < out) {
                out = in[i];
            }
            ++i;
        }
        return out;
    }

    public static final double min(double[] in) {
        double out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] < out) {
                out = in[i];
            }
            ++i;
        }
        return out;
    }

    public static final float min(float[] in) {
        float out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] < out) {
                out = in[i];
            }
            ++i;
        }
        return out;
    }

    public static final int maxIdx(int[] in) {
        int out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] > in[out]) {
                out = i;
            }
            ++i;
        }
        return out;
    }

    public static final int maxIdx(double[] in) {
        int out = 0;
        int i = 1;
        while (i < in.length) {
            if (in[i] > in[out]) {
                out = i;
            }
            ++i;
        }
        return out;
    }

    public static final int maxIdx(float[] in) {
        int out = 0;
        int i = 1;
        while (i < in.length) {
            if (in[i] > in[out]) {
                out = i;
            }
            ++i;
        }
        return out;
    }

    public static final int minIdx(int[] in) {
        int out = in[0];
        int i = 1;
        while (i < in.length) {
            if (in[i] < in[out]) {
                out = i;
            }
            ++i;
        }
        return out;
    }

    public static final int minIdx(double[] in) {
        int out = 0;
        int i = 1;
        while (i < in.length) {
            if (in[i] < in[out]) {
                out = i;
            }
            ++i;
        }
        return out;
    }

    public static final int minIdx(float[] in) {
        int out = 0;
        int i = 1;
        while (i < in.length) {
            if (in[i] < in[out]) {
                out = i;
            }
            ++i;
        }
        return out;
    }

    public static final float[] add(float[] a, float[] b) {
        if (a.length != b.length) {
            return null;
        }
        float[] out = new float[a.length];
        int i = 0;
        while (i < b.length) {
            out[i] = a[i] + b[i];
            ++i;
        }
        return out;
    }

    public static final void addInPlace(double[] a, double[] b) {
        if (a.length != b.length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int n = i;
            a[n] = a[n] + b[i];
            ++i;
        }
    }

    public static final void addInPlace(double[][] a, double[][] b) {
        if (a.length != b.length) {
            return;
        }
        if (a[0].length != b[0].length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < b[0].length) {
                double[] dArray = a[i];
                int n = j;
                dArray[n] = dArray[n] + b[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static final void addInPlace(double[][][] a, double[][][] b) {
        if (a.length != b.length) {
            return;
        }
        if (a[0].length != b[0].length) {
            return;
        }
        if (a[0][0].length != b[0][0].length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < b[0].length) {
                int k = 0;
                while (k < b[0][0].length) {
                    double[] dArray = a[i][j];
                    int n = k;
                    dArray[n] = dArray[n] + b[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void addInPlace(double[][][][] a, double[][][][] b) {
        if (a.length != b.length) {
            return;
        }
        if (a[0].length != b[0].length) {
            return;
        }
        if (a[0][0].length != b[0][0].length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < b[0].length) {
                int k = 0;
                while (k < b[0][0].length) {
                    int l = 0;
                    while (l < b[0][0][0].length) {
                        double[] dArray = a[i][j][k];
                        int n = l;
                        dArray[n] = dArray[n] + b[i][j][k][l];
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void addInPlace(float[] a, float[] b) {
        if (a.length != b.length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int n = i;
            a[n] = a[n] + b[i];
            ++i;
        }
    }

    public static final void addInPlace(float[][] a, float[][] b) {
        if (a.length != b.length) {
            return;
        }
        if (a[0].length != b[0].length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < b[0].length) {
                float[] fArray = a[i];
                int n = j;
                fArray[n] = fArray[n] + b[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static final void addInPlace(float[][][] a, float[][][] b) {
        if (a.length != b.length) {
            return;
        }
        if (a[0].length != b[0].length) {
            return;
        }
        if (a[0][0].length != b[0][0].length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < b[0].length) {
                int k = 0;
                while (k < b[0][0].length) {
                    float[] fArray = a[i][j];
                    int n = k;
                    fArray[n] = fArray[n] + b[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void addInPlace(float[][][][] a, float[][][][] b) {
        if (a.length != b.length) {
            return;
        }
        if (a[0].length != b[0].length) {
            return;
        }
        if (a[0][0].length != b[0][0].length) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < b[0].length) {
                int k = 0;
                while (k < b[0][0].length) {
                    int l = 0;
                    while (l < b[0][0][0].length) {
                        float[] fArray = a[i][j][k];
                        int n = l;
                        fArray[n] = fArray[n] + b[i][j][k][l];
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void subtractInPlace(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            int n = i;
            a[n] = a[n] - b[i];
            ++i;
        }
    }

    public static final double[] multiply(double[] in, double val) {
        double[] out = new double[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[i] * val;
            ++i;
        }
        return out;
    }

    public static final void multiplyInPlace(double[] img, double val) {
        int i = 0;
        while (i < img.length) {
            int n = i++;
            img[n] = img[n] * val;
        }
    }

    public static final float[] multiply(float[] in, float val) {
        float[] out = new float[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[i] * val;
            ++i;
        }
        return out;
    }

    public static final void multiplyInPlace(float[] img, float val) {
        int i = 0;
        while (i < img.length) {
            int n = i++;
            img[n] = img[n] * val;
        }
    }

    public static final void multiply(float[][][][] img, float val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    int l = 0;
                    while (l < img[0][0][0].length) {
                        float[] fArray = img[i][j][k];
                        int n = l++;
                        fArray[n] = fArray[n] * val;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void multiply(float[][][][] img, double val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    int l = 0;
                    while (l < img[0][0][0].length) {
                        float[] fArray = img[i][j][k];
                        int n = l++;
                        fArray[n] = (float)((double)fArray[n] * val);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void multiply(float[][][] img, float val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    float[] fArray = img[i][j];
                    int n = k++;
                    fArray[n] = fArray[n] * val;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void multiply(float[][][] img, double val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    float[] fArray = img[i][j];
                    int n = k++;
                    fArray[n] = (float)((double)fArray[n] * val);
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(float[][][][] img, float val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    int l = 0;
                    while (l < img[0][0][0].length) {
                        float[] fArray = img[i][j][k];
                        int n = l++;
                        fArray[n] = fArray[n] / val;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(float[][] img, float val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                float[] fArray = img[i];
                int n = j++;
                fArray[n] = fArray[n] / val;
            }
            ++i;
        }
    }

    public static final void divide(float[][][][] img, double val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    int l = 0;
                    while (l < img[0][0][0].length) {
                        float[] fArray = img[i][j][k];
                        int n = l++;
                        fArray[n] = (float)((double)fArray[n] / val);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(float[][][] img, float val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    float[] fArray = img[i][j];
                    int n = k++;
                    fArray[n] = fArray[n] / val;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(float[][][] img, double val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                int k = 0;
                while (k < img[0][0].length) {
                    float[] fArray = img[i][j];
                    int n = k++;
                    fArray[n] = (float)((double)fArray[n] / val);
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(double[][] img, double val) {
        int i = 0;
        while (i < img.length) {
            int j = 0;
            while (j < img[0].length) {
                double[] dArray = img[i];
                int n = j++;
                dArray[n] = dArray[n] / val;
            }
            ++i;
        }
    }

    public static final void divide(float[] img, float val) {
        int i = 0;
        while (i < img.length) {
            int n = i++;
            img[n] = img[n] / val;
        }
    }

    public static final void divide(int[] img, int val) {
        int i = 0;
        while (i < img.length) {
            int n = i++;
            img[n] = img[n] / val;
        }
    }

    public static final void negateInPlace(float[] in) {
        int i = 0;
        while (i < in.length) {
            int n = i++;
            in[n] = in[n] * -1.0f;
        }
    }

    public static final float[] negate(float[] in) {
        float[] out = new float[in.length];
        int i = 0;
        while (i < in.length) {
            int n = i;
            out[n] = out[n] * -in[i];
            ++i;
        }
        return out;
    }

    public static final float sum(float[] in) {
        float sum = 0.0f;
        int i = 0;
        while (i < in.length) {
            sum += in[i];
            ++i;
        }
        return sum;
    }

    public static final double sum(double[] in) {
        double sum = 0.0;
        int i = 0;
        while (i < in.length) {
            sum += in[i];
            ++i;
        }
        return sum;
    }

    public static final float prod(float[] in) {
        float prod = 1.0f;
        int i = 0;
        while (i < in.length) {
            prod *= in[i];
            ++i;
        }
        return prod;
    }

    public static final double prod(double[] in) {
        double prod = 1.0;
        int i = 0;
        while (i < in.length) {
            prod *= in[i];
            ++i;
        }
        return prod;
    }

    public static final float sumOfSquares(float[] in) {
        float sum = 0.0f;
        int i = 0;
        while (i < in.length) {
            sum += in[i] * in[i];
            ++i;
        }
        return sum;
    }

    public static final double sumOfSquares(double[] in) {
        float sum = 0.0f;
        int i = 0;
        while (i < in.length) {
            sum = (float)((double)sum + in[i] * in[i]);
            ++i;
        }
        return sum;
    }

    public static final double sumabs(double[] in) {
        double sum = 0.0;
        int i = 0;
        while (i < in.length) {
            sum += Math.abs(in[i]);
            ++i;
        }
        return sum;
    }

    public static final double sumsquares(double[] in) {
        double sum = 0.0;
        int i = 0;
        while (i < in.length) {
            sum += in[i] * in[i];
            ++i;
        }
        return sum;
    }

    public static final void complement(boolean[][][] a) {
        int nx = a.length;
        int ny = a[0].length;
        int nz = a[0][0].length;
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    a[x][y][z] = !a[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static final String printArray(Object[] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = String.valueOf(out) + in[i].toString() + " ; ";
            ++i;
        }
        return out;
    }

    public static final String printArray(String[] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = String.valueOf(out) + in[i] + " ; ";
            ++i;
        }
        return out;
    }

    public static final String printArray(boolean[] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = in[i] ? String.valueOf(out) + "1 ; " : String.valueOf(out) + "0 ; ";
            ++i;
        }
        return out;
    }

    public static final String printArray(byte[] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = String.valueOf(out) + in[i] + " ";
            ++i;
        }
        return out;
    }

    public static final String printArray(float[] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = String.valueOf(out) + in[i] + " ";
            ++i;
        }
        return out;
    }

    public static final String printArray(double[] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = String.valueOf(out) + in[i] + " ";
            ++i;
        }
        return out;
    }

    public static final String printArray(int[] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = String.valueOf(out) + in[i] + " ";
            ++i;
        }
        return out;
    }

    public static final String printArray(boolean[][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                out = in[i][j] ? String.valueOf(out) + "1  " : String.valueOf(out) + "0  ";
                ++j;
            }
            out = String.valueOf(out) + "\n";
            ++i;
        }
        return out;
    }

    public static final String printArray(byte[][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                out = String.valueOf(out) + in[i][j] + " ";
                ++j;
            }
            out = String.valueOf(out) + "\n";
            ++i;
        }
        return out;
    }

    public static final String printArray(float[][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                out = String.valueOf(out) + in[i][j] + " ";
                ++j;
            }
            out = String.valueOf(out) + "\n";
            ++i;
        }
        return out;
    }

    public static final String printArray(int[][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                out = String.valueOf(out) + in[i][j] + " ";
                ++j;
            }
            out = String.valueOf(out) + "\n";
            ++i;
        }
        return out;
    }

    public static final String printArray(double[][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[0].length) {
                out = String.valueOf(out) + in[i][j] + " ";
                ++j;
            }
            out = String.valueOf(out) + "\n";
            ++i;
        }
        return out;
    }

    public static final String printArray(float[][][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int k = 0;
        while (k < in[0][0].length) {
            int i = 0;
            while (i < in.length) {
                int j = 0;
                while (j < in[0].length) {
                    out = String.valueOf(out) + in[i][j][k] + " ";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                ++i;
            }
            out = String.valueOf(out) + "****************\n";
            ++k;
        }
        return out;
    }

    public static final String printArray(boolean[][][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int k = 0;
        while (k < in[0][0].length) {
            int i = 0;
            while (i < in.length) {
                int j = 0;
                while (j < in[0].length) {
                    out = String.valueOf(out) + in[i][j][k] + " ";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                ++i;
            }
            out = String.valueOf(out) + "****************\n";
            ++k;
        }
        return out;
    }

    public static final String printArray(int[][][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int k = 0;
        while (k < in[0][0].length) {
            int i = 0;
            while (i < in.length) {
                int j = 0;
                while (j < in[0].length) {
                    out = String.valueOf(out) + in[i][j][k] + " ";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                ++i;
            }
            out = String.valueOf(out) + "****************\n";
            ++k;
        }
        return out;
    }

    public static final String printArray(double[][][] in) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int k = 0;
        while (k < in[0][0].length) {
            int i = 0;
            while (i < in.length) {
                int j = 0;
                while (j < in[0].length) {
                    out = String.valueOf(out) + in[i][j][k] + " ";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                ++i;
            }
            out = String.valueOf(out) + "****************\n";
            ++k;
        }
        return out;
    }

    public static final String printsubArray(byte[][][] in, int x, int y) {
        if (in == null) {
            return "null";
        }
        String out = "";
        int i = 0;
        while (i < in.length) {
            out = String.valueOf(out) + in[x][y][i] + " ";
            ++i;
        }
        return out;
    }

    public static final double[] getRow(double[][] in, int r) {
        double[] out = new double[in[0].length];
        int i = 0;
        while (i < in[0].length) {
            out[i] = in[r][i];
            ++i;
        }
        return out;
    }

    public static final double[] getColumn(double[][] in, int c) {
        double[] out = new double[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[i][c];
            ++i;
        }
        return out;
    }

    public static final float[] getRow(float[][] in, int r) {
        float[] out = new float[in[0].length];
        int i = 0;
        while (i < in[0].length) {
            out[i] = in[r][i];
            ++i;
        }
        return out;
    }

    public static final float[] getColumn(float[][] in, int c) {
        float[] out = new float[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[i][c];
            ++i;
        }
        return out;
    }

    public static final int[] getRow(int[][] in, int r) {
        int[] out = new int[in[0].length];
        int i = 0;
        while (i < in[0].length) {
            out[i] = in[r][i];
            ++i;
        }
        return out;
    }

    public static final int[] getColumn(int[][] in, int c) {
        int[] out = new int[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = in[i][c];
            ++i;
        }
        return out;
    }

    public static final byte[] get1dSubArray(byte[][][] in, int x, int y, int dim) {
        byte[] out = null;
        int len = -1;
        if (dim == 0) {
            len = in.length;
            out = new byte[len];
            int i = 0;
            while (i < len) {
                out[i] = in[i][x][y];
                ++i;
            }
        } else if (dim == 1) {
            len = in[0].length;
            out = new byte[len];
            int i = 0;
            while (i < len) {
                out[i] = in[x][i][y];
                ++i;
            }
        } else if (dim == 2) {
            len = in[0][0].length;
            out = new byte[len];
            int i = 0;
            while (i < len) {
                out[i] = in[x][y][i];
                ++i;
            }
        } else {
            System.out.println("Invalid dim");
        }
        return out;
    }

    public static final int[] get1dSubArray(int[][][] in, int x, int y, int dim) {
        int[] out = null;
        int len = -1;
        if (dim == 0) {
            len = in.length;
            out = new int[len];
            int i = 0;
            while (i < len) {
                out[i] = in[i][x][y];
                ++i;
            }
        } else if (dim == 1) {
            len = in[0].length;
            out = new int[len];
            int i = 0;
            while (i < len) {
                out[i] = in[x][i][y];
                ++i;
            }
        } else if (dim == 2) {
            len = in[0][0].length;
            out = new int[len];
            int i = 0;
            while (i < len) {
                out[i] = in[x][y][i];
                ++i;
            }
        } else {
            System.out.println("Invalid dim");
        }
        return out;
    }

    public static final float[] get1dSubArray(float[][][] in, int x, int y, int dim) {
        float[] out = null;
        int len = -1;
        if (dim == 0) {
            len = in.length;
            out = new float[len];
            int i = 0;
            while (i < len) {
                out[i] = in[i][x][y];
                ++i;
            }
        } else if (dim == 1) {
            len = in[0].length;
            out = new float[len];
            int i = 0;
            while (i < len) {
                out[i] = in[x][i][y];
                ++i;
            }
        } else if (dim == 2) {
            len = in[0][0].length;
            out = new float[len];
            int i = 0;
            while (i < len) {
                out[i] = in[x][y][i];
                ++i;
            }
        } else {
            System.out.println("Invalid dim");
        }
        return out;
    }

    public static final byte[][] get2dSubArray(byte[][][] in, int x, int dim) {
        byte[][] out = null;
        int dim1 = -1;
        int dim2 = -1;
        if (dim == 0) {
            dim1 = in[0].length;
            dim2 = in[0][0].length;
            out = new byte[dim1][dim2];
            int i = 0;
            while (i < dim1) {
                int j = 0;
                while (j < dim2) {
                    out[i][j] = in[x][i][j];
                    ++j;
                }
                ++i;
            }
        } else if (dim == 2) {
            dim1 = in.length;
            dim2 = in[0][0].length;
            out = new byte[dim1][dim2];
            int i = 0;
            while (i < dim1) {
                int j = 0;
                while (j < dim2) {
                    out[i][j] = in[i][x][j];
                    ++j;
                }
                ++i;
            }
        } else if (dim == 3) {
            dim1 = in.length;
            dim2 = in[0].length;
            out = new byte[dim1][dim2];
            int i = 0;
            while (i < dim1) {
                int j = 0;
                while (j < dim2) {
                    out[i][j] = in[i][j][x];
                    ++j;
                }
                ++i;
            }
        } else {
            System.out.println("Invalid dim");
        }
        return out;
    }

    public static final double[][] get1dSubArray(double[][] in, int[] x, boolean getRows) {
        int N = x.length;
        int maxind = ArrayUtil.max(x);
        double[][] out = null;
        if (getRows) {
            if (maxind >= in.length) {
                System.out.println("INDICES REQUESTED OUT OF BOUNDS OF INPUT ROWS");
                return null;
            }
            out = new double[N][in[0].length];
        } else {
            if (N >= in[0].length) {
                System.out.println("INDICES REQUESTED OUT OF BOUNDS OF INPUT COLUMNS");
                return null;
            }
            out = new double[in.length][N];
        }
        if (getRows) {
            int i = 0;
            while (i < N) {
                int j = 0;
                while (j < in[0].length) {
                    out[i][j] = in[x[i]][j];
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < in.length) {
                int j = 0;
                while (j < N) {
                    out[i][j] = in[j][x[i]];
                    ++j;
                }
                ++i;
            }
        }
        return out;
    }

    public static final int[][] get1dSubArray(int[][] in, int[] x, boolean getRows) {
        int N = x.length;
        int maxind = ArrayUtil.max(x);
        int[][] out = null;
        if (getRows) {
            if (maxind >= in.length) {
                System.out.println("INDICES REQUESTED OUT OF BOUNDS OF INPUT ROWS");
                return null;
            }
            out = new int[N][in[0].length];
        } else {
            if (N >= in[0].length) {
                System.out.println("INDICES REQUESTED OUT OF BOUNDS OF INPUT COLUMNS");
                return null;
            }
            out = new int[in.length][N];
        }
        if (getRows) {
            int i = 0;
            while (i < N) {
                int j = 0;
                while (j < in[0].length) {
                    out[i][j] = in[x[i]][j];
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < in.length) {
                int j = 0;
                while (j < N) {
                    out[i][j] = in[j][x[i]];
                    ++j;
                }
                ++i;
            }
        }
        return out;
    }

    public static final float[][] get1dSubArray(float[][] in, int[] x, boolean getRows) {
        int N = x.length;
        int maxind = ArrayUtil.max(x);
        float[][] out = null;
        if (getRows) {
            if (maxind >= in.length) {
                System.out.println("INDICES REQUESTED OUT OF BOUNDS OF INPUT ROWS");
                return null;
            }
            out = new float[N][in[0].length];
        } else {
            if (N >= in[0].length) {
                System.out.println("INDICES REQUESTED OUT OF BOUNDS OF INPUT COLUMNS");
                return null;
            }
            out = new float[in.length][N];
        }
        if (getRows) {
            int i = 0;
            while (i < N) {
                int j = 0;
                while (j < in[0].length) {
                    out[i][j] = in[x[i]][j];
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < in.length) {
                int j = 0;
                while (j < N) {
                    out[i][j] = in[j][x[i]];
                    ++j;
                }
                ++i;
            }
        }
        return out;
    }

    public static final int[] get1dSubArray(int[][] in, int fullidx, int startsub, int end, boolean fullRowSubCols) {
        int[] out = new int[end - startsub];
        int k = 0;
        if (fullRowSubCols) {
            int i = startsub;
            while (i < end) {
                out[k] = in[fullidx][i];
                ++k;
                ++i;
            }
        } else {
            int i = startsub;
            while (i < end) {
                out[k] = in[i][fullidx];
                ++k;
                ++i;
            }
        }
        return out;
    }

    public static final float[] get1dSubArray(float[][] in, int fullidx, int startsub, int end, boolean fullRowSubCols) {
        float[] out = new float[end - startsub];
        int k = 0;
        if (fullRowSubCols) {
            int i = startsub;
            while (i < end) {
                out[k] = in[fullidx][i];
                ++k;
                ++i;
            }
        } else {
            int i = startsub;
            while (i < end) {
                out[k] = in[i][fullidx];
                ++k;
                ++i;
            }
        }
        return out;
    }

    public static final void setComponent(float[][][][] dest, float[][][] src, int c, int nx, int ny, int nz) {
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    dest[x][y][z][c] = src[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static final void setComponent(int[][][][] dest, int[][][] src, int c, int nx, int ny, int nz) {
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    dest[x][y][z][c] = src[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static final double[][][] pad(double[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        double[][][] out = new double[nx + padxlo + padxhi][ny + padylo + padyhi][nz + padzlo + padzhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    out[x + padxlo][y + padylo][z + padzlo] = in[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final double[][][] pad(double[][][] in, int padx, int pady, int padz) {
        return ArrayUtil.pad(in, padx, padx, pady, pady, padz, padz);
    }

    public static final float[][][] pad(float[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        float[][][] out = new float[nx + padxlo + padxhi][ny + padylo + padyhi][nz + padzlo + padzhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    out[x + padxlo][y + padylo][z + padzlo] = in[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final float[][][] pad(float[][][] in, int padx, int pady, int padz) {
        return ArrayUtil.pad(in, padx, padx, pady, pady, padz, padz);
    }

    public static final int[][][] pad(int[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int[][][] out = new int[nx + padxlo + padxhi][ny + padylo + padyhi][nz + padzlo + padzhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    out[x + padxlo][y + padylo][z + padzlo] = in[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final int[][][] pad(int[][][] in, int padx, int pady, int padz) {
        return ArrayUtil.pad(in, padx, padx, pady, pady, padz, padz);
    }

    public static final byte[][][] pad(byte[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        byte[][][] out = new byte[nx + padxlo + padxhi][ny + padylo + padyhi][nz + padzlo + padzhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    out[x + padxlo][y + padylo][z + padzlo] = in[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final byte[][][] pad(byte[][][] in, int padx, int pady, int padz) {
        return ArrayUtil.pad(in, padx, padx, pady, pady, padz, padz);
    }

    public static final double[][] pad(double[][] in, int padxlo, int padxhi, int padylo, int padyhi) {
        int nx = in.length;
        int ny = in[0].length;
        double[][] out = new double[nx + padxlo + padxhi][ny + padylo + padyhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                out[x + padxlo][y + padylo] = in[x][y];
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final double[][] pad(double[][] in, int padx, int pady) {
        return ArrayUtil.pad(in, padx, padx, pady, pady);
    }

    public static final float[][] pad(float[][] in, int padxlo, int padxhi, int padylo, int padyhi) {
        int nx = in.length;
        int ny = in[0].length;
        float[][] out = new float[nx + padxlo + padxhi][ny + padylo + padyhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                out[x + padxlo][y + padylo] = in[x][y];
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final float[][] pad(float[][] in, int padx, int pady) {
        return ArrayUtil.pad(in, padx, padx, pady, pady);
    }

    public static final int[][] pad(int[][] in, int padxlo, int padxhi, int padylo, int padyhi) {
        int nx = in.length;
        int ny = in[0].length;
        int[][] out = new int[nx + padxlo + padxhi][ny + padylo + padyhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                out[x + padxlo][y + padylo] = in[x][y];
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final int[][] pad(int[][] in, int padx, int pady) {
        return ArrayUtil.pad(in, padx, padx, pady, pady);
    }

    public static final byte[][] pad(byte[][] in, int padxlo, int padxhi, int padylo, int padyhi) {
        int nx = in.length;
        int ny = in[0].length;
        byte[][] out = new byte[nx + padxlo + padxhi][ny + padylo + padyhi];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                out[x + padxlo][y + padylo] = in[x][y];
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final byte[][] pad(byte[][] in, int padx, int pady) {
        return ArrayUtil.pad(in, padx, padx, pady, pady);
    }

    public static final int[][][] padRepeat(int[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        int[][][] out = new int[nx_new][ny_new][nz_new];
        int x = 0;
        while (x < nx_new) {
            int y = 0;
            while (y < ny_new) {
                int z = 0;
                while (z < nz_new) {
                    xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                    yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                    zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                    out[x][y][z] = in[xx][yy][zz];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final int[][][][] padRepeat(int[][][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        int[][][][] out = new int[nx_new][ny_new][nz_new][nc];
        int x = 0;
        while (x < nx_new) {
            int y = 0;
            while (y < ny_new) {
                int z = 0;
                while (z < nz_new) {
                    int c = 0;
                    while (c < nc) {
                        xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                        yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                        zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                        out[x][y][z][c] = in[xx][yy][zz][c];
                        ++c;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final int[] padRepeatReshape1D(int[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        int[] out = new int[nx_new * ny_new * nz_new];
        int k = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx_new) {
                int y = 0;
                while (y < ny_new) {
                    int z = 0;
                    while (z < nz_new) {
                        xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                        yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                        zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                        out[k] = in[xx][yy][zz];
                        ++k;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz_new) {
                int y = 0;
                while (y < ny_new) {
                    int x = 0;
                    while (x < nx_new) {
                        xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                        yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                        zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                        out[k] = in[xx][yy][zz];
                        ++k;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final int[][] padRepeatReshape2D(int[][][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        int[][] out = new int[nx_new * ny_new * nz_new][nc];
        int k = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                k = 0;
                int x = 0;
                while (x < nx_new) {
                    int y = 0;
                    while (y < ny_new) {
                        int z = 0;
                        while (z < nz_new) {
                            xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                            yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                            zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                            out[k][c] = in[xx][yy][zz][c];
                            ++k;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                k = 0;
                int z = 0;
                while (z < nz_new) {
                    int y = 0;
                    while (y < ny_new) {
                        int x = 0;
                        while (x < nx_new) {
                            xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                            yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                            zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                            out[k][c] = in[xx][yy][zz][c];
                            ++k;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final float[][][] padRepeat(float[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        float[][][] out = new float[nx_new][ny_new][nz_new];
        int x = 0;
        while (x < nx_new) {
            int y = 0;
            while (y < ny_new) {
                int z = 0;
                while (z < nz_new) {
                    xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                    yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                    zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                    out[x][y][z] = in[xx][yy][zz];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final float[][][][] padRepeat(float[][][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        float[][][][] out = new float[nx_new][ny_new][nz_new][nc];
        int x = 0;
        while (x < nx_new) {
            int y = 0;
            while (y < ny_new) {
                int z = 0;
                while (z < nz_new) {
                    int c = 0;
                    while (c < nc) {
                        xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                        yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                        zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                        out[x][y][z][c] = in[xx][yy][zz][c];
                        ++c;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final float[][] padRepeatReshape2D(float[][][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        float[][] out = new float[nx_new * ny_new * nz_new][nc];
        int k = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                k = 0;
                int x = 0;
                while (x < nx_new) {
                    int y = 0;
                    while (y < ny_new) {
                        int z = 0;
                        while (z < nz_new) {
                            xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                            yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                            zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                            out[k][c] = in[xx][yy][zz][c];
                            ++k;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                k = 0;
                int z = 0;
                while (z < nz_new) {
                    int y = 0;
                    while (y < ny_new) {
                        int x = 0;
                        while (x < nx_new) {
                            xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                            yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                            zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                            out[k][c] = in[xx][yy][zz][c];
                            ++k;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final float[][] padRepeatReshape2Dcompwise(float[][][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        float[][] out = new float[nc][nx_new * ny_new * nz_new];
        int k = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                k = 0;
                int x = 0;
                while (x < nx_new) {
                    int y = 0;
                    while (y < ny_new) {
                        int z = 0;
                        while (z < nz_new) {
                            xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                            yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                            zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                            out[c][k] = in[xx][yy][zz][c];
                            ++k;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                k = 0;
                int z = 0;
                while (z < nz_new) {
                    int y = 0;
                    while (y < ny_new) {
                        int x = 0;
                        while (x < nx_new) {
                            xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                            yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                            zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                            out[c][k] = in[xx][yy][zz][c];
                            ++k;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final double[][][] padRepeat(double[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        double[][][] out = new double[nx_new][ny_new][nz_new];
        int x = 0;
        while (x < nx_new) {
            int y = 0;
            while (y < ny_new) {
                int z = 0;
                while (z < nz_new) {
                    xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                    yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                    zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                    out[x][y][z] = in[xx][yy][zz];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final double[][][][] padRepeat(double[][][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        double[][][][] out = new double[nx_new][ny_new][nz_new][nc];
        int x = 0;
        while (x < nx_new) {
            int y = 0;
            while (y < ny_new) {
                int z = 0;
                while (z < nz_new) {
                    int c = 0;
                    while (c < nc) {
                        xx = ArrayUtil.getReplicatePadCoordinate(x, nx, padxlo, padxhi);
                        yy = ArrayUtil.getReplicatePadCoordinate(y, ny, padylo, padyhi);
                        zz = ArrayUtil.getReplicatePadCoordinate(z, nz, padzlo, padzhi);
                        out[x][y][z][c] = in[xx][yy][zz][c];
                        ++c;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final int[][][] padMirror(int[][][] in, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        int xx = -1;
        int yy = -1;
        int zz = -1;
        int[][][] out = new int[nx_new][ny_new][nz_new];
        int x = 0;
        while (x < nx_new) {
            int y = 0;
            while (y < ny_new) {
                int z = 0;
                while (z < nz_new) {
                    xx = ArrayUtil.getMirrorPadCoordinate(x, nx, padxlo, padxhi);
                    yy = ArrayUtil.getMirrorPadCoordinate(y, ny, padylo, padyhi);
                    zz = ArrayUtil.getMirrorPadCoordinate(z, nz, padzlo, padzhi);
                    out[x][y][z] = in[xx][yy][zz];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final int getReplicatePadCoordinate(int x, int nxOrig, int padxlo, int padxhi) {
        int xx = -1;
        xx = x < padxlo ? 0 : (x - padxlo >= nxOrig ? nxOrig - 1 : x - padxlo);
        return xx;
    }

    public static final int getMirrorPadCoordinate(int x, int nxOrig, int padxlo, int padxhi) {
        int xx = -1;
        xx = x < padxlo ? padxlo - x - 1 : (x - 2 >= nxOrig ? 2 * nxOrig - x + 1 : x - padxlo);
        return xx;
    }

    public static int[] indexToCoordinates(int xyz, int nx, int ny, int nz) {
        if (xyz > nx * ny * nz) {
            return null;
        }
        if (xyz < 0) {
            return null;
        }
        int[] coord = new int[3];
        coord[2] = xyz % nz;
        xyz -= coord[2];
        coord[1] = (xyz /= nz) % ny;
        xyz -= coord[1];
        coord[0] = (xyz /= ny) % nx;
        return coord;
    }

    public static int coordsToIndex(int x, int y, int z, int nx, int ny, int nz, boolean rowwise) {
        if (rowwise) {
            return z + nz * y + nz * ny * x;
        }
        return x + nx * y + nx * ny * z;
    }

    public static final int[][][] cropReshape3D(int[] in, int nx, int ny, int nz, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        int[][][] out = new int[nx][ny][nz];
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = in[ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = in[ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final float[][][] cropReshape3D(float[] in, int nx, int ny, int nz, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        float[][][] out = new float[nx][ny][nz];
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = in[ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = in[ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final float[][][][] cropReshape4D(float[][] in, int nx, int ny, int nz, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        int nc = in.length;
        float[][][][] out = new float[nx][ny][nz][nc];
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c] = in[c][ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c] = in[c][ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final int[][][][] cropReshape4D(int[][] in, int nx, int ny, int nz, int padxlo, int padxhi, int padylo, int padyhi, int padzlo, int padzhi, boolean rowwise) {
        int nc = in.length;
        int[][][][] out = new int[nx][ny][nz][nc];
        int nx_new = nx + padxlo + padxhi;
        int ny_new = ny + padylo + padyhi;
        int nz_new = nz + padzlo + padzhi;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c] = in[c][ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c] = in[c][ArrayUtil.coordsToIndex(x + padxlo, y + padylo, z + padzlo, nx_new, ny_new, nz_new, rowwise)];
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final float[][] crop(float[][] in, int cropxlo, int cropxhi, int cropylo, int cropyhi) {
        int nx = in.length;
        int ny = in[0].length;
        float[][] out = new float[nx - cropxlo - cropxhi][ny - cropxlo - cropxhi];
        int x = cropxlo;
        while (x < nx - cropxhi) {
            int y = cropylo;
            while (y < ny - cropyhi) {
                out[x - cropxlo][y - cropylo] = in[x][y];
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final float[][] crop(float[][] in, int cropx, int cropy) {
        return ArrayUtil.crop(in, cropx, cropx, cropy, cropy);
    }

    public static final int[][] crop(int[][] in, int cropxlo, int cropxhi, int cropylo, int cropyhi) {
        int nx = in.length;
        int ny = in[0].length;
        int[][] out = new int[nx - cropxlo - cropxhi][ny - cropxlo - cropxhi];
        int x = cropxlo;
        while (x < nx - cropxhi) {
            int y = cropylo;
            while (y < ny - cropyhi) {
                out[x - cropxlo][y - cropylo] = in[x][y];
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final int[][] crop(int[][] in, int cropx, int cropy) {
        return ArrayUtil.crop(in, cropx, cropx, cropy, cropy);
    }

    public static final byte[][] crop(byte[][] in, int cropxlo, int cropxhi, int cropylo, int cropyhi) {
        int nx = in.length;
        int ny = in[0].length;
        byte[][] out = new byte[nx - cropxlo - cropxhi][ny - cropxlo - cropxhi];
        int x = cropxlo;
        while (x < nx - cropxhi) {
            int y = cropylo;
            while (y < ny - cropyhi) {
                out[x - cropxlo][y - cropylo] = in[x][y];
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static final byte[][] crop(byte[][] in, int cropx, int cropy) {
        return ArrayUtil.crop(in, cropx, cropx, cropy, cropy);
    }

    public static final float[] reshape1D(float[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        float[] out = new float[nx * ny * nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final byte[] reshape1D(byte[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        byte[] out = new byte[nx * ny * nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final int[] reshape1D(int[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int[] out = new int[nx * ny * nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final double[] reshape1D(double[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        double[] out = new double[nx * ny * nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[i] = in[x][y][z];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final byte[] reshape1D(byte[][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        byte[] out = new byte[nx * ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[i] = in[x][y];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[i] = in[x][y];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final int[] reshape1D(int[][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int[] out = new int[nx * ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[i] = in[x][y];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[i] = in[x][y];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final float[] reshape1D(float[][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        float[] out = new float[nx * ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[i] = in[x][y];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[i] = in[x][y];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final double[] reshape1D(double[][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        double[] out = new double[nx * ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[i] = in[x][y];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[i] = in[x][y];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final float[][] reshape2D(float[] in, int nx, int ny, boolean rowwise) {
        float[][] out = new float[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = in[i];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = in[i];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final int[][] reshape2D(int[] in, int nx, int ny, boolean rowwise) {
        int[][] out = new int[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = in[i];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = in[i];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final byte[][] reshape2D(byte[] in, int nx, int ny, boolean rowwise) {
        byte[][] out = new byte[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = in[i];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = in[i];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final boolean[][] reshape2D(boolean[] in, int nx, int ny, boolean rowwise) {
        boolean[][] out = new boolean[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = in[i];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = in[i];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final float[][] reshape2D(float[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        float[][] out = new float[nx * ny][nz];
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int i = 0;
                    int c = 0;
                    while (c < nz) {
                        out[i][c] = in[x][y][c];
                        ++i;
                        ++c;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int i = 0;
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    int c = 0;
                    while (c < nz) {
                        out[i][c] = in[x][y][c];
                        ++i;
                        ++c;
                    }
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final float[][] reshape2D(float[][][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        float[][] out = new float[nx * ny * nz][nc];
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int i = 0;
                        int c = 0;
                        while (c < nc) {
                            out[i][c] = in[x][y][z][c];
                            ++i;
                            ++c;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int i = 0;
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int c = 0;
                        while (c < nc) {
                            out[i][c] = in[x][y][z][c];
                            ++i;
                            ++c;
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final int[][] reshape2Dcompwise(int[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int[][] out = new int[nz][nx * ny];
        int i = 0;
        if (rowwise) {
            i = 0;
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int c = 0;
                    while (c < nz) {
                        out[c][i] = in[x][y][c];
                        ++c;
                    }
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            i = 0;
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    int c = 0;
                    while (c < nz) {
                        out[c][i] = in[x][y][c];
                        ++c;
                    }
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final float[][] reshape2Dcompwise(float[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        float[][] out = new float[nz][nx * ny];
        int i = 0;
        if (rowwise) {
            i = 0;
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int c = 0;
                    while (c < nz) {
                        out[c][i] = in[x][y][c];
                        ++c;
                    }
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            i = 0;
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    int c = 0;
                    while (c < nz) {
                        out[c][i] = in[x][y][c];
                        ++c;
                    }
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final int[][] reshape2Dcompwise(int[][][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        int[][] out = new int[nc][nx * ny * nz];
        int i = 0;
        if (rowwise) {
            i = 0;
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int c = 0;
                        while (c < nc) {
                            out[c][i] = in[x][y][z][c];
                            ++c;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            i = 0;
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int c = 0;
                        while (c < nc) {
                            out[c][i] = in[x][y][z][c];
                            ++c;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final float[][] reshape2Dcompwise(float[][][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        float[][] out = new float[nc][nx * ny * nz];
        int i = 0;
        if (rowwise) {
            i = 0;
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int c = 0;
                        while (c < nc) {
                            out[c][i] = in[x][y][z][c];
                            ++c;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            i = 0;
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int c = 0;
                        while (c < nc) {
                            out[c][i] = in[x][y][z][c];
                            ++c;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final int[][] reshape2DInt(byte[] in, int nx, int ny, boolean rowwise) {
        int[][] out = new int[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = in[i];
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = in[i];
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static final float[][][] reshape3D(float[] in, int nx, int ny, int nz, boolean rowwise) {
        float[][][] out = new float[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final int[][][] reshape3D(int[] in, int nx, int ny, int nz, boolean rowwise) {
        int[][][] out = new int[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final double[][][] reshape3D(double[] in, int nx, int ny, int nz, boolean rowwise) {
        double[][][] out = new double[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final byte[][][] reshape3D(byte[] in, int nx, int ny, int nz, boolean rowwise) {
        byte[][][] out = new byte[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final int[][][] reshape3DInt(byte[] in, int nx, int ny, int nz, boolean rowwise) {
        int[][][] out = new int[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = in[i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static final byte[][][] reshape3D(byte[][] in, int nx, int ny, int nc, boolean rowwise) {
        byte[][][] out = new byte[nx][ny][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        out[x][y][c] = in[c][i];
                        ++i;
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][c] = in[c][i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++c;
            }
        }
        return out;
    }

    public static final int[][][] reshape3D(int[][] in, int nx, int ny, int nc, boolean rowwise) {
        int[][][] out = new int[nx][ny][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        out[x][y][c] = in[c][i];
                        ++i;
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][c] = in[c][i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++c;
            }
        }
        return out;
    }

    public static final float[][][] reshape3D(float[][] in, int nx, int ny, int nc, boolean rowwise) {
        float[][][] out = new float[nx][ny][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        out[x][y][c] = in[c][i];
                        ++i;
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][c] = in[c][i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++c;
            }
        }
        return out;
    }

    public static byte[][][] reshape3DSubset(byte[][] in, int nx, int ny, int ncmin, int ncmax, boolean rowwise) {
        byte[][][] out = new byte[nx][ny][ncmax - ncmin];
        int i = 0;
        if (rowwise) {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        out[x][y][c - ncmin] = in[c][i];
                        ++i;
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][c - ncmin] = in[c][i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++c;
            }
        }
        return out;
    }

    public static int[][][] reshape3DSubset(int[][] in, int nx, int ny, int ncmin, int ncmax, boolean rowwise) {
        int[][][] out = new int[nx][ny][ncmax - ncmin];
        int i = 0;
        if (rowwise) {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        out[x][y][c - ncmin] = in[c][i];
                        ++i;
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][c - ncmin] = in[c][i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++c;
            }
        }
        return out;
    }

    public static int[][][] reshape3DSubsetInt(byte[][] in, int nx, int ny, int ncmin, int ncmax, boolean rowwise) {
        int[][][] out = new int[nx][ny][ncmax - ncmin];
        int i = 0;
        if (rowwise) {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        out[x][y][c - ncmin] = in[c][i];
                        ++i;
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][c - ncmin] = in[c][i];
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++c;
            }
        }
        return out;
    }

    public static final double[][][][] reshape4D(double[][] in, int nx, int ny, int nz, int nc, boolean rowwise) {
        double[][][][] out = new double[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final float[][][][] reshape4D(float[][] in, int nx, int ny, int nz, int nc, boolean rowwise) {
        float[][][][] out = new float[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static int[][][][] reshape4D(int[][] in, int nx, int ny, int nz, int nc, boolean rowwise) {
        int[][][][] out = new int[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static int[][][][] reshape4DSubset(int[][] in, int nx, int ny, int nz, int ncmin, int ncmax, boolean rowwise) {
        int[][][][] out = new int[nx][ny][nz][ncmax - ncmin];
        int i = 0;
        if (rowwise) {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c - ncmin] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c - ncmin] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final byte[][][][] reshape4D(byte[][] in, int nx, int ny, int nz, int nc, boolean rowwise) {
        byte[][][][] out = new byte[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static byte[][][][] reshape4DSubset(byte[][] in, int nx, int ny, int nz, int ncmin, int ncmax, boolean rowwise) {
        byte[][][][] out = new byte[nx][ny][nz][ncmax - ncmin];
        int i = 0;
        if (rowwise) {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c - ncmin] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c - ncmin] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final int[][][][] reshape4DInt(byte[][] in, int nx, int ny, int nz, int nc, boolean rowwise) {
        int[][][][] out = new int[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int c = 0;
            while (c < nc) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < nc) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static int[][][][] reshape4DSubsetInt(byte[][] in, int nx, int ny, int nz, int ncmin, int ncmax, boolean rowwise) {
        int[][][][] out = new int[nx][ny][nz][ncmax - ncmin];
        int i = 0;
        if (rowwise) {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int x = 0;
                while (x < nx) {
                    int y = 0;
                    while (y < ny) {
                        int z = 0;
                        while (z < nz) {
                            out[x][y][z][c - ncmin] = in[c][i];
                            ++i;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++c;
            }
        } else {
            int c = ncmin;
            while (c < ncmax) {
                i = 0;
                int z = 0;
                while (z < nz) {
                    int y = 0;
                    while (y < ny) {
                        int x = 0;
                        while (x < nx) {
                            out[x][y][z][c - ncmin] = in[c][i];
                            ++i;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++c;
            }
        }
        return out;
    }

    public static final double[][] transpose(double[][] in) {
        int nr = in.length;
        int nc = in[0].length;
        double[][] out = new double[nc][nr];
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                out[j][i] = in[i][j];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static final float[][] transpose(float[][] in) {
        int nr = in.length;
        int nc = in[0].length;
        float[][] out = new float[nc][nr];
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                out[j][i] = in[i][j];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static float[][] symMatrix(float[] v) {
        float[][] out;
        block7: {
            int k;
            block6: {
                out = null;
                k = 0;
                if (v.length != 4) break block6;
                out = new float[2][2];
                int i = 0;
                while (i < 2) {
                    int j = i;
                    while (j < 2) {
                        out[i][j] = v[k];
                        if (i != j) {
                            out[j][i] = v[k];
                        }
                        ++j;
                    }
                    ++i;
                }
                break block7;
            }
            if (v.length != 6) break block7;
            out = new float[3][3];
            int i = 0;
            while (i < 3) {
                int j = i;
                while (j < 3) {
                    out[i][j] = v[k];
                    if (i != j) {
                        out[j][i] = v[k];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return out;
    }

    public static float[][] symMatrix(float[][] in, boolean upper) {
        float[][] out = new float[in.length][in[0].length];
        if (upper) {
            int i = 0;
            while (i < in.length) {
                int j = i;
                while (j < in[0].length) {
                    out[i][j] = in[i][j];
                    if (i != j) {
                        out[j][i] = in[i][j];
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < in[0].length) {
                int i = j;
                while (i < in.length) {
                    out[i][j] = in[i][j];
                    if (i != j) {
                        out[j][i] = in[i][j];
                    }
                    ++i;
                }
                ++j;
            }
        }
        return out;
    }

    public static double[][] symMatrixDouble(float[] v) {
        double[][] out;
        block7: {
            int k;
            block6: {
                out = null;
                k = 0;
                if (v.length != 4) break block6;
                out = new double[2][2];
                int i = 0;
                while (i < 2) {
                    int j = i;
                    while (j < 2) {
                        out[i][j] = v[k];
                        if (i != j) {
                            out[j][i] = v[k];
                        }
                        ++k;
                        ++j;
                    }
                    ++i;
                }
                break block7;
            }
            if (v.length != 6) break block7;
            out = new double[3][3];
            int i = 0;
            while (i < 3) {
                int j = i;
                while (j < 3) {
                    out[i][j] = v[k];
                    if (i != j) {
                        out[j][i] = v[k];
                    }
                    ++k;
                    ++j;
                }
                ++i;
            }
        }
        return out;
    }

    public static double[][] symMatrixDouble(float[][] in, boolean upper) {
        double[][] out = new double[in.length][in[0].length];
        if (upper) {
            int i = 0;
            while (i < in.length) {
                int j = i;
                while (j < in[0].length) {
                    out[i][j] = in[i][j];
                    if (i != j) {
                        out[j][i] = in[i][j];
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < in[0].length) {
                int i = j;
                while (i < in.length) {
                    out[i][j] = in[i][j];
                    if (i != j) {
                        out[j][i] = in[i][j];
                    }
                    ++i;
                }
                ++j;
            }
        }
        return out;
    }

    public static final Matrix toVector(double[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        Matrix vecout = new Matrix(nx * ny * nz, 1);
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        vecout.set(i, 0, in[x][y][z]);
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        vecout.set(i, 0, in[x][y][z]);
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return vecout;
    }

    public static final Matrix toVector(int[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        Matrix vecout = new Matrix(nx * ny * nz, 1);
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        vecout.set(i, 0, (double)in[x][y][z]);
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        vecout.set(i, 0, (double)in[x][y][z]);
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return vecout;
    }

    public static final Matrix toVector(float[][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        Matrix vecout = new Matrix(nx * ny * nz, 1);
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        vecout.set(i, 0, (double)in[x][y][z]);
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        vecout.set(i, 0, (double)in[x][y][z]);
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return vecout;
    }

    public static final Matrix toMatrix(double[][][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        Matrix vecout = new Matrix(nx * ny * nz, nc);
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int n = 0;
                        while (n < nc) {
                            vecout.set(i, n, in[x][y][z][n]);
                            ++n;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int n = 0;
                        while (n < nc) {
                            vecout.set(i, n, in[x][y][z][n]);
                            ++n;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return vecout;
    }

    public static final Matrix toMatrix(int[][][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        Matrix vecout = new Matrix(nx * ny * nz, nc);
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int n = 0;
                        while (n < nc) {
                            vecout.set(i, n, (double)in[x][y][z][n]);
                            ++n;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int n = 0;
                        while (n < nc) {
                            vecout.set(i, n, (double)in[x][y][z][n]);
                            ++n;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return vecout;
    }

    public static final Matrix toMatrix(float[][][][] in, boolean rowwise) {
        int nx = in.length;
        int ny = in[0].length;
        int nz = in[0][0].length;
        int nc = in[0][0][0].length;
        Matrix vecout = new Matrix(nx * ny * nz, nc);
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int n = 0;
                        while (n < nc) {
                            vecout.set(i, n, (double)in[x][y][z][n]);
                            ++n;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int n = 0;
                        while (n < nc) {
                            vecout.set(i, n, (double)in[x][y][z][n]);
                            ++n;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return vecout;
    }

    public static float[][][][] fromMatrixFloat(Matrix m, int nx, int ny, int nz, int nc, boolean rowwise) {
        float[][][][] out = new float[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int n = 0;
                        while (n < nc) {
                            out[x][y][z][n] = (float)m.get(i, n);
                            ++n;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int n = 0;
                        while (n < nc) {
                            out[x][y][z][n] = (float)m.get(i, n);
                            ++n;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static int[][][][] fromMatrixInt(Matrix m, int nx, int ny, int nz, int nc, boolean rowwise) {
        int[][][][] out = new int[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int n = 0;
                        while (n < nc) {
                            out[x][y][z][n] = (int)m.get(i, n);
                            ++n;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int n = 0;
                        while (n < nc) {
                            out[x][y][z][n] = (int)m.get(i, n);
                            ++n;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static double[][][][] fromMatrixDouble(Matrix m, int nx, int ny, int nz, int nc, boolean rowwise) {
        double[][][][] out = new double[nx][ny][nz][nc];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        int n = 0;
                        while (n < nc) {
                            out[x][y][z][n] = m.get(i, n);
                            ++n;
                        }
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        int n = 0;
                        while (n < nc) {
                            out[x][y][z][n] = m.get(i, n);
                            ++n;
                        }
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static float[][][] fromMatrixFloat(Matrix m, int nx, int ny, int nc, boolean rowwise) {
        float[][][] out = new float[nx][ny][nc];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int n = 0;
                    while (n < nc) {
                        out[x][y][n] = (float)m.get(i, n);
                        ++n;
                    }
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    int n = 0;
                    while (n < nc) {
                        out[x][y][n] = (float)m.get(i, n);
                        ++n;
                    }
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static float[][][] fromVectorFloat(Matrix m, int nx, int ny, int nz, boolean rowwise) {
        float[][][] out = new float[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = (float)m.get(i, 0);
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = (float)m.get(i, 0);
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static int[][][] fromVectorInt(Matrix m, int nx, int ny, int nz, boolean rowwise) {
        int[][][] out = new int[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = (int)m.get(i, 0);
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = (int)m.get(i, 0);
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static double[][][] fromVectorDouble(Matrix m, int nx, int ny, int nz, boolean rowwise) {
        double[][][] out = new double[nx][ny][nz];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    int z = 0;
                    while (z < nz) {
                        out[x][y][z] = m.get(i, 0);
                        ++i;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            int z = 0;
            while (z < nz) {
                int y = 0;
                while (y < ny) {
                    int x = 0;
                    while (x < nx) {
                        out[x][y][z] = m.get(i, 0);
                        ++i;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        return out;
    }

    public static float[][] fromVectorFloat(Matrix m, int nx, int ny, boolean rowwise) {
        float[][] out = new float[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = (float)m.get(i, 0);
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = (float)m.get(i, 0);
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static int[][] fromVectorInt(Matrix m, int nx, int ny, boolean rowwise) {
        int[][] out = new int[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = (int)m.get(i, 0);
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = (int)m.get(i, 0);
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static double[][] fromVectorDouble(Matrix m, int nx, int ny, boolean rowwise) {
        double[][] out = new double[nx][ny];
        int i = 0;
        if (rowwise) {
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    out[x][y] = m.get(i, 0);
                    ++i;
                    ++y;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < ny) {
                int x = 0;
                while (x < nx) {
                    out[x][y] = m.get(i, 0);
                    ++i;
                    ++x;
                }
                ++y;
            }
        }
        return out;
    }

    public static double[][] fromVectorDouble(TransMatrix m) {
        double[][] out = new double[m.getDim()][m.getDim()];
        int i = 0;
        int x = 0;
        while (x < out.length) {
            int y = 0;
            while (y < out[0].length) {
                out[x][y] = m.get(x, y);
                ++i;
                ++y;
            }
            ++x;
        }
        return out;
    }

    public static float[] fromVectorFloat(Matrix m) {
        float[] out;
        int nx = m.getRowDimension();
        int ny = m.getColumnDimension();
        if (nx == 1) {
            out = new float[ny];
            int i = 0;
            while (i < ny) {
                out[i] = (float)m.get(0, i);
                ++i;
            }
        } else if (ny == 1) {
            out = new float[nx];
            int i = 0;
            while (i < nx) {
                out[i] = (float)m.get(i, 0);
                ++i;
            }
        } else {
            System.err.println("fromVector method requires that either row or columndimension equals one.");
            return null;
        }
        return out;
    }

    public static int[] fromVectorInt(Matrix m) {
        int[] out;
        int nx = m.getRowDimension();
        int ny = m.getColumnDimension();
        if (nx == 1) {
            out = new int[ny];
            int i = 0;
            while (i < ny) {
                out[i] = (int)m.get(0, i);
                ++i;
            }
        } else if (ny == 1) {
            out = new int[nx];
            int i = 0;
            while (i < nx) {
                out[i] = (int)m.get(i, 0);
                ++i;
            }
        } else {
            System.err.println("fromVector method requires that either row or columndimension equals one.");
            return null;
        }
        return out;
    }

    public static double[] fromVectorDouble(Matrix m) {
        double[] out;
        int nx = m.getRowDimension();
        int ny = m.getColumnDimension();
        if (nx == 1) {
            out = new double[ny];
            int i = 0;
            while (i < ny) {
                out[i] = m.get(0, i);
                ++i;
            }
        } else if (ny == 1) {
            out = new double[nx];
            int i = 0;
            while (i < nx) {
                out[i] = m.get(i, 0);
                ++i;
            }
        } else {
            System.err.println("fromVector method requires that either row or columndimension equals one.");
            return null;
        }
        return out;
    }

    public static final double[][] fromTransMatrix(TransMatrix tm) {
        int dim = tm.getDim();
        double[][] d = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                d[i][j] = tm.get(i, j);
                ++j;
            }
            ++i;
        }
        return d;
    }

    public static final double[][] fromTransMatrix(TransMatrix tm, double[][] d) {
        int dim = tm.getDim();
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                d[i][j] = tm.get(i, j);
                ++j;
            }
            ++i;
        }
        return d;
    }

    public static final Object[] arrayFromObjectList(List<Object> l) {
        Object[] out = new Object[l.size()];
        int i = 0;
        Iterator<Object> iterator = l.iterator();
        while (iterator.hasNext()) {
            Object n;
            out[i] = n = iterator.next();
            ++i;
        }
        return out;
    }

    public static final String[] arrayFromStringList(List<String> l) {
        String[] out = new String[l.size()];
        int i = 0;
        Iterator<String> iterator = l.iterator();
        while (iterator.hasNext()) {
            String n;
            out[i] = n = iterator.next();
            ++i;
        }
        return out;
    }

    public static final int[] arrayFromIntegerList(List<Integer> l) {
        int[] out = new int[l.size()];
        int i = 0;
        Iterator<Integer> iterator = l.iterator();
        while (iterator.hasNext()) {
            int n;
            out[i] = n = iterator.next().intValue();
            ++i;
        }
        return out;
    }

    public static final double[] arrayFromDoubleList(List<Double> l) {
        double[] out = new double[l.size()];
        int i = 0;
        Iterator<Double> iterator = l.iterator();
        while (iterator.hasNext()) {
            double n;
            out[i] = n = iterator.next().doubleValue();
            ++i;
        }
        return out;
    }

    public static final float[] arrayFromFloatList(List<Float> l) {
        float[] out = new float[l.size()];
        int i = 0;
        Iterator<Float> iterator = l.iterator();
        while (iterator.hasNext()) {
            float n;
            out[i] = n = iterator.next().floatValue();
            ++i;
        }
        return out;
    }

    public static final float[][] arrayFromfloatarrayList(List<float[]> l) {
        float[][] out = new float[l.size()][l.get(0).length];
        int i = 0;
        for (float[] n : l) {
            out[i] = n;
            ++i;
        }
        return out;
    }

    public static final int[][] arrayFromintarrayList(List<int[]> l) {
        int[][] out = new int[l.size()][l.get(0).length];
        int i = 0;
        for (int[] n : l) {
            out[i] = n;
            ++i;
        }
        return out;
    }

    public static final byte[][] arrayFrombytearrayList(List<byte[]> l) {
        byte[][] out = new byte[l.size()][l.get(0).length];
        int i = 0;
        for (byte[] n : l) {
            out[i] = n;
            ++i;
        }
        return out;
    }

    public static boolean[][] getBooleanArray2d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        boolean[][] vol = new boolean[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                vol[i][j] = img.get(i, j).byteValue() > 0;
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static boolean[][][] getBooleanArray3d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        boolean[][][] vol = new boolean[rows][cols][slices];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol[i][j][k] = img.get(i, j, k).byteValue() > 0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static byte[][] getByteArray2d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        byte[][] vol = new byte[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                vol[i][j] = img.get(i, j).byteValue();
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static byte[][][] getByteArray3d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        byte[][][] vol = new byte[rows][cols][slices];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol[i][j][k] = img.get(i, j, k).byteValue();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static int[] getIntArray1d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        int[] vol = new int[rows * cols * slices];
        int t = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol[t] = img.getInt(i, j, k);
                    ++t;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static int[][] getIntArray2d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int[][] vol = new int[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                vol[i][j] = img.get(i, j).intValue();
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static int[][][] getIntArray3d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        int[][][] vol = new int[rows][cols][slices];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol[i][j][k] = img.get(i, j, k).intValue();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static float[][][] getFloatArray3d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        float[][][] vol = new float[rows][cols][slices];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol[i][j][k] = img.get(i, j, k).floatValue();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static float[] getFloatArray1d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        float[] vol = new float[rows * cols * slices];
        int xyz = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol[xyz] = img.get(i, j, k).floatValue();
                    ++xyz;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static float[][] getFloatArray2d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        float[][] vol = new float[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                vol[i][j] = img.get(i, j).floatValue();
                ++j;
            }
            ++i;
        }
        return vol;
    }

    public static int[][][][] getIntArray4d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        int components = img.getComponents();
        int[][][][] vol4d = new int[rows][cols][slices][components];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    int l = 0;
                    while (l < components) {
                        vol4d[i][j][k][l] = img.get(i, j, k, l).intValue();
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol4d;
    }

    public static float[][] getFloatArray4dTo2d(ImageData img, boolean compfirst, int pad) {
        float[][] vol4d;
        int nx = img.getRows();
        int ny = img.getCols();
        int nz = img.getSlices();
        int nc = img.getComponents();
        int nn = 0;
        if (compfirst) {
            vol4d = new float[nc][(nx + 2 * pad) * (ny + 2 * pad) * (nz + 2 * pad)];
            int l = 0;
            while (l < nc) {
                nn = 0;
                int xx = -1;
                int yy = -1;
                int zz = -1;
                int x = 0;
                while (x < nx + 2 * pad) {
                    int y = 0;
                    while (y < ny + 2 * pad) {
                        int z = 0;
                        while (z < nz + 2 * pad) {
                            xx = x < pad ? pad - 1 - x : (x - pad >= nx ? 2 * nx - x + pad - 1 : x - pad);
                            yy = y < pad ? pad - 1 - y : (y - pad >= ny ? 2 * ny - y + pad - 1 : y - pad);
                            zz = z < pad ? pad - 1 - z : (z - pad >= nz ? 2 * nz - z + pad - 1 : z - pad);
                            vol4d[l][nn] = img.getFloat(xx, yy, zz, l);
                            ++nn;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++l;
            }
        } else {
            vol4d = new float[nc][(nx + 2 * pad) * (ny + 2 * pad) * (nz + 2 * pad)];
            int l = 0;
            while (l < nc) {
                nn = 0;
                int xx = -1;
                int yy = -1;
                int zz = -1;
                int z = 0;
                while (z < nz + 2 * pad) {
                    int y = 0;
                    while (y < ny + 2 * pad) {
                        int x = 0;
                        while (x < nx + 2 * pad) {
                            xx = x < pad ? pad - 1 - x : (x - pad >= nx ? 2 * nx - x + pad - 1 : x - pad);
                            yy = y < pad ? pad - 1 - y : (y - pad >= ny ? 2 * ny - y + pad - 1 : y - pad);
                            zz = z < pad ? pad - 1 - z : (z - pad >= nz ? 2 * nz - z + pad - 1 : z - pad);
                            vol4d[nn][l] = img.getFloat(xx, yy, zz, l);
                            ++nn;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++l;
            }
        }
        return vol4d;
    }

    public static float[][] getFloatArray4dTo2d(ImageData img, boolean compfirst) {
        return ArrayUtil.getFloatArray4dTo2d(img, compfirst, 0);
    }

    public static int[][] getIntArray4dTo2d(ImageData img, boolean compfirst, int pad) {
        int[][] vol4d;
        int nx = img.getRows();
        int ny = img.getCols();
        int nz = img.getSlices();
        int nc = img.getComponents();
        int nn = 0;
        if (compfirst) {
            vol4d = new int[nc][(nx + 2 * pad) * (ny + 2 * pad) * (nz + 2 * pad)];
            int l = 0;
            while (l < nc) {
                nn = 0;
                int xx = -1;
                int yy = -1;
                int zz = -1;
                int x = 0;
                while (x < nx + 2 * pad) {
                    int y = 0;
                    while (y < ny + 2 * pad) {
                        int z = 0;
                        while (z < nz + 2 * pad) {
                            xx = x < pad ? pad - 1 - x : (x - pad >= nx ? 2 * nx - x + pad - 1 : x - pad);
                            yy = y < pad ? pad - 1 - y : (y - pad >= ny ? 2 * ny - y + pad - 1 : y - pad);
                            zz = z < pad ? pad - 1 - z : (z - pad >= nz ? 2 * nz - z + pad - 1 : z - pad);
                            vol4d[l][nn] = img.getInt(xx, yy, zz, l);
                            ++nn;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++l;
            }
        } else {
            vol4d = new int[nc][(nx + 2 * pad) * (ny + 2 * pad) * (nz + 2 * pad)];
            int l = 0;
            while (l < nc) {
                nn = 0;
                int xx = -1;
                int yy = -1;
                int zz = -1;
                int z = 0;
                while (z < nz + 2 * pad) {
                    int y = 0;
                    while (y < ny + 2 * pad) {
                        int x = 0;
                        while (x < nx + 2 * pad) {
                            xx = x < pad ? pad - 1 - x : (x - pad >= nx ? 2 * nx - x + pad - 1 : x - pad);
                            yy = y < pad ? pad - 1 - y : (y - pad >= ny ? 2 * ny - y + pad - 1 : y - pad);
                            zz = z < pad ? pad - 1 - z : (z - pad >= nz ? 2 * nz - z + pad - 1 : z - pad);
                            vol4d[nn][l] = img.getInt(xx, yy, zz, l);
                            ++nn;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++l;
            }
        }
        return vol4d;
    }

    public static int[][] getIntArray4dTo2d(ImageData img, boolean compfirst) {
        return ArrayUtil.getIntArray4dTo2d(img, compfirst, 0);
    }

    public static float[][][][] getFloatArray4d(ImageData img) {
        int rows = img.getRows();
        int cols = img.getCols();
        int slices = img.getSlices();
        int components = img.getComponents();
        float[][][][] vol4d = new float[rows][cols][slices][components];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    int l = 0;
                    while (l < components) {
                        vol4d[i][j][k][l] = img.get(i, j, k, l).floatValue();
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol4d;
    }

    public static float[][][] getFloatArray3d(ModelImage img) {
        int rows = img.getExtents()[0];
        int cols = img.getExtents()[1];
        int slices = img.getExtents()[2];
        float[][][] vol3d = new float[rows][cols][slices];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol3d[i][j][k] = img.get(i, j, k).floatValue();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol3d;
    }

    public static byte[][][] getByteArray3d(ModelImage img) {
        int rows = img.getExtents()[0];
        int cols = img.getExtents()[1];
        int slices = img.getExtents()[2];
        byte[][][] vol3d = new byte[rows][cols][slices];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    vol3d[i][j][k] = img.get(i, j, k).byteValue();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vol3d;
    }

    public static void modelImgTo1d(ModelImage img, float[] x) {
        int rows = img.getExtents()[0];
        int cols = img.getExtents()[1];
        int slices = img.getExtents()[2];
        int n = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    x[n] = img.get(i, j, k).floatValue();
                    ++n;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void modelImgTo1d(ModelImage img, byte[] x) {
        int rows = img.getExtents()[0];
        int cols = img.getExtents()[1];
        int slices = img.getExtents()[2];
        int n = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int k = 0;
                while (k < slices) {
                    x[n] = img.get(i, j, k).byteValue();
                    ++n;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        int[][] testa = new int[3][5];
        testa[0][0] = 1;
        testa[0][1] = 2;
        testa[0][2] = 3;
        testa[0][3] = 4;
        testa[0][4] = 5;
        testa[1][0] = 10;
        testa[1][1] = 20;
        testa[1][2] = 30;
        testa[1][3] = 40;
        testa[1][4] = 50;
        testa[2][0] = 100;
        testa[2][1] = 200;
        testa[2][2] = 300;
        testa[2][3] = 400;
        testa[2][4] = 500;
        System.out.println(ArrayUtil.printArray(testa));
        System.out.println(ArrayUtil.printArray(ArrayUtil.get1dSubArray(testa, 2, 2, 5, true)));
    }
}

