/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.oct.structures;

import edu.jhmi.rad.medic.oct.RepositoryChangeListener;
import edu.jhmi.rad.medic.oct.structures.RepositoryException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ObjectRepository<Key, Data> {
    protected ArrayList<Tuple> m_ObjectList = new ArrayList();
    protected boolean m_EnforceUnique;
    protected Vector<RepositoryChangeListener> m_Listeners;

    public ObjectRepository() {
        this.m_EnforceUnique = true;
        this.m_Listeners = new Vector();
    }

    public ObjectRepository(boolean useUnique) {
        this.m_EnforceUnique = useUnique;
        this.m_Listeners = new Vector();
    }

    public void addChangeListener(RepositoryChangeListener listener) {
        if (listener != null && !this.m_Listeners.contains(listener)) {
            this.m_Listeners.add(listener);
        }
    }

    public void removeChangeListener(RepositoryChangeListener listener) {
        if (listener != null && this.m_Listeners.contains(listener)) {
            this.m_Listeners.remove(listener);
        }
    }

    protected void fireChangeListeners() {
        int i = 0;
        while (i < this.m_Listeners.size()) {
            if (this.m_Listeners.get(i) != null) {
                this.m_Listeners.get(i).changed(this);
            }
            ++i;
        }
    }

    public void add(Key key, Data data) throws RepositoryException {
        this.add(key, data, false);
    }

    public void flushTemporary() {
        List<Tuple> instanceList = this.getTemporaryInstances();
        Iterator<Tuple> iterator = instanceList.iterator();
        while (iterator.hasNext()) {
            this.m_ObjectList.remove(iterator.next());
        }
        this.fireChangeListeners();
    }

    public void add(Key key, Data data, boolean temp) throws RepositoryException {
        System.out.println("Storing : " + key);
        if (key == null) {
            throw new RepositoryException("Key cannot be null.");
        }
        if (this.m_EnforceUnique) {
            for (Tuple p : this.m_ObjectList) {
                if (!p.key.equals(key)) continue;
                throw new RepositoryException("Key must be Unique.");
            }
        }
        Tuple p = new Tuple();
        p.key = key;
        p.data = data;
        p.temporaryFlag = temp;
        this.m_ObjectList.add(p);
        this.fireChangeListeners();
    }

    public void remove(Key key) throws RepositoryException {
        List<Tuple> instanceList = this.getInstances(key);
        Iterator<Tuple> iterator = instanceList.iterator();
        while (iterator.hasNext()) {
            this.m_ObjectList.remove(iterator.next());
        }
        this.fireChangeListeners();
    }

    public List<Tuple> getTemporaryInstances() {
        ArrayList<Tuple> instanceList = new ArrayList<Tuple>();
        for (Tuple p : this.m_ObjectList) {
            if (!p.temporaryFlag) continue;
            instanceList.add(p);
        }
        return instanceList;
    }

    public List<Tuple> getInstances(Key key) {
        ArrayList<Tuple> instanceList = new ArrayList<Tuple>();
        for (Tuple p : this.m_ObjectList) {
            if (!p.key.equals(key)) continue;
            instanceList.add(p);
        }
        return instanceList;
    }

    public Data get(Key key) {
        Data d = null;
        for (Tuple p : this.m_ObjectList) {
            if (!p.key.equals(key)) continue;
            d = p.data;
            break;
        }
        return d;
    }

    public void clear() {
        for (Tuple p : this.m_ObjectList) {
            p.data = null;
            p.key = null;
        }
        this.m_ObjectList.clear();
        this.fireChangeListeners();
        System.gc();
    }

    public String toString() {
        Iterator<Tuple> it = this.m_ObjectList.iterator();
        String s = "Object Repository " + this.hashCode() + " with keys:";
        while (it.hasNext()) {
            s = String.valueOf(s) + "\t" + it.next().key + "\n";
        }
        return s;
    }

    public class Tuple {
        public Data data;
        public Key key;
        public boolean temporaryFlag = false;
    }
}

