/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.structures;

public class BinaryHeap2D {
    private float[] val;
    private int[] id;
    private int[] state;
    private int currentSize = 0;
    private int capacity;
    private int minormax;
    public static final int MINTREE = -1;
    public static final int MAXTREE = 1;

    public BinaryHeap2D(int Nsize, int type) {
        this.capacity = Nsize;
        this.minormax = type;
        this.val = new float[this.capacity + 1];
        this.id = new int[this.capacity + 1];
        this.state = new int[this.capacity + 1];
        if (this.minormax == -1) {
            this.val[0] = -1.0E12f;
        } else if (this.minormax == 1) {
            this.val[0] = 1.0E12f;
        }
    }

    public void finalize() {
        this.val = null;
        this.id = null;
        this.state = null;
    }

    public final void reset() {
        this.currentSize = 0;
    }

    public final void setMaxTree() {
        this.minormax = 1;
        this.val[0] = 1.0E12f;
    }

    public final void setMinTree() {
        this.minormax = -1;
        this.val[0] = -1.0E12f;
    }

    public final void addValue(float val_, int id_, int state_) {
        if (this.currentSize == this.val.length - 1) {
            float[] oldVal = this.val;
            int[] oldId = this.id;
            int[] oldState = this.state;
            this.val = new float[this.currentSize + this.capacity];
            this.id = new int[this.currentSize + this.capacity];
            this.state = new int[this.currentSize + this.capacity];
            int i = 0;
            while (i < oldVal.length) {
                this.val[i] = oldVal[i];
                this.id[i] = oldId[i];
                this.state[i] = oldState[i];
                ++i;
            }
            oldVal = null;
            oldId = null;
            oldState = null;
        }
        int hole = ++this.currentSize;
        if (this.minormax == -1) {
            while (val_ < this.val[hole / 2]) {
                this.val[hole] = this.val[hole / 2];
                this.id[hole] = this.id[hole / 2];
                this.state[hole] = this.state[hole / 2];
                hole /= 2;
            }
            this.val[hole] = val_;
            this.id[hole] = id_;
            this.state[hole] = state_;
        } else if (this.minormax == 1) {
            while (val_ > this.val[hole / 2]) {
                this.val[hole] = this.val[hole / 2];
                this.id[hole] = this.id[hole / 2];
                this.state[hole] = this.state[hole / 2];
                hole /= 2;
            }
            this.val[hole] = val_;
            this.id[hole] = id_;
            this.state[hole] = state_;
        }
    }

    public final void removeFirst() {
        int hole = 1;
        this.val[hole] = this.val[this.currentSize];
        this.id[hole] = this.id[this.currentSize];
        this.state[hole] = this.state[this.currentSize];
        --this.currentSize;
        float tmp = this.val[hole];
        int tmpId = this.id[hole];
        int tmpState = this.state[hole];
        if (this.minormax == -1) {
            while (hole * 2 <= this.currentSize) {
                int child = hole * 2;
                if (child != this.currentSize && this.val[child + 1] < this.val[child]) {
                    ++child;
                }
                if (!(this.val[child] < tmp)) break;
                this.val[hole] = this.val[child];
                this.id[hole] = this.id[child];
                this.state[hole] = this.state[child];
                hole = child;
            }
            this.val[hole] = tmp;
            this.id[hole] = tmpId;
            this.state[hole] = tmpState;
        } else if (this.minormax == 1) {
            while (hole * 2 <= this.currentSize) {
                int child = hole * 2;
                if (child != this.currentSize && this.val[child + 1] > this.val[child]) {
                    ++child;
                }
                if (!(this.val[child] > tmp)) break;
                this.val[hole] = this.val[child];
                this.id[hole] = this.id[child];
                this.state[hole] = this.state[child];
                hole = child;
            }
            this.val[hole] = tmp;
            this.id[hole] = tmpId;
            this.state[hole] = tmpState;
        }
    }

    public final float getFirst() {
        return this.val[1];
    }

    public final int getFirstId() {
        return this.id[1];
    }

    public final int getFirstState() {
        return this.state[1];
    }

    public final float get(int n) {
        return this.val[n];
    }

    public final float getId(int n) {
        return this.id[n];
    }

    public final float getState(int n) {
        return this.state[n];
    }

    public final void print() {
        int n = 2;
        int i = 1;
        while (i < this.currentSize) {
            System.out.print("  " + (int)(100.0f * this.val[i]));
            if (i % n == n - 1) {
                System.out.print("\n");
                n *= 2;
            }
            ++i;
        }
    }

    public final boolean isNotEmpty() {
        return this.currentSize > 0;
    }

    public final int getCurrentSize() {
        return this.currentSize;
    }

    public final boolean isBinaryTree() {
        boolean isBinary;
        block4: {
            block5: {
                isBinary = true;
                if (this.minormax != -1) break block5;
                int i = 2;
                while (i < this.currentSize) {
                    int n = i / 2;
                    if (this.val[n] > this.val[i]) {
                        isBinary = false;
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (this.minormax != 1) break block4;
            int i = 2;
            while (i < this.currentSize) {
                int n = i / 2;
                if (this.val[n] < this.val[i]) {
                    isBinary = false;
                    break;
                }
                ++i;
            }
        }
        return isBinary;
    }
}

