/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.structures;

public class BinaryHeap4D {
    private float[] val;
    private short[] x;
    private short[] y;
    private short[] z;
    private short[] k;
    private int currentSize = 0;
    private int capacity;
    private int minormax;
    public static final int MINTREE = -1;
    public static final int MAXTREE = 1;

    public BinaryHeap4D(int Nsize, int type) {
        this.capacity = Nsize;
        this.minormax = type;
        this.val = new float[this.capacity + 1];
        this.x = new short[this.capacity + 1];
        this.y = new short[this.capacity + 1];
        this.z = new short[this.capacity + 1];
        this.k = new short[this.capacity + 1];
        if (this.minormax == -1) {
            this.val[0] = -1.0E12f;
        } else if (this.minormax == 1) {
            this.val[0] = 1.0E12f;
        }
    }

    public void finalize() {
        this.val = null;
        this.x = null;
        this.y = null;
        this.z = null;
        this.k = null;
    }

    public final void reset() {
        this.currentSize = 0;
    }

    public final void setMaxTree() {
        this.minormax = 1;
        this.val[0] = 1.0E12f;
    }

    public final void setMinTree() {
        this.minormax = -1;
        this.val[0] = -1.0E12f;
    }

    public final void addValue(float val_, int x_, int y_, int z_, int k_) {
        this.addValue(val_, (short)x_, (short)y_, (short)z_, (short)k_);
    }

    public final void addValue(float val_, short x_, short y_, short z_, short k_) {
        if (this.currentSize == this.val.length - 1) {
            float[] oldVal = this.val;
            short[] oldX = this.x;
            short[] oldY = this.y;
            short[] oldZ = this.z;
            short[] oldK = this.k;
            this.val = new float[this.currentSize + this.capacity];
            this.x = new short[this.currentSize + this.capacity];
            this.y = new short[this.currentSize + this.capacity];
            this.z = new short[this.currentSize + this.capacity];
            this.k = new short[this.currentSize + this.capacity];
            int i = 0;
            while (i < oldVal.length) {
                this.val[i] = oldVal[i];
                this.x[i] = oldX[i];
                this.y[i] = oldY[i];
                this.z[i] = oldZ[i];
                this.k[i] = oldK[i];
                ++i;
            }
        }
        int hole = ++this.currentSize;
        if (this.minormax == -1) {
            while (val_ < this.val[hole / 2]) {
                this.val[hole] = this.val[hole / 2];
                this.x[hole] = this.x[hole / 2];
                this.y[hole] = this.y[hole / 2];
                this.z[hole] = this.z[hole / 2];
                this.k[hole] = this.k[hole / 2];
                hole /= 2;
            }
            this.val[hole] = val_;
            this.x[hole] = x_;
            this.y[hole] = y_;
            this.z[hole] = z_;
            this.k[hole] = k_;
        } else if (this.minormax == 1) {
            while (val_ > this.val[hole / 2]) {
                this.val[hole] = this.val[hole / 2];
                this.x[hole] = this.x[hole / 2];
                this.y[hole] = this.y[hole / 2];
                this.z[hole] = this.z[hole / 2];
                this.k[hole] = this.k[hole / 2];
                hole /= 2;
            }
            this.val[hole] = val_;
            this.x[hole] = x_;
            this.y[hole] = y_;
            this.z[hole] = z_;
            this.k[hole] = k_;
        }
    }

    public final void removeFirst() {
        int hole = 1;
        this.val[hole] = this.val[this.currentSize];
        this.x[hole] = this.x[this.currentSize];
        this.y[hole] = this.y[this.currentSize];
        this.z[hole] = this.z[this.currentSize];
        this.k[hole] = this.k[this.currentSize];
        --this.currentSize;
        float tmp = this.val[hole];
        short tmpX = this.x[hole];
        short tmpY = this.y[hole];
        short tmpZ = this.z[hole];
        short tmpK = this.k[hole];
        if (this.minormax == -1) {
            while (hole * 2 <= this.currentSize) {
                int child = hole * 2;
                if (child != this.currentSize && this.val[child + 1] < this.val[child]) {
                    ++child;
                }
                if (!(this.val[child] < tmp)) break;
                this.val[hole] = this.val[child];
                this.x[hole] = this.x[child];
                this.y[hole] = this.y[child];
                this.z[hole] = this.z[child];
                this.k[hole] = this.k[child];
                hole = child;
            }
            this.val[hole] = tmp;
            this.x[hole] = tmpX;
            this.y[hole] = tmpY;
            this.z[hole] = tmpZ;
            this.k[hole] = tmpK;
        } else if (this.minormax == 1) {
            while (hole * 2 <= this.currentSize) {
                int child = hole * 2;
                if (child != this.currentSize && this.val[child + 1] > this.val[child]) {
                    ++child;
                }
                if (!(this.val[child] > tmp)) break;
                this.val[hole] = this.val[child];
                this.x[hole] = this.x[child];
                this.y[hole] = this.y[child];
                this.z[hole] = this.z[child];
                this.k[hole] = this.k[child];
                hole = child;
            }
            this.val[hole] = tmp;
            this.x[hole] = tmpX;
            this.y[hole] = tmpY;
            this.z[hole] = tmpZ;
            this.k[hole] = tmpK;
        }
    }

    public final float getFirst() {
        return this.val[1];
    }

    public final short getFirstX() {
        return this.x[1];
    }

    public final short getFirstY() {
        return this.y[1];
    }

    public final short getFirstZ() {
        return this.z[1];
    }

    public final short getFirstK() {
        return this.k[1];
    }

    public final void print() {
        int n = 2;
        int i = 1;
        while (i < this.currentSize) {
            System.out.print("  " + (int)(100.0f * this.val[i]));
            if (i % n == n - 1) {
                System.out.print("\n");
                n *= 2;
            }
            ++i;
        }
    }

    public final boolean isNotEmpty() {
        return this.currentSize > 0;
    }

    public final int getCurrentSize() {
        return this.currentSize;
    }

    public final boolean isBinaryTree() {
        boolean isBinary;
        block4: {
            block5: {
                isBinary = true;
                if (this.minormax != -1) break block5;
                int i = 2;
                while (i < this.currentSize) {
                    int n = i / 2;
                    if (this.val[n] > this.val[i]) {
                        isBinary = false;
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (this.minormax != 1) break block4;
            int i = 2;
            while (i < this.currentSize) {
                int n = i / 2;
                if (this.val[n] < this.val[i]) {
                    isBinary = false;
                    break;
                }
                ++i;
            }
        }
        return isBinary;
    }
}

