/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.structures;

public class GraphNode {
    private int label;
    private int[] connected;
    private int Nc;
    private int Nmax;
    private static final int MIN_NODES = 2;

    public GraphNode(int lb) {
        this.label = lb;
        this.Nc = 0;
        this.Nmax = 2;
        this.connected = new int[this.Nmax];
    }

    public GraphNode(int lb, int max) {
        this.label = lb;
        this.Nc = 0;
        this.Nmax = max;
        this.connected = new int[max];
    }

    public GraphNode(int lb, int[] connect, int N) {
        this.label = lb;
        this.connected = new int[N];
        int n = 0;
        while (n < N) {
            this.connected[n] = connect[n];
            ++n;
        }
        this.Nc = N;
        this.Nmax = N;
    }

    public void finalize() {
        this.connected = null;
        this.Nc = 0;
        this.Nmax = 0;
    }

    public final void addLinkTo(int lb) {
        if (this.Nc >= this.Nmax) {
            int[] tmp = new int[this.Nc];
            int n = 0;
            while (n < this.Nc) {
                tmp[n] = this.connected[n];
                ++n;
            }
            this.Nmax = Math.max(2 * this.Nmax, 1);
            this.connected = new int[this.Nmax];
            n = 0;
            while (n < this.Nc) {
                this.connected[n] = tmp[n];
                ++n;
            }
            int[] nArray = null;
        }
        this.connected[this.Nc] = lb;
        ++this.Nc;
    }

    public final void removeLinkAt(int indx) {
        int n = indx + 1;
        while (n < this.Nc) {
            this.connected[n - 1] = this.connected[n];
            ++n;
        }
        --this.Nc;
    }

    public final void removeLinkTo(int lb) {
        int n = 0;
        while (n < this.Nc) {
            if (this.connected[n] == lb) {
                this.removeLinkAt(n);
                break;
            }
            ++n;
        }
    }

    public final int getLabel() {
        return this.label;
    }

    public final int getLinkSize() {
        return this.Nc;
    }

    public final int getMaxSize() {
        return this.Nmax;
    }

    public final int[] getLinks() {
        return this.connected;
    }

    public final int getLinkAt(int n) {
        return this.connected[n];
    }

    public final void setLinkAt(int n, int lb) {
        this.connected[n] = lb;
    }

    public final boolean isLinkedTo(int lb) {
        int n = 0;
        while (n < this.Nc) {
            if (this.connected[n] == lb) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean equals(GraphNode nod) {
        return this.label == nod.getLabel();
    }

    public final boolean equals(int lb) {
        return this.label == lb;
    }

    public final String printNode() {
        String message = new String();
        message = message.concat(this.label + " ->");
        int n = 0;
        while (n < this.Nc) {
            message = message.concat(" " + this.connected[n] + ",");
            ++n;
        }
        return message;
    }
}

