/*
 * Decompiled with CFR 0.152.
 */
package edu.jhmi.rad.medic.utilities;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class ImageUncropper
extends AbstractCalculation {
    public ImageUncropper() {
        this.setLabel("Image Uncropper");
    }

    public final ImageData solve(ImageData _f, int upRow, int downRow, int leftColumn, int rightColumn, int upSlice, int downSlice, float val) {
        System.out.println("Uncropping Image...");
        ImageDataFloat f = new ImageDataFloat(_f);
        String name = String.valueOf(f.getName()) + "_Uncropped";
        int nx = f.getRows();
        int ny = f.getCols();
        int nz = f.getSlices();
        int nc = f.getComponents();
        System.out.println("Original dimension :(" + nx + ", " + ny + ", " + nz + ")");
        int mx = nx + upRow + downRow;
        int my = ny + leftColumn + rightColumn;
        int mz = nz + upSlice + downSlice;
        System.out.println("New Dimensions: (" + mx + ", " + my + ", " + mz + ")");
        ImageDataFloat V = null;
        if (nc == 1) {
            this.setTotalUnits(1L);
            V = new ImageDataFloat(mx, my, mz);
            float[][][] image = f.toArray3d();
            float[][][] Vmat = V.toArray3d();
            int x = 0;
            while (x < mx) {
                int y = 0;
                while (y < my) {
                    int z = 0;
                    while (z < mz) {
                        Vmat[x][y][z] = upRow - 1 < x && x < nx + upRow && leftColumn - 1 < y && y < ny + leftColumn && upSlice - 1 < z && z < nz + upSlice ? image[x - upRow][y - leftColumn][z - upSlice] : val;
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            this.incrementCompletedUnits();
        } else {
            this.setTotalUnits(nc);
            V = new ImageDataFloat(mx, my, mz, nc);
            float[][][][] image = f.toArray4d();
            float[][][][] Vmat = V.toArray4d();
            int l = 0;
            while (l < nc) {
                int x = 0;
                while (x < mx) {
                    int y = 0;
                    while (y < my) {
                        int z = 0;
                        while (z < mz) {
                            Vmat[x][y][z][l] = upRow - 1 < x && x < nx + upRow && leftColumn - 1 < y && y < ny + leftColumn && upSlice - 1 < z && z < nz + upSlice ? image[x - upRow][y - leftColumn][z - upSlice][l] : val;
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                this.incrementCompletedUnits();
                ++l;
            }
        }
        V.setName(name);
        this.markCompleted();
        return V;
    }
}

