package edu.jhu.ece.iacl.algorithms.MGDM.forces;

/**
 * Enumeration for different types of forces supported by MGDM.
 * @author Bhaskar Kishore
 * @author John Bogovic
 *
 */
public class MgdmConstants {
	public static final int INVALID = -1;
	public static final MgdmBoundary NOBOUNDARY = new MgdmBoundary(-1,-1);
	public static final MgdmBoundary ANYBOUNDARY = new MgdmBoundary(-2,-2);
	
	public enum ForceType {
		CURVATURE,
		PRESSURE,
		REGION,
		FIELD,
		INTENSITY,
		ATLAS,
		LUA,
		CUSTOM;
	};
	
	public static String[] forceClassList = new String[]{
		"MgdmForceCurvature",
		"MgdmForcePressure",
		"MgdmForceRegion",
		"MgdmForceField",
		"MgdmForceIntensity",
		"MgdmForceLua",
		"MgdmForceCustom"
	};
	
	public enum Labels {
		UNKNOWN,
		WHITE_MATTER ,
		GREY_MATTER,
		CSF,
		VENTRICAL;
	};
}
