package edu.jhu.ece.iacl.algorithms.MGDM.forces;

import edu.jhu.ece.iacl.algorithms.MGDM.GdmDerivatives;
import edu.jhu.ece.iacl.algorithms.MGDM.forces.MgdmConstants.ForceType;

/**
 * An empty mgdm custom force class
 * @author Bhaskar Kishore
 * @author John Bogovic
 *
 */
public class MgdmForceCustom extends MgdmForce {

	private static MgdmConstants.ForceType type = ForceType.CUSTOM;
	
	public MgdmForceCustom() {
		super(ForceType.CUSTOM, 0.0, MgdmConstants.INVALID);
	}
	
	public MgdmForceCustom(ForceType typein, double w, int id){
		super(type, w, id);
	}

	@Override
	public void initForce(MgdmDataRepository repo) {
		// Do nothing
	}

	@Override
	public double getForce(int xyz, int lbl, int nbr, GdmDerivatives dr, int iteration,
			MgdmDataRepository repo, float flipValue, boolean debug) {
		// Do nothing
		return 0;
	}
	
	public void fromParameters(String[] params){
		// Do nothing
	}
	
	public MgdmForceCustom clone(){
		return new MgdmForceCustom();
	}
}
