package edu.jhu.ece.iacl.algorithms.MGDM.test;

import static org.junit.Assert.*;

import org.junit.Test;

import edu.jhu.ece.iacl.algorithms.MGDM.*;

public class MgdmDerivativesTest {
	
	@Test
	public void testDerivativeResolution() {
		float[][][] phi = new float[3][3][3];
		for(int x=1; x<3; x++)for(int y=0; y<3; y++)for(int z=0; z<3; z++){
			phi[x][y][z] = x;
		}
		// System.out.println("phi:\n"+ArrayUtil.printArray(phi));
		
		// test dx
		GdmDerivatives dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		assertEquals(1,dr.D0x(),0.000001);
		
		// test dx with coarser resolution
		dr = GdmDerivatives.computeDerivatives(phi, 2f, 1f, 1f);
		assertEquals(0.5,dr.D0x(),0.000001);
		
		// make sure resolutions dont affect things accross dimensions
		dr = GdmDerivatives.computeDerivatives(phi, 2f, 2f, 2f);
		assertEquals(0.5,dr.D0x(),0.000001);
		
		
		
		phi = new float[3][3][3];
		for(int x=0; x<3; x++)for(int y=1; y<3; y++)for(int z=0; z<3; z++){
			phi[x][y][z] = y;
		}
		
		// test dy
		dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		assertEquals(0,dr.D0x(),0.000001);
		assertEquals(1,dr.D0y(),0.000001);
		
		
		phi = new float[3][3][3];
		for(int x=0; x<3; x++)for(int y=0; y<3; y++)for(int z=1; z<3; z++){
			phi[x][y][z] = z;
		}
		
		// test dy
		dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		assertEquals(0,dr.D0x(),0.000001);
		assertEquals(0,dr.D0y(),0.000001);
		assertEquals(1,dr.D0z(),0.000001);
		
		
	}
	
	
	@Test
	public void testForwardVsBackwardDifferences() {
		
		// X
		float[][][] phi = new float[3][3][3];
		for(int x=1; x<3; x++)for(int y=0; y<3; y++)for(int z=0; z<3; z++){
			phi[x][y][z] = 1;
		}
		GdmDerivatives dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		assertEquals(1,dr.Dmx(),0.000001);
		assertEquals(0,dr.Dpx(),0.000001);
		assertEquals(0.5,dr.D0x(),0.000001);
		
		// Y
		phi = new float[3][3][3];
		for(int x=0; x<3; x++)for(int y=1; y<3; y++)for(int z=0; z<3; z++){
			phi[x][y][z] = 1;
		}
		
		dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		assertEquals(1,dr.Dmy(),0.000001);
		assertEquals(0,dr.Dpy(),0.000001);
		assertEquals(0.5,dr.D0y(),0.000001);
		
		// Z
		phi = new float[3][3][3];
		for(int x=0; x<3; x++)for(int y=0; y<3; y++)for(int z=1; z<3; z++){
			phi[x][y][z] = 1;
		}
		
		dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		assertEquals(1,dr.Dmz(),0.000001);
		assertEquals(0,dr.Dpz(),0.000001);
		assertEquals(0.5,dr.D0z(),0.000001);
		
		
	}

}
