package edu.jhu.ece.iacl.algorithms.MGDM.test;

import java.io.File;
import java.net.URL;

import org.junit.Test;

import edu.jhu.ece.iacl.algorithms.MGDM.*;
import edu.jhu.ece.iacl.algorithms.MGDM.forces.*;

public class MgdmEvolutionTest {
	
//	public static MgdmForceSpec setUpTestForces(){
////		
////		MgdmForceSpec mgdmForces = new MgdmForceSpec();
////		
////		MgdmBoundary bnd0v1 = new MgdmBoundary(0,1);
////		
////		mgdmForces.addForce(bnd0v1, new MgdmForceCurvature(MgdmConstants.ForceType.CURVATURE, 0.1, 1));
////		mgdmForces.addForce(bnd0v1, new MgdmForcePressure(MgdmConstants.ForceType.PRESSURE, 0.1, 2));
////		mgdmForces.addForce(bnd0v1,  new MgdmForceField(MgdmConstants.ForceType.FIELD, 2.0, 3));
//		
//		
//		File configf = new File("C:\\Users\\John\\Documents\\Research\\testDat\\mgdmConfigSample.txt");
//		MgdmBoundaryForces bndforces = new MgdmBoundaryForces(configf);
//		
//		MgdmForceSpec mgdmForces = MgdmForceSpec.MgdmWeights2Spec(bndforces);
//		
//		return mgdmForces;
//		
//	}
	

//	@Test
//	public void testIntensity3d(){
//		MgdmEvolutionTest t = new MgdmEvolutionTest();
//		
//		URL url = t.getClass().getResource("ini3d.bin.gz");
//		int[][][] ini3d = MgdmTestUtils.<int[][][]>deserializeCompressObject(new File(url.getFile()));
//		
//		MgdmDecomposition mgdmdecomp = new MgdmDecomposition(ini3d);
//
//		MgdmDataRepository repo = new MgdmDataRepository();
//		try{
//			
//			URL urlint = t.getClass().getResource("int3d.bin.gz");
//			float[][][] intdat = MgdmTestUtils.<float[][][]>deserializeCompressObject(new File(urlint.getFile()));
//			
//			System.out.println("numintensity: " + intdat.length);
//			repo.addVolume("intensityforces", intdat);
//			
//		}catch(Exception e){
//			e.printStackTrace();
//		}
//		
//		MgdmForceSpec mgdmForces = new MgdmForceSpec();
//		
//		MgdmBoundary bnd1v5 = new MgdmBoundary(1,5);
//		MgdmBoundary bnd2v5 = new MgdmBoundary(2,5);
//		
//		mgdmForces.addForce(bnd1v5, new MgdmForceIntensity(MgdmConstants.ForceType.INTENSITY, 0.7, 2));
//		mgdmForces.addForce(bnd2v5, new MgdmForceIntensity(MgdmConstants.ForceType.INTENSITY, 0.7, 3));
//		
//		
//		MgdmEvolution mgdmevo = new MgdmEvolution(mgdmdecomp);
//		mgdmevo.setForce(mgdmForces); 			// set forces for mgdm 
//		mgdmevo.setDataRepository(repo);		// set data for mgdm 
//		mgdmevo.evolveNarrowBand(6,5);
//		
//	}
//	
//	@Test
//	public void testIntensity2d(){
//		MgdmEvolutionTest t = new MgdmEvolutionTest();
//		
//		URL url = t.getClass().getResource("ini3d.bin.gz");
//		int[][][] ini3d = MgdmTestUtils.<int[][][]>deserializeCompressObject(new File(url.getFile()));
//		
//		int[][] ini2d = new int[ini3d.length][ini3d[0].length];
//		for(int i=0; i<ini2d.length; i++)for(int j=0; j<ini2d[0].length; j++){
//			ini2d[i][j]=ini3d[i][j][3];
//		}
//		
//		MgdmDecomposition mgdmdecomp = new MgdmDecomposition(ini2d);
//
//		MgdmDataRepository repo = new MgdmDataRepository();
//		try{
//			
//			URL urlint = t.getClass().getResource("int3d.bin.gz");
//			float[][][] intdat = MgdmTestUtils.<float[][][]>deserializeCompressObject(new File(urlint.getFile()));
//			
//			float[][] int2d = new float[intdat.length][intdat[0].length];
//			for(int i=0; i<ini2d.length; i++)for(int j=0; j<ini2d[0].length; j++){
//				int2d[i][j]=intdat[i][j][3];
//			}
//			
//			repo.addImage("intensityforces", int2d);
//			
//		}catch(Exception e){
//			e.printStackTrace();
//		}
//		
//		MgdmForceSpec mgdmForces = new MgdmForceSpec();
//		
//		MgdmBoundary bnd1v5 = new MgdmBoundary(1,5);
//		MgdmBoundary bnd2v5 = new MgdmBoundary(2,5);
//		
//		mgdmForces.addForce(bnd1v5, new MgdmForceIntensity(MgdmConstants.ForceType.INTENSITY, 0.7, 2));
//		mgdmForces.addForce(bnd2v5, new MgdmForceIntensity(MgdmConstants.ForceType.INTENSITY, 0.7, 3));
//		
//		
//		MgdmEvolution mgdmevo = new MgdmEvolution(mgdmdecomp);
//		mgdmevo.setForce(mgdmForces); 			// set forces for mgdm 
//		mgdmevo.setDataRepository(repo);		// set data for mgdm 
//		mgdmevo.evolveNarrowBand(6,5);
//		
//	}
	
	@Test
	public void testRegion3d(){
		MgdmEvolutionTest t = new MgdmEvolutionTest();
		
		URL url = t.getClass().getResource("ini3d.bin.gz");
		int[][][] ini3d = MgdmTestUtils.<int[][][]>deserializeCompressObject(new File(url.getFile()));
		
		MgdmDecomposition mgdmdecomp = new MgdmDecomposition(ini3d);

		MgdmDataRepository repo = new MgdmDataRepository();
		try{
			
			URL urlint = t.getClass().getResource("reg3d.bin.gz");
			float[][][] intdat = MgdmTestUtils.<float[][][]>deserializeCompressObject(new File(urlint.getFile()));
			
			System.out.println("intdat: " + intdat.length +" " + intdat[0].length+" " + intdat[0][0].length );
			
			System.out.println("numregion: " + intdat.length);
			repo.addVolume("regionforces", intdat);
			
		}catch(Exception e){
			e.printStackTrace();
		}
		
		MgdmForceSpec mgdmForces = new MgdmForceSpec();
		
		MgdmBoundary bnd1v2 = new MgdmBoundary(1,2);
		MgdmBoundary bnd3v4 = new MgdmBoundary(3,4);
		
		mgdmForces.addForce(bnd1v2, new MgdmForceRegion(0.7, 0, 0.4));
		mgdmForces.addForce(bnd3v4, new MgdmForceRegion(0.7, 0, 0.4));
		
		
		MgdmEvolution mgdmevo = new MgdmEvolution(mgdmdecomp);
		mgdmevo.setForce(mgdmForces); 			// set forces for mgdm 
		mgdmevo.setDataRepository(repo);		// set data for mgdm 
		mgdmevo.evolveNarrowBand(15,5);
		
	}
	
	@Test
	public void testRegion2d(){
		MgdmEvolutionTest t = new MgdmEvolutionTest();
		
		URL url = t.getClass().getResource("ini3d.bin.gz");
		int[][][] ini3d = MgdmTestUtils.<int[][][]>deserializeCompressObject(new File(url.getFile()));
		
		int[][] ini2d = new int[ini3d.length][ini3d[0].length];
		for(int i=0; i<ini2d.length; i++)for(int j=0; j<ini2d[0].length; j++){
			ini2d[i][j]=ini3d[i][j][3];
		}
		
		MgdmDecomposition mgdmdecomp = new MgdmDecomposition(ini2d);

		MgdmDataRepository repo = new MgdmDataRepository();
		try{
			
			URL urlint = t.getClass().getResource("reg3d.bin.gz");
			float[][][] intdat = MgdmTestUtils.<float[][][]>deserializeCompressObject(new File(urlint.getFile()));
			
			float[][] int2d = new float[intdat.length][intdat[0].length];
			for(int i=0; i<ini2d.length; i++)for(int j=0; j<ini2d[0].length; j++){
				int2d[i][j]=intdat[i][j][3];
			}
			
			
			repo.addImage("regionforces", int2d);
			
		}catch(Exception e){
			e.printStackTrace();
		}
		
		MgdmForceSpec mgdmForces = new MgdmForceSpec();
		
		MgdmBoundary bnd1v2 = new MgdmBoundary(1,2);
		MgdmBoundary bnd3v4 = new MgdmBoundary(3,4);
		
		mgdmForces.addForce(bnd1v2, new MgdmForceRegion(0.7, 0, 0.4));
		mgdmForces.addForce(bnd3v4, new MgdmForceRegion(0.7, 0, 0.4));
		
		
		MgdmEvolution mgdmevo = new MgdmEvolution(mgdmdecomp);
		mgdmevo.setForce(mgdmForces); 			// set forces for mgdm 
		mgdmevo.setDataRepository(repo);		// set data for mgdm 
		mgdmevo.evolveNarrowBand(15,5);
		
	}
	
	@Test
	public void testAll3d(){
		MgdmEvolutionTest t = new MgdmEvolutionTest();
		
		URL url = t.getClass().getResource("ini3d.bin.gz");
		int[][][] ini3d = MgdmTestUtils.<int[][][]>deserializeCompressObject(new File(url.getFile()));
		
		MgdmDecomposition mgdmdecomp = new MgdmDecomposition(ini3d);

		MgdmDataRepository repo = new MgdmDataRepository();
		try{
			
			// region volume
			URL urlreg = t.getClass().getResource("reg3d.bin.gz");
			float[][][] regdat = MgdmTestUtils.<float[][][]>deserializeCompressObject(new File(urlreg.getFile()));
			repo.addVolume("regionforces", regdat);
			
			// intensity volume
			URL urlint = t.getClass().getResource("int3d.bin.gz");
			float[][][] intdat = MgdmTestUtils.<float[][][]>deserializeCompressObject(new File(urlint.getFile()));
			repo.addVolume("intensityforces", intdat);
			
			// field volume
			URL urlfld = t.getClass().getResource("gvf3d.bin.gz");
			float[][][][] flddat = MgdmTestUtils.<float[][][][]>deserializeCompressObject(new File(urlfld.getFile()));
			repo.addField("fieldforces", flddat);
			
		}catch(Exception e){
			e.printStackTrace();
		}
		
		URL forcefile = t.getClass().getResource("testForces.mgdmForceXML");
		System.out.println("forcefile: " + forcefile);
		MgdmForceSpec mgdmForces = MgdmForceReaderWriter.getInstance().readObject(new File(forcefile.getFile()));
		
		System.out.println("mgdmForces: " + mgdmForces);
		
		MgdmEvolution mgdmevo = new MgdmEvolution(mgdmdecomp);
		mgdmevo.setForce(mgdmForces); 			// set forces for mgdm 
		mgdmevo.setDataRepository(repo);		// set data for mgdm 
		mgdmevo.evolveNarrowBand(6,2);
		
	}

}
