package edu.jhu.ece.iacl.algorithms.MGDM.forces;

import edu.jhmi.rad.medic.oct.structures.ObjectRepository;
import edu.jhmi.rad.medic.oct.structures.RepositoryException;
import edu.jhu.ece.iacl.utility.ArrayReshape;

/**
 * An instance of object repository class for ImageData objects
 * @author Bhaskar Kishore
 * @author John Bogovic
 */
public class MgdmDataRepository extends ObjectRepository <String, Object> {
	public MgdmDataRepository() {
		super(false);
	}

	public void addField(String key, float[][][][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			float[][][] adddat = new float[1][][];
			adddat[0] = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, 2, 2, true, false);
			add(key,adddat);
		}else{
			
			float[][][] olddat = null;
			try{
				// grab the old data
				olddat = (float[][][])oldobj;
				
			}catch(Exception e){
				System.out.println("ERROR");
				throw e;
			}
			
			// reshape data to add
			float[][]  newdat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, 2, 2, true, false);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			float[][][] addme = new float[olddat.length+1][][];
			
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[i]=olddat[i];
			}
			addme[newdat.length-1]=newdat;
			
			remove(key);
			add(key,addme);
			
		}
	}
	
	public void addField(String key, float[][][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			float[][][] adddat = new float[1][][];
			adddat[0] = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, true, false);
			add(key,adddat);
		}else{
			
			float[][][] olddat = null;
			try{
				// grab the old data
				olddat = (float[][][])oldobj;
				
			}catch(Exception e){
				System.out.println("ERROR");
				throw e;
			}
			
			// reshape data to add
			float[][]  newdat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, true, false);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			float[][][] addme = new float[olddat.length+1][][];
			
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[i]=olddat[i];
			}
			addme[newdat.length-1]=newdat;
			
			remove(key);
			add(key,addme);
			
		}
	}
	
	public void addImage(String key, int[][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			int[][] adddat = new int[1][];
			adddat[0] = ArrayReshape.reshapePad(data, 2, 2, 2, 2, true);
			add(key,adddat);
		}else{
			int[][] olddat = null;
			try{
				// grab the old data
				olddat = (int[][])oldobj;
				
			}catch(Exception e){
				throw e;
			}
			
			// reshape data to add
			int[] newdat = ArrayReshape.reshapePad(data, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			int[][] addme = new int[olddat.length+1][];
			
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[i]=olddat[i];
			}
			addme[newdat.length-1]=newdat;
			
			remove(key);
			add(key,addme);
		}
	}
	
	public void addImages(String key, int[][][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			int[][] adddat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, true);
			add(key,adddat);
		}else{
			int[][] olddat = null;
			try{
				// grab the old data
				olddat = (int[][])oldobj;
				
			}catch(Exception e){
				throw e;
			}
			
			// reshape data to add
			int[][] newdat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			int[][] addme = new int[olddat.length+1][];
			
			
			// add new data
			int k = 0 ;
			for(int i=0; i<olddat.length; i++){
				addme[k]=olddat[i];
				k++;
			}
			
			for(int i=0; i<newdat.length; i++){
				addme[k]=newdat[i];
				k++;
			}
			
			remove(key);
			add(key,addme);
		}
	}
	
	public void addImage(String key, float[][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			float[][] adddat = new float[1][];
			adddat[0] = ArrayReshape.reshapePad(data, 2, 2, 2, 2, true);
			add(key,adddat);
		}else{
			float[][] olddat = null;
			try{
				// grab the old data
				olddat = (float[][])oldobj;
				
			}catch(Exception e){
				throw e;
			}
			
			// reshape data to add
			float[] newdat = ArrayReshape.reshapePad(data, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			float[][] addme = new float[olddat.length+1][];
			
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[i]=olddat[i];
			}
			addme[newdat.length-1]=newdat;
			
			remove(key);
			add(key,addme);
		}
	}
	
	public void addImages(String key, float[][][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			float[][] adddat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, true);
			add(key,adddat);
		}else{
			float[][] olddat = null;
			try{
				// grab the old data
				olddat = (float[][])oldobj;
				
			}catch(Exception e){
				throw e;
			}
			
			// reshape data to add
			float[][] newdat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			float[][] addme = new float[olddat.length+1][];
			
			
			// add new data
			int k = 0 ;
			for(int i=0; i<olddat.length; i++){
				addme[k]=olddat[i];
				k++;
			}
			
			for(int i=0; i<newdat.length; i++){
				addme[k]=newdat[i];
				k++;
			}
			
			remove(key);
			add(key,addme);
		}
	}

	public void addVolume(String key, int[][][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			int[][] adddat = new int[1][];
			adddat[0] = ArrayReshape.reshapePad(data, 2, 2, 2, 2, 2, 2, true);
			add(key,adddat);
		}else{
			
			int[][] olddat = null;
			try{
				// grab the old data
				olddat = (int[][])oldobj;
				
			}catch(Exception e){
				System.out.println("ERROR");
				throw e;
			}
			
			// reshape data to add
			int[] newdat = ArrayReshape.reshapePad(data, 2, 2, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			int[][] addme = new int[olddat.length+1][];
			
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[i]=olddat[i];
			}
			addme[newdat.length-1]=newdat;
			
			remove(key);
			add(key,addme);
			
		}
		
	}
	
	
	
	public void addVolumes(String key, int[][][][] data) throws Exception{
		Object oldobj = get(key);
		if(oldobj==null){
			int[][] adddat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, 2, 2, true);
			add(key,adddat);
		}else{
			int[][] olddat = null;
			try{
				// grab the old data
				olddat = (int[][])oldobj;
			}catch(Exception e){
				System.out.println("REPOSITORY ADD ERROR");
				throw e;
			}
			
			// reshape data to add
			int[][] newdat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			int[][] addme = new int[olddat.length+newdat.length][];
			
			int k = 0 ;
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[k]=olddat[i];
				k++;
			}
			
			for(int i=0; i<newdat.length; i++){
				addme[k]=newdat[i];
				k++;
			}
			
			remove(key);
			add(key,addme);
		}
	}
	
	public void addVolume(String key, float[][][] data) throws Exception {
		Object oldobj = get(key);
		if(oldobj==null){
			float[][] adddat = new float[1][];
			adddat[0] = ArrayReshape.reshapePad(data, 2, 2, 2, 2, 2, 2, true);
			add(key,adddat);
		}else{
			float[][] olddat = null;
			try{
				// grab the old data
				olddat = (float[][])oldobj;
				
			}catch(Exception e){
				throw e;
			}
			
			// reshape data to add
			float[] newdat = ArrayReshape.reshapePad(data, 2, 2, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			float[][] addme = new float[olddat.length+1][];
			
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[i]=olddat[i];
			}
			addme[newdat.length-1]=newdat;
			
			remove(key);
			add(key,addme);
		}
		
	}
	
	
	
	public void addVolume(String key, float[][][][] data) throws Exception{
		Object oldobj = get(key);
		if(oldobj==null){
			float[][] adddat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, 2, 2, true);
			add(key,adddat);
			System.out.println("Added a volume");
		}else{
			float[][] olddat = null;
			try{
				// grab the old data
				olddat = (float[][])oldobj;
				
			}catch(Exception e){
				System.out.println("REPOSITORY ADD ERROR");
				throw e;
			}
			
			// reshape data to add
			float[][] newdat = ArrayReshape.reshapeMultiPad(data, 2, 2, 2, 2, 2, 2, true);
			
			// make sure the size is okay
			if(newdat.length != olddat[0].length){
				throw new RepositoryException("Data to add is of incompatible size with data already present.");
			}
			
			// new array
			float[][] addme = new float[olddat.length+newdat.length][];
			
			int k = 0 ;
			// add new data
			for(int i=0; i<olddat.length; i++){
				addme[k]=olddat[i];
				k++;
			}
			
			for(int i=0; i<newdat.length; i++){
				addme[k]=newdat[i];
				k++;
			}
			
			remove(key);
			add(key,addme);
			System.out.println("Appended a volume");
		}
	}
	
	
	public Double getDouble(String key) throws RepositoryException {
		Object o = get(key);
		if(o == null)
			return null;
		if(o instanceof Double)
			return (Double) o;
		else
			throw new RepositoryException("Cannot cast to double");
	}
	
	public Float getFloat(String key) throws RepositoryException {
		Object o = get(key);
		if(o == null)
			return null;
		if(o instanceof Float)
			return (Float) o;
		else
			throw new RepositoryException("Cannot cast to float");
	}
	
	public Integer getInt(String key) throws RepositoryException {
		Object o = get(key);
		if(o == null)
			return null;
		if(o instanceof Integer)
			return (Integer) o;
		else
			throw new RepositoryException("Cannot cast to integer");
	}
	
	public Boolean getBoolean(String key) throws RepositoryException {
		Object o = get(key);
		if(o == null)
			return null;
		if(o instanceof Boolean)
			return (Boolean) o;
		else
			throw new RepositoryException("Cannot cast to boolean");
	}
	
	public String getString(String key) throws RepositoryException {
		Object o = get(key);
		if(o == null)
			return null;
		if(o instanceof String)
			return (String) o;
		else
			throw new RepositoryException("Cannot cast to String");
	}
	
	
}
