package edu.jhu.ece.iacl.algorithms.MGDM.forces;

import edu.jhmi.rad.medic.utilities.Numerics;
import edu.jhu.ece.iacl.algorithms.MGDM.GdmDerivatives;
import edu.jhu.ece.iacl.algorithms.MGDM.forces.MgdmConstants.ForceType;

/**
 * This class implements the force `PRESSURE` for MGDM.
 * 
 * 
 * @author Bhaskar Kishore
 * @author John Bogovic
 *
 */
public class MgdmForcePressure extends MgdmForce{
	
	private static MgdmConstants.ForceType type = ForceType.PRESSURE;
	
	public MgdmForcePressure(ForceType typein, double w, int id){
		super(type, w, id);
	}
	
	public MgdmForcePressure(double w){
		super(ForceType.PRESSURE, w, MgdmConstants.INVALID);
		setRequiredData(new String[]{"DeltaP","DeltaM"});
	}
	
	@Override
	public double getForce(int xyz, int lbl, int nbr, GdmDerivatives dr, int iteration,
			MgdmDataRepository repo, float flipValue, boolean debug) {
		
		if(debug){
			System.out.println("deltaP: " + dr.deltaP());
			System.out.println("deltaM: " + dr.deltaM());
		}
		
		return -flipValue * (Numerics.max(m_Weight, 0.0) * dr.deltaP() +
							 Numerics.min(m_Weight, 0.0) * dr.deltaM());
	}
	
	@Override
	public void initForce(MgdmDataRepository repo) {
		// Do nothing
	}
	
	public void fromParameters(String[] params){
		// Do nothing
	}
	
	public MgdmForcePressure clone(){
		return new MgdmForcePressure(this.m_Weight);
	}
}
