package edu.jhu.ece.iacl.algorithms.MGDM.forces;

import java.io.*;

import javax.swing.filechooser.*;

import org.apache.commons.io.FileUtils;

import com.thoughtworks.xstream.XStream;


public class MgdmForceReaderWriter {

	
	protected static final MgdmForceReaderWriter readerWriter=new MgdmForceReaderWriter();
	
	public static MgdmForceReaderWriter getInstance(){
		return readerWriter;
	}
	
	/** The extension filter. */
	public static FileNameExtensionFilter extensionFilter = new FileNameExtensionFilter("Mgdm Force File Extensions","mgdmForceXML");
	
	public MgdmForceSpec readObject(File f) {
		
		if(!extensionFilter.accept(f)){
			System.err.println("Invalid extension, must be: " + extensionFilter.getExtensions()[0]);
			return null;
		}
		
		XStream xs = new XStream();
		Object  fs =  null;
		try{
			fs = xs.fromXML(FileUtils.readFileToString(f));
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
		
		if(fs instanceof MgdmForceSpec){
			return (MgdmForceSpec)fs;
		}else{
			System.err.println("XML FILE IS NOT A VALID FORCE SPECIFICATION");
			return null;
		}

	}
	
	public File writeObject(MgdmForceSpec dat,File f) {
		File fout = f;
		if(!extensionFilter.accept(f)){
			System.err.println("Warning: setting extension to " + extensionFilter.getExtensions()[0]);
			fout = new File(f.getAbsolutePath() + "."+ extensionFilter.getExtensions()[0]);
		}

		XStream xs = new XStream();
		try{
			FileUtils.writeStringToFile(fout, xs.toXML(dat));
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
		return fout;
	}
	
}
