package edu.jhu.ece.iacl.algorithms.MGDM.forces;

import edu.jhmi.rad.medic.utilities.Numerics;
import edu.jhu.ece.iacl.algorithms.MGDM.GdmDerivatives;
import edu.jhu.ece.iacl.algorithms.MGDM.forces.MgdmConstants.ForceType;

/**
 * This class implements the force `REGION` for Mgdm
 * 
 * @author John Bogovic
 * @author Bhaskar Kishore
 *
 */
public class MgdmForceRegion extends MgdmForce {
	private double	m_Threshold;		// The threshold parameter
	private int		m_Regionidx;		// The region index
	private static MgdmConstants.ForceType type = ForceType.REGION;
	
	public MgdmForceRegion(ForceType typein, double w, int id){
		super(type, w, id);
		parameters = new String[]{"Index", "Threshold"};
	}
	
	public MgdmForceRegion(double w, int regionidx, double threshold){
		super(ForceType.REGION, w, MgdmConstants.INVALID);
		setRequiredData(new String[]{"DeltaP","DeltaM","regionforces"});
		setThreshold(threshold);
		setIndex(regionidx);
		parameters = new String[]{"Index", "Threshold"};
	}
	
	@Override
	public double getForce(int xyz, int lbl, int nbr, GdmDerivatives dr, int iteration, MgdmDataRepository repo, float flipValue, boolean debug) {
		float[][] regionforce = null;
		try {
			regionforce = (float[][]) repo.get("regionforces");
		}
		catch(Exception e){
			System.err.println("REPO ERROR : regionforces fetch failed.");
			e.printStackTrace();
			return Double.NaN;
		}
		
		if(debug){
			System.out.println("m_Regionidx: " + m_Regionidx);
			System.out.println("reforce val: " + regionforce[m_Regionidx][xyz]);
		}
		
		return -flipValue * 
				 (Numerics.max(m_Weight * (regionforce[m_Regionidx][xyz] - m_Threshold), 0.0)* dr.deltaP() 
				+ Numerics.min(m_Weight * (regionforce[m_Regionidx][xyz] - m_Threshold), 0.0)* dr.deltaM());
	}
	
	public void setIndex(int idx){
		m_Regionidx=idx;
	}
	public void setThreshold(double thresh){
		m_Threshold=thresh;
	}
	
	public void fromParameters(String[] params){
		setIndex(Integer.parseInt(params[0]));
		setThreshold(Double.parseDouble(params[1]));
	}

	@Override
	public void initForce(MgdmDataRepository repo) {
		// Do nothing		
	}
	
	public MgdmForceRegion clone(){
		return new MgdmForceRegion(this.m_Weight, this.m_Regionidx, this.m_Threshold);
	}
	
	@Override
	public String toString() {
		String rep = "Force (Type - " + m_ForceType.toString() + ", Weight: " + m_Weight + 
			", Threshold: " + m_Threshold + ", Index: " + m_Regionidx +
			", Boundary <" + m_Boundary + ">)";
		return rep;
	}
}
