package edu.jhu.ece.iacl.algorithms.MGDM.test;

import static org.junit.Assert.*;

import java.io.File;
import java.net.URL;

import org.junit.Test;

import edu.jhu.ece.iacl.algorithms.MGDM.MgdmDecomposition;
import edu.jhu.ece.iacl.algorithms.MGDM.test.MgdmTestUtils;

public class MgdmDecompositionTest {


	
	@Test
	public void testMgdmDecomp3d() {
		
		MgdmDecompositionTest t = new MgdmDecompositionTest();
		
		URL url = t.getClass().getResource("ini3d.bin.gz");
		System.out.println("url: " + url);
		
		// test 3D
		int[][][] ini3d = MgdmTestUtils.<int[][][]>deserializeCompressObject(new File(url.getFile()));
			
		MgdmDecomposition mgdmDecomp3d = new MgdmDecomposition(ini3d);

		assertEquals(mgdmDecomp3d.getNumLabels(), 6);
		assertEquals(mgdmDecomp3d.nxPad, 260);
		assertEquals(mgdmDecomp3d.nyPad, 256);
		assertEquals(mgdmDecomp3d.nzPad, 11);
		
	}
	
	@Test
	public void testMgdmDecomp2d() {
		
		MgdmDecompositionTest t = new MgdmDecompositionTest();
		
		URL url = t.getClass().getResource("ini3d.bin.gz");
		System.out.println("url: " + url);
		
		// test 3D
		int[][][] ini3d = MgdmTestUtils.<int[][][]>deserializeCompressObject(new File(url.getFile()));
		
		int[][] ini2d = new int[ini3d.length][ini3d[0].length];
		for(int i=0; i<ini2d.length; i++)for(int j=0; j<ini2d[0].length; j++){
			ini2d[i][j]=ini3d[i][j][3];
		}
			
		MgdmDecomposition mgdmDecomp2d = new MgdmDecomposition(ini2d);

		assertEquals(mgdmDecomp2d.getNumLabels(), 6);
		assertEquals(mgdmDecomp2d.nxPad, 260);
		assertEquals(mgdmDecomp2d.nyPad, 256);
		
	}

}
