package edu.jhu.ece.iacl.algorithms.MGDM.test;

import static org.junit.Assert.*;

import org.junit.Test;

import edu.jhu.ece.iacl.algorithms.MGDM.*;
import edu.jhu.ece.iacl.algorithms.MGDM.forces.*;
import edu.jhu.ece.iacl.utility.ArrayUtil;

public class MgdmForceTest {
	
	@Test
	public void testMgdmBoundary(){
		
		MgdmBoundary bnd01 = new MgdmBoundary(0,1);
		MgdmBoundary bnd10 = new MgdmBoundary(1,0);
		
		assertEquals(bnd01,bnd10);
		
		assertEquals(bnd01, MgdmConstants.ANYBOUNDARY);
		assertEquals(bnd10, MgdmConstants.ANYBOUNDARY);
		assertEquals(bnd10, MgdmConstants.ANYBOUNDARY);
		
		assertFalse(bnd10.equals(MgdmConstants.NOBOUNDARY));
		assertFalse(bnd10.equals(MgdmConstants.NOBOUNDARY));
		assertFalse(MgdmConstants.ANYBOUNDARY.equals(MgdmConstants.NOBOUNDARY));
		
	}
	
	@Test
	public void testCurvatureForce(){
		boolean debug = false;
		
		MgdmForceCurvature force = new MgdmForceCurvature(0.1);
		
		MgdmDataRepository repo = new MgdmDataRepository();
		
		
		// generage a level set patch with zero curvature
		float[][][] phiFlatX = new float[3][3][3];
		for(int x=1; x<3; x++)for(int y=0; y<3; y++)for(int z=0; z<3; z++){
			phiFlatX[x][y][z] = x;
		}
		GdmDerivatives dr = GdmDerivatives.computeDerivatives(phiFlatX, 1f, 1f, 1f);
		
		
		double speedout = force.getForce(0, 0, 1, dr, 0, repo, 0f, debug);
		if(debug) System.out.println("speedout: " + speedout );
		assertEquals(0.0, speedout, 0.0000001);
		
		
		// create a concave boundary - expect a negative speed
		float[][][] phiConcave = new float[3][3][3];
		ArrayUtil.fill(phiConcave, 0.5f);
		for(int x=1; x<3; x++)for(int y=1; y<3; y++)for(int z=0; z<3; z++){
			phiConcave[x][y][z] = x*(-y*y);
		}
		if(debug)System.out.println("phiConcave:\n"+ArrayUtil.printArray(phiConcave));
		dr = GdmDerivatives.computeDerivatives(phiConcave, 1f, 1f, 1f);

		speedout = force.getForce(0, 0, 1, dr, 0, repo, 0f, debug);
		if(debug) System.out.println("speedout: " + speedout );
		assertTrue(speedout<0);
		
		
		// create a convex boundary - expect a  positive speed
		float[][][] phiConvex = new float[3][3][3];
		ArrayUtil.fill(phiConcave, 0.5f);
		for(int x=1; x<3; x++)for(int y=1; y<3; y++)for(int z=0; z<3; z++){
			phiConvex[x][y][z] = x;
		}
		if(debug)System.out.println("phiConvex:\n"+ArrayUtil.printArray(phiConvex));
		
		dr = GdmDerivatives.computeDerivatives(phiConvex, 1f, 1f, 1f);

		speedout = force.getForce(0, 0, 1, dr, 0, repo, 0f, debug);
		if(debug) System.out.println("speedout: " + speedout );
		assertTrue(speedout>0);
		
		
	}
	
	@Test
	public void testPressureForce(){
		boolean debug = false;
		
		MgdmForcePressure force = new MgdmForcePressure(0.1);
		MgdmDataRepository repo = new MgdmDataRepository();
		
		
		// generage a level set patch with zero curvature
		float[][][] phiFlatX = new float[3][3][3];
		for(int x=1; x<3; x++)for(int y=0; y<3; y++)for(int z=0; z<3; z++){
			phiFlatX[x][y][z] = x;
		}
		GdmDerivatives dr = GdmDerivatives.computeDerivatives(phiFlatX, 1f, 1f, 1f);
		
		
		double speedout = force.getForce(0, 0, 1, dr, 0, repo, 1f, debug);
		if(debug) System.out.println("speedout: " + speedout );
		assertEquals(-0.1, speedout, 0.0000001);
		

		speedout = force.getForce(0, 0, 1, dr, 0, repo, -1f, debug);
		if(debug) System.out.println("speedout: " + speedout );
		assertEquals(0.1, speedout, 0.0000001);
		
		
	}
	
	
	@Test
	public void testIntensityForce(){
		
		MgdmForceIntensity intforce = new MgdmForceIntensity(1);
		
		
		float[][][] phi = new float[3][3][3];
		for(int x=1; x<3; x++)for(int y=0; y<3; y++)for(int z=0; z<3; z++){
			phi[x][y][z] = x;
		}
		
		GdmDerivatives dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		
		MgdmDataRepository repo = new MgdmDataRepository();
		
		try{
			float[][] intensityVol = new float[1][1];
			intensityVol[0][0] = 0.5f;
			repo.add("intensityforces", intensityVol);

			float[][] centroids = new float[1][2];
			centroids[0][0] = 0.5f;
			centroids[0][1] = 0.6f;
			repo.add("centroids", centroids);
		}catch(Exception e){
			e.printStackTrace();
		}
		
		double speedout = intforce.getForce(0, 0, 1, dr, 0, repo, 0f, false);
//		System.out.println("speedout: " + speedout );
	
		
		assertEquals(0.1, speedout, 0.0000001);
		
	}

	@Test
	public void testRegionForce(){
		
		MgdmForceRegion forceT0 = new MgdmForceRegion(1, 0, 0);
		MgdmForceRegion forceTp5 = new MgdmForceRegion(1, 0, 0.5);
		MgdmForceRegion forceT1 = new MgdmForceRegion(1, 0, 1);
		
		float[][][] phi = new float[3][3][3];
		for(int x=1; x<3; x++)for(int y=0; y<3; y++)for(int z=0; z<3; z++){
			phi[x][y][z] = x;
		}
		
		GdmDerivatives dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		
		MgdmDataRepository repo = new MgdmDataRepository();
		
		try{
			float[][] regvol= new float[1][1];
			regvol[0][0] = 0.5f;
			repo.add("regionforces", regvol);

		}catch(Exception e){
			e.printStackTrace();
		}
		
		boolean debug = false;
		
		double speedoutT0 = forceT0.getForce(0, 0, 1, dr, 0, repo, 1f, debug);
		if(debug)System.out.println("speedoutT0: " + speedoutT0 );	
		assertEquals(-0.5, speedoutT0, 0.0000001);
		
		double speedoutTp5 = forceTp5.getForce(0, 0, 1, dr, 0, repo, 1f, debug);
		if(debug)System.out.println("speedoutTp5: " + speedoutTp5 );	
		assertEquals(0.0, speedoutTp5, 0.0000001);
		
		double speedoutT1 = forceT1.getForce(0, 0, 1, dr, 0, repo, 1f, debug);
		if(debug)System.out.println("speedoutT1: " + speedoutT1 );	
		assertEquals(0.5, speedoutT1, 0.0000001);
	}
	
	@Test
	public void testFieldForce(){
		
		MgdmForceField force = new MgdmForceField(1,0);
		
		
		float[][][] phi = new float[3][3][3];
		for(int x=1; x<3; x++)for(int y=0; y<3; y++)for(int z=0; z<3; z++){
			phi[x][y][z] = x;
		}
		
		GdmDerivatives dr = GdmDerivatives.computeDerivatives(phi, 1f, 1f, 1f);
		
		MgdmDataRepository repo = new MgdmDataRepository();
		
		try{
			float[][][] fieldvol = new float[1][1][3];
			fieldvol[0][0] = new float[]{1.0f, 0.0f, 0.0f};
			repo.add("fieldforces", fieldvol);

		}catch(Exception e){
			e.printStackTrace();
		}
		
		double speedout = force.getForce(0, 0, 1, dr, 0, repo, 0f, false);
//		System.out.println("speedout: " + speedout );
	
		assertEquals(1.0, speedout, 0.0000001);
		
	}
	
}
