package edu.jhu.ece.iacl.algorithms.MGDM.forces;

/**
 * Class represents a boundary in MGDM.
 * Boundaries are represented as unordered pairs of integers (i,j),
 * where i and j are the labels on either side of the boundary.
 * 
 * Note that if:
 * 		MgdmBoundary a = new MgdmBoundary(1,2);
 * 		MgdmBoundary b = new MgdmBoundary(2,1);
 * then
 * 		a.equals(b);
 * will return true.
 * 
 * @author Bhaskar Kishore
 * @author John Bogovic
 *
 */
public class MgdmBoundary implements Cloneable {
	public int m_b1;
	public int m_b2;
	
	/**
	 * Constructor for the boundary.
	 * 
	 */
	public MgdmBoundary(int b1, int b2) {
		if(b1<b2){
			m_b1 = b1;
			m_b2 = b2;
		}else{
			m_b2 = b1;
			m_b1 = b2;
		}
	}
	
	/**
	 * Overloaded equal function.
	 */
	public boolean equals(Object obj) {
		
		// 'ANYBOUNDARY' is not equal to 'NOBOUNDARY' 
		if((obj==MgdmConstants.ANYBOUNDARY && this==MgdmConstants.NOBOUNDARY) || (this==MgdmConstants.ANYBOUNDARY && obj==MgdmConstants.NOBOUNDARY)){
			return false;
		}
		
		// return true if either boundary is 'ANYBOUNDARY'
		if(obj== MgdmConstants.ANYBOUNDARY || this == MgdmConstants.ANYBOUNDARY){
			return true;
		}
		
		// return true if both objects are 'NOBOUNDARY'
		// but return false if one object is 'NOBOUNDARY'
		if(obj==MgdmConstants.NOBOUNDARY && this==MgdmConstants.NOBOUNDARY){
			return true;
		}
		
		if(obj == null || this.getClass() != obj.getClass())
			return false;
		if(obj == this)
			return true;
		MgdmBoundary compare = (MgdmBoundary) obj;
		
		return (compare.m_b1 == this.m_b1) && (compare.m_b2 == this.m_b2);
	}
	
	/**
	 * Overloaded hashCode function. 
	 * Reference : javax.vecmath source
	 * @return	A hash value
	 */
	public int hashCode() {
		long bits = 1L;
		bits = 31L * bits + (long) m_b1;
		bits = 31L * bits + (long) m_b2;
		return (int) (bits ^ (bits >> 32));
	}
	
	/**
	 * 
	 */
	public Object clone() {		
		try {
			return super.clone();
		} catch (CloneNotSupportedException e) {
			throw new InternalError();
		}
	}
	
	public String toString(){
		if(this.equals(MgdmConstants.NOBOUNDARY)){
			return "(NONE)";
		}else if(this.equals(MgdmConstants.ANYBOUNDARY)){
			return "(ANY)";
		}else{
			return "("+m_b1+","+m_b2+")";
		}
		
	}
}
