package edu.jhu.ece.iacl.algorithms.MGDM.forces;

import edu.jhu.ece.iacl.algorithms.MGDM.GdmDerivatives;
import edu.jhu.ece.iacl.algorithms.MGDM.forces.MgdmConstants.ForceType;

/**
 * This class implements the force `CURVATURE` for Mgdm
 * @author Bhaskar Kishore
 * @author John Bogovic
 *
 */
public class MgdmForceCurvature extends MgdmForce {
	
	private static MgdmConstants.ForceType type = ForceType.CURVATURE;
	
	public MgdmForceCurvature(ForceType typein, double w, int id){
		super(type, w, id);
	}
	
	public MgdmForceCurvature(double w)	{
		super(ForceType.CURVATURE, w, MgdmConstants.INVALID);
		setRequiredData(new String[]{"D0x","D0y","D0z",
				"Dxx","Dyy","Dzz","Dxy","Dxz","Dyz",
				"label","neighbor","intensityforces","centroids"});
	}
	
	@Override
	public double getForce(int xyz, int lbl, int nbr, GdmDerivatives dr, int iteration, MgdmDataRepository repo, float flipValue, boolean debug) {
		return -(m_Weight * dr.meanCurvatureFlow(debug));
	}

	@Override
	public void initForce(MgdmDataRepository repo) {
		// Do nothing
	}
	
	public void fromParameters(String[] params){
		// Do nothing
	}
	
	public MgdmForceCurvature clone(){
		return new MgdmForceCurvature(this.m_Weight);
	}
}
