package edu.jhu.ece.iacl.algorithms.MGDM.forces;

import edu.jhmi.rad.medic.utilities.Numerics;
import edu.jhu.ece.iacl.algorithms.MGDM.GdmDerivatives;
import edu.jhu.ece.iacl.algorithms.MGDM.forces.MgdmConstants.ForceType;

/**
 * This class implements the force `FIELD` for Mgdm
 * @author Bhaskar Kishore
 * @author John Bogovic
 *
 */
public class MgdmForceField extends MgdmForce {
	private final static byte X = 0;
	private final static byte Y = 1;
	private final static byte Z = 2;
	
	private int fieldidx = -1;
	
	private static MgdmConstants.ForceType type = ForceType.FIELD;
	
	public MgdmForceField(ForceType typein, double w, int id){
		super(type, w, id);
	}

	public MgdmForceField(double w, int fieldidx){
		super(ForceType.FIELD, w, MgdmConstants.INVALID);
		setRequiredData(new String[]{"Dmx","Dpx","Dmy","Dpy","Dmz","Dpz","fieldforces"});
		this.fieldidx = fieldidx;
	}

	@Override
	public double getForce(int xyz, int lbl, int nbr, GdmDerivatives dr, int iteration, MgdmDataRepository repo, float flipValue, boolean debug) {
		float[][][] fieldforce = null; 
		// TODO we can cache the field force object in the initForce function, does that increase memory?
		try {
			fieldforce = (float[][][]) repo.get("fieldforces");
		}
		catch(Exception e) {
			System.out.println("REPO ERROR : FieldForce fetch failed.");
			return Double.NaN;
		}
		
//		System.out.println("fieldforce: " + fieldforce);
		
		return	( Numerics.max(m_Weight * fieldforce[fieldidx][xyz][X], 0.0)* dr.Dmx()
				+ Numerics.min(m_Weight * fieldforce[fieldidx][xyz][X], 0.0)* dr.Dpx()
				+ Numerics.max(m_Weight * fieldforce[fieldidx][xyz][Y], 0.0)* dr.Dmy()
				+ Numerics.min(m_Weight * fieldforce[fieldidx][xyz][Y], 0.0)* dr.Dpy()
				+ Numerics.max(m_Weight * fieldforce[fieldidx][xyz][Z], 0.0)* dr.Dmz()
				+ Numerics.min(m_Weight * fieldforce[fieldidx][xyz][Z], 0.0)* dr.Dpz());
	}

	@Override
	public void initForce(MgdmDataRepository repo) {
		// Do nothing
	}
	
	public void fromParameters(String[] params){
		// Do nothing
	}
	
	public MgdmForceField clone(){
		return new MgdmForceField(this.m_Weight, this.fieldidx);
	}
}