% Mgdm 3d demo

load mgdmDemo.mat;


%% set up forces

p = mfilename('fullpath');
[thispath,name,ext]=fileparts(p);


idxs =  strfind(thispath,filesep);
configpath=fullfile(thispath(1:idxs(end-1)),'tests/javaTests/edu/jhu/ece/iacl/algorithms/MGDM/test/testForces.mgdmForceXML');

fconfigfile = javaObject('java.io.File',configpath);

mgdmForceRW =  edu.jhu.ece.iacl.algorithms.MGDM.forces.MgdmForceReaderWriter.getInstance();
mgdmForces = mgdmForceRW.readObject(fconfigfile);

%% build data repository

repo = edu.jhu.ece.iacl.algorithms.MGDM.forces.MgdmDataRepository();

try
    repo.addVolume('intensityforces',intforce);
    repo.addVolume('regionforces',regforce);
    repo.addField('fieldforces',gvfforce);
catch e
    e
end


%% run mgdm

[mgdmseg, mgdmDecomp] = mgdm3d(ini,mgdmForces,repo,15,5);

%% visualize

imagesc(mgdmseg(:,:,3)); axis equal;
